/*
 * Decompiled with CFR 0.152.
 */
package splash;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JWindow;

public class Splash
extends JWindow
implements WindowListener {
    public Splash(URL picture) {
        this.showSplash(picture);
    }

    public Splash(JFrame frame, URL picture) {
        super(frame);
        this.showSplash(picture);
    }

    private void showSplash(URL picture) {
        try {
            JLabel l = new JLabel(new ImageIcon(picture));
            this.getContentPane().add((Component)l, "Center");
            this.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension labelSize = l.getPreferredSize();
            this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Splash.this.windowOpened(null);
                }
            });
            this.setVisible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

