/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JDialog;

public class JJDialog
extends JDialog
implements ComponentListener {
    private Frame frame;
    private Dimension minimumSize;
    private boolean centerDialog = true;

    public JJDialog(Frame frame, String title, boolean modal, boolean centerDialog) {
        super(frame, title, modal);
        this.frame = frame;
        this.centerDialog = centerDialog;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JJDialog(Frame frame, String title, boolean modal) {
        this(frame, title, modal, true);
    }

    public JJDialog(Frame frame, String title) {
        this(frame, title, false, true);
    }

    public JJDialog() {
        this((Frame)null, "");
    }

    @Override
    public void pack() {
        super.pack();
        this.minimumSize = this.getSize();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int titleWidth = fm.stringWidth(this.getTitle());
        if (this.minimumSize.width < (titleWidth += 81)) {
            this.minimumSize.width = titleWidth;
            this.setSize(this.minimumSize);
        }
        if (this.centerDialog) {
            if (this.frame != null) {
                Point location = this.frame.getLocation();
                location.x += (this.frame.getSize().width - this.getSize().width) / 2;
                location.y += (this.frame.getSize().height - this.getSize().height) / 2;
                this.setLocation(location);
            } else {
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                int x = (screen.width - this.getSize().width) / 2;
                int y = (screen.height - this.getSize().height) / 2;
                this.setLocation(x, y);
            }
        }
        this.addComponentListener(this);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        boolean tooSmall = false;
        Dimension newSize = this.getSize();
        if (newSize.width < this.minimumSize.width) {
            newSize.width = this.minimumSize.width;
            tooSmall = true;
        }
        if (newSize.height < this.minimumSize.height) {
            newSize.height = this.minimumSize.height;
            tooSmall = true;
        }
        if (tooSmall) {
            this.setSize(newSize);
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private void jbInit() throws Exception {
    }
}

