/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ButtonListener;
import gui.JJPanel_jButton_actionAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;

public class ButtonPanel
extends JPanel {
    public static final int CANCEL_BUTTON = 0;
    public static final int OK_BUTTON = 1;
    public static final int HELP_BUTTON = 2;
    public static final int APPLY_BUTTON = 3;
    public static final int CLOSE_BUTTON = 4;
    private final String CANCEL = "Annuler";
    private final String OK = "OK";
    private final String HELP = "Hj\u00e6lp";
    private final String APPLY = "Anvend";
    private final String CLOSE = "Luk";
    private boolean hasClose = false;
    private boolean hasOK = true;
    private boolean hasHelp = true;
    private boolean hasCancel = true;
    private boolean hasApply = true;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelBorder = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanelCenter = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    JPanel jPanelSouth = new JPanel();
    JPanel jPanelButtons = new JPanel();
    Border border1;
    JButton jButtonOK = new JButton();
    JButton jButtonApply = new JButton();
    JButton jButtonCancel = new JButton();
    JButton jButtonHelp = new JButton();
    ArrayList buttonListeners = new ArrayList();
    JRootPane rootPane = null;

    public ButtonPanel(JRootPane rootPane) {
        this.rootPane = rootPane;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JButton getButton(int button) {
        switch (button) {
            case 0: {
                return this.hasCancel ? this.jButtonCancel : null;
            }
            case 1: {
                return this.hasOK ? this.jButtonOK : null;
            }
            case 2: {
                return this.hasHelp ? this.jButtonHelp : null;
            }
            case 3: {
                return this.hasApply ? this.jButtonApply : null;
            }
            case 4: {
                return this.hasClose ? this.jButtonCancel : null;
            }
        }
        return null;
    }

    public void addButtonListener(ButtonListener l) {
        this.buttonListeners.add(l);
    }

    public void removeButtonListener(ButtonListener l) {
        this.buttonListeners.remove(l);
    }

    public void setHasOK(boolean hasOK) {
        this.hasOK = hasOK;
        if (hasOK) {
            this.hasClose = false;
            this.jButtonCancel.setText("Annuler");
        }
        this.buildButtons();
    }

    public void setHasClose(boolean hasClose) {
        this.hasClose = hasClose;
        if (hasClose) {
            this.hasCancel = false;
            this.hasOK = false;
            this.jButtonCancel.setText("Luk");
        }
        this.buildButtons();
    }

    public void setHasCancel(boolean hasCancel) {
        this.hasCancel = hasCancel;
        if (hasCancel) {
            this.hasClose = false;
            this.hasOK = true;
            this.jButtonCancel.setText("Annuler");
        }
        this.buildButtons();
    }

    public void setHasApply(boolean hasApply) {
        this.hasApply = hasApply;
        this.buildButtons();
    }

    public void setHasHelp(boolean hasHelp) {
        this.hasHelp = hasHelp;
        this.buildButtons();
    }

    public boolean isHasOK() {
        return this.hasOK;
    }

    public boolean isHasClose() {
        return this.hasClose;
    }

    public boolean isHasCancel() {
        return this.hasCancel;
    }

    public boolean isHasApply() {
        return this.hasApply;
    }

    public boolean isHasHelp() {
        return this.hasHelp;
    }

    protected void buildButtons() {
        this.jPanelButtons.remove(this.jButtonOK);
        this.jPanelButtons.remove(this.jButtonApply);
        this.jPanelButtons.remove(this.jButtonCancel);
        this.jPanelButtons.remove(this.jButtonHelp);
        this.jPanelButtons.remove(this.jButtonOK);
        if (this.hasOK) {
            this.jPanelButtons.add((Component)this.jButtonOK, null);
            this.rootPane.setDefaultButton(this.jButtonOK);
        }
        if (this.hasCancel || this.hasClose) {
            this.jPanelButtons.add((Component)this.jButtonCancel, null);
            if (!this.hasOK) {
                this.rootPane.setDefaultButton(this.jButtonCancel);
            }
        }
        if (this.hasApply) {
            this.jPanelButtons.add((Component)this.jButtonApply, null);
        }
        if (this.hasHelp) {
            this.jPanelButtons.add((Component)this.jButtonHelp, null);
        }
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(0, 10, 10, 10);
        this.setLayout(this.borderLayout1);
        this.jPanelBorder.setLayout(this.borderLayout2);
        this.jButtonHelp.setText("Hj\u00e6lp");
        this.jButtonHelp.addActionListener(new JJPanel_jButton_actionAdapter(this));
        this.flowLayout1.setAlignment(2);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new JJPanel_jButton_actionAdapter(this));
        this.jPanelSouth.setLayout(this.flowLayout1);
        this.jPanelButtons.setLayout(this.gridLayout1);
        this.jPanelBorder.setBorder(this.border1);
        this.gridLayout1.setHgap(5);
        this.jButtonApply.setText("Anvend");
        this.jButtonApply.addActionListener(new JJPanel_jButton_actionAdapter(this));
        this.jButtonCancel.setText("Annuler");
        this.jButtonCancel.addActionListener(new JJPanel_jButton_actionAdapter(this));
        this.add((Component)this.jPanelBorder, "Center");
        this.jPanelBorder.add((Component)this.jPanelCenter, "Center");
        this.jPanelBorder.add((Component)this.jPanelSouth, "South");
        this.jPanelSouth.add((Component)this.jPanelButtons, null);
        this.jPanelButtons.add((Component)this.jButtonOK, null);
        this.jPanelButtons.add((Component)this.jButtonCancel, null);
        this.jPanelButtons.add((Component)this.jButtonApply, null);
        this.jPanelButtons.add((Component)this.jButtonHelp, null);
    }

    void jButton_actionPerformed(ActionEvent e) {
        if (this.buttonListeners.size() < 1) {
            throw new UnsupportedOperationException("JJPanel: No button listener");
        }
        for (int i = this.buttonListeners.size() - 1; i >= 0; --i) {
            ButtonListener l = (ButtonListener)this.buttonListeners.get(i);
            if (e.getSource() == this.jButtonApply) {
                l.applyPressed(e);
                continue;
            }
            if (e.getSource() == this.jButtonCancel) {
                l.cancelPressed(e);
                continue;
            }
            if (e.getSource() == this.jButtonHelp) {
                l.helpPressed(e);
                continue;
            }
            if (e.getSource() != this.jButtonOK) continue;
            l.okPressed(e);
        }
    }
}

