/*
 * Decompiled with CFR 0.152.
 */
package glider.utils;

import glider.COMMON;
import glider.GDialog;
import glider.GliderIF;
import glider.data.Coordinate;
import glider.data.Task;
import glider.data.TurnPoint;
import glider.utils.JJProgressMonitor;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import javax.swing.ImageIcon;

public abstract class Utils {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
    static double oneKm = -1.0;

    public static void center(Container myself) {
        Utils.centerHorizontal(myself);
        Utils.centerVertical(myself);
    }

    public static void center(Container owner, Container myself) {
        Utils.centerHorizontal(owner, myself);
        Utils.centerVertical(owner, myself);
    }

    public static void centerHorizontal(Container myself) {
        Rectangle b = myself.getBounds();
        Container parent = myself.getParent();
        if (parent == null) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            b.x = (screen.width - b.width) / 2;
        } else {
            Rectangle pb = parent.getBounds();
            b.x = pb.x + (pb.width - b.width) / 2;
        }
        if (b.x < 0) {
            b.x = 0;
        }
        myself.setBounds(b);
    }

    public static void centerHorizontal(Container owner, Container myself) {
        Rectangle b = myself.getBounds();
        if (owner == null) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            b.x = (screen.width - b.width) / 2;
        } else {
            Rectangle pb = owner.getBounds();
            b.x = pb.x + (pb.width - b.width) / 2;
        }
        if (b.x < 0) {
            b.x = 0;
        }
        myself.setBounds(b);
    }

    public static void centerVertical(Container myself) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle b = myself.getBounds();
        Container parent = myself.getParent();
        if (parent == null) {
            b.y = (screen.height - b.height) / 2;
        } else {
            Rectangle pb = parent.getBounds();
            b.y = pb.y + (pb.height - b.height) / 2;
        }
        if (b.y < 0) {
            b.y = 0;
        }
        myself.setBounds(b);
    }

    public static void centerVertical(Container owner, Container myself) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle b = myself.getBounds();
        if (owner == null) {
            b.y = (screen.height - b.height) / 2;
        } else {
            Rectangle pb = owner.getBounds();
            b.y = pb.y + (pb.height - b.height) / 2;
        }
        if (b.y < 0) {
            b.y = 0;
        }
        myself.setBounds(b);
    }

    public static ImageIcon getIcon(String imageFile) {
        URL url = Utils.class.getClassLoader().getResource(imageFile);
        if (url == null) {
            throw new NullPointerException(imageFile);
        }
        return new ImageIcon(url);
    }

    public static double latlong2x(Coordinate coord) {
        if (coord == null) {
            return 0.0;
        }
        Coordinate orig = new Coordinate(5747300, 759000);
        double yScale = 1306.0;
        double y = (orig.lat2double() - coord.lat2double()) * yScale;
        double xScale = 702.0 + y * 0.014;
        double x = (coord.lon2double() - orig.lon2double()) * xScale;
        y -= x / 50.0;
        return x -= y / 70.0;
    }

    public static double latlong2y(Coordinate coord) {
        Coordinate orig = new Coordinate(5747300, 759000);
        double yScale = 1306.0;
        double y = (orig.lat2double() - coord.lat2double()) * yScale;
        double xScale = 702.0 + y * 0.014;
        double x = (coord.lon2double() - orig.lon2double()) * xScale;
        y -= x / 50.0;
        double deltaY = (1760.0 - Math.abs(1760.0 - (x -= y / 70.0))) / 80.0;
        return y += deltaY;
    }

    public static double rad(double arc) {
        return ((double)((int)(arc / 10000.0)) + arc % 10000.0 / 6000.0) * Math.PI / 180.0;
    }

    public static double distance(Coordinate c1, Coordinate c2) {
        double r = 6371.0;
        double delta = 0.001;
        double B1 = (double)c1.getLatitude() / 10.0;
        double L1 = (double)c1.getLongitude() / 10.0;
        double B2 = (double)c2.getLatitude() / 10.0;
        double L2 = (double)c2.getLongitude() / 10.0;
        if (Math.abs(B1 - B2) < delta && Math.abs(L1 - L2) < delta) {
            return 0.0;
        }
        return Math.acos(Math.sin(Utils.rad(B1)) * Math.sin(Utils.rad(B2)) + Math.cos(Utils.rad(B1)) * Math.cos(Utils.rad(B2)) * Math.cos(Utils.rad(L1) - Utils.rad(L2))) * r;
    }

    public static void setTask(Task task) {
        if (task == null) {
            return;
        }
        task.calculateLength();
        COMMON.getTasks().add(task);
        COMMON.setCurrentTask(task);
        COMMON.getContest().rememberTask();
        COMMON.getContest().setTask(task);
        COMMON.getMapViewer().setContestList(task);
        COMMON.getUpdater().updateLength();
        ((GliderIF)((Object)COMMON.topFrame)).enableMenusAndTools();
    }

    public static Task getTask(String fileName) {
        return Utils.getTask(new File(fileName));
    }

    public static Task getTask(File igcFile) {
        Task t = null;
        try {
            String line = null;
            BufferedReader br = new BufferedReader(new FileReader(igcFile));
            while ((line = br.readLine()) != null && !line.startsWith("B")) {
                if (!line.startsWith("C") || line.charAt(8) != 'N' || line.charAt(17) != 'E') continue;
                String lats = line.substring(1, 7);
                String lons = line.substring(9, 16);
                int lat = 0;
                int lon = 0;
                try {
                    lat = Integer.parseInt(lats);
                    lon = Integer.parseInt(lons);
                }
                catch (NumberFormatException ex1) {
                    lat = 0;
                    lon = 0;
                }
                if (lat <= 0 || lon <= 0) continue;
                if (t == null) {
                    t = new Task();
                }
                Coordinate coord = new Coordinate(lat * 10, lon * 10);
                t.addTurnpoint(coord);
            }
            br.close();
        }
        catch (IOException ex) {
            GDialog.exception(ex);
        }
        if (t != null) {
            TurnPoint last = null;
            Task result = new Task();
            for (int i = 0; i < t.size(); ++i) {
                TurnPoint tp = t.getTurnpoint(i);
                if (!tp.equals(last)) {
                    result.addTurnpoint(new Coordinate(tp.getCoordinate()));
                }
                last = tp;
            }
            return result;
        }
        return null;
    }

    public static double heading(Coordinate c0, Coordinate c1) {
        if (c0 == null || c1 == null) {
            return 0.0;
        }
        double x1 = Utils.latlong2x(c0);
        double y1 = Utils.latlong2y(c0);
        double x2 = Utils.latlong2x(c1);
        double y2 = Utils.latlong2y(c1);
        double arc = Math.asin((x2 - x1) / Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)));
        if (y2 > y1) {
            arc = Math.PI - arc;
        }
        if (arc < 0.0) {
            arc += Math.PI * 2;
        }
        return arc * 180.0 / Math.PI;
    }

    public static double get1km() {
        if (oneKm < 0.0) {
            int lat1 = 5500000;
            int lat2 = 5600000;
            int lon = 1200000;
            Coordinate c1 = new Coordinate(5500000, 1200000);
            Coordinate c2 = new Coordinate(5600000, 1200000);
            Point p1 = c1.latlong2xy(1);
            Point p2 = c2.latlong2xy(1);
            oneKm = (double)(p1.y - p2.y) / Utils.distance(c1, c2);
        }
        return oneKm;
    }

    public static void copy(File src, File dst) throws IOException {
        Utils.copy(src, dst, null);
    }

    public static void copy(File src, File dst, JJProgressMonitor pm) throws IOException {
        char[] buffer = new char[2048];
        FileReader fr = null;
        OutputStreamWriter fw = null;
        if (!src.exists()) {
            // empty if block
        }
        try {
            fr = new FileReader(src);
            fw = new FileWriter(dst);
            int cnt = 0;
            while ((cnt = fr.read(buffer)) > 0) {
                fw.write(buffer, 0, cnt);
                if (pm == null) continue;
                pm.setProgress(pm.getProgress() + cnt);
            }
        }
        catch (IOException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException iOException) {}
            try {
                fr.close();
            }
            catch (IOException iOException) {}
        }
    }
}

