/*
 * Decompiled with CFR 0.152.
 */
package glider.utils;

import glider.COMMON;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SelectList
extends JPanel {
    private JList ivjJList1 = null;
    private JTextField ivjJTextField1 = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private DefaultListModel ivjDefaultListModel1 = null;
    private DefaultListModel ivjDefaultListModel2 = null;

    public SelectList() {
        this.initialize();
    }

    public SelectList(LayoutManager layout) {
        super(layout);
    }

    public SelectList(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public SelectList(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    private void connEtoC1(KeyEvent arg1) {
        try {
            this.jTextField1_KeyReleased();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(KeyEvent arg1) {
        try {
            this.jTextField1_KeyTyped(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(MouseEvent arg1) {
        try {
            this.selectionMade();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2() {
        try {
            this.getJList1().setModel(this.getDefaultListModel2());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private DefaultListModel getDefaultListModel1() {
        return this.ivjDefaultListModel1;
    }

    private DefaultListModel getDefaultListModel2() {
        if (this.ivjDefaultListModel2 == null) {
            try {
                this.ivjDefaultListModel2 = new DefaultListModel();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDefaultListModel2;
    }

    private JList getJList1() {
        if (this.ivjJList1 == null) {
            try {
                this.ivjJList1 = new JList();
                this.ivjJList1.setName("JList1");
                this.ivjJList1.setVisible(false);
                this.ivjJList1.setSelectionMode(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJList1;
    }

    private JTextField getJTextField1() {
        if (this.ivjJTextField1 == null) {
            try {
                this.ivjJTextField1 = new JTextField();
                this.ivjJTextField1.setName("JTextField1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextField1;
    }

    public DefaultListModel getModel() {
        return this.getDefaultListModel1();
    }

    private void handleException(Throwable exception) {
        COMMON.errorLog(this.getClass().getName(), exception);
    }

    private void initConnections() throws Exception {
        this.getJTextField1().addKeyListener(this.ivjEventHandler);
        this.getJList1().addMouseListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("SelectList");
            this.setLayout(new BorderLayout());
            this.setSize(160, 120);
            this.add((Component)this.getJTextField1(), "North");
            this.add((Component)this.getJList1(), "Center");
            this.initConnections();
            this.connEtoM2();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void jTextField1_KeyReleased() {
        DefaultListModel m = this.getModel();
        DefaultListModel lm = (DefaultListModel)this.getJList1().getModel();
        lm.removeAllElements();
        if (this.getJTextField1().getText().length() > 0) {
            String t = this.getJTextField1().getText().toLowerCase();
            for (int i = 0; i < m.getSize(); ++i) {
                String s = ((String)m.elementAt(i)).toLowerCase();
                if (!s.startsWith(t)) continue;
                lm.addElement(m.elementAt(i));
            }
        }
        this.getJList1().setVisible(lm.size() > 0);
        this.doLayout();
        this.repaint();
    }

    public void jTextField1_KeyTyped(KeyEvent keyEvent) {
        int selectedIndex;
        if (keyEvent.getKeyCode() == 40) {
            keyEvent.consume();
            selectedIndex = this.getJList1().getSelectionModel().getMinSelectionIndex();
            if (selectedIndex < this.getJList1().getModel().getSize() - 1) {
                this.getJList1().setSelectedIndex(selectedIndex + 1);
            }
        }
        if (keyEvent.getKeyCode() == 38) {
            keyEvent.consume();
            selectedIndex = this.getJList1().getSelectionModel().getMinSelectionIndex();
            if (selectedIndex > 0) {
                this.getJList1().setSelectedIndex(selectedIndex - 1);
            }
        }
        if (keyEvent.getKeyCode() == 10) {
            keyEvent.consume();
            this.selectionMade();
        }
    }

    public void selectionMade() {
        int i = this.getJList1().getSelectionModel().getMinSelectionIndex();
        this.getJTextField1().setText((String)this.getJList1().getModel().getElementAt(i));
        this.getJList1().setVisible(false);
        this.doLayout();
        this.repaint();
    }

    private void setDefaultListModel1(DefaultListModel newValue) {
        if (this.ivjDefaultListModel1 != newValue) {
            try {
                DefaultListModel oldValue = this.getDefaultListModel1();
                this.ivjDefaultListModel1 = newValue;
                this.firePropertyChange("model", oldValue, newValue);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    public void setModel(DefaultListModel arg1) {
        this.setDefaultListModel1(arg1);
    }

    public void setPrototypeCellValue(Object value) {
        this.getJList1().setPrototypeCellValue(value);
    }

    class IvjEventHandler
    implements KeyListener,
    MouseListener {
        IvjEventHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getSource() == SelectList.this.getJTextField1()) {
                SelectList.this.connEtoC1(e);
            }
            if (e.getSource() == SelectList.this.getJTextField1()) {
                SelectList.this.connEtoC2(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getSource() == SelectList.this.getJList1()) {
                SelectList.this.connEtoC3(e);
            }
        }
    }
}

