/*
 * Decompiled with CFR 0.152.
 */
package glider.utils;

public class ByteArray {
    private byte[] bytes;
    private int length = 0;

    public ByteArray() {
        this(1000);
    }

    public ByteArray(int length) {
        this.bytes = new byte[length];
    }

    public ByteArray(byte[] data) {
        if (data.length > this.length) {
            this.bytes = new byte[2 * data.length];
        }
        System.arraycopy(data, 0, this.bytes, 0, data.length);
        this.length = data.length;
    }

    public synchronized void clear() {
        this.length = 0;
    }

    public synchronized void append(byte b) {
        if (this.length == this.bytes.length) {
            byte[] newbytes = new byte[this.bytes.length * 2];
            System.arraycopy(this.bytes, 0, newbytes, 0, this.bytes.length);
            this.bytes = newbytes;
        }
        this.bytes[this.length++] = b;
    }

    public synchronized void backspace() {
        if (this.length < 1) {
            return;
        }
        --this.length;
    }

    public synchronized byte delete() {
        byte result = this.bytes[0];
        --this.length;
        byte[] newBytes = new byte[this.length];
        System.arraycopy(this.bytes, 1, newBytes, 0, this.length);
        this.bytes = newBytes;
        return result;
    }

    public synchronized byte[] getBytes() {
        return this.getBytes(0, this.length - 1);
    }

    public synchronized byte[] getBytes(int start) {
        return this.getBytes(start, this.length - 1);
    }

    public synchronized byte[] getBytes(int start, int end) {
        byte[] result = new byte[end - start + 1];
        System.arraycopy(this.bytes, start, result, 0, end - start + 1);
        return result;
    }

    public synchronized int length() {
        return this.length;
    }
}

