/*
 * Decompiled with CFR 0.152.
 */
package glider.table;

import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
implements TableModel,
TableModelListener {
    private Vector listeners = new Vector();
    private TableModel model = null;
    private int[] index = null;
    public boolean ascending = true;
    public int sortColumn;
    private JTable table = null;

    public TableSorter(JTable table, TableModel model) {
        this.model = model;
        this.table = table;
        this.regenerateIndex();
        this.addMouseListenerToHeaderInTable(table);
    }

    private void addMouseListenerToHeaderInTable(JTable table) {
        table.setColumnSelectionAllowed(false);
        final JTable jTable = table;
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = jTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                TableSorter.this.sortColumn = jTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && TableSorter.this.sortColumn != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    TableSorter.this.ascending = shiftPressed == 0;
                    TableSorter.this.sort();
                }
            }
        };
        JTableHeader th = jTable.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.addElement(l);
    }

    public int compare(int row1, int row2) {
        int result = this.compareRowsByColumn(row1, row2, this.sortColumn);
        if (result != 0) {
            return this.ascending ? result : -result;
        }
        return 0;
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        Object v2;
        String s2;
        Class<?> type = this.model.getColumnClass(column);
        TableModel data = this.model;
        Object o1 = data.getValueAt(row1, column);
        Object o2 = data.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type.getSuperclass() == Number.class) {
            Number n2;
            double d2;
            Number n1 = (Number)data.getValueAt(row1, column);
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)data.getValueAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (type == Date.class) {
            Date d2;
            long n2;
            Date d1 = (Date)data.getValueAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)data.getValueAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == String.class) {
            String s22;
            String s1 = (String)data.getValueAt(row1, column);
            int result = s1.compareTo(s22 = (String)data.getValueAt(row2, column));
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Boolean.class) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)data.getValueAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)data.getValueAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return -1;
            }
            return 1;
        }
        Object v1 = data.getValueAt(row1, column);
        String s1 = v1.toString();
        int result = s1.compareTo(s2 = (v2 = data.getValueAt(row2, column)).toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public Class getColumnClass(int columnIndex) {
        return this.model.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.model.getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        if (this.index.length != this.model.getRowCount()) {
            this.regenerateIndex();
        }
        return this.model.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.model.getValueAt(this.index[rowIndex], columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.model.isCellEditable(this.index[rowIndex], columnIndex);
    }

    private void regenerateIndex() {
        this.index = new int[this.model.getRowCount()];
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = i;
        }
        this.reSize();
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.removeElement(l);
    }

    public void reSize() {
        int FILL = 10;
        TableModel model = this.table.getModel();
        FontMetrics fm = this.table.getFontMetrics(this.table.getFont());
        for (int col = 0; col < this.table.getColumnCount(); ++col) {
            TableColumn tc = this.table.getColumnModel().getColumn(col);
            int dataCol = tc.getModelIndex();
            int max = fm.stringWidth((String)tc.getHeaderValue());
            for (int row = 0; row < model.getRowCount(); ++row) {
                String s;
                if (model.getColumnClass(dataCol) == Integer.class) {
                    s = ((Integer)model.getValueAt(row, dataCol)).toString();
                } else {
                    if (model.getColumnClass(dataCol) == Boolean.class) break;
                    s = (String)model.getValueAt(row, dataCol);
                }
                int size = fm.stringWidth(s);
                if (size <= max) continue;
                max = size;
            }
            tc.setWidth(max + 10);
        }
        this.table.getTableHeader().repaint();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.model.setValueAt(aValue, this.index[rowIndex], columnIndex);
    }

    void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    public void sort() {
        this.shuttlesort((int[])this.index.clone(), this.index, 0, this.index.length);
        for (int i = 0; i < this.listeners.size(); ++i) {
            TableModelListener l = (TableModelListener)this.listeners.elementAt(i);
            l.tableChanged(new TableModelEvent(this));
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.regenerateIndex();
        this.sort();
    }
}

