/*
 * Decompiled with CFR 0.152.
 */
package glider.replay;

import glider.COMMON;
import glider.Day;
import glider.Glider;
import glider.Home;
import glider.MapViewer;
import glider.replay.LogHolder;
import glider.replay.MovingPlane;
import glider.replay.ReplayOptions;
import glider.replay.Replay_jButtonPause_actionAdapter;
import glider.replay.Replay_jButtonPlay_actionAdapter;
import glider.replay.Replay_jButtonRewind_actionAdapter;
import glider.replay.Replay_jButtonSynch_actionAdapter;
import glider.replay.Replay_jComboBoxDelay_actionAdapter;
import glider.replay.Replay_jSlider1_propertyChangeAdapter;
import glider.replay.TimeListener;
import gui.JJDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class Replay
extends JJDialog
implements ActionListener {
    Ticker ticker = new Ticker();
    ArrayList<TimeListener> listeners = new ArrayList();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    GridLayout gridLayout1 = new GridLayout();
    JToggleButton jButtonPause = new JToggleButton();
    JToggleButton jButtonPlay = new JToggleButton();
    JPanel jPanel4 = new JPanel();
    JComboBox jComboBoxDelay = new JComboBox();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JButton jButtonRewind = new JButton();
    JSlider jSlider1 = new JSlider();
    Border border1;
    JToggleButton jButtonSynch = new JToggleButton();
    long maxTime = 0L;
    long minTime = Long.MAX_VALUE;
    Color[] colors = new Color[]{Color.black, Color.gray.darker(), Color.blue, new Color(200, 200, 255), Color.cyan, Color.white, Color.cyan.darker(), Color.green, new Color(200, 255, 200), Color.magenta, Color.orange, Color.pink, Color.red, Color.yellow};

    public Replay(Frame frame, String title) {
        super(frame, title, false, false);
        try {
            this.jbInit();
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Replay() {
        this((Frame)null, "");
    }

    public void addTimeListener(TimeListener l) {
        this.listeners.add(l);
        if (l.getMaxTime() > this.maxTime) {
            this.maxTime = l.getMaxTime();
        }
        if (l.getMinTime() < this.minTime) {
            this.minTime = l.getMinTime();
        }
    }

    private void init() throws Exception {
        this.jComboBoxDelay.addItem("1");
        this.jComboBoxDelay.addItem("2");
        this.jComboBoxDelay.addItem("5");
        this.jComboBoxDelay.addItem("10");
        this.jComboBoxDelay.addItem("20");
        this.jComboBoxDelay.addItem("50");
        this.jComboBoxDelay.setSelectedIndex(0);
        COMMON.currentClassBox.addActionListener(this);
        COMMON.currentDay.addActionListener(this);
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(0, 5, 0, 0);
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(0);
        this.jPanel3.setLayout(this.gridLayout1);
        this.gridLayout1.setHgap(0);
        this.jPanel4.setLayout(this.borderLayout2);
        this.jLabel1.setText("Fart:");
        this.jPanel4.setBorder(this.border1);
        this.jButtonPlay.addActionListener(new Replay_jButtonPlay_actionAdapter(this));
        this.jButtonPause.addActionListener(new Replay_jButtonPause_actionAdapter(this));
        this.jButtonRewind.addActionListener(new Replay_jButtonRewind_actionAdapter(this));
        this.jButtonSynch.addActionListener(new Replay_jButtonSynch_actionAdapter(this));
        this.jComboBoxDelay.addActionListener(new Replay_jComboBoxDelay_actionAdapter(this));
        this.jSlider1.addPropertyChangeListener(new Replay_jSlider1_propertyChangeAdapter(this));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.jButtonPlay, null);
        this.jPanel3.add((Component)this.jButtonPause, null);
        this.jPanel3.add((Component)this.jButtonRewind, null);
        this.jPanel3.add((Component)this.jButtonSynch, null);
        this.jPanel3.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.jComboBoxDelay, "Center");
        this.jPanel4.add((Component)this.jLabel1, "West");
        this.jPanel1.add((Component)this.jSlider1, "Center");
        URL url = Replay.class.getClassLoader().getResource("glider/resourcer/Synch16.gif");
        this.jButtonSynch.setIcon(new ImageIcon(url));
        url = Replay.class.getClassLoader().getResource("glider/resourcer/Play16.gif");
        this.jButtonPlay.setIcon(new ImageIcon(url));
        url = Replay.class.getClassLoader().getResource("glider/resourcer/Pause16.gif");
        this.jButtonPause.setIcon(new ImageIcon(url));
        url = Replay.class.getClassLoader().getResource("glider/resourcer/Rewind16.gif");
        this.jButtonRewind.setIcon(new ImageIcon(url));
        this.jButtonPause.setToolTipText("Pause");
        this.jButtonPlay.setToolTipText("Afspil");
        this.jButtonRewind.setToolTipText("Forfra");
        this.jButtonSynch.setToolTipText("Synkroniser start");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void tick(long time) {
        if (time >= this.maxTime) {
            this.ticker.pause();
        }
        int percent = (int)(100L * (time - this.minTime) / (this.maxTime - this.minTime));
        this.jSlider1.setValue(percent);
        for (int i = 0; i < this.listeners.size(); ++i) {
            TimeListener l = this.listeners.get(i);
            l.tick(time);
        }
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
        if (value) {
            this.prepareRace();
            new Thread(this.ticker).start();
        } else {
            this.ticker.stop();
            COMMON.getMapViewer().removeMovingPlanes();
        }
    }

    void prepareRace() {
        this.jSlider1.setValue(0);
        MapViewer mapViewer = COMMON.getMapViewer();
        mapViewer.removeMovingPlanes();
        int planeCount = COMMON.getContest().getCurrentClass().planeCount();
        String dirName = Home.getHome() + COMMON.getContest().getName() + Home.SEP + "Dag " + ((Day)COMMON.currentDay.getSelectedItem()).getDay();
        ArrayList<String> planes = new ArrayList<String>();
        for (int i = 0; i < planeCount; ++i) {
            String name = COMMON.getContest().getCurrentClass().getPlane(i).getContestNumber();
            planes.add(name);
        }
        ReplayOptions ro = new ReplayOptions(new Frame(), "V\u00e6lg viste fly", planes);
        ro.setVisible(true);
        for (Object o : ro.getSelectedPlanes()) {
            String name = (String)o;
            Color color = this.getColor(name);
            String fileName = dirName + Home.SEP + name + ".igc";
            File igcFile = new File(fileName);
            if (!igcFile.exists()) continue;
            MovingPlane plane = new MovingPlane(name, color, mapViewer);
            LogHolder logHolder = new LogHolder(igcFile, plane);
            this.addTimeListener(logHolder);
        }
    }

    Color getColor(String name) {
        if (name == null || name.length() == 0) {
            return Color.BLACK;
        }
        char c = name.charAt(0);
        if (name.length() > 1) {
            c = (char)(c + name.charAt(1));
        }
        return this.colors[c % 14];
    }

    void jButtonPlay_actionPerformed(ActionEvent e) {
        this.ticker.play();
    }

    void jButtonPause_actionPerformed(ActionEvent e) {
        this.ticker.pause();
    }

    void jButtonRewind_actionPerformed(ActionEvent e) {
        this.ticker.rewind();
    }

    void jButtonSynch_actionPerformed(ActionEvent e) {
        boolean synchroneous = Glider.getRoundButtonRace().isSelected();
        for (TimeListener tl : this.listeners) {
            tl.setSynchroneous(synchroneous);
        }
    }

    void jComboBoxDelay_actionPerformed(ActionEvent e) {
        int step = Integer.parseInt((String)this.jComboBoxDelay.getSelectedItem());
        this.ticker.setStep(step);
    }

    void jSlider1_propertyChange(PropertyChangeEvent e) {
        this.ticker.setTime(this.minTime + (this.maxTime - this.minTime) * (long)this.jSlider1.getValue() / 100L);
    }

    private class Ticker
    implements Runnable {
        int step = 1000;
        boolean active;
        boolean alive;
        long time;

        private Ticker() {
            this.time = Replay.this.minTime;
        }

        public void stop() {
            this.alive = false;
        }

        public void play() {
            this.active = true;
            Replay.this.jButtonPlay.setSelected(true);
            Replay.this.jButtonPause.setSelected(false);
        }

        public void pause() {
            Replay.this.jButtonPlay.setSelected(false);
            Replay.this.jButtonPause.setSelected(true);
            this.active = false;
        }

        public void rewind() {
            Replay.this.jSlider1.setValue(0);
            this.time = Replay.this.minTime;
            this.pause();
            for (int i = 0; i < Replay.this.listeners.size(); ++i) {
                TimeListener l = Replay.this.listeners.get(i);
                l.rewind();
            }
        }

        public void setStep(int step) {
            this.step = step;
        }

        public void setTime(long time) {
            this.time = time;
        }

        @Override
        public void run() {
            this.alive = true;
            this.rewind();
            this.play();
            while (this.alive) {
                if (this.active) {
                    Replay.this.tick(this.time);
                    this.time += (long)(this.step * 10000);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

