/*
 * Decompiled with CFR 0.152.
 */
package glider.replay;

import glider.GDialog;
import glider.data.Coordinate;
import glider.replay.PositionListener;
import glider.replay.TimeListener;
import glider.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class LogHolder
implements TimeListener {
    final DateFormat sdf = new SimpleDateFormat("HHmmss");
    ArrayList<Position> positions = new ArrayList();
    PositionListener plane;
    long lastTime = -1L;
    int lastIndex = 0;
    long maxTime = 0L;
    long minTime = Long.MAX_VALUE;
    long syncOffset = 0L;
    private boolean synchronous = false;

    public LogHolder(File igcFile, PositionListener plane) {
        this.plane = plane;
        try {
            BufferedReader br = new BufferedReader(new FileReader(igcFile));
            String line = null;
            Coordinate lastCoord = null;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("B")) continue;
                int indexN = line.indexOf(78);
                int indexE = line.indexOf(69);
                if (indexN < 0 || indexE < 0 || indexE < indexN) continue;
                int lat = new Integer(line.substring(7, line.indexOf(78)));
                int lon = new Integer(line.substring(line.indexOf(78) + 1, line.indexOf(69)));
                Coordinate coord = new Coordinate(lat, lon);
                int course = lastCoord == null ? 0 : (int)Utils.heading(lastCoord, coord);
                int height = Integer.parseInt(line.substring(25, 29)) / 4;
                String utc = line.substring(1, 7);
                Date date = this.sdf.parse(utc);
                long time = date.getTime();
                Position p = new Position(time, course, height, coord);
                this.positions.add(p);
                lastCoord = coord;
                if (height > 1 && time < this.minTime) {
                    this.minTime = time;
                }
                if (time <= this.maxTime) continue;
                this.maxTime = time;
            }
            br.close();
        }
        catch (Exception ex) {
            GDialog.exception(ex);
        }
    }

    @Override
    public void rewind() {
        this.lastIndex = 0;
    }

    @Override
    public long getMaxTime() {
        return this.maxTime;
    }

    @Override
    public long getMinTime() {
        return this.minTime;
    }

    @Override
    public void tick(long time) {
        if (this.plane == null) {
            return;
        }
        if (this.lastTime < 0L) {
            this.lastTime = time;
            this.syncOffset = this.positions.get((int)0).time - time;
            return;
        }
        if (time == this.lastTime) {
            return;
        }
        Position p = null;
        for (int i = this.lastIndex; i < this.positions.size(); ++i) {
            p = this.positions.get(i);
            if (this.synchronous) {
                if (p.time - this.syncOffset <= time) continue;
                this.lastIndex = i;
                break;
            }
            if (p.time <= time) continue;
            this.lastIndex = i;
            break;
        }
        if (p != null) {
            this.plane.positionChanged(p.course, p.height, p.coord);
        }
    }

    @Override
    public void setSynchroneous(boolean value) {
        this.synchronous = value;
    }

    class Position {
        long time;
        int course;
        int height;
        Coordinate coord;

        Position(long time, int course, int height, Coordinate coord) {
            this.time = time;
            this.course = course;
            this.height = height;
            this.coord = coord;
        }
    }
}

