/*
 * Decompiled with CFR 0.152.
 */
package glider.importcontest;

import glider.COMMON;
import glider.GDialog;
import glider.Glider;
import glider.Handicap;
import glider.Home;
import glider.Out;
import glider.Registration;
import glider.RegistrationRecord;
import glider.data.Contest;
import glider.data.Plane;
import glider.data.Task;
import glider.importcontest.Correct;
import glider.importcontest.TitleCase;
import glider.utils.Utils;
import gui.ButtonListener;
import gui.ButtonPanel;
import gui.JJDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class ImportContest
extends JJDialog
implements ButtonListener {
    private boolean useHandicap;
    final long ONEDAY = 86400000L;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    ButtonPanel buttonPanel = new ButtonPanel(this.getRootPane());
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JTextArea jTextArea1 = new JTextArea();
    Frame frame;
    JComboBox comboBoxDay;
    private JFileChooser jFileChooser;
    private String contestName;
    HashMap oldLoggerMap = new HashMap();
    private SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy");
    private HashMap fileTree = new HashMap();
    private TreeMap dayTree = new TreeMap();
    private Contest contest;
    private final String text = "Programmet opretter en konkurrence\nved at gennems\u00f8ge et filtr\u00e6 for IGC filer\nEksempel:\nSM 2005\n  Dag 1\n    70.igc\n    37.igc\n  Dag 2\n    75.igc\n    70.igc\nvil bevirke at konkurrencen SM 2005 oprettes med 2 konkurrence\ndage og flyene 70, 37 og 75 med informationer taget fra deres\nIGC filer.\n\nTryk OK for at forts\u00e6tte\n";
    Border border1;

    public ImportContest(Frame frame, String title, JComboBox comboBoxDay) {
        super(frame, title, true);
        this.frame = frame;
        this.comboBoxDay = comboBoxDay;
        try {
            this.jbInit();
            this.pack();
            this.buttonPanel.addButtonListener(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void applyPressed(ActionEvent actionEvent) {
    }

    @Override
    public void cancelPressed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    @Override
    public void helpPressed(ActionEvent actionEvent) {
    }

    @Override
    public void okPressed(ActionEvent actionEvent) {
        if (this.jFileChooser == null) {
            this.jFileChooser = new JFileChooser();
            this.jFileChooser.setDialogTitle("V\u00e6lg filtr\u00e6 med IGC filer");
            this.jFileChooser.setCurrentDirectory(new File("\\"));
            this.jFileChooser.setFileSelectionMode(1);
            this.jFileChooser.setAcceptAllFileFilterUsed(false);
            this.jFileChooser.setFileFilter(new DirFilter());
        }
        this.setVisible(false);
        this.jFileChooser.showDialog(this, "Importer");
        try {
            this.importDir(this.jFileChooser.getSelectedFile());
        }
        catch (Exception ex) {
            GDialog.exception(ex);
        }
        this.cancelPressed(actionEvent);
    }

    private void importDir(File dir) throws Exception {
        this.contest = null;
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        this.contestName = dir.getName();
        int lastDay = this.buildFileTree(dir, 0);
        String firstFile = (String)this.dayTree.firstKey();
        for (int someDay = ((Integer)this.dayTree.get(firstFile)).intValue(); someDay > 0; --someDay) {
        }
        Contest contest = this.getContest();
        if (contest == null) {
            return;
        }
        for (int i = 0; i <= lastDay; ++i) {
            contest.newDay(this.comboBoxDay);
        }
        for (String fileName : this.dayTree.keySet()) {
            int day0 = (Integer)this.dayTree.get(fileName);
            this.comboBoxDay.setSelectedIndex(day0);
            File igcFile = new File(fileName);
            this.addPilot(day0, igcFile);
            Date date = (Date)this.fileTree.get(fileName);
            COMMON.getContest().getDayResult().setDate(this.sdf.format(date));
        }
    }

    private void addPilot(int day0, File igcFile) {
        Properties props = new Properties();
        boolean problems = false;
        Plane plane = null;
        String contestNo = null;
        String pilot = null;
        String registration = null;
        String type = null;
        try {
            props.load(new FileInputStream(igcFile));
            String loggerId = this.getLoggerId(props);
            if (loggerId != null) {
                plane = (Plane)this.oldLoggerMap.get(loggerId);
            }
            if (plane == null) {
                contestNo = this.getContestNo(props);
                if (contestNo != null && contestNo.length() > 0) {
                    plane = this.getContest().getPlane(contestNo);
                    if (plane == null) {
                        RegistrationRecord regRecord = Registration.get(contestNo);
                        if (regRecord != null) {
                            registration = regRecord.registration;
                            type = regRecord.type;
                        } else {
                            registration = this.getRegistration(props);
                            type = this.getType(props);
                        }
                    }
                } else {
                    registration = this.getRegistration(props);
                    type = this.getType(props);
                }
                pilot = this.getPilot(props);
                plane = new Plane(registration, contestNo, type, pilot, 0);
                this.processNewPlane(plane, igcFile);
                this.oldLoggerMap.put(loggerId, plane);
            }
        }
        catch (IOException ex) {
            GDialog.exception(ex);
            problems = true;
        }
        if (problems || plane == null) {
            Out.show(COMMON.errorLogName);
            if (!GDialog.accept("Vil du forts\u00e6tte?", "Problemer")) {
                return;
            }
        }
        try {
            Task t;
            Plane existing = this.getContest().getPlane(plane.getContestNumber());
            if (existing == null) {
                existing = this.getContest().getPlane(plane.getRegistration());
            }
            if (existing == null) {
                this.getContest().addPlane((JFrame)this.frame, plane.getRegistration(), plane.getContestNumber(), plane.getType(), plane.getPilot(), "" + plane.getHandicap());
            }
            String dstName = Home.getHome() + this.getContest().getName() + Home.SEP + "Dag " + (day0 + 1) + Home.SEP + plane.getContestNumber() + ".igc";
            File dst = new File(dstName);
            try {
                Utils.copy(igcFile, dst);
            }
            catch (IOException ex1) {
                GDialog.exception(ex1);
            }
            if (COMMON.getContest().getDayResult(day0).getTask() == null && (t = Utils.getTask(igcFile)) != null) {
                COMMON.getContest().getDayResult(day0).setTask(t);
            }
        }
        catch (Exception ex) {
            GDialog.exception(ex);
        }
    }

    private void processNewPlane(Plane plane, File igcFile) {
        try {
            boolean checkit;
            Handicap handicaps = Handicap.getInstance();
            String handi = handicaps.get(plane.getType());
            int handicap = 100;
            if (this.useHandicap) {
                try {
                    handicap = Integer.parseInt(handi);
                }
                catch (NumberFormatException ex1) {
                    handicap = 0;
                }
            }
            plane.setHandicap(handicap);
            boolean bl = checkit = plane.getRegistration() == null || plane.getRegistration().length() < 6 || plane.getContestNumber() == null || plane.getContestNumber().length() < 1 || plane.getType() == null || plane.getType().length() < 1 || plane.getPilot() == null || plane.getPilot().length() < 2 || plane.getHandicap() == 0;
            if (checkit) {
                Plane existing = this.getContest().getPlane(plane.getContestNumber());
                if (existing != null && existing.getContestNumber().equals(plane.getContestNumber())) {
                    checkit = false;
                }
                if (checkit) {
                    Correct correct = new Correct(this.frame, plane, igcFile, this.useHandicap);
                    correct.setVisible(true);
                }
            }
        }
        catch (Exception ex) {
            GDialog.exception(ex);
        }
    }

    private String getType(Properties props) {
        String type = this.getIgnoreCase("HFGTYGLIDERTYPE", props);
        if (type == null) {
            return "Ukendt fly type";
        }
        return type;
    }

    private String getContestNo(Properties props) {
        String contestNo = this.getIgnoreCase("HFCID", props);
        if (contestNo == null) {
            contestNo = this.getIgnoreCase("HSCID", props);
        }
        if (contestNo != null) {
            contestNo = contestNo.toUpperCase();
        }
        return contestNo;
    }

    private String getPilot(Properties props) {
        String pilot = this.getIgnoreCase("HFPLT", props);
        if (pilot == null || pilot.length() < 1) {
            return "Ukendt Pilot";
        }
        return TitleCase.format(pilot);
    }

    private String getRegistration(Properties props) {
        String registration = this.getIgnoreCase("HFGID", props);
        if (registration != null) {
            registration = registration.toUpperCase();
        }
        return registration;
    }

    private String getIgnoreCase(String name, Properties props) {
        String match = null;
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String item = (String)names.nextElement();
            if (!item.toUpperCase().startsWith(name.toUpperCase())) continue;
            match = props.getProperty(item);
            int colon = match.indexOf(58);
            if (colon < 0) break;
            match = match.substring(colon + 1);
            break;
        }
        if (match != null) {
            match = match.trim();
        }
        return match;
    }

    private String getLoggerId(Properties props) {
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String item = (String)names.nextElement();
            if (item.charAt(0) != 'A') continue;
            return item.substring(1, 7);
        }
        return null;
    }

    private Date getDate(File igcFile) {
        BufferedReader br = null;
        try {
            String line = null;
            br = new BufferedReader(new FileReader(igcFile));
            boolean cnt = false;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("HFDTE")) continue;
                br.close();
                String d = line.substring(5);
                return this.sdf.parse(d);
            }
            br.close();
        }
        catch (Exception ex) {
            GDialog.exception(ex);
            try {
                br.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private int buildFileTree(File topDir, int generation) throws Exception {
        if (generation == 0) {
            this.fileTree.clear();
            this.dayTree.clear();
        }
        int lastDay = 0;
        File[] files = topDir.listFiles(new IgcFileFilter());
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                this.buildFileTree(f, generation + 1);
                continue;
            }
            Date d = this.getDate(f);
            if (d == null) {
                d = new Date(f.lastModified());
                String fileDate = this.sdf.format(d);
                String answer = GDialog.ask("Ingen dato (HFDTE) inde i filen\n" + f.getAbsolutePath() + "\nSkal filens dato benyttes i stedet?", fileDate, "Ugyldig IGC fil");
                try {
                    d = this.sdf.parse(answer);
                }
                catch (Exception ex) {
                    GDialog.exception(ex);
                    d = this.sdf.parse(fileDate);
                }
            }
            this.fileTree.put(f.getAbsolutePath(), d);
        }
        if (generation == 0) {
            TreeSet s = new TreeSet();
            for (Object fileName : this.fileTree.keySet()) {
                s.add(this.fileTree.get(fileName));
            }
            for (Object fileName : this.fileTree.keySet()) {
                String[] items = ((String)fileName).split("\\\\");
                if (items.length <= 2) continue;
                String day = items[items.length - 2];
                day = day.substring(4);
                int day0 = Integer.parseInt(day) - 1;
                this.dayTree.put(fileName, new Integer(day0));
                if (day0 <= lastDay) continue;
                lastDay = day0;
            }
        }
        return lastDay;
    }

    private void emptyDir(File top) {
        if (top.isDirectory()) {
            File[] content = top.listFiles();
            for (int i = 0; i < content.length; ++i) {
                this.emptyDir(content[i]);
            }
        }
        top.delete();
    }

    private Contest getContest() {
        if (this.contest == null) {
            boolean ok;
            this.contestName = GDialog.ask(this.frame, "V\u00e6lg konkurrence navn", this.contestName, "Konkurrence Navn");
            if (this.contestName == null) {
                return null;
            }
            String className = GDialog.ask(this.frame, "V\u00e6lg klasse navn", "15m", "Klasse");
            if (className == null) {
                return null;
            }
            Vector<String> classList = new Vector<String>();
            classList.add(className);
            this.contest = COMMON.getContest();
            File contestDir = new File(Home.getHome() + this.contestName);
            if (contestDir.isDirectory()) {
                if (!GDialog.accept("Skal den eksisterende konkurrence slettes?", "Advarsel")) {
                    return null;
                }
                this.emptyDir(contestDir);
                if (contestDir.isDirectory()) {
                    GDialog.warning(this, "Kunne ikke slette den eksisterende konkurrence");
                    return null;
                }
            }
            if (ok = this.contest.newContest(this.contestName, classList)) {
                ((Glider)COMMON.topFrame).ruleSetup(COMMON.topFrame);
            }
            boolean bl = this.useHandicap = !COMMON.getContest().getDmRules();
            if (!ok) {
                GDialog.accept("Kunne ikke oprette konkurrencen", "Fejl");
            }
        }
        return this.contest;
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.getContentPane().setLayout(this.borderLayout1);
        this.buttonPanel.setHasApply(false);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setText("Programmet opretter en konkurrence\nved at gennems\u00f8ge et filtr\u00e6 for IGC filer\nEksempel:\nSM 2005\n  Dag 1\n    70.igc\n    37.igc\n  Dag 2\n    75.igc\n    70.igc\nvil bevirke at konkurrencen SM 2005 oprettes med 2 konkurrence\ndage og flyene 70, 37 og 75 med informationer taget fra deres\nIGC filer.\n\nTryk OK for at forts\u00e6tte\n");
        this.jPanel1.setBorder(this.border1);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jTextArea1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    private class IgcFileFilter
    implements FileFilter {
        private IgcFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            String name = f.getName();
            return f.isDirectory() || name.toLowerCase().endsWith(".igc");
        }

        public String getDescription() {
            return "IGC filer";
        }
    }

    private class DirFilter
    extends javax.swing.filechooser.FileFilter {
        private DirFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "Folder";
        }
    }
}

