/*
 * Decompiled with CFR 0.152.
 */
package glider.importcontest;

import glider.COMMON;
import glider.Handicap;
import glider.Out;
import glider.Registration;
import glider.RegistrationRecord;
import glider.data.Plane;
import glider.importcontest.Correct_jButtonCheck_actionAdapter;
import glider.importcontest.Correct_jButtonOpen_actionAdapter;
import glider.importcontest.TitleCase;
import gui.ButtonListener;
import gui.ButtonPanel;
import gui.JJDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class Correct
extends JJDialog
implements ButtonListener {
    BorderLayout borderLayout1 = new BorderLayout();
    ButtonPanel buttonPanel1 = new ButtonPanel(this.getRootPane());
    JPanel jPanel1 = new JPanel();
    Border border1;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JTextField jTextFieldReg = new JTextField();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabelHandicap = new JLabel();
    JLabel jLabel5 = new JLabel();
    JTextField jTextFieldContestNo = new JTextField();
    JTextField jTextFieldType = new JTextField();
    JTextField jTextFieldHandicap = new JTextField();
    JTextField jTextFieldPilot = new JTextField();
    Plane plane;
    JLabel jLabel1 = new JLabel();
    JButton jButtonCheck = new JButton();
    JLabel jLabel6 = new JLabel();
    JLabel jLabel7 = new JLabel();
    JLabel jLabel8 = new JLabel();
    JPanel jPanel2 = new JPanel();
    JButton jButtonOpen = new JButton();
    JLabel jLabelFileName = new JLabel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    private boolean useHandicap;

    public Correct(Frame frame, Plane plane, File igcFile, boolean useHandicap) {
        super(frame, "Korriger Oplysninger", true);
        this.plane = plane;
        this.useHandicap = useHandicap;
        try {
            this.jbInit();
            this.init(igcFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void okPressed(ActionEvent e) {
        this.plane.setContestNumber(this.jTextFieldContestNo.getText().trim().toUpperCase());
        if (this.useHandicap) {
            this.plane.setHandicap(Integer.parseInt(this.jTextFieldHandicap.getText().trim()));
        }
        this.plane.setPilot(TitleCase.format(this.jTextFieldPilot.getText()));
        this.plane.setRegistration(this.jTextFieldReg.getText().trim());
        this.plane.setType(this.jTextFieldType.getText().trim());
        this.setVisible(false);
    }

    @Override
    public void applyPressed(ActionEvent e) {
    }

    @Override
    public void cancelPressed(ActionEvent e) {
        this.setVisible(false);
    }

    @Override
    public void helpPressed(ActionEvent e) {
    }

    private void initFields() {
        this.jTextFieldContestNo.setText(this.plane.getContestNumber());
        this.jTextFieldType.setText(this.plane.getType());
        if (this.useHandicap) {
            this.jTextFieldHandicap.setMinimumSize(new Dimension(100, 20));
            this.jTextFieldHandicap.setPreferredSize(new Dimension(100, 20));
            this.jPanel1.add((Component)this.jLabelHandicap, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.jTextFieldHandicap, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            int handicap = this.plane.getHandicap();
            if (handicap > 0) {
                this.jTextFieldHandicap.setText("" + handicap);
            }
        }
        this.jTextFieldPilot.setText(this.plane.getPilot());
        this.jTextFieldReg.setText(this.plane.getRegistration());
    }

    private void init(File igcFile) {
        this.initFields();
        this.jLabelFileName.setText(igcFile.getAbsolutePath());
        this.pack();
        this.buttonPanel1.addButtonListener(this);
        this.checkValid();
        Enabler enabler = new Enabler();
        this.jTextFieldContestNo.addKeyListener(enabler);
        if (this.useHandicap) {
            this.jTextFieldHandicap.addKeyListener(enabler);
        }
        this.jTextFieldPilot.addKeyListener(enabler);
        this.jTextFieldReg.addKeyListener(enabler);
        this.jTextFieldType.addKeyListener(enabler);
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 0, 10);
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setBorder(this.border1);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jLabel2.setText("Konkurrence Nummer:");
        this.jLabel3.setText("Type:");
        this.jLabelHandicap.setText("Handikap:");
        this.jLabel5.setText("Pilot:");
        this.buttonPanel1.setHasApply(false);
        this.buttonPanel1.setHasHelp(false);
        this.jLabel1.setText("Registrering:");
        this.jButtonCheck.setToolTipText("Hent oplysninger for dette nr");
        this.jButtonCheck.setText("<-- Check");
        this.jButtonCheck.addActionListener(new Correct_jButtonCheck_actionAdapter(this));
        this.jLabel6.setRequestFocusEnabled(true);
        this.jLabel6.setText("Hint: Hvis mange felter er tomme, s\u00e5 se, om du kan");
        this.jLabel7.setText("udlede konkurrence nummeret fra filnavnet. \u00c5bn evt. filen");
        this.jLabel8.setText("Tryk derefter p\u00e5 Check knappen");
        this.jTextFieldPilot.setMinimumSize(new Dimension(200, 20));
        this.jTextFieldPilot.setPreferredSize(new Dimension(200, 20));
        this.jTextFieldType.setMinimumSize(new Dimension(100, 20));
        this.jTextFieldType.setPreferredSize(new Dimension(100, 20));
        this.jTextFieldContestNo.setMinimumSize(new Dimension(100, 20));
        this.jTextFieldContestNo.setPreferredSize(new Dimension(100, 20));
        this.jTextFieldReg.setMinimumSize(new Dimension(100, 20));
        this.jTextFieldReg.setPreferredSize(new Dimension(100, 20));
        this.jPanel2.setLayout(this.gridBagLayout2);
        this.jButtonOpen.setText("\u00c5bn IGC fil");
        this.jButtonOpen.addActionListener(new Correct_jButtonOpen_actionAdapter(this));
        this.jLabelFileName.setText("filnavn");
        this.getContentPane().add((Component)this.buttonPanel1, "South");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jTextFieldReg, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel3, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel5, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jTextFieldContestNo, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jTextFieldType, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jTextFieldPilot, new GridBagConstraints(1, 8, 3, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel6, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel7, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jButtonCheck, new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jLabel8, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel2, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jButtonOpen, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.jPanel2.add((Component)this.jLabelFileName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void checkValid() {
        String tooltip = null;
        int handicap = 100;
        if (this.useHandicap) {
            try {
                handicap = Integer.parseInt(this.jTextFieldHandicap.getText().trim());
            }
            catch (NumberFormatException ex) {
                handicap = 0;
            }
        }
        if (this.jTextFieldReg.getText().trim().length() < 1) {
            tooltip = "Mangler registrerings nummer";
        } else if (this.jTextFieldContestNo.getText().trim().length() < 1) {
            tooltip = "Mangler konkurrence nummer";
        } else if (this.jTextFieldType.getText().trim().length() < 1) {
            tooltip = "Mangler fly type";
        } else if (handicap == 0) {
            tooltip = "Ugyldigt handikap";
        } else if (this.jTextFieldPilot.getText().trim().length() < 1) {
            tooltip = "Mangler pilot navn";
        }
        JButton ok = this.buttonPanel1.getButton(1);
        ok.setToolTipText(tooltip);
        ok.setEnabled(tooltip == null);
    }

    void jButtonCheck_actionPerformed(ActionEvent e) {
        String displayedHandicap;
        String h;
        RegistrationRecord regRecord;
        String contestNo = this.jTextFieldContestNo.getText().trim().toUpperCase();
        Plane p = COMMON.getContest().getPlane(contestNo);
        if (p != null) {
            this.plane.setContestNumber(p.getContestNumber());
            this.plane.setPilot(p.getPilot());
            this.plane.setRegistration(p.getRegistration());
            this.plane.setType(p.getType());
            this.plane.setHandicap(p.getHandicap());
            this.initFields();
            this.checkValid();
        } else if (contestNo != null && contestNo.length() > 0 && (regRecord = Registration.get(contestNo)) != null) {
            this.plane.setContestNumber(contestNo);
            this.plane.setRegistration(regRecord.registration);
            this.plane.setType(regRecord.type);
            h = Handicap.getInstance().get(regRecord.type);
            if (h != null && h.length() > 0) {
                this.plane.setHandicap(Integer.parseInt(h));
            }
            this.initFields();
            this.checkValid();
        }
        if (this.useHandicap && ((displayedHandicap = this.jTextFieldHandicap.getText().trim()) == null || displayedHandicap.length() < 1) && (h = Handicap.getInstance().get(this.jTextFieldType.getText().trim())) != null && h.length() > 0) {
            this.jTextFieldHandicap.setText(h);
            this.checkValid();
        }
    }

    void jButtonOpen_actionPerformed(ActionEvent e) {
        Out.show(this.jLabelFileName.getText());
    }

    private class Enabler
    implements KeyListener {
        private Enabler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            Correct.this.checkValid();
        }
    }
}

