/*
 * Decompiled with CFR 0.152.
 */
package glider.data;

import glider.Home;
import glider.Line;
import glider.data.Coordinate;
import glider.data.IGCturnpoints;
import glider.data.TurnPoint;
import glider.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class TurnPoints {
    protected static Vector tpList = new Vector();
    private static Line line = new Line();
    final String dateDm = "8/7 2007";
    final String dateNatCatE = "1/5 2007";
    final String dateNatCatW = "10/4 2001";

    public TurnPoints() {
        this.read();
    }

    public TurnPoint[] get4Nearest(Coordinate coord) {
        TurnPoint[] nearest = new TurnPoint[4];
        double[] ndist = new double[]{10000.0, 10000.0, 10000.0, 10000.0};
        for (int i = 0; i < tpList.size(); ++i) {
            TurnPoint t = (TurnPoint)tpList.elementAt(i);
            double dist = Utils.distance(coord, new Coordinate(t.latlon));
            if (!(dist < ndist[3])) continue;
            if (dist < ndist[2]) {
                if (dist < ndist[1]) {
                    if (dist < ndist[0]) {
                        ndist[0] = dist;
                        nearest[0] = t;
                        continue;
                    }
                    ndist[1] = dist;
                    nearest[1] = t;
                    continue;
                }
                ndist[2] = dist;
                nearest[2] = t;
                continue;
            }
            ndist[3] = dist;
            nearest[3] = t;
        }
        return nearest;
    }

    public Coordinate getCoord(String name) {
        for (int i = 0; i < tpList.size(); ++i) {
            TurnPoint t = (TurnPoint)tpList.elementAt(i);
            if (!name.equals(t.description)) continue;
            return new Coordinate(t.latlon);
        }
        return null;
    }

    int getLatitude() {
        String cs = line.getItem();
        String lats = cs.substring(0, cs.indexOf(78));
        return new Integer(lats);
    }

    int getLongitude() {
        String cs = line.getItem();
        String lats = cs.substring(0, cs.indexOf(69));
        return new Integer(lats);
    }

    public TurnPoint getNearest(Coordinate coord) {
        double minDist = 10000.0;
        TurnPoint best = null;
        for (int i = 0; i < tpList.size(); ++i) {
            TurnPoint t = (TurnPoint)tpList.elementAt(i);
            double dist = Utils.distance(coord, new Coordinate(t.latlon));
            if (!(dist < minDist)) continue;
            minDist = dist;
            best = t;
        }
        return best;
    }

    public TurnPoint get(Coordinate coord) {
        for (int i = 0; i < tpList.size(); ++i) {
            TurnPoint t = (TurnPoint)tpList.elementAt(i);
            if (t.getCoordinate().latitude != coord.getLatitude() || t.getCoordinate().longitude != coord.getLongitude()) continue;
            return t;
        }
        return null;
    }

    public Vector getTpList() {
        return tpList;
    }

    private String getTpName() {
        int start = 0;
        while (line.isDelimiter(line.charAt(start))) {
            ++start;
        }
        int end = line.length() - 1;
        while (!line.isDelimiter(line.charAt(end))) {
            --end;
        }
        while (line.isDelimiter(line.charAt(end))) {
            --end;
        }
        if (end < line.length() - 1) {
            ++end;
        }
        String result = line.substring(start, end);
        line.set(line.substring(end, line.length()));
        return result;
    }

    public String getTpName(Coordinate coord) {
        for (int i = 0; i < tpList.size(); ++i) {
            TurnPoint t = (TurnPoint)tpList.elementAt(i);
            if (Math.abs(t.latlon.latitude - coord.latitude) >= 6 || Math.abs(t.latlon.longitude - coord.longitude) >= 6) continue;
            return t.description;
        }
        return "Ukendt";
    }

    public void add(TurnPoint tp) {
        if (!TurnPoints.isUsed(tp.getName())) {
            tpList.addElement(tp);
        }
    }

    public int count() {
        return tpList.size();
    }

    public String getDateDm() {
        return "8/7 2007";
    }

    public void dm() {
        tpList.removeAllElements();
        this.add(new TurnPoint(27, "8/7 2007", "ARDENJ", 5646.18, 951.59, "Arden Stn.", "", false));
        this.add(new TurnPoint(98, "8/7 2007", "ARNBOV", 5600.62, 900.5, "Arnborg Ankomst Vest", "", false));
        this.add(new TurnPoint(99, "8/7 2007", "ARNBO0", 5600.64, 901.08, "Arnborg Ankomst \u00d8st", "", false));
        this.add(new TurnPoint(97, "8/7 2007", "ARNBOH", 5600.64, 901.32, "Arnborg Hangar", "", true));
        this.add(new TurnPoint(1, "8/7 2007", "ARNBOR", 5600.85, 859.84, "Arnborg Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(68, "8/7 2007", "ASSENK", 5626.46, 1008.93, "Assentoft Kirke", "", false));
        this.add(new TurnPoint(87, "8/7 2007", "BEDERG", 5604.08, 1011.35, "Beder/Vilhelmsborg G", "", false));
        this.add(new TurnPoint(91, "8/7 2007", "BILLUH", 5544.02, 909.13, "Billund Svfl Klub", "Klubhus", true));
        this.add(new TurnPoint(90, "8/7 2007", "BILLUF", 5544.27, 910.03, "Billund TWR", "", false));
        this.add(new TurnPoint(24, "8/7 2007", "BJERRK", 5622.7, 939.63, "Bjerringbro Kirke", "", false));
        this.add(new TurnPoint(96, "8/7 2007", "BLAAHS", 5552.45, 901.97, "Bl\u00e5 H\u00f8j Silo", "", false));
        this.add(new TurnPoint(63, "8/7 2007", "BORUPH", 5655.37, 928.28, "Borup Hangar", "", false));
        this.add(new TurnPoint(49, "8/7 2007", "BRANDJ", 5556.7, 907.74, "Brande Stn.", "", false));
        this.add(new TurnPoint(3, "8/7 2007", "BREJNX", 5605.16, 830.42, "Brejning Vej-X", "", false));
        this.add(new TurnPoint(92, "8/7 2007", "BRYRUK", 5601.52, 930.77, "Bryrup Kirke", "", false));
        this.add(new TurnPoint(14, "8/7 2007", "BRADSK", 5558.01, 936.51, "Br\u00e6dstrup Kirke", "", false));
        this.add(new TurnPoint(38, "8/7 2007", "BR0RUJ", 5528.96, 900.92, "Br\u00f8rup Stn.", "", false));
        this.add(new TurnPoint(73, "8/7 2007", "BURKAK", 5455.6, 904.01, "Burkal Kirke", "", false));
        this.add(new TurnPoint(46, "8/7 2007", "BAEKMJ", 5624.79, 818.42, "B\u00e6kmarksbro Stn.", "", false));
        this.add(new TurnPoint(220, "8/7 2007", "CHRISF", 5606.31, 923.58, "Christianshede Flpl.", "Hangar", true));
        this.add(new TurnPoint(224, "8/7 2007", "EJSTRK", 5558.97, 917.21, "Ejstrupholm Kirke", "", false));
        this.add(new TurnPoint(47, "8/7 2007", "FASTEX", 5600.5, 906.69, "Fasterholt", "Vej/Jernbane-X", false));
        this.add(new TurnPoint(25, "8/7 2007", "FRISBG", 5615.9, 953.62, "Frisenborg Gods", "", false));
        this.add(new TurnPoint(9, "8/7 2007", "GIVE R", 5551.78, 915.19, "Give Rundk\u00f8rsel N\u00d8", "", false));
        this.add(new TurnPoint(74, "8/7 2007", "GRAM S", 5517.64, 903.4, "Gram Slot", "", false));
        this.add(new TurnPoint(58, "8/7 2007", "GRASTK", 5455.53, 935.71, "Gr\u00e5sten Slot Kirke", "", false));
        this.add(new TurnPoint(75, "8/7 2007", "HADRSK", 5514.97, 929.26, "Haderslev Domkirke", "", false));
        this.add(new TurnPoint(8, "8/7 2007", "HADSTJ", 5619.67, 1002.75, "Hadsten Stn.", "", false));
        this.add(new TurnPoint(66, "8/7 2007", "HADSUB", 5642.85, 1007.07, "Hadsund Bro", "Man\u00f8vrehus", false));
        this.add(new TurnPoint(30, "8/7 2007", "HAMMLB", 5614.06, 951.88, "Hammel X Ved Anb\u00e6k", "", false));
        this.add(new TurnPoint(7, "8/7 2007", "HMMRHK", 5630.07, 945.32, "Hammersh\u00f8j Kirke", "", false));
        this.add(new TurnPoint(85, "8/7 2007", "HMMRMJ", 5607.9, 903.77, "Hammerum Stn.", "", false));
        this.add(new TurnPoint(94, "8/7 2007", "HATTIY", 5550.63, 944.16, "Hatting SV", "Afk\u00f8rsel 57", false));
        this.add(new TurnPoint(136, "8/7 2007", "HEE  K", 5608.76, 816.7, "Hee Kirke", "", false));
        this.add(new TurnPoint(76, "8/7 2007", "HENNEJ", 5542.59, 818.4, "Henne Stn.", "", false));
        this.add(new TurnPoint(10, "8/7 2007", "HINGES", 5615.21, 928.98, "Hinge S\u00f8", "Vinderslevholm", false));
        this.add(new TurnPoint(31, "8/7 2007", "HOBROJ", 5638.59, 946.95, "Hobro Stn.", "", false));
        this.add(new TurnPoint(4, "8/7 2007", "HOLSTV", 5621.13, 838.37, "Holstebro Vandkraft", "", false));
        this.add(new TurnPoint(69, "8/7 2007", "HORNSJ", 5619.26, 1018.85, "Hornslet Stn.", "", false));
        this.add(new TurnPoint(37, "8/7 2007", "HOVDGJ", 5556.75, 957.76, "Hovedg\u00e5rd Stn.", "", false));
        this.add(new TurnPoint(26, "8/7 2007", "HOVENR", 5551.1, 845.0, "Hoven V Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(59, "8/7 2007", "HVIDKS", 5504.4, 1032.01, "Hvidkilde Slot", "", false));
        this.add(new TurnPoint(95, "8/7 2007", "IDOM K", 5620.16, 828.89, "Idom Kirkeby Kirke", "", false));
        this.add(new TurnPoint(40, "8/7 2007", "JELS K", 5521.43, 912.11, "Jels Kirke", "", false));
        this.add(new TurnPoint(50, "8/7 2007", "KIBAKJ", 5601.95, 851.12, "Kib\u00e6k Stn.", "", false));
        this.add(new TurnPoint(16, "8/7 2007", "KOLDIB", 5531.76, 928.01, "Kolding Motorvej-X", "", false));
        this.add(new TurnPoint(56, "8/7 2007", "KRUSAH", 5452.33, 916.72, "Krus\u00e5/Padborg Hangar", "", true));
        this.add(new TurnPoint(60, "8/7 2007", "KVARNJ", 5510.7, 1031.14, "Kv\u00e6rndrup Stn.", "", false));
        this.add(new TurnPoint(48, "8/7 2007", "K0LKAJ", 5603.91, 905.09, "K\u00f8lk\u00e6r Stn.", "", false));
        this.add(new TurnPoint(28, "8/7 2007", "LANGAY", 5622.99, 953.62, "Lang\u00e5 Jernbane-Y", "", false));
        this.add(new TurnPoint(36, "8/7 2007", "LAVENJ", 5607.5, 943.04, "Laven Stn.", "", false));
        this.add(new TurnPoint(89, "8/7 2007", "LIND R", 5624.91, 829.3, "Lind Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(64, "8/7 2007", "LINDBG", 5654.45, 1002.07, "Lindenborg Gods", "Hovedbygning", false));
        this.add(new TurnPoint(18, "8/7 2007", "L0GUMK", 5503.41, 857.02, "L\u00f8gumkloster Kirke", "", false));
        this.add(new TurnPoint(15, "8/7 2007", "L0SNIJ", 5548.16, 942.09, "L\u00f8sning Stn.", "", false));
        this.add(new TurnPoint(67, "8/7 2007", "MARIAK", 5638.89, 958.72, "Mariager Kirke", "", false));
        this.add(new TurnPoint(13, "8/7 2007", "MATTRG", 5555.46, 932.63, "Mattrup Gods", "", false));
        this.add(new TurnPoint(17, "8/7 2007", "TAPS B", 5523.48, 926.91, "Motorvejsbro A10", "Ved Taps", false));
        this.add(new TurnPoint(44, "8/7 2007", "M0LDRR", 5637.28, 930.7, "M\u00f8ldrup Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(161, "8/7 2007", "NR. FH", 5618.55, 835.27, "Nr. Felding Flpl.", "Hangar", true));
        this.add(new TurnPoint(12, "8/7 2007", "NRSNEX", 5557.86, 923.66, "N\u00f8rre Snede Vej-X", "", false));
        this.add(new TurnPoint(11, "8/7 2007", "PARUPX", 5608.21, 921.09, "P\u00e5rup Vej-X A15/A13", "", false));
        this.add(new TurnPoint(72, "8/7 2007", "RNDRSH", 5630.3, 1001.99, "Randers Flyveplads", "Hangar", true));
        this.add(new TurnPoint(19, "8/7 2007", "RIBE J", 5519.66, 846.21, "Ribe Stn.", "", false));
        this.add(new TurnPoint(52, "8/7 2007", "RIND K", 5605.43, 857.49, "Rind Kirke", "", false));
        this.add(new TurnPoint(20, "8/7 2007", "RINGGR", 5547.36, 910.69, "Ringgive Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(35, "8/7 2007", "ROM  K", 5631.0, 818.29, "Rom Kirke", "", false));
        this.add(new TurnPoint(77, "8/7 2007", "R0DDIR", 5521.96, 904.32, "R\u00f8dding Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(57, "8/7 2007", "R0DEKJ", 5504.19, 920.01, "R\u00f8dekro Stn.", "", false));
        this.add(new TurnPoint(78, "8/7 2007", "SIG  J", 5539.96, 834.6, "Sig Stn.", "", false));
        this.add(new TurnPoint(79, "8/7 2007", "SILKEJ", 5609.86, 932.7, "Silkeborg Stn.", "", false));
        this.add(new TurnPoint(80, "8/7 2007", "SJ0RUX", 5625.58, 905.07, "Sj\u00f8rup Vej-X A16", "", false));
        this.add(new TurnPoint(83, "8/7 2007", "SKANDJ", 5602.61, 955.5, "Skanderborg Stn.", "", false));
        this.add(new TurnPoint(51, "8/7 2007", "SKARRR", 5558.7, 853.86, "Skarrild Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(42, "8/7 2007", "SKINDH", 5611.28, 902.34, "Skinderholm", "Sv\u00e6veflyve Hangar", true));
        this.add(new TurnPoint(34, "8/7 2007", "SKIVEY", 5631.92, 902.28, "Skive Travbane Vej-Y", "", false));
        this.add(new TurnPoint(23, "8/7 2007", "SKJRNJ", 5556.85, 829.54, "Skjern Stn.", "", false));
        this.add(new TurnPoint(81, "8/7 2007", "SK0RPJ", 5650.2, 953.25, "Sk\u00f8rping Stn.", "", false));
        this.add(new TurnPoint(41, "8/7 2007", "STBINR", 5646.35, 934.19, "St. Binderup Rundk.", "", false));
        this.add(new TurnPoint(6, "8/7 2007", "ST0VRB", 5652.79, 948.2, "St\u00f8vring Motorvej-X", "Syd", false));
        this.add(new TurnPoint(65, "8/7 2007", "SULDRT", 5650.58, 944.5, "Suldrup", "Statoil Vest", false));
        this.add(new TurnPoint(84, "8/7 2007", "SVENSB", 5656.98, 951.94, "Svenstrup Motorvejsbro", "", false));
        this.add(new TurnPoint(93, "8/7 2007", "TAMDRK", 5553.51, 944.3, "Tamdrup Kirke", "", false));
        this.add(new TurnPoint(169, "8/7 2007", "THEM S", 5605.76, 932.73, "Them Silo", "", false));
        this.add(new TurnPoint(86, "8/7 2007", "TJELEG", 5630.58, 936.74, "Tjele Gods,Hovedbygning", "", false));
        this.add(new TurnPoint(54, "8/7 2007", "TOFTLR", 5510.79, 903.77, "Toftlund Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(62, "8/7 2007", "TOMMRY", 5520.78, 1011.29, "Tommerup Jernbane-Y", "", false));
        this.add(new TurnPoint(55, "8/7 2007", "T0NDRF", 5455.63, 850.62, "T\u00f8nder Flyveplads Forplads", "", true));
        this.add(new TurnPoint(82, "8/7 2007", "T0RRIG", 5550.8, 928.52, "T\u00f8rring,Staug\u00e5rd", "", false));
        this.add(new TurnPoint(53, "8/7 2007", "ULFBOJ", 5616.3, 819.48, "Ulfborg Stn.", "", false));
        this.add(new TurnPoint(88, "8/7 2007", "V.EJSH", 5601.17, 841.58, "V. Ejstrup Flyvepl. Hangar", "", true));
        this.add(new TurnPoint(21, "8/7 2007", "VARDEB", 5538.28, 830.84, "Varde Vej-X A11/A12", "", false));
        this.add(new TurnPoint(43, "8/7 2007", "VEJENJ", 5528.56, 908.17, "Vejen Stn.", "", false));
        this.add(new TurnPoint(29, "8/7 2007", "VEMB Y", 5620.85, 821.03, "Vemb Jernbane-Y", "", false));
        this.add(new TurnPoint(5, "8/7 2007", "VIBRGH", 5624.6, 924.68, "Viborg Flyveplads Hangar", "", true));
        this.add(new TurnPoint(2, "8/7 2007", "VIDEBK", 5605.55, 837.57, "Videb\u00e6k Kirke", "", false));
        this.add(new TurnPoint(71, "8/7 2007", "VILDBJ", 5611.86, 846.12, "Vildbjerg Stn.", "", false));
        this.add(new TurnPoint(45, "8/7 2007", "VINDEJ", 5628.98, 846.95, "Vinderup Stn.", "", false));
        this.add(new TurnPoint(39, "8/7 2007", "VORBAC", 5537.8, 904.84, "Vorbasse Bymidte", "", false));
        this.add(new TurnPoint(61, "8/7 2007", "V0JSTH", 5514.93, 1012.47, "V\u00f8jstrup Hangar", "", true));
        this.add(new TurnPoint(33, "8/7 2007", "AARS H", 5650.88, 927.87, "\u00c5rs Flyveplads Syd Hangar", "", true));
        this.add(new TurnPoint(70, "8/7 2007", "AARSLB", 5609.18, 1002.67, "\u00c5rslev Motorvejsafk\u00f8rsel", "", false));
        this.add(new TurnPoint(22, "8/7 2007", "0LGODJ", 5548.66, 837.35, "\u00d8lgod Stn.", "", false));
        this.add(new TurnPoint(32, "8/7 2007", "0RNH0K", 5612.09, 833.62, "\u00d8rnh\u00f8j Kirke", "", false));
        this.add(new TurnPoint(170, "8/7 2007", "0STBIX", 5558.09, 944.9, "\u00d8stbirk Vej-X", "", false));
    }

    public Object elementAt(int i) {
        return tpList.elementAt(i);
    }

    public void fill(DefaultListModel m, String s) {
        m.removeAllElements();
        if (s.length() < 1) {
            return;
        }
        int count = 0;
        for (int i = 0; i < tpList.size(); ++i) {
            TurnPoint t = (TurnPoint)tpList.elementAt(i);
            if (t.description.toUpperCase().indexOf(s.toUpperCase()) < 0) continue;
            m.addElement(t.description);
            if (++count <= 8) continue;
            return;
        }
    }

    public void fillAll(DefaultListModel m) {
        m.removeAllElements();
        for (int i = 0; i < tpList.size(); ++i) {
            TurnPoint t = (TurnPoint)tpList.elementAt(i);
            m.addElement(t.description);
        }
    }

    public void nationalCatalog() {
        tpList.removeAllElements();
        this.nationalCatalogW();
        this.nationalCatalogE();
    }

    public String getDateNatCatE() {
        return "1/5 2007";
    }

    public void nationalCatalogE() {
        this.add(new TurnPoint(362, "1/5 2007", "ALLERF", 5552.18, 1219.04, "Aller\u00f8d Fl. plads", "", true));
        this.add(new TurnPoint(782, "1/5 2007", "ANNEBG", 5554.13, 1140.07, "Annebjerg Gods", "", false));
        this.add(new TurnPoint(363, "1/5 2007", "BAVELK", 5520.27, 1138.62, "Bavelse Kirke", "", false));
        this.add(new TurnPoint(235, "1/5 2007", "BELDRG", 5506.39, 1159.47, "Beldringe Gods", "", false));
        this.add(new TurnPoint(418, "1/5 2007", "BISSEH", 5511.98, 1129.44, "Bisserup Havn", "", false));
        this.add(new TurnPoint(771, "1/5 2007", "BJAVE-", 5526.59, 1200.57, "Bj\u00e6verskov", "", false));
        this.add(new TurnPoint(781, "1/5 2007", "BOESLR", 5518.11, 1117.24, "Boeslunde Rundk.", "", false));
        this.add(new TurnPoint(306, "1/5 2007", "BREGVG", 5518.44, 1200.4, "Bregentved Gods", "", false));
        this.add(new TurnPoint(365, "1/5 2007", "CHARLG", 5522.86, 1122.89, "Charlottedal", "", false));
        this.add(new TurnPoint(236, "1/5 2007", "DALE X", 5602.45, 1227.32, "Dale Vej-X", "", false));
        this.add(new TurnPoint(237, "1/5 2007", "DALMOY", 5517.37, 1125.49, "Dalmose Jernbane-Y", "", false));
        this.add(new TurnPoint(366, "1/5 2007", "DIANAJ", 5532.05, 1129.9, "Dianalund Stn.", "", false));
        this.add(new TurnPoint(238, "1/5 2007", "DRAGSS", 5546.31, 1123.44, "Dragsholm Slot", "", false));
        this.add(new TurnPoint(239, "1/5 2007", "EGEBJK", 5550.7, 1140.84, "Egebjerg Kirke", "", false));
        this.add(new TurnPoint(367, "1/5 2007", "ESB0NK", 5603.16, 1220.64, "Esb\u00f8nderup Kirke", "", false));
        this.add(new TurnPoint(240, "1/5 2007", "FAKSEK", 5515.34, 1207.33, "Fakse Kirke", "", false));
        this.add(new TurnPoint(241, "1/5 2007", "FAKSLJ", 5513.04, 1209.68, "Fakse Ladeplads Stn.", "", false));
        this.add(new TurnPoint(301, "1/5 2007", "FFF  H", 5551.1, 1204.15, "FFF Hangar", "", true));
        this.add(new TurnPoint(302, "1/5 2007", "FRDNBS", 5558.92, 1223.76, "Fredensborg Slot", "", false));
        this.add(new TurnPoint(304, "1/5 2007", "FRDRBS", 5556.1, 1218.06, "Frederiksborg Slot", "", false));
        this.add(new TurnPoint(305, "1/5 2007", "FRDRVK", 5558.4, 1201.35, "Frederiksv\u00e6rk Kirke", "", false));
        this.add(new TurnPoint(441, "1/5 2007", "VARL0H", 5545.78, 1218.82, "FSN V\u00e6rl\u00f8se Hangar", "", true));
        this.add(new TurnPoint(242, "1/5 2007", "FUGLBK", 5518.32, 1132.91, "Fuglebjerg Kirke", "", false));
        this.add(new TurnPoint(243, "1/5 2007", "FAREVJ", 5547.25, 1128.1, "F\u00e5revejle Stn.", "", false));
        this.add(new TurnPoint(445, "1/5 2007", "GADEVT", 5558.07, 1217.45, "Gadevang Vej-T", "", false));
        this.add(new TurnPoint(244, "1/5 2007", "GANGEB", 5515.77, 1145.17, "Gangesbro", "", false));
        this.add(new TurnPoint(245, "1/5 2007", "GIESEG", 5525.05, 1155.97, "Gieseg\u00e5rd", "", false));
        this.add(new TurnPoint(369, "1/5 2007", "GILLEK", 5607.4, 1218.64, "Gilleleje Kirke", "", false));
        this.add(new TurnPoint(309, "1/5 2007", "GISSFG", 5517.33, 1158.3, "Gisselfeldt Gods", "", false));
        this.add(new TurnPoint(246, "1/5 2007", "GLUMSJ", 5521.22, 1141.72, "Glums\u00f8 Stn.", "", false));
        this.add(new TurnPoint(370, "1/5 2007", "GRASTK", 5603.99, 1216.81, "Gr\u00e6sted Kirke", "", false));
        this.add(new TurnPoint(371, "1/5 2007", "GR0NHF", 5556.58, 1222.86, "Gr\u00f8nholt Twr", "", true));
        this.add(new TurnPoint(455, "1/5 2007", "GUNDSK", 5518.82, 1140.34, "Gunderslevholm Kirke", "", false));
        this.add(new TurnPoint(373, "1/5 2007", "GNDSMK", 5544.11, 1208.9, "Gunds\u00f8magle Kirke", "", false));
        this.add(new TurnPoint(374, "1/5 2007", "GURREB", 5601.27, 1231.41, "Gurre Vej-Bro", "", false));
        this.add(new TurnPoint(310, "1/5 2007", "GURREX", 5602.81, 1231.5, "Gurre Vej-X", "", false));
        this.add(new TurnPoint(375, "1/5 2007", "GYRSTK", 5529.27, 1141.08, "Gyrstinge Kirke", "", false));
        this.add(new TurnPoint(451, "1/5 2007", "G0RLVA", 5533.14, 1111.77, "G\u00f8rlev Fl. plads", "", true));
        this.add(new TurnPoint(452, "1/5 2007", "G0RLES", 5532.21, 1113.98, "G\u00f8rlev Sukkerfabrik", "", false));
        this.add(new TurnPoint(339, "1/5 2007", "G0RL0H", 5553.03, 1213.68, "G\u00f8rl\u00f8se Hangar", "", true));
        this.add(new TurnPoint(311, "1/5 2007", "G0RL0K", 5553.15, 1211.64, "G\u00f8rl\u00f8se Kirke", "", false));
        this.add(new TurnPoint(320, "1/5 2007", "GAASET", 5500.41, 1154.73, "G\u00e5set\u00e5rnet", "", false));
        this.add(new TurnPoint(460, "1/5 2007", "HAMMEF", 5545.21, 1150.49, "Hammer Bakke F\u00e6rgeleje", "", false));
        this.add(new TurnPoint(377, "1/5 2007", "HARALK", 5529.49, 1146.07, "Haraldsted Kirke", "", false));
        this.add(new TurnPoint(249, "1/5 2007", "HASLVJ", 5519.76, 1157.69, "Haslev Stn.", "", false));
        this.add(new TurnPoint(378, "1/5 2007", "HAVNSH", 5545.27, 1119.42, "Havns\u00f8 Havn", "", false));
        this.add(new TurnPoint(379, "1/5 2007", "HELSIK", 5601.43, 1211.85, "Helsinge Kirke", "", false));
        this.add(new TurnPoint(250, "1/5 2007", "HOLBAJ", 5542.89, 1142.53, "Holb\u00e6k Stn.", "", false));
        this.add(new TurnPoint(465, "1/5 2007", "HOLMEG", 5517.19, 1149.44, "Holmeg\u00e5rd Glasv\u00e6rk", "", false));
        this.add(new TurnPoint(251, "1/5 2007", "HOLMOJ", 5515.65, 1150.96, "Holme-Olstrup Stn.", "", false));
        this.add(new TurnPoint(252, "1/5 2007", "HOLSTG", 5512.84, 1127.84, "Holsteinborg Gods", "", false));
        this.add(new TurnPoint(380, "1/5 2007", "HORNBJ", 5605.36, 1227.59, "Hornb\u00e6k Stn.", "", false));
        this.add(new TurnPoint(381, "1/5 2007", "HUNDEK", 5557.07, 1151.57, "Hundested Kirke", "", false));
        this.add(new TurnPoint(382, "1/5 2007", "HVEDSK", 5541.93, 1211.7, "Hvedstrup Kirke", "", false));
        this.add(new TurnPoint(253, "1/5 2007", "H0M  K", 5524.67, 1146.78, "H\u00f8m Kirke", "", false));
        this.add(new TurnPoint(254, "1/5 2007", "H0NG J", 5530.38, 1117.15, "H\u00f8ng Stn.", "", false));
        this.add(new TurnPoint(255, "1/5 2007", "H0RVEJ", 5545.14, 1127.38, "H\u00f8rve Stn.", "", false));
        this.add(new TurnPoint(206, "1/5 2007", "ISSLIG", 5500.89, 1155.64, "Iselingen Gods", "", false));
        this.add(new TurnPoint(383, "1/5 2007", "ISTERR", 5552.64, 1228.67, "Ister\u00f8d Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(437, "1/5 2007", "JUNGHK", 5504.87, 1207.35, "Jungshoved Kirke", "", false));
        this.add(new TurnPoint(256, "1/5 2007", "JYDERJ", 5539.58, 1123.95, "Jyderup Stn.", "", false));
        this.add(new TurnPoint(257, "1/5 2007", "JYSTRK", 5530.94, 1152.08, "Jystrup Kirke", "", false));
        this.add(new TurnPoint(258, "1/5 2007", "KALDRH", 5541.96, 1115.49, "Kaldred Hangar", "", true));
        this.add(new TurnPoint(574, "1/5 2007", "KALDRV", 5541.9, 1114.4, "Kaldred T\u00e6rskel Vest", "", false));
        this.add(new TurnPoint(577, "1/5 2007", "KALDR0", 5541.9, 1115.8, "Kaldred T\u00e6rskel \u00d8st", "", false));
        this.add(new TurnPoint(474, "1/5 2007", "KALUNK", 5540.83, 1104.85, "Kalundborg Domkirke", "", false));
        this.add(new TurnPoint(259, "1/5 2007", "KALUNR", 5540.62, 1104.16, "Kalundborg RadioStn.", "", false));
        this.add(new TurnPoint(260, "1/5 2007", "KARISK", 5518.31, 1212.64, "Karise Kirke", "", false));
        this.add(new TurnPoint(384, "1/5 2007", "KASTRK", 5502.22, 1153.59, "Kastrup Kirke", "", false));
        this.add(new TurnPoint(385, "1/5 2007", "KATTRG", 5536.64, 1122.35, "Kattrup Gods", "", false));
        this.add(new TurnPoint(387, "1/5 2007", "KIRKHK", 5542.21, 1153.3, "Kirke Hyllinge Kirke", "", false));
        this.add(new TurnPoint(261, "1/5 2007", "KRKEHJ", 5535.71, 1151.48, "Kirkehvals\u00f8 Stn.", "", false));
        this.add(new TurnPoint(361, "1/5 2007", "KONGSV", 5515.04, 1203.36, "Kongsted Ankomst Vest", "", false));
        this.add(new TurnPoint(360, "1/5 2007", "KONGS0", 5515.16, 1204.13, "Kongsted Ankomst \u00d8st", "", false));
        this.add(new TurnPoint(233, "1/5 2007", "KONGSH", 5515.05, 1203.73, "Kongsted Hangar", "", true));
        this.add(new TurnPoint(482, "1/5 2007", "KORS0A", 5520.3, 1114.64, "Kors\u00f8r Fl. plads", "", true));
        this.add(new TurnPoint(262, "1/5 2007", "KORS0B", 5519.87, 1108.54, "Kors\u00f8r Havnebro", "", false));
        this.add(new TurnPoint(388, "1/5 2007", "KREGMK", 5556.74, 1202.85, "Kregme Kirke", "", false));
        this.add(new TurnPoint(263, "1/5 2007", "KRONBS", 5602.34, 1237.32, "Kronborg Slot", "", false));
        this.add(new TurnPoint(389, "1/5 2007", "KVANLK", 5539.13, 1140.14, "Kvanl\u00f8se Kirke", "", false));
        this.add(new TurnPoint(390, "1/5 2007", "KVISTJ", 5559.43, 1230.19, "Kvistg\u00e5rd Stn.", "", false));
        this.add(new TurnPoint(485, "1/5 2007", "KYNDBV", 5548.8, 1152.71, "Kyndbyv\u00e6rket", "", false));
        this.add(new TurnPoint(775, "1/5 2007", "LERCHG", 5539.15, 1104.38, "Lerchenborg Gods", "", false));
        this.add(new TurnPoint(443, "1/5 2007", "LHEDDK", 5516.44, 1223.44, "Lille Heddinge Kirke", "", false));
        this.add(new TurnPoint(264, "1/5 2007", "LILNDG", 5501.73, 1203.43, "Lillendal Gods", "", false));
        this.add(new TurnPoint(392, "1/5 2007", "LYNGEK", 5550.56, 1216.84, "Lynge Kirke", "", false));
        this.add(new TurnPoint(351, "1/5 2007", "L0VNBS", 5540.96, 1135.29, "L\u00f8venborg Slot", "", false));
        this.add(new TurnPoint(394, "1/5 2007", "MELBYK", 5559.74, 1158.15, "Melby Kirke", "", false));
        this.add(new TurnPoint(303, "1/5 2007", "MELBYT", 5539.07, 1106.33, "Melby Vestlige Vej-T", "", false));
        this.add(new TurnPoint(265, "1/5 2007", "MERN K", 5503.01, 1203.45, "Mern Kirke", "", false));
        this.add(new TurnPoint(495, "1/5 2007", "MUNKEK", 5530.37, 1131.24, "Munkebjergby Kirke", "", false));
        this.add(new TurnPoint(266, "1/5 2007", "MUNKHB", 5540.43, 1148.68, "Munkholm Broen", "", false));
        this.add(new TurnPoint(267, "1/5 2007", "M0RK0J", 5539.25, 1130.13, "M\u00f8rk\u00f8v Stn.", "", false));
        this.add(new TurnPoint(268, "1/5 2007", "NIL0SK", 5533.41, 1129.71, "Nil\u00f8se Kirke", "", false));
        this.add(new TurnPoint(395, "1/5 2007", "NORDRG", 5529.44, 1126.35, "Nordruplund Gods", "", false));
        this.add(new TurnPoint(269, "1/5 2007", "NYBODX", 5513.76, 1131.15, "Nyboder Vej-X", "", false));
        this.add(new TurnPoint(270, "1/5 2007", "NYBROY", 5512.31, 1140.0, "Nybro Vej-Y", "", false));
        this.add(new TurnPoint(271, "1/5 2007", "NASBYB", 5523.19, 1138.9, "N\u00e6sby Bro", "", false));
        this.add(new TurnPoint(299, "1/5 2007", "NASBYG", 5522.11, 1136.15, "N\u00e6sbyholm Gods", "", false));
        this.add(new TurnPoint(496, "1/5 2007", "NASTVA", 5512.64, 1142.96, "N\u00e6stved Fl. plads", "", true));
        this.add(new TurnPoint(497, "1/5 2007", "NASTVJ", 5513.88, 1146.02, "N\u00e6stved Stn.", "", false));
        this.add(new TurnPoint(499, "1/5 2007", "N0DDEK", 5558.22, 1220.3, "N\u00f8ddebo kirke", "", false));
        this.add(new TurnPoint(399, "1/5 2007", "N0RAGG", 5534.6, 1121.25, "N\u00f8rager G\u00e5rd", "", false));
        this.add(new TurnPoint(400, "1/5 2007", "ODDENF", 5558.43, 1117.98, "Odden F\u00e6rgehavn", "", false));
        this.add(new TurnPoint(774, "1/5 2007", "OSTEDK", 5534.15, 1157.59, "Osted Kirke", "", false));
        this.add(new TurnPoint(401, "1/5 2007", "OVERDK", 5550.44, 1159.32, "Over Dr\u00e5by Kirke", "", false));
        this.add(new TurnPoint(313, "1/5 2007", "PETERG", 5500.2, 1206.2, "Petersg\u00e5rd", "", false));
        this.add(new TurnPoint(402, "1/5 2007", "RAKLEK", 5541.87, 1103.94, "Raklev Kirke", "", false));
        this.add(new TurnPoint(403, "1/5 2007", "RAML0M", 5600.95, 1207.13, "Raml\u00f8se M\u00f8lle", "", false));
        this.add(new TurnPoint(272, "1/5 2007", "REERSK", 5531.53, 1106.76, "Reers\u00f8 Kirke", "", false));
        this.add(new TurnPoint(314, "1/5 2007", "RINGSH", 5525.62, 1148.82, "Ringsted Hangar", "", true));
        this.add(new TurnPoint(512, "1/5 2007", "RINGSJ", 5526.5, 1147.0, "Ringsted Stn.", "", false));
        this.add(new TurnPoint(517, "1/5 2007", "ROSENG", 5500.99, 1152.57, "Rosenfeld Gods", "", false));
        this.add(new TurnPoint(273, "1/5 2007", "RUDSVJ", 5532.38, 1122.47, "Rudsvedby Stn.", "", false));
        this.add(new TurnPoint(315, "1/5 2007", "R0DVIJ", 5515.29, 1222.69, "R\u00f8dvig Stn.", "", false));
        this.add(new TurnPoint(274, "1/5 2007", "R0NNEB", 5515.5, 1159.67, "R\u00f8nnede Motorvejsbro", "", false));
        this.add(new TurnPoint(275, "1/5 2007", "R0RBYK", 5538.64, 1109.47, "R\u00f8rby Kirke", "", false));
        this.add(new TurnPoint(396, "1/5 2007", "R0SNAF", 5544.62, 1052.14, "R\u00f8sn\u00e6s Fyr", "", false));
        this.add(new TurnPoint(276, "1/5 2007", "SKELLJ", 5532.26, 1126.93, "Skellebjerg Stn.", "", false));
        this.add(new TurnPoint(405, "1/5 2007", "SKIBBK", 5544.91, 1157.5, "Skibby Kirke", "", false));
        this.add(new TurnPoint(406, "1/5 2007", "SKJOLG", 5532.12, 1151.18, "Skjolden\u00e6sholm", "", false));
        this.add(new TurnPoint(277, "1/5 2007", "SKLSKB", 5515.3, 1117.52, "Sk\u00e6lsk\u00f8r Havnebro", "", false));
        this.add(new TurnPoint(527, "1/5 2007", "SKAVIK", 5554.56, 1209.09, "Sk\u00e6vinge Kirke", "", false));
        this.add(new TurnPoint(532, "1/5 2007", "SLAGEA", 5522.9, 1119.41, "Slagelse Fl. plads", "", false));
        this.add(new TurnPoint(278, "1/5 2007", "SLAGEB", 5524.66, 1124.59, "Slagelse Motorvej/Jernbane-X", "", false));
        this.add(new TurnPoint(533, "1/5 2007", "SLAGEJ", 5524.43, 1120.93, "Slagelse Stn.", "", false));
        this.add(new TurnPoint(535, "1/5 2007", "SLAGLV", 5527.13, 1138.2, "Slaglille Ankomst Vest", "", false));
        this.add(new TurnPoint(534, "1/5 2007", "SLAGL0", 5527.2, 1139.53, "Slaglille Ankomst \u00d8st", "", false));
        this.add(new TurnPoint(279, "1/5 2007", "SLAGLH", 5527.07, 1138.28, "Slaglille Hangar", "", true));
        this.add(new TurnPoint(538, "1/5 2007", "SLAIPV", 5527.64, 1133.8, "Slaglille IP Vest", "", false));
        this.add(new TurnPoint(537, "1/5 2007", "SLAIP0", 5527.3, 1143.92, "Slaglille IP \u00d8st", "", false));
        this.add(new TurnPoint(539, "1/5 2007", "SLANGK", 5550.75, 1210.22, "Slangerup Kirke", "", false));
        this.add(new TurnPoint(540, "1/5 2007", "SNERTR", 5542.7, 1123.02, "Snertinge Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(280, "1/5 2007", "SNESEK", 5509.93, 1155.8, "Snesere Kirke", "", false));
        this.add(new TurnPoint(281, "1/5 2007", "SNESLK", 5522.51, 1151.12, "Sneslev Kirke", "", false));
        this.add(new TurnPoint(282, "1/5 2007", "STENLJ", 5532.45, 1135.86, "Stenlille Stn.", "", false));
        this.add(new TurnPoint(283, "1/5 2007", "STIGSL", 5512.74, 1114.64, "Stigsn\u00e6s F\u00e6rgeleje", "", false));
        this.add(new TurnPoint(300, "1/5 2007", "STFREG", 5526.53, 1127.79, "Store Frederikslund", "", false));
        this.add(new TurnPoint(284, "1/5 2007", "STHEDJ", 5518.6, 1223.16, "Store Heddinge Stn.", "", false));
        this.add(new TurnPoint(285, "1/5 2007", "STMERJ", 5532.69, 1142.71, "Store Merl\u00f8se Stn.", "", false));
        this.add(new TurnPoint(393, "1/5 2007", "SVALLK", 5536.37, 1110.72, "Svallerup Kirke", "", false));
        this.add(new TurnPoint(548, "1/5 2007", "SVEB0J", 5539.12, 1117.52, "Sveb\u00f8lle Stn.", "", false));
        this.add(new TurnPoint(286, "1/5 2007", "SVINNJ", 5543.4, 1128.02, "Svinninge Stn.", "", false));
        this.add(new TurnPoint(783, "1/5 2007", "SVIN0K", 5506.57, 1145.33, "Svin\u00f8 Kirke", "", false));
        this.add(new TurnPoint(287, "1/5 2007", "SABYVT", 5532.72, 1118.49, "S\u00e6by Vej-T", "", false));
        this.add(new TurnPoint(288, "1/5 2007", "S0RBYK", 5521.59, 1126.45, "S\u00f8rbymagle Kirke", "", false));
        this.add(new TurnPoint(289, "1/5 2007", "TAPPNX", 5509.65, 1158.76, "Tappern\u00f8je Vej-X", "", false));
        this.add(new TurnPoint(408, "1/5 2007", "TIBIRK", 5602.49, 1206.41, "Tibirke Kirke", "", false));
        this.add(new TurnPoint(409, "1/5 2007", "TIK0BK", 5601.12, 1227.23, "Tik\u00f8b Kirke", "", false));
        this.add(new TurnPoint(290, "1/5 2007", "TORBFG", 5538.3, 1131.05, "Torbenfeldt Gods", "", false));
        this.add(new TurnPoint(503, "1/5 2007", "NYK0BA", 5553.39, 1135.18, "Trundholm Fl. plads", "", true));
        this.add(new TurnPoint(291, "1/5 2007", "TYSTRK", 5521.68, 1133.78, "Tystrup Kirke", "", false));
        this.add(new TurnPoint(292, "1/5 2007", "T0LL0H", 5534.87, 1145.37, "T\u00f8ll\u00f8se Hangar", "", true));
        this.add(new TurnPoint(410, "1/5 2007", "T0LL0J", 5536.7, 1146.41, "T\u00f8ll\u00f8se Stn.", "", false));
        this.add(new TurnPoint(293, "1/5 2007", "T0MMRK", 5540.66, 1109.06, "T\u00f8mmerup Kirke", "", false));
        this.add(new TurnPoint(769, "1/5 2007", "UBBY K", 5537.15, 1112.48, "Ubby Kirke", "", false));
        this.add(new TurnPoint(556, "1/5 2007", "UDBY K", 5504.31, 1156.51, "Udby Kirke", "", false));
        this.add(new TurnPoint(294, "1/5 2007", "ULSE B", 5517.34, 1201.09, "Ulse Motorvejsbro", "", false));
        this.add(new TurnPoint(411, "1/5 2007", "ULSTRK", 5543.96, 1057.59, "Ulstrup Kirke", "", false));
        this.add(new TurnPoint(558, "1/5 2007", "UNDL0K", 5536.33, 1134.88, "Undl\u00f8se Kirke", "", false));
        this.add(new TurnPoint(318, "1/5 2007", "VALS0K", 5531.28, 1150.01, "Vals\u00f8lille Kirke", "", false));
        this.add(new TurnPoint(298, "1/5 2007", "VEDDEJ", 5531.93, 1132.87, "Vedde Stn.", "", false));
        this.add(new TurnPoint(295, "1/5 2007", "VMMLVB", 5521.92, 1115.57, "Vemmelev Bro", "", false));
        this.add(new TurnPoint(296, "1/5 2007", "VEGEBK", 5509.47, 1149.12, "Vester Egesborg Kirke", "", false));
        this.add(new TurnPoint(297, "1/5 2007", "VIG  K", 5551.05, 1135.03, "Vig Kirke", "", false));
        this.add(new TurnPoint(412, "1/5 2007", "VINDIK", 5537.52, 1208.26, "Vindinge Kirke", "", false));
        this.add(new TurnPoint(319, "1/5 2007", "VISKIK", 5539.72, 1116.25, "Viskinge Kirke", "", false));
        this.add(new TurnPoint(413, "1/5 2007", "VARL0V", 5546.29, 1218.04, "V\u00e6rl\u00f8se Ankomst Vest", "", false));
        this.add(new TurnPoint(430, "1/5 2007", "VARL0A", 5546.1, 1219.26, "V\u00e6rl\u00f8se Banemidte", "", true));
        this.add(new TurnPoint(376, "1/5 2007", "VARL0J", 5546.93, 1222.4, "V\u00e6rl\u00f8se Stn.", "", false));
        this.add(new TurnPoint(414, "1/5 2007", "0LSTEK", 5555.27, 1204.4, "\u00d8lsted Kirke", "", false));
        this.add(new TurnPoint(415, "1/5 2007", "0RSTEK", 5532.49, 1204.61, "\u00d8rsted Kirke", "", false));
    }

    public String getDateNatCatW() {
        return "10/4 2001";
    }

    public void nationalCatalogW() {
        tpList.removeAllElements();
        this.add(new TurnPoint(219, "1/5 2007", "BREDBJ", 5503.39, 849.41, "Bredebro Stn.", "", false));
        this.add(new TurnPoint(3, "1/5 2007", "BREJNX", 5605.16, 830.42, "Brejning vej-X", "", false));
        this.add(new TurnPoint(92, "1/5 2007", "BRYRUK", 5601.52, 930.77, "Bryrup Kirke", "", false));
        this.add(new TurnPoint(337, "1/5 2007", "BRYRUX", 5601.78, 930.92, "Bryrup vej-X", "Nord for Bryrup", false));
        this.add(new TurnPoint(14, "1/5 2007", "BRADSK", 5558.01, 936.51, "Br\u00e6dstrup Kirke", "Ring", false));
        this.add(new TurnPoint(146, "1/5 2007", "BRADSF", 5556.57, 939.12, "Br\u00e6dstrup Flyveplads", "", true));
        this.add(new TurnPoint(-1, "1/5 2007", "BRADSA", 5556.58, 939.12, "Br\u00e6dstrup Flyveplads", "", false));
        this.add(new TurnPoint(216, "1/5 2007", "BRANDG", 5507.54, 1023.49, "Br\u00e6ndeg\u00e5rd Storg\u00e5rd", "", false));
        this.add(new TurnPoint(147, "1/5 2007", "BR0NDK", 5716.09, 957.2, "Br\u00f8nderslev Kirke", "", false));
        this.add(new TurnPoint(199, "1/5 2007", "BR0NDJ", 5716.23, 956.56, "Br\u00f8nderslev Stn.", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "BR0NDA", 5717.32, 951.5, "Br\u00f8nderslev Fl.pl.", "", true));
        this.add(new TurnPoint(217, "1/5 2007", "BR0RUS", 5528.84, 901.71, "Br\u00f8rup DLG Silo", "", false));
        this.add(new TurnPoint(38, "1/5 2007", "BR0RUJ", 5528.96, 900.92, "Br\u00f8rup Stn.", "", false));
        this.add(new TurnPoint(185, "1/5 2007", "BULDBK", 5709.49, 901.47, "Buldbjerg Klint", "", false));
        this.add(new TurnPoint(73, "1/5 2007", "BURKAK", 5455.6, 904.01, "Burkal lille Kirke", "", false));
        this.add(new TurnPoint(46, "1/5 2007", "BAEKMJ", 5624.79, 818.42, "B\u00e6kmarksbro Stn.", "", false));
        this.add(new TurnPoint(188, "1/5 2007", "B0GSTH", 5727.65, 1005.64, "B\u00f8gsted Hangar", "", true));
        this.add(new TurnPoint(143, "1/5 2007", "B0RGLK", 5722.12, 948.02, "B\u00f8rglum Kloster", "", false));
        this.add(new TurnPoint(209, "1/5 2007", "B0RKOJ", 5538.48, 939.13, "B\u00f8rkob Stn.", "", false));
        this.add(new TurnPoint(220, "1/5 2007", "CHRHDF", 5606.31, 923.58, "Christianshede Flpl.", "Klubhus (Midte)", true));
        this.add(new TurnPoint(333, "1/5 2007", "CHRHDH", 5606.17, 923.96, "Christianshede Hang.", "Hangar \u00d8st", false));
        this.add(new TurnPoint(221, "1/5 2007", "DRONNS", 5709.3, 1015.62, "Dronninglund Slot", "Slot/Hovedg\u00e5rd", false));
        this.add(new TurnPoint(222, "1/5 2007", "EGESKS", 5510.56, 1029.42, "Egeskov Slot", "Ved Kv\u00e6rndrup - Fyn", false));
        this.add(new TurnPoint(148, "1/5 2007", "EGVADK", 5553.13, 831.53, "Egvad Kirke", "", false));
        this.add(new TurnPoint(223, "1/5 2007", "EJBY J", 5525.7, 955.76, "Ejby Stn.", "", false));
        this.add(new TurnPoint(224, "1/5 2007", "EJSTRK", 5558.97, 917.21, "Ejstrupholm Kirke", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "EJSTRA", 5559.48, 916.07, "Ejstrupholm Fl.pl.", "", true));
        this.add(new TurnPoint(149, "1/5 2007", "ELLIDK", 5655.82, 952.06, "Ellidsh\u00f8j Kirke", "", false));
        this.add(new TurnPoint(323, "1/5 2007", "ELMSHJ", 5345.38, 939.41, "Elmshorn Stn.", "", false));
        this.add(new TurnPoint(225, "1/5 2007", "ELSEHF", 5506.09, 1046.52, "Elsehoved Fyrt\u00e5rn", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "ENDELA", 5545.41, 1014.86, "Endelave Vest", "", true));
        this.add(new TurnPoint(226, "1/5 2007", "ENGESJ", 5610.1, 921.09, "Engesvang Stn.", "", false));
        this.add(new TurnPoint(227, "1/5 2007", "ESBJEF", 5531.31, 832.93, "Esbjerg Lufthavn", "Terminal", true));
        this.add(new TurnPoint(-1, "1/5 2007", "ESTRLA", 5633.46, 1021.5, "Estruplund Fl.pl.", "", true));
        this.add(new TurnPoint(-1, "1/5 2007", "FANGLA", 5517.61, 1018.41, "Fangel Flyveplads", "", true));
        this.add(new TurnPoint(133, "1/5 2007", "FARS0K", 5646.45, 920.32, "Fars\u00f8 Kirke", "", false));
        this.add(new TurnPoint(47, "1/5 2007", "FASTEX", 5600.5, 906.69, "Fasterholt", "Jernbane/vej-X", false));
        this.add(new TurnPoint(203, "1/5 2007", "FERSLH", 5656.65, 956.22, "Ferslev Hangar", "", true));
        this.add(new TurnPoint(150, "1/5 2007", "FILSKF", 5548.83, 902.78, "Filskov Flyveplads", "", true));
        this.add(new TurnPoint(-1, "1/5 2007", "FILSKA", 5548.83, 902.79, "Filskov Flyveplads", "", false));
        this.add(new TurnPoint(175, "1/5 2007", "FJERRK", 5705.31, 915.99, "Fjerritslev Kro", "", false));
        this.add(new TurnPoint(116, "1/5 2007", "FLENSH", 5446.42, 922.51, "Flensburg Hangar", "", true));
        this.add(new TurnPoint(229, "1/5 2007", "FLYNDK", 5626.83, 818.29, "Flynder Kirke", "", false));
        this.add(new TurnPoint(25, "1/5 2007", "FRISBG", 5615.9, 953.62, "Frisenborg Gods", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "FRISVA", 5506.71, 1021.69, "Frisenv\u00e6nge Fl.pl.", "", true));
        this.add(new TurnPoint(-1, "1/5 2007", "FUR  A", 5649.49, 859.27, "Fur Flyveplads", "", true));
        this.add(new TurnPoint(151, "1/5 2007", "FUSS0S", 5628.37, 950.62, "Fussing\u00f8 Slot", "", false));
        this.add(new TurnPoint(152, "1/5 2007", "FYRKAB", 5637.38, 946.25, "Fyrkat Vikinge borg", "", false));
        this.add(new TurnPoint(228, "1/5 2007", "FAREVG", 5455.02, 1042.39, "F\u00e5revejle Gods", "Ved Rudk\u00f8bing", false));
        this.add(new TurnPoint(230, "1/5 2007", "GAB0LR", 5515.24, 908.75, "Gab\u00f8l Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(231, "1/5 2007", "GELSTJ", 5523.8, 958.41, "Gelsted Stn.", "", false));
        this.add(new TurnPoint(232, "1/5 2007", "GESTNH", 5533.06, 911.58, "Gesten Fl.pl.", "Klubhus/Hangar", true));
        this.add(new TurnPoint(9, "1/5 2007", "GIVE R", 5551.78, 915.19, "Give Rundk\u00f8rsel", "N\u00d8", false));
        this.add(new TurnPoint(187, "1/5 2007", "GL.LIB", 5531.04, 942.57, "Gl. Lilleb\u00e6ltsbro", "Bromidte", false));
        this.add(new TurnPoint(74, "1/5 2007", "GRAM S", 5517.64, 903.4, "Gram Slot", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "GRENAA", 5626.51, 1055.79, "Gren\u00e5 Flyveplads", "", true));
        this.add(new TurnPoint(58, "1/5 2007", "GRASTK", 5455.53, 935.71, "Gr\u00e5sten Slots Kirke", "", false));
        this.add(new TurnPoint(111, "1/5 2007", "GUDMEK", 5509.06, 1042.55, "Gudme Kirke", "", false));
        this.add(new TurnPoint(75, "1/5 2007", "HADRSK", 5514.97, 929.26, "Haderslev Domkirke", "", false));
        this.add(new TurnPoint(340, "1/5 2007", "HADRSH", 5518.06, 931.74, "Haderslev Hangar", "", true));
        this.add(new TurnPoint(8, "1/5 2007", "HADSTJ", 5619.67, 1002.75, "Hadsten Stn.", "", false));
        this.add(new TurnPoint(66, "1/5 2007", "HADSUB", 5642.85, 1007.07, "Hadsund Bro", "Man\u00f8vrehus", false));
        this.add(new TurnPoint(-1, "1/5 2007", "HADSUA", 5645.36, 1013.73, "Hadsund Flyveplads", "", true));
        this.add(new TurnPoint(202, "1/5 2007", "HALS K", 5659.87, 1018.66, "Hals Kirke", "", false));
        this.add(new TurnPoint(30, "1/5 2007", "HAMMLB", 5614.06, 951.88, "Hammel Vejbro", "Ved Anb\u00e6k. Rute36/457", false));
        this.add(new TurnPoint(201, "1/5 2007", "HAMMRK", 5709.05, 1000.7, "Hammer Kirke.", "Nordjylland", false));
        this.add(new TurnPoint(106, "1/5 2007", "HAMMRH", 5554.41, 927.22, "Hammer Hangar", "", true));
        this.add(new TurnPoint(153, "1/5 2007", "HMMRHR", 5629.98, 944.54, "Hammersh\u00f8j Rundk.", "", false));
        this.add(new TurnPoint(7, "1/5 2007", "HMMRHK", 5630.07, 945.32, "Hammersh\u00f8j Kirke", "", false));
        this.add(new TurnPoint(85, "1/5 2007", "HMMRMJ", 5607.9, 903.77, "Hammerum Stn.", "", false));
        this.add(new TurnPoint(176, "1/5 2007", "HANSTF", 5706.75, 835.86, "Hanstholm Fyr", "", false));
        this.add(new TurnPoint(94, "1/5 2007", "HATTIY", 5550.63, 944.16, "Hatting motorv. afk.", "SV motorvejs afk\u00f8rsel 57", false));
        this.add(new TurnPoint(103, "1/5 2007", "HAVRSR", 5647.94, 938.12, "Haverslev Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(136, "1/5 2007", "HEE  K", 5608.76, 816.7, "Hee Kirke", "", false));
        this.add(new TurnPoint(118, "1/5 2007", "HLLEVK", 5712.77, 1009.15, "Hellevad Kirke", "Nordjylland", false));
        this.add(new TurnPoint(76, "1/5 2007", "HENNEJ", 5542.59, 818.4, "Henne Stn.", "", false));
        this.add(new TurnPoint(348, "1/5 2007", "HERNIJ", 5607.97, 858.61, "Herning Stn.", "", false));
        this.add(new TurnPoint(119, "1/5 2007", "HERNIF", 5611.02, 902.35, "Herning Fl.pl.", "Forplads/V\u00e6rksted", true));
        this.add(new TurnPoint(349, "1/5 2007", "HSSLAG", 5509.51, 1045.77, "Hesselager Gods", "", false));
        this.add(new TurnPoint(10, "1/5 2007", "HINGES", 5615.21, 928.98, "Hinge S\u00f8", "Vinderslevholm Gods", false));
        this.add(new TurnPoint(31, "1/5 2007", "HOBROJ", 5638.59, 946.95, "Hobro Stn.", "", false));
        this.add(new TurnPoint(154, "1/5 2007", "HOLSTY", 5622.15, 834.09, "Holstebro Vej Y", "", false));
        this.add(new TurnPoint(4, "1/5 2007", "HOLSTV", 5621.13, 838.37, "Holstebro Vandkraftv", "", false));
        this.add(new TurnPoint(332, "1/5 2007", "HOLSTX", 5529.1, 854.76, "Holsted jernb./vej-X", "", false));
        this.add(new TurnPoint(120, "1/5 2007", "HORNEK", 5543.45, 831.84, "Horne Kirke", "Vestjylland", false));
        this.add(new TurnPoint(69, "1/5 2007", "HORNSJ", 5619.26, 1018.85, "Hornslet Stn.", "", false));
        this.add(new TurnPoint(37, "1/5 2007", "HOVDGJ", 5556.75, 957.76, "Hovedg\u00e5rd Stn.", "", false));
        this.add(new TurnPoint(26, "1/5 2007", "HOVENR", 5551.1, 845.0, "Hoven Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(198, "1/5 2007", "HUNE K", 5715.07, 937.07, "Hune Kirke", "", false));
        this.add(new TurnPoint(177, "1/5 2007", "HVIDBJ", 5638.99, 831.6, "Hvidbjerg Stn. Thy", "", false));
        this.add(new TurnPoint(59, "1/5 2007", "HVIDKS", 5504.4, 1032.01, "Hvidkilde Slot", "", false));
        this.add(new TurnPoint(140, "1/5 2007", "HASTRK", 5724.83, 958.32, "H\u00e5strup Kirke", "", false));
        this.add(new TurnPoint(326, "1/5 2007", "H0RUPK", 5617.62, 926.34, "H\u00f8rup Kirke", "Ved Kjellerup", false));
        this.add(new TurnPoint(95, "1/5 2007", "IDOM K", 5620.16, 828.89, "Idom kirkeby. Kirke", "", false));
        this.add(new TurnPoint(350, "1/5 2007", "ILSKOK", 5613.98, 906.79, "Ilskov Kirke", "", false));
        this.add(new TurnPoint(40, "1/5 2007", "JELS K", 5521.43, 912.11, "Jels Kirke", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "JRLVGA", 5539.61, 927.52, "Jerlevgaard Fl.pl.", "", true));
        this.add(new TurnPoint(155, "1/5 2007", "JRNITG", 5615.9, 955.4, "Jernit Gods", "", false));
        this.add(new TurnPoint(156, "1/5 2007", "JORDRX", 5533.51, 918.68, "Jordrup vej-X.", "Bymidte ved Silo", false));
        this.add(new TurnPoint(-1, "1/5 2007", "KASTBA", 5638.24, 1009.89, "Kastbjerg Flyveplads", "", true));
        this.add(new TurnPoint(50, "1/5 2007", "KIBAKJ", 5601.95, 851.12, "Kib\u00e6k Stn.", "", false));
        this.add(new TurnPoint(101, "1/5 2007", "KLEJT-", 5635.45, 938.55, "Klejtrup Verdenskort", "", false));
        this.add(new TurnPoint(331, "1/5 2007", "KLIPLJ", 5456.12, 923.8, "Kliplev Stn.", "", false));
        this.add(new TurnPoint(186, "1/5 2007", "KLITMK", 5702.33, 830.36, "Klitm\u00f8ller Kirke", "", false));
        this.add(new TurnPoint(16, "1/5 2007", "KOLDIB", 5531.76, 928.01, "Kolding motorvejsbro", "A1/A3", false));
        this.add(new TurnPoint(328, "1/5 2007", "KOLDIS", 5529.49, 928.46, "Koldinghus Slot", "", false));
        this.add(new TurnPoint(56, "1/5 2007", "KRUSAH", 5452.33, 916.72, "Krus\u00e5/Padborg Hangar", "", true));
        this.add(new TurnPoint(60, "1/5 2007", "KVARNJ", 5510.7, 1031.14, "Kv\u00e6rndrup Stn.", "", false));
        this.add(new TurnPoint(48, "1/5 2007", "K0LKAJ", 5603.91, 905.09, "K\u00f8lk\u00e6r Stn.", "", false));
        this.add(new TurnPoint(28, "1/5 2007", "LANGAY", 5622.99, 953.62, "Lang\u00e5 jernbane Y", "", false));
        this.add(new TurnPoint(157, "1/5 2007", "LANGAJ", 5623.16, 953.77, "Lang\u00e5 Stn.", "", false));
        this.add(new TurnPoint(36, "1/5 2007", "LAVENJ", 5607.5, 943.04, "Laven Stn.", "", false));
        this.add(new TurnPoint(234, "1/5 2007", "LECH J", 5446.51, 858.63, "Lech Stn.", "Tyskland", false));
        this.add(new TurnPoint(158, "1/5 2007", "LEJRSK", 5530.99, 920.2, "Lejrskov Kirke", "", false));
        this.add(new TurnPoint(341, "1/5 2007", "LEMVIF", 5630.3, 818.26, "Lemvig Flyveplads", "", true));
        this.add(new TurnPoint(141, "1/5 2007", "LENDUK", 5724.56, 1018.03, "Lendum Kirke", "", false));
        this.add(new TurnPoint(89, "1/5 2007", "LIND R", 5624.91, 829.3, "Lind Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(64, "1/5 2007", "LINDBG", 5654.45, 1002.07, "Lindenborg Gods", "Hovedbygning", false));
        this.add(new TurnPoint(159, "1/5 2007", "LINDKK", 5533.87, 901.24, "Lindknud Kirke", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "LINDTA", 5623.8, 826.57, "Lindtorp Flyveplads", "", true));
        this.add(new TurnPoint(178, "1/5 2007", "LODBJF", 5649.42, 815.74, "Lodbjerg Fyr", "", false));
        this.add(new TurnPoint(335, "1/5 2007", "LYSTRJ", 5613.83, 1014.08, "Lystrup Stn.", "", false));
        this.add(new TurnPoint(112, "1/5 2007", "LASBYX", 5608.78, 949.13, "L\u00e5sby vej-X", "A15/457", false));
        this.add(new TurnPoint(-1, "1/5 2007", "LAS0 A", 5716.65, 1100.04, "L\u00e6s\u00f8 Flyveplads", "", true));
        this.add(new TurnPoint(18, "1/5 2007", "L0GUMK", 5503.41, 857.02, "L\u00f8gumkloster Kirke", "Kloster Kirke", false));
        this.add(new TurnPoint(108, "1/5 2007", "L0GUMR", 5503.64, 855.29, "L\u00f8gumkloster Rundk.", "A25/401", false));
        this.add(new TurnPoint(-1, "1/5 2007", "L0JTVA", 5505.61, 857.93, "L\u00f8jtved Flyveplads", "", true));
        this.add(new TurnPoint(15, "1/5 2007", "L0SNIJ", 5548.16, 942.09, "L\u00f8sning Stn.", "", false));
        this.add(new TurnPoint(351, "1/5 2007", "L0VNBS", 5627.1, 1026.599, "L\u00f8venborg Slot", "", false));
        this.add(new TurnPoint(131, "1/5 2007", "L0VNHS", 5627.09, 1026.599, "L\u00f8venholm Slot/Gods", "", false));
        this.add(new TurnPoint(67, "1/5 2007", "MARIAK", 5638.89, 958.72, "Mariager Kirke", "", false));
        this.add(new TurnPoint(13, "1/5 2007", "MATTRG", 5555.46, 932.63, "Mattrup Gods", "", false));
        this.add(new TurnPoint(172, "1/5 2007", "MORS0F", 5649.44, 847.43, "Mors\u00f8 Fl.pl.", "Hovedbygning", true));
        this.add(new TurnPoint(160, "1/5 2007", "M0LBYS", 5519.18, 915.95, "M\u00f8lby Silo", "Cirkus Dannebrog", false));
        this.add(new TurnPoint(44, "1/5 2007", "M0LDRR", 5637.28, 930.7, "M\u00f8ldrup Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(139, "1/5 2007", "NIEB0J", 5447.31, 850.12, "Nieb\u00f8ll Stn.", "Tyskland", false));
        this.add(new TurnPoint(-1, "1/5 2007", "NORDBA", 5504.5, 945.34, "Nordborg Fl.pl.", "P\u00f8l", true));
        this.add(new TurnPoint(109, "1/5 2007", "NY LIB", 5531.12, 944.96, "Ny Lilleb\u00e6ltsbro", "Bromidte", false));
        this.add(new TurnPoint(-1, "1/5 2007", "NYMINA", 5549.62, 811.01, "Nymindegab Fl.pl.", "", true));
        this.add(new TurnPoint(100, "1/5 2007", "N0RLUG", 5646.9, 943.48, "N\u00f8rlund Gods", "", false));
        this.add(new TurnPoint(161, "1/5 2007", "NR. FH", 5618.41, 835.86, "N\u00f8rre Felding Hangar", "", true));
        this.add(new TurnPoint(12, "1/5 2007", "NRSNEX", 5557.86, 923.66, "N\u00f8rre Snede vej-X", "Midt i byen", false));
        this.add(new TurnPoint(330, "1/5 2007", "NRABYJ", 5527.61, 952.17, "N\u00f8rre \u00c5by Stn.", "", false));
        this.add(new TurnPoint(134, "1/5 2007", "ODDERK", 5558.41, 1009.17, "Odder Kirke", "", false));
        this.add(new TurnPoint(342, "1/5 2007", "ODENSF", 5528.45, 1019.77, "Odense Lufthavn", "Terminal bygning", true));
        this.add(new TurnPoint(130, "1/5 2007", "OKSB0J", 5537.58, 817.01, "Oksb\u00f8l Stn.", "", false));
        this.add(new TurnPoint(329, "1/5 2007", "OVRJSR", 5511.86, 917.74, "Over Jerstal Rundk.", "", false));
        this.add(new TurnPoint(162, "1/5 2007", "OVSTEK", 5558.31, 951.34, "Ovsted Kirke", "", false));
        this.add(new TurnPoint(322, "1/5 2007", "OWSLAJ", 5423.35, 935.26, "Owslag Stn.", "Tyskland", false));
        this.add(new TurnPoint(121, "1/5 2007", "PADBOG", 5448.33, 919.69, "Padborg/Fr\u00f8slev", "Motorvejs gr\u00e6nseovergang", false));
        this.add(new TurnPoint(11, "1/5 2007", "PARUPX", 5608.21, 921.09, "P\u00e5rup vej-X", "A15/A13", false));
        this.add(new TurnPoint(72, "1/5 2007", "RNDRSH", 5630.3, 1001.99, "Randers Hangar", "Flyvepl. Administr.", true));
        this.add(new TurnPoint(122, "1/5 2007", "RAVNHG", 5515.65, 1034.95, "Ravnholt Gods", "", false));
        this.add(new TurnPoint(19, "1/5 2007", "RIBE J", 5519.66, 846.21, "Ribe Stn.", "", false));
        this.add(new TurnPoint(52, "1/5 2007", "RIND K", 5605.43, 857.49, "Rind Kirke", "", false));
        this.add(new TurnPoint(110, "1/5 2007", "RINGEX", 5514.2, 1029.5, "Ringe vej-X", "A9/323", false));
        this.add(new TurnPoint(20, "1/5 2007", "RINGGR", 5547.36, 910.69, "Ringgive Rundk\u00f8rsel", "Karlskov", false));
        this.add(new TurnPoint(-1, "1/5 2007", "ROLSTA", 5519.42, 1034.829, "Rolsted Flyveplads", "", true));
        this.add(new TurnPoint(35, "1/5 2007", "ROM  K", 5631.0, 818.29, "Rom Kirke", "", false));
        this.add(new TurnPoint(179, "1/5 2007", "ROSNHG", 5619.99, 1019.82, "Rosenholm Gods", "", false));
        this.add(new TurnPoint(193, "1/5 2007", "RUBJEF", 5726.92, 946.41, "Rubjerg Knude Fyrt.", "Fyrt\u00e5rn", false));
        this.add(new TurnPoint(190, "1/5 2007", "RABJEK", 5737.55, 1021.35, "R\u00e5bjerg Kirke", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "RARUPA", 5546.69, 956.28, "R\u00f8rup Flyveplads", "", true));
        this.add(new TurnPoint(77, "1/5 2007", "R0DDIR", 5521.96, 904.32, "R\u00f8dding Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(57, "1/5 2007", "R0DEKJ", 5504.19, 920.01, "R\u00f8dekro Stn.", "", false));
        this.add(new TurnPoint(334, "1/5 2007", "R0DEKH", 5504.64, 917.97, "R\u00f8dekro Hangar", "Ved banekryds", true));
        this.add(new TurnPoint(-1, "1/5 2007", "SAMS0A", 5553.29, 1036.64, "Sams\u00f8 Flyveplads", "", true));
        this.add(new TurnPoint(184, "1/5 2007", "SCHLEJ", 5430.75, 933.5, "Schleswig Stn.", "", false));
        this.add(new TurnPoint(338, "1/5 2007", "SRFLDK", 5556.6, 847.34, "Sdr. Felding Kirke", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "SRFLDA", 5556.83, 844.56, "Sdr. Felding Fl.pl.", "", true));
        this.add(new TurnPoint(138, "1/5 2007", "SEJLFK", 5659.25, 1005.97, "Sejlflod Kirke", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "SENLSA", 5657.77, 846.65, "Sennels Flyveplads", "", true));
        this.add(new TurnPoint(78, "1/5 2007", "SIG  J", 5539.96, 834.6, "Sig Stn.", "", false));
        this.add(new TurnPoint(79, "1/5 2007", "SILKEJ", 5609.86, 932.7, "Silkeborg Stn.", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "SINDAA", 5730.2, 1013.78, "Sindal Lufthavn", "", true));
        this.add(new TurnPoint(-1, "1/5 2007", "SDRHOA", 5522.02, 827.96, "S\u00f8nderho Fl.pl.", "Fan\u00f8", true));
        this.add(new TurnPoint(344, "1/5 2007", "AARHUA", 5618.42, 1037.619, "Aarhus Lufthavn", "Tirstrup administration", true));
        this.add(new TurnPoint(33, "1/5 2007", "AARS H", 5650.88, 927.87, "Aars Syd-Hangar", "", true));
        this.add(new TurnPoint(204, "1/5 2007", "ABILDY", 5459.28, 851.63, "Abild Vej Y", "", false));
        this.add(new TurnPoint(205, "1/5 2007", "AGRSKR", 5507.75, 908.49, "Agerskov Rundk\u00f8rsel", "\u00d8st for byen", false));
        this.add(new TurnPoint(145, "1/5 2007", "ANS VB", 5618.71, 935.94, "Ans Vejbro", "Midte over Tange s\u00f8", false));
        this.add(new TurnPoint(27, "1/5 2007", "ARDENJ", 5646.18, 951.59, "Arden Stn.", "", false));
        this.add(new TurnPoint(98, "1/5 2007", "ARNBOV", 5600.62, 900.5, "Arnborg Ankomst Vest", "", false));
        this.add(new TurnPoint(1, "1/5 2007", "ARNBOR", 5600.85, 859.84, "Arnborg Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(99, "1/5 2007", "ARNBO0", 5600.64, 901.08, "Arnborg Ankomst \u00d8st", "", true));
        this.add(new TurnPoint(97, "1/5 2007", "ARNBOH", 5600.64, 901.32, "Arnborg Hangar", "Kontor", false));
        this.add(new TurnPoint(325, "1/5 2007", "ARRILK", 5508.95, 857.73, "Arrild Kirke", "", false));
        this.add(new TurnPoint(68, "1/5 2007", "ASSENK", 5626.46, 1008.93, "Assentoft Kirke", "", false));
        this.add(new TurnPoint(207, "1/5 2007", "ASTRUK", 5646.08, 958.62, "Astrup Kirke", "", false));
        this.add(new TurnPoint(208, "1/5 2007", "AULUMJ", 5615.9, 847.32, "Aulum Stn.", "", false));
        this.add(new TurnPoint(137, "1/5 2007", "BARRIK", 5543.21, 952.68, "Barrit Kirke", "", false));
        this.add(new TurnPoint(87, "1/5 2007", "BEDERG", 5604.08, 1011.35, "Beder Vilhelmsborg G", "Gods", false));
        this.add(new TurnPoint(90, "1/5 2007", "BILLUF", 5544.27, 910.03, "Billund TWR", "", false));
        this.add(new TurnPoint(91, "1/5 2007", "BILLUH", 5544.02, 909.13, "Billund Hangar", "Sv\u00e6veflyveklub Klubhus/Hangar", true));
        this.add(new TurnPoint(210, "1/5 2007", "BJRGBK", 5730.85, 1002.88, "Bjergby Kirke", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "BJRGBA", 5730.18, 1003.22, "Bjergby Flyveplads", "", true));
        this.add(new TurnPoint(24, "1/5 2007", "BJERRK", 5622.7, 939.63, "Bjerringbro Kirke", "", false));
        this.add(new TurnPoint(96, "1/5 2007", "BLAAHS", 5552.45, 901.97, "Bl\u00e5h\u00f8j Silo", "", false));
        this.add(new TurnPoint(211, "1/5 2007", "BOGENK", 5534.06, 1005.23, "Bogense Kirke", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "BOGENA", 5532.54, 1001.88, "Bogense Flyveplads", "", true));
        this.add(new TurnPoint(212, "1/5 2007", "BOLDSX", 5459.28, 916.79, "Bolderslev Vej/jb-X", "", false));
        this.add(new TurnPoint(213, "1/5 2007", "BOLHEH", 5537.9, 845.29, "Bolhede Hangar", "Hangar/Klubhus", true));
        this.add(new TurnPoint(117, "1/5 2007", "BOLLRS", 5550.27, 953.89, "Boller Slot", "", false));
        this.add(new TurnPoint(214, "1/5 2007", "BORDIJ", 5608.83, 916.69, "Bording Stn.", "", false));
        this.add(new TurnPoint(215, "1/5 2007", "BORRIJ", 5557.49, 838.65, "Borris Stn.", "", false));
        this.add(new TurnPoint(63, "1/5 2007", "BORUPH", 5655.37, 928.28, "Borup Hangar", "", true));
        this.add(new TurnPoint(218, "1/5 2007", "BRAMMJ", 5527.89, 842.49, "Bramming Stn.", "", false));
        this.add(new TurnPoint(49, "1/5 2007", "BRANDJ", 5556.7, 907.74, "Brande Stn.", "", false));
        this.add(new TurnPoint(197, "1/5 2007", "OTTSTH", 5720.71, 1024.81, "Ottestrup Hangar", "S\u00e6by", true));
        this.add(new TurnPoint(80, "1/5 2007", "SJ0RUX", 5625.58, 905.07, "Sj\u00f8rup vej-X A16", "", false));
        this.add(new TurnPoint(189, "1/5 2007", "SKAGNK", 5742.84, 1033.05, "Skagen Tilsand Kirke", "", false));
        this.add(new TurnPoint(114, "1/5 2007", "SKALSB", 5632.51, 924.12, "Skals \u00c5 bromidte", "", false));
        this.add(new TurnPoint(83, "1/5 2007", "SKANDJ", 5602.61, 955.5, "Skanderborg Stn.", "", false));
        this.add(new TurnPoint(51, "1/5 2007", "SKARRR", 5558.7, 853.86, "Skarrild Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(42, "1/5 2007", "SKINDH", 5611.28, 902.34, "Skinderholm Hangar", "", true));
        this.add(new TurnPoint(105, "1/5 2007", "SKIVEA", 5633.22, 909.84, "Skive Flyveplads", "Administration", true));
        this.add(new TurnPoint(34, "1/5 2007", "SKIVEY", 5631.92, 902.28, "Skive vej-Y", "Ved travbanen", false));
        this.add(new TurnPoint(181, "1/5 2007", "SKIVEJ", 5633.73, 901.43, "Skive Stn.", "", false));
        this.add(new TurnPoint(23, "1/5 2007", "SKJRNJ", 5556.85, 829.54, "Skjern Stn.", "", false));
        this.add(new TurnPoint(163, "1/5 2007", "SKRYDH", 5513.51, 915.6, "Skrydstrup Hangar", "Sv\u00e6veflyvehangar", true));
        this.add(new TurnPoint(352, "1/5 2007", "SKARBJ", 5509.52, 846.29, "Sk\u00e6rb\u00e6k Stn.", "", false));
        this.add(new TurnPoint(81, "1/5 2007", "SK0RPJ", 5650.2, 953.25, "Sk\u00f8rping Stn.", "", false));
        this.add(new TurnPoint(324, "1/5 2007", "SOLTAB", 5259.2, 955.45, "Soltau Jernb./vejbro", "6 Km \u00d8st - Tyskland", false));
        this.add(new TurnPoint(123, "1/5 2007", "SOMRSK", 5519.2, 918.7, "Sommersted Kirke", "", false));
        this.add(new TurnPoint(124, "1/5 2007", "SPARKK", 5628.75, 913.95, "Spark\u00e6r Kirke", "VNV for Viborg", false));
        this.add(new TurnPoint(164, "1/5 2007", "SPJALF", 5506.16, 830.81, "Spjald Flyveplads", "", true));
        this.add(new TurnPoint(165, "1/5 2007", "SPODSL", 5456.09, 1049.96, "Spodsbjerg Havn", "F\u00e6rgeleje", false));
        this.add(new TurnPoint(343, "1/5 2007", "STAUNF", 5559.48, 821.18, "Stauning TWR", "", true));
        this.add(new TurnPoint(41, "1/5 2007", "STBINR", 5646.35, 934.19, "Store Binderup Rundk", "", false));
        this.add(new TurnPoint(166, "1/5 2007", "STUDSJ", 5605.46, 854.54, "Studsg\u00e5rd Stn.", "", false));
        this.add(new TurnPoint(6, "1/5 2007", "ST0VRB", 5652.79, 948.2, "St\u00f8vring motorvejs X", "Syd", false));
        this.add(new TurnPoint(65, "1/5 2007", "SULDRT", 5650.58, 944.5, "Suldrup 1 Statoil", "Servicestation Vest", false));
        this.add(new TurnPoint(167, "1/5 2007", "SULSTK", 5708.87, 959.37, "Sulsted Kirke", "", false));
        this.add(new TurnPoint(84, "1/5 2007", "SVENSB", 5656.98, 951.94, "Svendstrup motorvbro", "", false));
        this.add(new TurnPoint(168, "1/5 2007", "SABY K", 5720.01, 1031.74, "S\u00e5by Kirke", "", false));
        this.add(new TurnPoint(93, "1/5 2007", "TAMDRK", 5553.51, 944.3, "Tamdrup Kirke", "", false));
        this.add(new TurnPoint(113, "1/5 2007", "TANGEV", 5621.26, 936.16, "Tange Vandkraftv\u00e6rk", "", false));
        this.add(new TurnPoint(17, "1/5 2007", "TAPS B", 5523.48, 926.91, "Taps motorvejs bro", "A10", false));
        this.add(new TurnPoint(321, "1/5 2007", "TARP J", 5439.79, 923.87, "Tarp (BRD) Stn.", "Slesvig Holsten", false));
        this.add(new TurnPoint(102, "1/5 2007", "TERNDK", 5649.08, 1003.13, "Terndrup Kirke", "", false));
        this.add(new TurnPoint(169, "1/5 2007", "THEM S", 5605.76, 932.73, "Them Silo", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "THISTA", 5704.29, 841.59, "Thisted Lufthavn", "Terminalbygning AFIS", true));
        this.add(new TurnPoint(-1, "1/5 2007", "TIM  A", 5611.22, 819.5, "Tim Flyveplads", "", true));
        this.add(new TurnPoint(125, "1/5 2007", "TINGLJ", 5456.15, 915.45, "Tinglev Stn.", "", false));
        this.add(new TurnPoint(86, "1/5 2007", "TJELEG", 5630.58, 936.74, "Tjele Gods", "Hovedbygning", false));
        this.add(new TurnPoint(54, "1/5 2007", "TOFTLR", 5510.79, 903.77, "Toftlund Rundk\u00f8rsel", "Syd for byen", false));
        this.add(new TurnPoint(192, "1/5 2007", "TOLNEK", 5728.24, 1018.84, "Tolne Kirke", "", false));
        this.add(new TurnPoint(62, "1/5 2007", "TOMMRY", 5520.78, 1011.29, "Tommerup jernbane Y", "", false));
        this.add(new TurnPoint(191, "1/5 2007", "TUEN T", 5735.38, 1017.28, "Tuen Vej T", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "TASINA", 5501.02, 1033.73, "T\u00e5singe Flyveplads", "", true));
        this.add(new TurnPoint(55, "1/5 2007", "T0NDRF", 5455.63, 850.62, "T\u00f8nder Flyveplads", "", true));
        this.add(new TurnPoint(82, "1/5 2007", "T0RRIG", 5550.8, 928.52, "T\u00f8rring Staug\u00e5rd", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "T0RSBA", 5455.0, 927.9, "T\u00f8rsb\u00f8l Flyveplads", "", true));
        this.add(new TurnPoint(115, "1/5 2007", "ULDBJR", 5636.6, 921.18, "Uldbjerg Rundk\u00f8rsel", "", false));
        this.add(new TurnPoint(53, "1/5 2007", "ULFBOJ", 5616.3, 819.48, "Ulfborg Stn.", "", false));
        this.add(new TurnPoint(327, "1/5 2007", "ULLRSK", 5521.82, 1039.829, "Ullerslev Kirke", "", false));
        this.add(new TurnPoint(126, "1/5 2007", "VALDES", 5501.34, 1039.16, "Valdemar Slot", "", false));
        this.add(new TurnPoint(173, "1/5 2007", "VAMDRK", 5525.67, 916.36, "Vamdrup Kirke", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "VAMDRA", 5526.17, 919.82, "Vamdrup Flyveplads", "", true));
        this.add(new TurnPoint(21, "1/5 2007", "VARDEB", 5538.28, 830.84, "Varde vej-jernb. bro", "A11/A12", false));
        this.add(new TurnPoint(-1, "1/5 2007", "VARDEA", 5536.43, 826.55, "Varde Flyveplads", "", true));
        this.add(new TurnPoint(43, "1/5 2007", "VEJENJ", 5528.56, 908.17, "Vejen Stn.", "", false));
        this.add(new TurnPoint(29, "1/5 2007", "VEMB Y", 5620.85, 821.03, "Vemb jernbane Y", "", false));
        this.add(new TurnPoint(88, "1/5 2007", "V.EJSH", 5601.17, 841.58, "V. Ejstrup Hangar", "", true));
        this.add(new TurnPoint(-1, "1/5 2007", "V.FYNA", 5515.04, 1002.82, "Vestfyns Flyveplads", "", true));
        this.add(new TurnPoint(5, "1/5 2007", "VIBRGH", 5624.6, 924.68, "Viborg Hangar", "", true));
        this.add(new TurnPoint(127, "1/5 2007", "VIBRDK", 5627.03, 924.76, "Viborg Domkirke", "", false));
        this.add(new TurnPoint(206, "1/5 2007", "VIBRGK", 5626.79, 925.49, "Viborg Asmild Kirke", "", false));
        this.add(new TurnPoint(104, "1/5 2007", "VIBRGD", 5626.98, 925.3, "Viborg D\u00e6mning", "", false));
        this.add(new TurnPoint(2, "1/5 2007", "VIDEBK", 5605.55, 837.57, "Videb\u00e6k Kirke", "", false));
        this.add(new TurnPoint(71, "1/5 2007", "VILDBJ", 5611.86, 846.12, "Vildbjerg Stn.", "", false));
        this.add(new TurnPoint(182, "1/5 2007", "VILDSB", 5653.04, 837.87, "Vildsund Bro", "Nordvest Mors", false));
        this.add(new TurnPoint(45, "1/5 2007", "VINDEJ", 5628.98, 846.95, "Vinderup Stn.", "", false));
        this.add(new TurnPoint(200, "1/5 2007", "VOERGS", 5714.54, 1020.12, "Voerg\u00e5rd Slot", "", false));
        this.add(new TurnPoint(144, "1/5 2007", "VOLSTK", 5719.64, 1026.3, "Volstrup Kirke", "", false));
        this.add(new TurnPoint(107, "1/5 2007", "VORBAK", 5537.87, 905.18, "Vorbasse Kirke", "", false));
        this.add(new TurnPoint(39, "1/5 2007", "VORBAC", 5537.8, 904.84, "Vorbasse Bymidte", "", false));
        this.add(new TurnPoint(195, "1/5 2007", "VREJLK", 5721.65, 1000.16, "Vrejlev Kloster", "", false));
        this.add(new TurnPoint(194, "1/5 2007", "VRAA J", 5721.29, 956.53, "Vr\u00e5 Stn.", "", false));
        this.add(new TurnPoint(61, "1/5 2007", "V0JSTH", 5514.93, 1012.47, "V\u00f8jstrup Hangar", "", true));
        this.add(new TurnPoint(171, "1/5 2007", "ARRE K", 5534.69, 840.13, "\u00c5rre Kirke", "", false));
        this.add(new TurnPoint(70, "1/5 2007", "AARSLB", 5609.18, 1002.67, "\u00c5rslev motorvejs bro", "A15", false));
        this.add(new TurnPoint(129, "1/5 2007", "ARUP J", 5523.98, 1003.17, "\u00c6rup Stn.", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "AER0 A", 5451.15, 1027.46, "\u00c6r\u00f8 Flyveplads", "", true));
        this.add(new TurnPoint(22, "1/5 2007", "0LGODJ", 5548.66, 837.35, "\u00d8lgod Stn.", "", false));
        this.add(new TurnPoint(-1, "1/5 2007", "0LGODA", 5549.94, 833.09, "\u00d8lgod/Vallund Fl.pl.", "", true));
        this.add(new TurnPoint(32, "1/5 2007", "0RNH0K", 5612.09, 833.62, "\u00d8rnh\u00f8j Kirke", "", false));
        this.add(new TurnPoint(170, "1/5 2007", "0STBIX", 5558.09, 944.9, "\u00d8stbirk vej-X", "", false));
        this.add(new TurnPoint(142, "1/5 2007", "0.BR0K", 5714.91, 959.97, "\u00d8. Br\u00f8nderslev Kirke", "", false));
        this.add(new TurnPoint(183, "1/5 2007", "0.HVIK", 5644.7, 837.18, "\u00d8. Hvidbjerg Kirke", "Mors", false));
        this.add(new TurnPoint(180, "1/5 2007", "0.RAHT", 5705.25, 840.71, "\u00d8ster R\u00e6hr vej-T", "\u00d8st i byen", false));
        this.add(new TurnPoint(128, "1/5 2007", "0.VR0J", 5539.22, 817.54, "\u00d8ster Vr\u00f8gum Stn.", "", false));
        this.add(new TurnPoint(196, "1/5 2007", "0STRVR", 5720.7, 1013.97, "\u00d8stervr\u00e5 Rundk\u00f8rsel", "", false));
    }

    public void read() {
        if (tpList.size() == 0) {
            File file = new File(Home.getResources() + "vendepkt.vpi");
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                IGCturnpoints.read(br, tpList);
                br.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void remove(String name) {
        if (!TurnPoints.isUsed(name)) {
            return;
        }
        tpList.removeElement(TurnPoints.get(name));
    }

    public void removeAllElements() {
        tpList.removeAllElements();
    }

    public void reread() {
        tpList = new Vector();
        this.read();
    }

    void skipNumber() {
        String ns = line.getItem();
    }

    public static TurnPoint get(int number) {
        return (TurnPoint)tpList.elementAt(number);
    }

    public static TurnPoint get(String name) {
        for (int i = 0; i < TurnPoints.getTpSize(); ++i) {
            TurnPoint tp = (TurnPoint)tpList.elementAt(i);
            if (!tp.getName().equals(name)) continue;
            return tp;
        }
        return null;
    }

    public static TurnPoint get(int lat, int lon) {
        for (int i = 0; i < TurnPoints.getTpSize(); ++i) {
            TurnPoint tp = (TurnPoint)tpList.elementAt(i);
            if (tp.getLatitude() != lat || tp.getLongitude() != lon) continue;
            return tp;
        }
        return null;
    }

    public static int getTpSize() {
        return tpList.size();
    }

    public static boolean isUsed(String name) {
        return TurnPoints.get(name) != null;
    }

    public static void to_String() {
        for (int i = 0; i < TurnPoints.getTpSize(); ++i) {
            TurnPoint turnPoint = (TurnPoint)tpList.elementAt(i);
        }
    }
}

