/*
 * Decompiled with CFR 0.152.
 */
package glider.data;

import glider.data.Coordinate;
import glider.data.CoordinateData;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class TurnPoint
implements Serializable {
    public int number;
    private String name;
    public boolean landable;
    public String description;
    public String detail;
    public CoordinateData latlon;
    private String date;
    public static final int JUTLAND = 0;
    public static final int FUEN = 1;
    public static final int ZEALAND = 2;
    public static final int FOREIGN = 3;
    private static final int COLUMNS = 8;

    public TurnPoint() {
        this.number = -1;
        this.name = null;
        this.latlon = new CoordinateData(0, 0);
        this.description = null;
        this.detail = "";
        this.landable = false;
        this.newDate();
    }

    public TurnPoint(int number, String date, String name, double lat, double lon, String descr, String detail, boolean landable) {
        this.number = number;
        this.name = name;
        if (lat > 5800.0) {
            throw new IllegalArgumentException("Lattitude must be less than 5800.000. Format: ddmm.ttt");
        }
        if (lon > 1300.0) {
            throw new IllegalArgumentException("Lattitude must be less than 1300.000. Format: ddmm.ttt");
        }
        int latRnd = Math.round((float)lat * 1000.0f);
        int lonRnd = Math.round((float)lon * 1000.0f);
        this.latlon = new CoordinateData(latRnd, lonRnd);
        this.description = descr;
        this.detail = detail;
        this.landable = landable;
        this.date = date;
    }

    public void setDate(String newDate) {
        this.date = newDate;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription.length() > 20 ? newDescription.substring(0, 19) : newDescription;
        this.newDate();
    }

    public void setDetail(String newDetail) {
        this.detail = newDetail.length() > 50 ? newDetail.substring(0, 49) : newDetail;
        this.newDate();
    }

    public void setLandable(boolean newLandable) {
        this.landable = newLandable;
        this.newDate();
    }

    public void setLat(String newLat) {
        int lat;
        double dLat = new Double(newLat);
        if (dLat > 5800.0) {
            throw new IllegalArgumentException("Lattitude must be less than 5800.000. Format: ddmm.ttt");
        }
        if (dLat < 5000.0) {
            throw new IllegalArgumentException("Lattitude must be less than 5000.000. Format: ddmm.ttt");
        }
        this.latlon.latitude = lat = (int)(dLat * 1000.0);
        this.newDate();
    }

    public void setLon(String newLon) {
        int lon;
        double dLon = new Double(newLon);
        if (dLon > 1300.0) {
            throw new IllegalArgumentException("Lattitude must be less than 1300.000. Format: ddmm.ttt");
        }
        if (dLon < 800.0) {
            throw new IllegalArgumentException("Lattitude must be greater than 0800.000. Format: ddmm.ttt");
        }
        this.latlon.longitude = lon = (int)(dLon * 1000.0);
        this.newDate();
    }

    public void setLatLon(Coordinate coord) {
        this.latlon.latitude = coord.getLatitude();
        this.latlon.longitude = coord.getLongitude();
    }

    public void setName(String newName) {
        this.name = newName.length() > 6 ? newName.substring(0, 6) : newName;
        this.newDate();
    }

    public void setNumber(int newNumber) {
        this.number = newNumber;
        this.newDate();
    }

    public CoordinateData getCoordinate() {
        return this.latlon;
    }

    public Object getDate() {
        return this.date;
    }

    public Object getDescription() {
        return this.description;
    }

    public Object getDetail() {
        return this.detail;
    }

    public Object getLandable() {
        return new Boolean(this.landable);
    }

    public Object getLat() {
        Locale.setDefault(Locale.US);
        DecimalFormat df = new DecimalFormat("0000.000");
        return df.format((double)this.latlon.latitude / 1000.0);
    }

    public int getLatitude() {
        return this.latlon.latitude;
    }

    public Object getLon() {
        DecimalFormat df = new DecimalFormat("00000.000");
        Locale.setDefault(Locale.US);
        return df.format((double)this.latlon.longitude / 1000.0);
    }

    public int getLongitude() {
        return this.latlon.longitude;
    }

    public String getName() {
        return this.name;
    }

    public Object getNumber() {
        return new Integer(this.number);
    }

    public boolean isLandable() {
        return this.landable;
    }

    public int location() {
        if (this.latlon.longitude > 940000 && this.latlon.longitude < 1100000 && this.latlon.latitude > 5440000 && this.latlon.latitude < 5540000) {
            if (this.latlon.longitude < 1000000 && this.latlon.latitude < 5505000) {
                return 0;
            }
            return 1;
        }
        if (this.latlon.longitude > 1050000 && this.latlon.longitude < 1300000 && this.latlon.latitude > 5430000 && this.latlon.latitude < 5610000) {
            return 2;
        }
        if (this.latlon.longitude > 800000 && this.latlon.longitude < 0x111700 && this.latlon.latitude > 5448000 && this.latlon.latitude < 5750000) {
            return 0;
        }
        return 3;
    }

    private void newDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy");
        this.date = sdf.format(new Date());
    }

    public static final int getColumns() {
        return 8;
    }

    public static TurnPoint loadV3(RandomAccessFile f) throws IOException {
        TurnPoint t = new TurnPoint();
        t.latlon = Coordinate.loadV3(f);
        t.name = f.readUTF();
        return t;
    }
}

