/*
 * Decompiled with CFR 0.152.
 */
package glider.data;

import glider.data.Coordinate;
import glider.data.TurnPoint;
import glider.utils.Utils;
import java.util.HashMap;
import java.util.Map;

public class TpNames {
    private static TpNames instance;
    private static Map names;

    private TpNames() {
    }

    public static TpNames getInstance() {
        if (instance == null) {
            instance = new TpNames();
        }
        return instance;
    }

    public void reUseName(TurnPoint tp) {
        Map names = this.getNames();
        for (LatLon latlon : names.keySet()) {
            Coordinate c = new Coordinate(tp.getLatitude(), tp.getLongitude());
            Tp tp1 = (Tp)names.get(latlon);
            Coordinate c1 = new Coordinate(latlon.lat, latlon.lon);
            c1.toDecimal();
            double dist = Utils.distance(c1, c);
            if (!(dist < 1.0)) continue;
            this.updateFields(tp, tp1);
            return;
        }
    }

    private void updateFields(TurnPoint tp, Tp existingTp) {
        tp.setName(existingTp.name);
        tp.setLandable(existingTp.landable);
    }

    private Map getNames() {
        if (names == null) {
            names = new HashMap();
            names.put(new LatLon(5618420, 1037618), new Tp("AARHUA", 344, true));
            names.put(new LatLon(5650880, 927870), new Tp("AARS H", 33, true));
            names.put(new LatLon(5459280, 851630), new Tp("ABILDY", 204, false));
            names.put(new LatLon(5507750, 908490), new Tp("AGRSKR", 205, false));
            names.put(new LatLon(5552180, 1219040), new Tp("ALLERF", 362, true));
            names.put(new LatLon(5554130, 0x116566), new Tp("ANNEBG", 782, false));
            names.put(new LatLon(5618710, 935940), new Tp("ANS VB", 145, false));
            names.put(new LatLon(5646180, 951590), new Tp("ARDENJ", 27, false));
            names.put(new LatLon(5600620, 900500), new Tp("ARNBOV", 98, false));
            names.put(new LatLon(5600640, 901080), new Tp("ARNBO0", 99, true));
            names.put(new LatLon(5600640, 901320), new Tp("ARNBOH", 97, false));
            names.put(new LatLon(5600850, 859840), new Tp("ARNBOR", 1, false));
            names.put(new LatLon(5508950, 857730), new Tp("ARRILK", 325, false));
            names.put(new LatLon(5626460, 1008930), new Tp("ASSENK", 68, false));
            names.put(new LatLon(5646080, 958620), new Tp("ASTRUK", 207, false));
            names.put(new LatLon(5615900, 847320), new Tp("AULUMJ", 208, false));
            names.put(new LatLon(5543210, 952680), new Tp("BARRIK", 137, false));
            names.put(new LatLon(5520270, 1138620), new Tp("BAVELK", 363, false));
            names.put(new LatLon(5604080, 1011350), new Tp("BEDERG", 87, false));
            names.put(new LatLon(5506390, 1159470), new Tp("BELDRG", 235, false));
            names.put(new LatLon(5544020, 909130), new Tp("BILLUH", 91, true));
            names.put(new LatLon(5544270, 910030), new Tp("BILLUF", 90, false));
            names.put(new LatLon(5511980, 1129440), new Tp("BISSEH", 418, false));
            names.put(new LatLon(5730180, 1003220), new Tp("BJRGBA", -1, true));
            names.put(new LatLon(0x577222, 1002880), new Tp("BJRGBK", 210, false));
            names.put(new LatLon(5622700, 939630), new Tp("BJERRK", 24, false));
            names.put(new LatLon(5526590, 1200570), new Tp("BJAVE-", 771, false));
            names.put(new LatLon(5552450, 901970), new Tp("BLAAHS", 96, false));
            names.put(new LatLon(5518110, 1117240), new Tp("BOESLR", 781, false));
            names.put(new LatLon(5532540, 1001880), new Tp("BOGENA", -1, true));
            names.put(new LatLon(5534060, 1005230), new Tp("BOGENK", 211, false));
            names.put(new LatLon(5459280, 916790), new Tp("BOLDSX", 212, false));
            names.put(new LatLon(5537900, 845290), new Tp("BOLHEH", 213, true));
            names.put(new LatLon(5550270, 953890), new Tp("BOLLRS", 117, false));
            names.put(new LatLon(5608830, 916690), new Tp("BORDIJ", 214, false));
            names.put(new LatLon(5557490, 838650), new Tp("BORRIJ", 215, false));
            names.put(new LatLon(5655370, 928280), new Tp("BORUPH", 63, true));
            names.put(new LatLon(5527890, 842490), new Tp("BRAMMJ", 218, false));
            names.put(new LatLon(5556700, 907740), new Tp("BRANDJ", 49, false));
            names.put(new LatLon(5503390, 849410), new Tp("BREDBJ", 219, false));
            names.put(new LatLon(5518440, 1200400), new Tp("BREGVG", 306, false));
            names.put(new LatLon(5605160, 830420), new Tp("BREJNX", 3, false));
            names.put(new LatLon(5601520, 930770), new Tp("BRYRUK", 92, false));
            names.put(new LatLon(5601780, 930920), new Tp("BRYRUX", 337, false));
            names.put(new LatLon(5556570, 939120), new Tp("BRADSF", 146, true));
            names.put(new LatLon(5556580, 939120), new Tp("BRADSA", -1, false));
            names.put(new LatLon(5558010, 936510), new Tp("BRADSK", 14, false));
            names.put(new LatLon(5507540, 1023490), new Tp("BRANDG", 216, false));
            names.put(new LatLon(5717320, 951500), new Tp("BR0NDA", -1, true));
            names.put(new LatLon(5716090, 957200), new Tp("BR0NDK", 147, false));
            names.put(new LatLon(5716230, 956560), new Tp("BR0NDJ", 199, false));
            names.put(new LatLon(5528840, 901710), new Tp("BR0RUS", 217, false));
            names.put(new LatLon(5528960, 900920), new Tp("BR0RUJ", 38, false));
            names.put(new LatLon(5709490, 901470), new Tp("BULDBK", 185, false));
            names.put(new LatLon(5455600, 904010), new Tp("BURKAK", 73, false));
            names.put(new LatLon(5624790, 818420), new Tp("BAEKMJ", 46, false));
            names.put(new LatLon(5727650, 1005640), new Tp("B0GSTH", 188, true));
            names.put(new LatLon(5722120, 948020), new Tp("B0RGLK", 143, false));
            names.put(new LatLon(5538480, 939130), new Tp("B0RKOJ", 209, false));
            names.put(new LatLon(5522860, 1122890), new Tp("CHARLG", 365, false));
            names.put(new LatLon(5606310, 923580), new Tp("CHRHDF", 220, true));
            names.put(new LatLon(5606170, 923960), new Tp("CHRHDH", 333, false));
            names.put(new LatLon(5602450, 1227320), new Tp("DALE X", 236, false));
            names.put(new LatLon(5517370, 1125490), new Tp("DALMOY", 237, false));
            names.put(new LatLon(5532050, 1129900), new Tp("DIANAJ", 366, false));
            names.put(new LatLon(5546310, 1123440), new Tp("DRAGSS", 238, false));
            names.put(new LatLon(5709300, 1015620), new Tp("DRONNS", 221, false));
            names.put(new LatLon(5550700, 0x116868), new Tp("EGEBJK", 239, false));
            names.put(new LatLon(5510560, 1029420), new Tp("EGESKS", 222, false));
            names.put(new LatLon(5553130, 831530), new Tp("EGVADK", 148, false));
            names.put(new LatLon(5525700, 955760), new Tp("EJBY J", 223, false));
            names.put(new LatLon(5559480, 916070), new Tp("EJSTRA", -1, true));
            names.put(new LatLon(5558970, 917210), new Tp("EJSTRK", 224, false));
            names.put(new LatLon(5655820, 952060), new Tp("ELLIDK", 149, false));
            names.put(new LatLon(5345380, 939410), new Tp("ELMSHJ", 323, false));
            names.put(new LatLon(5506090, 1046520), new Tp("ELSEHF", 225, false));
            names.put(new LatLon(5545410, 1014860), new Tp("ENDELA", -1, true));
            names.put(new LatLon(5610100, 921090), new Tp("ENGESJ", 226, false));
            names.put(new LatLon(5531310, 832930), new Tp("ESBJEF", 227, true));
            names.put(new LatLon(5603160, 1220640), new Tp("ESB0NK", 367, false));
            names.put(new LatLon(5633460, 1021500), new Tp("ESTRLA", -1, true));
            names.put(new LatLon(5551100, 1204150), new Tp("FFF  H", 301, true));
            names.put(new LatLon(5545780, 1218820), new Tp("VARL0H", 441, true));
            names.put(new LatLon(5515340, 1207330), new Tp("FAKSEK", 240, false));
            names.put(new LatLon(5513040, 1209680), new Tp("FAKSLJ", 241, false));
            names.put(new LatLon(5517610, 1018410), new Tp("FANGLA", -1, true));
            names.put(new LatLon(5646450, 920320), new Tp("FARS0K", 133, false));
            names.put(new LatLon(5600500, 906690), new Tp("FASTEX", 47, false));
            names.put(new LatLon(5656650, 956220), new Tp("FERSLH", 203, true));
            names.put(new LatLon(5548830, 902780), new Tp("FILSKF", 150, true));
            names.put(new LatLon(5548830, 902790), new Tp("FILSKA", -1, false));
            names.put(new LatLon(5705310, 915990), new Tp("FJERRK", 175, false));
            names.put(new LatLon(5446420, 922510), new Tp("FLENSH", 116, true));
            names.put(new LatLon(5626830, 818290), new Tp("FLYNDK", 229, false));
            names.put(new LatLon(5558920, 1223760), new Tp("FRDNBS", 302, false));
            names.put(new LatLon(5556100, 1218060), new Tp("FRDRBS", 304, false));
            names.put(new LatLon(5558400, 1201350), new Tp("FRDRVK", 305, false));
            names.put(new LatLon(5615900, 953620), new Tp("FRISBG", 25, false));
            names.put(new LatLon(5506710, 1021690), new Tp("FRISVA", -1, true));
            names.put(new LatLon(5518320, 1132910), new Tp("FUGLBK", 242, false));
            names.put(new LatLon(5649490, 859270), new Tp("FUR  A", -1, true));
            names.put(new LatLon(5628370, 950620), new Tp("FUSS0S", 151, false));
            names.put(new LatLon(5637380, 946250), new Tp("FYRKAB", 152, false));
            names.put(new LatLon(5455020, 1042390), new Tp("FAREVG", 228, false));
            names.put(new LatLon(5547250, 1128100), new Tp("FAREVJ", 243, false));
            names.put(new LatLon(5515240, 908750), new Tp("GAB0LR", 230, false));
            names.put(new LatLon(5558070, 1217450), new Tp("GADEVT", 445, false));
            names.put(new LatLon(5515770, 1145170), new Tp("GANGEB", 244, false));
            names.put(new LatLon(5523800, 958410), new Tp("GELSTJ", 231, false));
            names.put(new LatLon(5533060, 911580), new Tp("GESTNH", 232, true));
            names.put(new LatLon(5525050, 1155970), new Tp("GIESEG", 245, false));
            names.put(new LatLon(5607400, 1218640), new Tp("GILLEK", 369, false));
            names.put(new LatLon(5517330, 1158300), new Tp("GISSFG", 309, false));
            names.put(new LatLon(5551780, 915190), new Tp("GIVE R", 9, false));
            names.put(new LatLon(5531040, 942570), new Tp("GL.LIB", 187, false));
            names.put(new LatLon(5521220, 1141720), new Tp("GLUMSJ", 246, false));
            names.put(new LatLon(5517640, 903400), new Tp("GRAM S", 74, false));
            names.put(new LatLon(5626510, 1055790), new Tp("GRENAA", -1, true));
            names.put(new LatLon(5455530, 935710), new Tp("GRASTK", 58, false));
            names.put(new LatLon(5556580, 1222860), new Tp("GR0NHF", 371, true));
            names.put(new LatLon(5509060, 1042550), new Tp("GUDMEK", 111, false));
            names.put(new LatLon(5518820, 1140340), new Tp("GUNDSK", 455, false));
            names.put(new LatLon(5544110, 1208900), new Tp("GNDSMK", 373, false));
            names.put(new LatLon(5601270, 1231410), new Tp("GURREB", 374, false));
            names.put(new LatLon(5602810, 1231500), new Tp("GURREX", 310, false));
            names.put(new LatLon(5529270, 1141080), new Tp("GYRSTK", 375, false));
            names.put(new LatLon(5500410, 1154730), new Tp("GAASET", 320, false));
            names.put(new LatLon(5533140, 1111770), new Tp("G0RLVA", 451, true));
            names.put(new LatLon(5532210, 1113980), new Tp("G0RLES", 452, false));
            names.put(new LatLon(5553030, 1213680), new Tp("G0RL0H", 339, true));
            names.put(new LatLon(5553150, 1211640), new Tp("G0RL0K", 311, false));
            names.put(new LatLon(5514970, 929260), new Tp("HADRSK", 75, false));
            names.put(new LatLon(5518060, 931740), new Tp("HADRSH", 340, true));
            names.put(new LatLon(5619670, 1002750), new Tp("HADSTJ", 8, false));
            names.put(new LatLon(5642850, 1007070), new Tp("HADSUB", 66, false));
            names.put(new LatLon(5645360, 1013730), new Tp("HADSUA", -1, true));
            names.put(new LatLon(5659870, 1018660), new Tp("HALS K", 202, false));
            names.put(new LatLon(5614060, 951880), new Tp("HAMMLB", 30, false));
            names.put(new LatLon(5545210, 1150490), new Tp("HAMMEF", 460, false));
            names.put(new LatLon(5554410, 927220), new Tp("HAMMRH", 106, true));
            names.put(new LatLon(5709050, 1000700), new Tp("HAMMRK", 201, false));
            names.put(new LatLon(5630070, 945320), new Tp("HMMRHK", 7, false));
            names.put(new LatLon(5629980, 944540), new Tp("HMMRHR", 153, false));
            names.put(new LatLon(5607900, 903770), new Tp("HMMRMJ", 85, false));
            names.put(new LatLon(5706750, 835860), new Tp("HANSTF", 176, false));
            names.put(new LatLon(5529490, 1146070), new Tp("HARALK", 377, false));
            names.put(new LatLon(5519760, 0x11AA3A), new Tp("HASLVJ", 249, false));
            names.put(new LatLon(5550630, 944160), new Tp("HATTIY", 94, false));
            names.put(new LatLon(5647940, 938120), new Tp("HAVRSR", 103, false));
            names.put(new LatLon(5545270, 1119420), new Tp("HAVNSH", 378, false));
            names.put(new LatLon(5608760, 816700), new Tp("HEE  K", 136, false));
            names.put(new LatLon(5712770, 1009150), new Tp("HLLEVK", 118, false));
            names.put(new LatLon(5601430, 1211850), new Tp("HELSIK", 379, false));
            names.put(new LatLon(5542590, 818400), new Tp("HENNEJ", 76, false));
            names.put(new LatLon(5611020, 902350), new Tp("HERNIF", 119, true));
            names.put(new LatLon(0x559222, 858610), new Tp("HERNIJ", 348, false));
            names.put(new LatLon(5509510, 1045770), new Tp("HSSLAG", 349, false));
            names.put(new LatLon(5615210, 928980), new Tp("HINGES", 10, false));
            names.put(new LatLon(5638590, 946950), new Tp("HOBROJ", 31, false));
            names.put(new LatLon(5542890, 1142530), new Tp("HOLBAJ", 250, false));
            names.put(new LatLon(5515650, 1150960), new Tp("HOLMOJ", 251, false));
            names.put(new LatLon(5517190, 1149440), new Tp("HOLMEG", 465, false));
            names.put(new LatLon(5621130, 838370), new Tp("HOLSTV", 4, false));
            names.put(new LatLon(5622150, 834090), new Tp("HOLSTY", 154, false));
            names.put(new LatLon(5529100, 854760), new Tp("HOLSTX", 332, false));
            names.put(new LatLon(5512840, 1127840), new Tp("HOLSTG", 252, false));
            names.put(new LatLon(5605360, 1227590), new Tp("HORNBJ", 380, false));
            names.put(new LatLon(5543450, 831840), new Tp("HORNEK", 120, false));
            names.put(new LatLon(5619260, 1018850), new Tp("HORNSJ", 69, false));
            names.put(new LatLon(5556750, 957760), new Tp("HOVDGJ", 37, false));
            names.put(new LatLon(5551100, 845000), new Tp("HOVENR", 26, false));
            names.put(new LatLon(5557070, 1151570), new Tp("HUNDEK", 381, false));
            names.put(new LatLon(5715070, 937070), new Tp("HUNE K", 198, false));
            names.put(new LatLon(5541930, 1211700), new Tp("HVEDSK", 382, false));
            names.put(new LatLon(5638990, 831600), new Tp("HVIDBJ", 177, false));
            names.put(new LatLon(5504400, 1032010), new Tp("HVIDKS", 59, false));
            names.put(new LatLon(5724830, 958320), new Tp("HASTRK", 140, false));
            names.put(new LatLon(5524670, 1146780), new Tp("H0M  K", 253, false));
            names.put(new LatLon(5530380, 1117150), new Tp("H0NG J", 254, false));
            names.put(new LatLon(5617620, 926340), new Tp("H0RUPK", 326, false));
            names.put(new LatLon(5545140, 1127380), new Tp("H0RVEJ", 255, false));
            names.put(new LatLon(5620160, 828890), new Tp("IDOM K", 95, false));
            names.put(new LatLon(5613980, 906790), new Tp("ILSKOK", 350, false));
            names.put(new LatLon(5500890, 1155640), new Tp("ISSLIG", 206, false));
            names.put(new LatLon(5552640, 1228670), new Tp("ISTERR", 383, false));
            names.put(new LatLon(5521430, 912110), new Tp("JELS K", 40, false));
            names.put(new LatLon(5539610, 927520), new Tp("JRLVGA", -1, true));
            names.put(new LatLon(5615900, 955400), new Tp("JRNITG", 155, false));
            names.put(new LatLon(5533510, 918680), new Tp("JORDRX", 156, false));
            names.put(new LatLon(5504870, 1207350), new Tp("JUNGHK", 437, false));
            names.put(new LatLon(5539580, 1123950), new Tp("JYDERJ", 256, false));
            names.put(new LatLon(5530940, 1152080), new Tp("JYSTRK", 257, false));
            names.put(new LatLon(5541960, 1115490), new Tp("KALDRH", 258, true));
            names.put(new LatLon(5541900, 0x110120), new Tp("KALDRV", 574, false));
            names.put(new LatLon(5541900, 1115800), new Tp("KALDR0", 577, false));
            names.put(new LatLon(5540830, 1104850), new Tp("KALUNK", 474, false));
            names.put(new LatLon(5540620, 1104160), new Tp("KALUNR", 259, false));
            names.put(new LatLon(5518310, 1212640), new Tp("KARISK", 260, false));
            names.put(new LatLon(5638240, 1009890), new Tp("KASTBA", -1, true));
            names.put(new LatLon(5502220, 1153590), new Tp("KASTRK", 384, false));
            names.put(new LatLon(5536640, 1122350), new Tp("KATTRG", 385, false));
            names.put(new LatLon(5601950, 851120), new Tp("KIBAKJ", 50, false));
            names.put(new LatLon(5542210, 0x119914), new Tp("KIRKHK", 387, false));
            names.put(new LatLon(5535710, 1151480), new Tp("KRKEHJ", 261, false));
            names.put(new LatLon(5635450, 938550), new Tp("KLEJT-", 101, false));
            names.put(new LatLon(5456120, 923800), new Tp("KLIPLJ", 331, false));
            names.put(new LatLon(5702330, 830360), new Tp("KLITMK", 186, false));
            names.put(new LatLon(5531760, 928010), new Tp("KOLDIB", 16, false));
            names.put(new LatLon(5529490, 928460), new Tp("KOLDIS", 328, false));
            names.put(new LatLon(5515040, 1203360), new Tp("KONGSV", 361, false));
            names.put(new LatLon(5515160, 1204130), new Tp("KONGS0", 360, false));
            names.put(new LatLon(5515050, 1203730), new Tp("KONGSH", 233, true));
            names.put(new LatLon(5520300, 0x110210), new Tp("KORS0A", 482, true));
            names.put(new LatLon(5519870, 1108540), new Tp("KORS0B", 262, false));
            names.put(new LatLon(5556740, 1202850), new Tp("KREGMK", 388, false));
            names.put(new LatLon(5602340, 1237320), new Tp("KRONBS", 263, false));
            names.put(new LatLon(5452330, 916720), new Tp("KRUSAH", 56, true));
            names.put(new LatLon(5539130, 1140140), new Tp("KVANLK", 389, false));
            names.put(new LatLon(5559430, 1230190), new Tp("KVISTJ", 390, false));
            names.put(new LatLon(5510700, 1031140), new Tp("KVARNJ", 60, false));
            names.put(new LatLon(5548800, 1152710), new Tp("KYNDBV", 485, false));
            names.put(new LatLon(5603910, 905090), new Tp("K0LKAJ", 48, false));
            names.put(new LatLon(5623160, 953770), new Tp("LANGAJ", 157, false));
            names.put(new LatLon(0x55CCCE, 953620), new Tp("LANGAY", 28, false));
            names.put(new LatLon(5607500, 943040), new Tp("LAVENJ", 36, false));
            names.put(new LatLon(5446510, 858630), new Tp("LECH J", 234, false));
            names.put(new LatLon(5530990, 920200), new Tp("LEJRSK", 158, false));
            names.put(new LatLon(5630300, 818260), new Tp("LEMVIF", 341, true));
            names.put(new LatLon(5724560, 1018030), new Tp("LENDUK", 141, false));
            names.put(new LatLon(5539150, 1104380), new Tp("LERCHG", 775, false));
            names.put(new LatLon(5516440, 1223440), new Tp("LHEDDK", 443, false));
            names.put(new LatLon(5501730, 1203430), new Tp("LILNDG", 264, false));
            names.put(new LatLon(5624910, 829300), new Tp("LIND R", 89, false));
            names.put(new LatLon(5654450, 1002070), new Tp("LINDBG", 64, false));
            names.put(new LatLon(5533870, 901240), new Tp("LINDKK", 159, false));
            names.put(new LatLon(5623800, 826570), new Tp("LINDTA", -1, true));
            names.put(new LatLon(5649420, 815740), new Tp("LODBJF", 178, false));
            names.put(new LatLon(5550560, 1216840), new Tp("LYNGEK", 392, false));
            names.put(new LatLon(5613830, 1014080), new Tp("LYSTRJ", 335, false));
            names.put(new LatLon(5608780, 949130), new Tp("LASBYX", 112, false));
            names.put(new LatLon(5716650, 1100040), new Tp("LAS0 A", -1, true));
            names.put(new LatLon(5503410, 857020), new Tp("L0GUMK", 18, false));
            names.put(new LatLon(5503640, 855290), new Tp("L0GUMR", 108, false));
            names.put(new LatLon(5505610, 857930), new Tp("L0JTVA", -1, true));
            names.put(new LatLon(5548160, 942090), new Tp("L0SNIJ", 15, false));
            names.put(new LatLon(0x55DCDC, 1026598), new Tp("L0VNBS", 351, false));
            names.put(new LatLon(5627090, 1026598), new Tp("L0VNHS", 131, false));
            names.put(new LatLon(5638890, 958720), new Tp("MARIAK", 67, false));
            names.put(new LatLon(5555460, 932630), new Tp("MATTRG", 13, false));
            names.put(new LatLon(5559740, 1158150), new Tp("MELBYK", 394, false));
            names.put(new LatLon(5539070, 1106330), new Tp("MELBYT", 303, false));
            names.put(new LatLon(5503010, 1203450), new Tp("MERN K", 265, false));
            names.put(new LatLon(5649440, 847430), new Tp("MORS0F", 172, true));
            names.put(new LatLon(5530370, 1131240), new Tp("MUNKEK", 495, false));
            names.put(new LatLon(5540430, 1148680), new Tp("MUNKHB", 266, false));
            names.put(new LatLon(5519180, 915950), new Tp("M0LBYS", 160, false));
            names.put(new LatLon(5637280, 930700), new Tp("M0LDRR", 44, false));
            names.put(new LatLon(5539250, 1130130), new Tp("M0RK0J", 267, false));
            names.put(new LatLon(5447310, 850120), new Tp("NIEB\u00d8J", 139, false));
            names.put(new LatLon(5533410, 1129710), new Tp("NIL0SK", 268, false));
            names.put(new LatLon(5504500, 945340), new Tp("NORDBA", -1, true));
            names.put(new LatLon(5529440, 1126350), new Tp("NORDRG", 395, false));
            names.put(new LatLon(5531120, 944960), new Tp("NY LIB", 109, false));
            names.put(new LatLon(5513760, 1131150), new Tp("NYBODX", 269, false));
            names.put(new LatLon(5512310, 1140000), new Tp("NYBROY", 270, false));
            names.put(new LatLon(5549620, 811010), new Tp("NYMINA", -1, true));
            names.put(new LatLon(5523190, 1138900), new Tp("NASBYB", 271, false));
            names.put(new LatLon(5522110, 0x115616), new Tp("NASBYG", 299, false));
            names.put(new LatLon(5512640, 1142960), new Tp("NASTVA", 496, true));
            names.put(new LatLon(5513880, 1146020), new Tp("NASTVJ", 497, false));
            names.put(new LatLon(5558220, 1220300), new Tp("N0DDEK", 499, false));
            names.put(new LatLon(5534600, 1121250), new Tp("N0RAGG", 399, false));
            names.put(new LatLon(5646900, 943480), new Tp("N0RLUG", 100, false));
            names.put(new LatLon(5618410, 835860), new Tp("NR. FH", 161, true));
            names.put(new LatLon(5557860, 923660), new Tp("NRSNEX", 12, false));
            names.put(new LatLon(5527610, 952170), new Tp("NRABYJ", 330, false));
            names.put(new LatLon(5558430, 1117980), new Tp("ODDENF", 400, false));
            names.put(new LatLon(5558410, 1009170), new Tp("ODDERK", 134, false));
            names.put(new LatLon(5528450, 1019770), new Tp("ODENSF", 342, true));
            names.put(new LatLon(5537580, 817010), new Tp("OKSB0J", 130, false));
            names.put(new LatLon(5534150, 1157590), new Tp("OSTEDK", 774, false));
            names.put(new LatLon(5720710, 1024810), new Tp("OTTSTH", 197, true));
            names.put(new LatLon(5550440, 1159320), new Tp("OVERDK", 401, false));
            names.put(new LatLon(5511860, 917740), new Tp("OVRJSR", 329, false));
            names.put(new LatLon(5558310, 951340), new Tp("OVSTEK", 162, false));
            names.put(new LatLon(5423350, 935260), new Tp("OWSLAJ", 322, false));
            names.put(new LatLon(5448330, 919690), new Tp("PADBOG", 121, false));
            names.put(new LatLon(5500200, 1206200), new Tp("PETERG", 313, false));
            names.put(new LatLon(5608210, 921090), new Tp("PARUPX", 11, false));
            names.put(new LatLon(5541870, 1103940), new Tp("RAKLEK", 402, false));
            names.put(new LatLon(5600950, 1207130), new Tp("RAML0M", 403, false));
            names.put(new LatLon(5630300, 1001990), new Tp("RNDRSH", 72, true));
            names.put(new LatLon(5515650, 1034950), new Tp("RAVNHG", 122, false));
            names.put(new LatLon(5531530, 1106760), new Tp("REERSK", 272, false));
            names.put(new LatLon(5519660, 846210), new Tp("RIBE J", 19, false));
            names.put(new LatLon(5605430, 857490), new Tp("RIND K", 52, false));
            names.put(new LatLon(5514200, 1029500), new Tp("RINGEX", 110, false));
            names.put(new LatLon(5547360, 910690), new Tp("RINGGR", 20, false));
            names.put(new LatLon(5525620, 1148820), new Tp("RINGSH", 314, true));
            names.put(new LatLon(5526500, 1147000), new Tp("RINGSJ", 512, false));
            names.put(new LatLon(5519420, 1034829), new Tp("ROLSTA", -1, true));
            names.put(new LatLon(5631000, 818290), new Tp("ROM  K", 35, false));
            names.put(new LatLon(5500990, 1152570), new Tp("ROSENG", 517, false));
            names.put(new LatLon(5619990, 1019820), new Tp("ROSNHG", 179, false));
            names.put(new LatLon(5726920, 946410), new Tp("RUBJEF", 193, false));
            names.put(new LatLon(5532380, 1122470), new Tp("RUDSVJ", 273, false));
            names.put(new LatLon(5737550, 1021350), new Tp("RABJEK", 190, false));
            names.put(new LatLon(5546690, 956280), new Tp("RARUPA", -1, true));
            names.put(new LatLon(5521960, 904320), new Tp("R0DDIR", 77, false));
            names.put(new LatLon(5504640, 917970), new Tp("R0DEKH", 334, true));
            names.put(new LatLon(5504190, 920010), new Tp("R0DEKJ", 57, false));
            names.put(new LatLon(5515290, 1222690), new Tp("R0DVIJ", 315, false));
            names.put(new LatLon(5515500, 1159670), new Tp("R0NNEB", 274, false));
            names.put(new LatLon(5538640, 1109470), new Tp("R0RBYK", 275, false));
            names.put(new LatLon(5544620, 1052140), new Tp("R0SNAF", 396, false));
            names.put(new LatLon(5553290, 1036640), new Tp("SAMS0A", -1, true));
            names.put(new LatLon(5430750, 933500), new Tp("SCHLEJ", 184, false));
            names.put(new LatLon(5556830, 844560), new Tp("SRFLDA", -1, true));
            names.put(new LatLon(5556600, 847340), new Tp("SRFLDK", 338, false));
            names.put(new LatLon(5659250, 1005970), new Tp("SEJLFK", 138, false));
            names.put(new LatLon(5657770, 846650), new Tp("SENLSA", -1, true));
            names.put(new LatLon(5539960, 834600), new Tp("SIG  J", 78, false));
            names.put(new LatLon(5609860, 932700), new Tp("SILKEJ", 79, false));
            names.put(new LatLon(5730200, 1013780), new Tp("SINDAA", -1, true));
            names.put(new LatLon(5625580, 905070), new Tp("SJ0RUX", 80, false));
            names.put(new LatLon(5742840, 1033050), new Tp("SKAGNK", 189, false));
            names.put(new LatLon(5632510, 924120), new Tp("SKALSB", 114, false));
            names.put(new LatLon(5602610, 955500), new Tp("SKANDJ", 83, false));
            names.put(new LatLon(5558700, 853860), new Tp("SKARRR", 51, false));
            names.put(new LatLon(5532260, 0x113212), new Tp("SKELLJ", 276, false));
            names.put(new LatLon(5544910, 1157500), new Tp("SKIBBK", 405, false));
            names.put(new LatLon(5611280, 902340), new Tp("SKINDH", 42, true));
            names.put(new LatLon(5633220, 909840), new Tp("SKIVEA", 105, true));
            names.put(new LatLon(5633730, 901430), new Tp("SKIVEJ", 181, false));
            names.put(new LatLon(5631920, 902280), new Tp("SKIVEY", 34, false));
            names.put(new LatLon(5556850, 829540), new Tp("SKJRNJ", 23, false));
            names.put(new LatLon(5532120, 1151180), new Tp("SKJOLG", 406, false));
            names.put(new LatLon(5513510, 915600), new Tp("SKRYDH", 163, true));
            names.put(new LatLon(5515300, 1117520), new Tp("SKLSKB", 277, false));
            names.put(new LatLon(5509520, 846290), new Tp("SKARBJ", 352, false));
            names.put(new LatLon(5554560, 1209090), new Tp("SKAVIK", 527, false));
            names.put(new LatLon(5650200, 953250), new Tp("SK0RPJ", 81, false));
            names.put(new LatLon(0x5445D4, 1119410), new Tp("SLAGEA", 532, false));
            names.put(new LatLon(5524660, 1124590), new Tp("SLAGEB", 278, false));
            names.put(new LatLon(5524430, 0x111AA2), new Tp("SLAGEJ", 533, false));
            names.put(new LatLon(5527130, 1138200), new Tp("SLAGLV", 535, false));
            names.put(new LatLon(5527200, 1139530), new Tp("SLAGL0", 534, false));
            names.put(new LatLon(5527070, 1138280), new Tp("SLAGLH", 279, true));
            names.put(new LatLon(0x545858, 1133800), new Tp("SLAIPV", 538, false));
            names.put(new LatLon(5527300, 1143920), new Tp("SLAIP0", 537, false));
            names.put(new LatLon(5550750, 1210220), new Tp("SLANGK", 539, false));
            names.put(new LatLon(5542700, 0x1122CC), new Tp("SNERTR", 540, false));
            names.put(new LatLon(5509930, 1155800), new Tp("SNESEK", 280, false));
            names.put(new LatLon(0x54444E, 0x119090), new Tp("SNESLK", 281, false));
            names.put(new LatLon(5259200, 955450), new Tp("SOLTAB", 324, false));
            names.put(new LatLon(5519200, 918700), new Tp("SOMRSK", 123, false));
            names.put(new LatLon(5628750, 913950), new Tp("SPARKK", 124, false));
            names.put(new LatLon(5506160, 830810), new Tp("SPJALF", 164, true));
            names.put(new LatLon(5456090, 1049960), new Tp("SPODSL", 165, false));
            names.put(new LatLon(5559480, 821180), new Tp("STAUNF", 343, true));
            names.put(new LatLon(5532450, 1135860), new Tp("STENLJ", 282, false));
            names.put(new LatLon(5512740, 0x110210), new Tp("STIGSL", 283, false));
            names.put(new LatLon(5646350, 934190), new Tp("STBINR", 41, false));
            names.put(new LatLon(5526530, 1127790), new Tp("STFREG", 300, false));
            names.put(new LatLon(5518600, 1223160), new Tp("STHEDJ", 284, false));
            names.put(new LatLon(5532690, 1142710), new Tp("STMERJ", 285, false));
            names.put(new LatLon(0x558854, 854540), new Tp("STUDSJ", 166, false));
            names.put(new LatLon(5652790, 948200), new Tp("ST0VRB", 6, false));
            names.put(new LatLon(5650580, 944500), new Tp("SULDRT", 65, false));
            names.put(new LatLon(5708870, 959370), new Tp("SULSTK", 167, false));
            names.put(new LatLon(5536370, 1110720), new Tp("SVALLK", 393, false));
            names.put(new LatLon(5539120, 1117520), new Tp("SVEB0J", 548, false));
            names.put(new LatLon(5656980, 951940), new Tp("SVENSB", 84, false));
            names.put(new LatLon(5543400, 1128020), new Tp("SVINNJ", 286, false));
            names.put(new LatLon(5506570, 1145330), new Tp("SVIN0K", 783, false));
            names.put(new LatLon(5720010, 1031740), new Tp("SABY K", 168, false));
            names.put(new LatLon(5532720, 0x11111A), new Tp("SABYVT", 287, false));
            names.put(new LatLon(5522020, 827960), new Tp("SDRHOA", -1, true));
            names.put(new LatLon(5521590, 1126450), new Tp("S0RBYK", 288, false));
            names.put(new LatLon(5553510, 944300), new Tp("TAMDRK", 93, false));
            names.put(new LatLon(5621260, 936160), new Tp("TANGEV", 113, false));
            names.put(new LatLon(5509650, 1158760), new Tp("TAPPNX", 289, false));
            names.put(new LatLon(5523480, 926910), new Tp("TAPS B", 17, false));
            names.put(new LatLon(5439790, 923870), new Tp("TARP J", 321, false));
            names.put(new LatLon(5649080, 1003130), new Tp("TERNDK", 102, false));
            names.put(new LatLon(5605760, 932730), new Tp("THEM S", 169, false));
            names.put(new LatLon(5704290, 841590), new Tp("THISTA", -1, true));
            names.put(new LatLon(5602490, 1206410), new Tp("TIBIRK", 408, false));
            names.put(new LatLon(5601120, 1227230), new Tp("TIK0BK", 409, false));
            names.put(new LatLon(5611220, 819500), new Tp("TIM  A", -1, true));
            names.put(new LatLon(5456150, 915450), new Tp("TINGLJ", 125, false));
            names.put(new LatLon(5630580, 936740), new Tp("TJELEG", 86, false));
            names.put(new LatLon(5510790, 903770), new Tp("TOFTLR", 54, false));
            names.put(new LatLon(5728240, 1018840), new Tp("TOLNEK", 192, false));
            names.put(new LatLon(5520780, 1011290), new Tp("TOMMRY", 62, false));
            names.put(new LatLon(5538300, 1131050), new Tp("TORBFG", 290, false));
            names.put(new LatLon(5553390, 1135180), new Tp("NYK0BA", 503, true));
            names.put(new LatLon(5735380, 1017280), new Tp("TUEN T", 191, false));
            names.put(new LatLon(5521680, 1133780), new Tp("TYSTRK", 291, false));
            names.put(new LatLon(5501020, 1033730), new Tp("TASINA", -1, true));
            names.put(new LatLon(5534870, 0x117A1A), new Tp("T0LL0H", 292, true));
            names.put(new LatLon(5536700, 1146410), new Tp("T0LL0J", 410, false));
            names.put(new LatLon(5540660, 1109060), new Tp("T0MMRK", 293, false));
            names.put(new LatLon(5455630, 850620), new Tp("T0NDRF", 55, true));
            names.put(new LatLon(5550800, 928520), new Tp("T0RRIG", 82, false));
            names.put(new LatLon(5455000, 927900), new Tp("T0RSBA", -1, true));
            names.put(new LatLon(5537150, 1112480), new Tp("UBBY K", 769, false));
            names.put(new LatLon(5504310, 1156510), new Tp("UDBY K", 556, false));
            names.put(new LatLon(5636600, 921180), new Tp("ULDBJR", 115, false));
            names.put(new LatLon(5616300, 819480), new Tp("ULFBOJ", 53, false));
            names.put(new LatLon(5521820, 1039829), new Tp("ULLRSK", 327, false));
            names.put(new LatLon(5517340, 1201090), new Tp("ULSE B", 294, false));
            names.put(new LatLon(5543960, 1057590), new Tp("ULSTRK", 411, false));
            names.put(new LatLon(5536330, 1134880), new Tp("UNDL0K", 558, false));
            names.put(new LatLon(5601170, 841580), new Tp("V.EJSH", 88, true));
            names.put(new LatLon(5501340, 1039160), new Tp("VALDES", 126, false));
            names.put(new LatLon(5531280, 1150010), new Tp("VALS0K", 318, false));
            names.put(new LatLon(5526170, 919820), new Tp("VAMDRA", -1, true));
            names.put(new LatLon(5525670, 916360), new Tp("VAMDRK", 173, false));
            names.put(new LatLon(5536430, 826550), new Tp("VARDEA", -1, true));
            names.put(new LatLon(5538280, 830840), new Tp("VARDEB", 21, false));
            names.put(new LatLon(5531930, 1132870), new Tp("VEDDEJ", 298, false));
            names.put(new LatLon(5528560, 908170), new Tp("VEJENJ", 43, false));
            names.put(new LatLon(5620850, 821030), new Tp("VEMB Y", 29, false));
            names.put(new LatLon(5521920, 1115570), new Tp("VMMLVB", 295, false));
            names.put(new LatLon(5509470, 1149120), new Tp("VEGEBK", 296, false));
            names.put(new LatLon(5515040, 1002820), new Tp("V.FYNA", -1, true));
            names.put(new LatLon(5626790, 925490), new Tp("VIBRGK", 206, false));
            names.put(new LatLon(5627030, 924760), new Tp("VIBRDK", 127, false));
            names.put(new LatLon(5626980, 925300), new Tp("VIBRGD", 104, false));
            names.put(new LatLon(5624600, 924680), new Tp("VIBRGH", 5, true));
            names.put(new LatLon(5605550, 837570), new Tp("VIDEBK", 2, false));
            names.put(new LatLon(5551050, 1135030), new Tp("VIG  K", 297, false));
            names.put(new LatLon(5611860, 846120), new Tp("VILDBJ", 71, false));
            names.put(new LatLon(5653040, 837870), new Tp("VILDSB", 182, false));
            names.put(new LatLon(5628980, 846950), new Tp("VINDEJ", 45, false));
            names.put(new LatLon(5537520, 1208260), new Tp("VINDIK", 412, false));
            names.put(new LatLon(5539720, 1116250), new Tp("VISKIK", 319, false));
            names.put(new LatLon(5714540, 1020120), new Tp("VOERGS", 200, false));
            names.put(new LatLon(5719640, 1026300), new Tp("VOLSTK", 144, false));
            names.put(new LatLon(5537800, 904840), new Tp("VORBAC", 39, false));
            names.put(new LatLon(5537870, 905180), new Tp("VORBAK", 107, false));
            names.put(new LatLon(5721650, 1000160), new Tp("VREJLK", 195, false));
            names.put(new LatLon(5721290, 956530), new Tp("VRAA J", 194, false));
            names.put(new LatLon(5546290, 1218040), new Tp("VARL0V", 413, false));
            names.put(new LatLon(5546100, 1219260), new Tp("VARL0A", 430, true));
            names.put(new LatLon(5546930, 1222400), new Tp("VARL0J", 376, false));
            names.put(new LatLon(5514930, 1012470), new Tp("V0JSTH", 61, true));
            names.put(new LatLon(5534690, 840130), new Tp("ARRE K", 171, false));
            names.put(new LatLon(5609180, 1002670), new Tp("AARSLB", 70, false));
            names.put(new LatLon(5523980, 1003170), new Tp("ARUP J", 129, false));
            names.put(new LatLon(5451150, 1027460), new Tp("AER0 A", -1, true));
            names.put(new LatLon(5714910, 959970), new Tp("0.BR0K", 142, false));
            names.put(new LatLon(5644700, 837180), new Tp("0.HVIK", 183, false));
            names.put(new LatLon(5548660, 837350), new Tp("0LGODJ", 22, false));
            names.put(new LatLon(5549940, 833090), new Tp("0LGODA", -1, true));
            names.put(new LatLon(5555270, 1204400), new Tp("0LSTEK", 414, false));
            names.put(new LatLon(5612090, 833620), new Tp("0RNH0K", 32, false));
            names.put(new LatLon(5532490, 1204610), new Tp("0RSTEK", 415, false));
            names.put(new LatLon(5558090, 944900), new Tp("0STBIX", 170, false));
            names.put(new LatLon(5705250, 840710), new Tp("0.RAHT", 180, false));
            names.put(new LatLon(5539220, 817540), new Tp("0.VR0J", 128, false));
            names.put(new LatLon(5720700, 1013970), new Tp("0STRVR", 196, false));
        }
        return names;
    }

    private class Tp {
        String name;
        int number;
        boolean landable;

        private Tp(String name, int number, boolean landable) {
            this.name = name;
            this.number = number;
            this.landable = landable;
        }
    }

    private class LatLon {
        private int lat;
        private int lon;

        private LatLon(int lat, int lon) {
            this.lat = lat;
            this.lon = lon;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            LatLon other = (LatLon)obj;
            return other.lat == this.lat && other.lon == this.lon;
        }

        public int hashCode() {
            return this.lat | this.lon;
        }

        public String toString() {
            return "lat: " + this.lat + ", lon: " + this.lon;
        }
    }
}

