/*
 * Decompiled with CFR 0.152.
 */
package glider.data;

import glider.COMMON;
import glider.data.Coordinate;
import glider.data.CoordinateData;
import glider.data.TaskData;
import glider.data.TurnPoint;
import glider.utils.Utils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class Task
extends TaskData {
    final int NORMAL = 0;
    final int CATS_CRADDLE = 1;

    public Task() {
        this.type = 0;
        this.length = 0.0;
        this.tpList = new Vector();
        this.fai = -1;
    }

    public void addTurnpoint(Coordinate coord) {
        CoordinateData data = new CoordinateData();
        data.latitude = coord.latitude;
        data.longitude = coord.longitude;
        this.tpList.addElement(data);
        this.calculateLength();
    }

    public void calculateLength() {
        this.length = 0.0;
        if (this.tpList.size() > 0) {
            Coordinate coord1 = new Coordinate((CoordinateData)this.tpList.elementAt(0));
            for (int i = 1; i < this.size(); ++i) {
                Coordinate coord2 = new Coordinate((CoordinateData)this.tpList.elementAt(i));
                this.length += Utils.distance(coord1, coord2);
                coord1 = coord2;
            }
        }
    }

    public Coordinate coordinate(int number) {
        return new Coordinate((CoordinateData)this.tpList.elementAt(number));
    }

    public boolean equals(Task t) {
        if (t == null) {
            return false;
        }
        if (t.tpList.size() != this.tpList.size()) {
            return false;
        }
        for (int i = 0; i < this.tpList.size(); ++i) {
            Coordinate c1 = new Coordinate((CoordinateData)this.tpList.elementAt(i));
            Coordinate c2 = new Coordinate((CoordinateData)t.tpList.elementAt(i));
            if (Math.abs(c1.latitude - c2.latitude) > 5) {
                return false;
            }
            if (Math.abs(c1.longitude - c2.longitude) <= 5) continue;
            return false;
        }
        return true;
    }

    public int getSector(int tpNo) {
        Coordinate tp = this.coordinate(tpNo);
        Coordinate next = this.coordinate((tpNo + 1) % this.size());
        if (tpNo == 0) {
            return tp.sector(next);
        }
        if (tpNo == this.size() - 1) {
            return tp.sector(this.coordinate(tpNo - 1));
        }
        return tp.sector(next, this.coordinate(tpNo - 1));
    }

    public TurnPoint getTurnpoint(int i) {
        Coordinate c = this.coordinate(i);
        return COMMON.getTurnPoints().getNearest(c);
    }

    public boolean isFai() {
        this.fai = 1;
        if (this.size() != 4) {
            this.fai = 0;
            return false;
        }
        if (!this.coordinate(0).same(this.coordinate(3))) {
            this.fai = 0;
            return false;
        }
        for (int i = 0; i < this.size() - 1; ++i) {
            if (this.length < 750.0) {
                if (!(Utils.distance(this.coordinate(i), this.coordinate(i + 1)) < this.length * 0.28)) continue;
                this.fai = 0;
                return false;
            }
            if (Utils.distance(this.coordinate(i), this.coordinate(i + 1)) < this.length * 0.25) {
                this.fai = 0;
                return false;
            }
            if (!(Utils.distance(this.coordinate(i), this.coordinate(i + 1)) > this.length * 0.45)) continue;
            this.fai = 0;
            return false;
        }
        return this.fai == 1;
    }

    public double length() {
        return this.length;
    }

    public static Task loadV3(RandomAccessFile f) throws IOException {
        Task task = new Task();
        int number = f.readInt();
        task.length = f.readDouble();
        int size = f.readInt();
        task.tpList = new Vector();
        Coordinate c = null;
        for (int i = 0; i < size; ++i) {
            TurnPoint t = TurnPoint.loadV3(f);
            c = new Coordinate(t.getLatitude(), t.getLongitude());
            task.tpList.addElement(c);
        }
        task.fai = -1;
        return task;
    }

    public void removeAllElements() {
        this.length = 0.0;
        this.fai = -1;
        this.tpList.removeAllElements();
    }

    public void removeTurnpoint() {
        if (this.tpList.size() < 1) {
            return;
        }
        this.tpList.removeElementAt(this.tpList.size() - 1);
    }

    public void setLength(double length) {
        this.length = length;
    }

    public int size() {
        return this.tpList.size();
    }
}

