/*
 * Decompiled with CFR 0.152.
 */
package glider.data;

import glider.data.Coordinate;
import glider.data.PlaneResultData;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PlaneResult
extends PlaneResultData {
    public PlaneResult() {
        this.contestNumber = null;
        this.points = 0;
        this.penaltyPoint = 0;
        this.finalPoints = 0;
        this.startTime = 0;
        this.endTime = 0;
        this.duration = 0;
        this.started = false;
        this.finished = false;
        this.distance = 0.0;
        this.disqualified = false;
        this.landingSpot = null;
        this.numberOfTurnPoints = 0;
    }

    public PlaneResult(String contestNumber) {
        this();
        this.contestNumber = contestNumber;
    }

    public void setLandingSpot(Coordinate spot) {
        this.landingSpot = spot;
    }

    public void setPenaltyPoint(int value) {
        this.penaltyPoint = value;
    }

    public String getContestNumber() {
        return this.contestNumber;
    }

    public double getDistance() {
        return this.distance;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public Coordinate getLandingSpot() {
        if (this.landingSpot == null) {
            return null;
        }
        return new Coordinate(this.landingSpot);
    }

    public int getNumberOfTurnPoints() {
        return this.numberOfTurnPoints;
    }

    public int getPenaltyPoint() {
        return this.penaltyPoint;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void removeAllElements() {
        this.landingSpot = null;
    }

    public static PlaneResult loadV3(RandomAccessFile f) throws IOException {
        PlaneResult p = new PlaneResult();
        p.contestNumber = f.readUTF();
        p.points = f.readInt();
        p.penaltyPoint = f.readInt();
        p.finalPoints = f.readInt();
        p.startTime = f.readInt();
        p.endTime = f.readInt();
        p.duration = f.readInt();
        p.started = f.readBoolean();
        p.finished = f.readBoolean();
        p.distance = f.readDouble();
        p.disqualified = f.readBoolean();
        if (p.started && !p.finished) {
            p.landingSpot = new Coordinate(0, 0);
            p.landingSpot.latitude = f.readInt();
            p.landingSpot.longitude = f.readInt();
            p.numberOfTurnPoints = f.readInt();
        } else {
            p.landingSpot = null;
            p.numberOfTurnPoints = 0;
        }
        return p;
    }
}

