/*
 * Decompiled with CFR 0.152.
 */
package glider.data;

import glider.data.PlaneData;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Plane
extends PlaneData {
    public Plane() {
        this.handicap = 100;
        this.totalPoints = 0;
        this.position = 0;
    }

    public Plane(String registration, String contestNumber, String type, String pilot, int handicap) {
        this();
        this.registration = registration;
        this.contestNumber = contestNumber;
        this.type = type;
        this.pilot = pilot;
        this.handicap = handicap;
    }

    public String getContestNumber() {
        return this.contestNumber;
    }

    public int getHandicap() {
        return this.handicap;
    }

    public String getPilot() {
        return this.pilot;
    }

    public String getRegistration() {
        return this.registration;
    }

    public String getType() {
        return this.type;
    }

    public static Plane loadV3(RandomAccessFile f) throws IOException {
        Plane p = new Plane();
        p.registration = f.readUTF();
        p.contestNumber = f.readUTF();
        p.type = f.readUTF();
        p.pilot = f.readUTF();
        p.handicap = f.readInt();
        p.totalPoints = f.readInt();
        p.position = f.readInt();
        return p;
    }

    public void setContestNumber(String value) {
        this.contestNumber = value;
    }

    public void setHandicap(int value) {
        this.handicap = value;
    }

    public void setPilot(String value) {
        this.pilot = value;
    }

    public void setRegistration(String value) {
        this.registration = value.toUpperCase();
    }

    public void setType(String value) {
        this.type = value;
    }
}

