/*
 * Decompiled with CFR 0.152.
 */
package glider.data;

import glider.GDialog;
import glider.data.TurnPoint;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Vector;

public abstract class IGCturnpoints {
    static final int MAXDESCR = 20;
    static final int MAXDETAIL = 50;
    private static final char COMMA = ',';
    private static final char TAB = '\t';
    private static final char QUOTE = '\"';
    private static String line = null;
    private static DecimalFormat dfLat = new DecimalFormat("0000.000", new DecimalFormatSymbols(Locale.ENGLISH));
    private static DecimalFormat dfLon = new DecimalFormat("00000.000", new DecimalFormatSymbols(Locale.ENGLISH));

    private static String getToken(char separator) {
        String token = null;
        if (line.charAt(0) == '\"') {
            line = line.substring(1);
            int index = line.indexOf(34);
            token = line.substring(0, index);
            line = line.substring(index + 2);
            return token;
        }
        int index = line.indexOf(separator);
        if (index < 0) {
            token = line;
            line = null;
        } else if (index < line.length()) {
            token = line.substring(0, index);
            line = line.substring(index + 1);
        }
        return token;
    }

    public static void read(BufferedReader br, Vector tpList) {
        int cnt = 0;
        String token = null;
        char separator = '?';
        try {
            while ((line = br.readLine()) != null) {
                if (cnt++ == 0 && (separator = (char)line.charAt(6)) != ',' && separator != '\t') {
                    throw new Exception("Forkert separator, 7. tegn skal v\u00e6re komma eller TAB");
                }
                TurnPoint tp = new TurnPoint();
                tp.setName(IGCturnpoints.getToken(separator));
                token = IGCturnpoints.getToken(separator);
                token = IGCturnpoints.getToken(separator);
                if (token.length() != 10 || token.charAt(2) != ' ' || token.charAt(5) != '.' || token.charAt(9) != 'N') {
                    throw new Exception("Illegal breddegrad");
                }
                token = token.substring(0, 2) + token.substring(3, 9);
                tp.setLat(token);
                token = IGCturnpoints.getToken(separator);
                if (token.length() != 11 || token.charAt(3) != ' ' || token.charAt(6) != '.' || token.charAt(10) != 'E') {
                    throw new Exception("Illegal l\u00e6ngdegrad");
                }
                token = token.substring(0, 3) + token.substring(4, 10);
                tp.setLon(token);
                tp.setDescription(IGCturnpoints.getToken(separator));
                tp.setDetail(IGCturnpoints.getToken(separator));
                String date = IGCturnpoints.getToken(separator);
                token = IGCturnpoints.getToken(separator);
                token = IGCturnpoints.getToken(separator);
                if (token.indexOf(76) >= 0) {
                    tp.setLandable(true);
                }
                for (int i = 0; i < 9; ++i) {
                    token = IGCturnpoints.getToken(separator);
                }
                tp.setNumber(Integer.parseInt(token));
                tp.setDate(date);
                tpList.addElement(tp);
            }
        }
        catch (Exception e) {
            GDialog.error(null, "Fejl i linie " + cnt + ":\n" + line + "\n" + e.getMessage());
        }
    }

    public static void write(BufferedWriter bw, TurnPoint tp) throws IOException {
        IGCturnpoints.writeFirstToken(bw, tp.getName());
        IGCturnpoints.writeToken(bw, "DK");
        String tmp = dfLat.format((double)tp.getLatitude() / 1000.0);
        tmp = tmp.substring(0, 2) + " " + tmp.substring(2) + "N";
        IGCturnpoints.writeToken(bw, tmp);
        tmp = dfLon.format((double)tp.getLongitude() / 1000.0);
        tmp = tmp.substring(0, 3) + " " + tmp.substring(3) + "E";
        IGCturnpoints.writeToken(bw, tmp);
        IGCturnpoints.writeToken(bw, (String)tp.getDescription());
        IGCturnpoints.writeToken(bw, (String)tp.getDetail());
        IGCturnpoints.writeToken(bw, (String)tp.getDate());
        IGCturnpoints.writeToken(bw, "");
        if (tp.isLandable()) {
            IGCturnpoints.writeToken(bw, "L");
        } else {
            IGCturnpoints.writeToken(bw, "");
        }
        IGCturnpoints.writeToken(bw, "");
        IGCturnpoints.writeToken(bw, "");
        IGCturnpoints.writeToken(bw, "");
        IGCturnpoints.writeToken(bw, "");
        IGCturnpoints.writeToken(bw, "");
        IGCturnpoints.writeToken(bw, "");
        IGCturnpoints.writeToken(bw, "");
        IGCturnpoints.writeToken(bw, "");
        IGCturnpoints.writeToken(bw, ((Integer)tp.getNumber()).toString());
        bw.newLine();
    }

    private static void writeFirstToken(BufferedWriter bw, String token) throws IOException {
        if (token.indexOf(44) >= 0) {
            bw.write("\"" + token + "\"");
        } else {
            bw.write(token);
        }
    }

    private static void writeToken(BufferedWriter bw, String token) throws IOException {
        bw.write(44);
        IGCturnpoints.writeFirstToken(bw, token);
    }
}

