/*
 * Decompiled with CFR 0.152.
 */
package glider.data;

import glider.data.DayResultData;
import glider.data.Plane;
import glider.data.PlaneResult;
import glider.data.Task;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class DayResult
extends DayResultData {
    public DayResult() {
        this.planeResultList = new Vector();
        this.date = new SimpleDateFormat("ddMMyy").format(new Date());
    }

    public DayResult(String contestNumber) {
        this();
        this.planeResultList.addElement(new PlaneResult(contestNumber));
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setPlaneResultList(Vector newValue) {
        this.planeResultList = newValue;
    }

    public void setTask(Task newValue) {
        this.task = newValue;
    }

    public String getDate() {
        return this.date;
    }

    public Vector getPlaneResultList() {
        return this.planeResultList;
    }

    public Task getTask() {
        return this.task;
    }

    public void removeAllElements() {
        this.task = null;
        for (int i = 0; i < this.planeResultList.size(); ++i) {
            PlaneResult p = (PlaneResult)this.planeResultList.elementAt(i);
            p.removeAllElements();
        }
        this.planeResultList.removeAllElements();
    }

    public void removeElement(Plane plane) {
        for (int i = 0; i < this.planeResultList.size(); ++i) {
            PlaneResult p = (PlaneResult)this.planeResultList.elementAt(i);
            if (!p.contestNumber.equals(plane.contestNumber)) continue;
            this.planeResultList.removeElementAt(i);
        }
    }

    public static DayResult loadV3(RandomAccessFile f) throws IOException {
        DayResult dayResult = new DayResult();
        dayResult.task = Task.loadV3(f);
        int size = f.readInt();
        for (int i = 0; i < size; ++i) {
            PlaneResult planeResult = PlaneResult.loadV3(f);
            dayResult.planeResultList.addElement(planeResult);
        }
        return dayResult;
    }
}

