/*
 * Decompiled with CFR 0.152.
 */
package glider.data;

import glider.data.CoordinateData;
import glider.utils.Utils;
import java.awt.Point;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Coordinate
extends CoordinateData {
    public Coordinate(int latitude, int longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Coordinate(int x, int y, Point origin, int reduction) {
        int X = (x - origin.x) * reduction;
        int Y = (y - origin.y) * reduction;
        int deltaY = (1760 - Math.abs(1760 - x)) / 80;
        X = (int)((double)X + (double)(Y -= deltaY) / 70.0);
        Y = (int)((double)Y + (double)X / 50.0);
        X = (int)((double)X * (100000.0 / (702.0 + (double)Y * 0.014)));
        Y = (int)((double)Y * 76.5696784073507);
        Y = Y / 100000 * 100000 + Y % 100000 * 6 / 10;
        X = X / 100000 * 100000 + X % 100000 * 6 / 10;
        Coordinate newCoord = new Coordinate(5747300, 759000);
        newCoord.add(-Y, X);
        this.latitude = newCoord.latitude;
        this.longitude = newCoord.longitude;
    }

    public Coordinate(CoordinateData data) {
        this.longitude = data.longitude;
        this.latitude = data.latitude;
    }

    public void setLatitude(int lat) {
        this.latitude = lat;
    }

    public void setLongitude(int lon) {
        this.longitude = lon;
    }

    public int getLatitude() {
        return this.latitude;
    }

    public int getLongitude() {
        return this.longitude;
    }

    public void add(int lat, int lon) {
        int high = this.latitude / 100000 + lat / 100000;
        int low = this.latitude % 100000 + lat % 100000;
        while (low < 0) {
            low += 60000;
            --high;
        }
        while (low >= 60000) {
            low -= 60000;
            ++high;
        }
        this.latitude = high * 100000 + low;
        high = this.longitude / 100000 + lon / 100000;
        low = this.longitude % 100000 + lon % 100000;
        while (low < 0) {
            low += 60000;
            --high;
        }
        while (low >= 60000) {
            low -= 60000;
            ++high;
        }
        this.longitude = high * 100000 + low;
    }

    public double lat2double() {
        return (double)((int)((double)this.latitude / 100000.0)) + (double)this.latitude % 100000.0 / 60000.0;
    }

    public Point latlong2xy(int reduction) {
        Coordinate orig = new Coordinate(5747300, 759000);
        double yScale = 1306.0;
        int y = (int)((orig.lat2double() - this.lat2double()) * yScale);
        double xScale = 702.0 + (double)y * 0.014;
        int x = (int)((this.lon2double() - orig.lon2double()) * xScale);
        y -= x / 50;
        int deltaY = (1760 - Math.abs(1760 - (x -= y / 70))) / 80;
        return new Point(x / reduction, (y += deltaY) / reduction);
    }

    public double lon2double() {
        return (double)((int)((double)this.longitude / 100000.0)) + (double)this.longitude % 100000.0 / 60000.0;
    }

    public double rad(double arc) {
        return ((double)((int)(arc / 10000.0)) + arc % 10000.0 / 6000.0) * Math.PI / 180.0;
    }

    public boolean same(Coordinate c) {
        return c.latitude == this.latitude && c.longitude == this.longitude;
    }

    public int sector(Coordinate coord1, Coordinate coord2) {
        double head = (Utils.heading(this, coord1) + Utils.heading(this, coord2)) / 2.0;
        head = Math.abs(Utils.heading(this, coord1) - Utils.heading(this, coord2)) < 180.0 ? (head += 180.0) : (head += 360.0);
        head %= 360.0;
        head = head * 12.0 / 360.0;
        int heading = (int)Math.round(head);
        if (heading == 0) {
            heading = 12;
        }
        return heading;
    }

    public int sector(Coordinate coordinate) {
        return this.sector(coordinate, coordinate);
    }

    public String show() {
        return this.longitude / 10 + "E " + this.latitude / 10 + "N";
    }

    public Coordinate toDecimal() {
        int lat = (int)Math.round((double)(this.latitude / 1000 * 1000) + (double)(this.latitude % 1000) * 10.0 / 6.0);
        int lon = (int)Math.round((double)(this.longitude / 1000 * 1000) + (double)(this.longitude % 1000) * 10.0 / 6.0);
        return new Coordinate(lon, lat);
    }

    public Coordinate toSeconds() {
        int lat = (int)Math.round((double)(this.latitude / 1000 * 1000) + (double)(this.latitude % 1000) * 6.0 / 10.0);
        int lon = (int)Math.round((double)(this.longitude / 1000 * 1000) + (double)(this.longitude % 1000) * 6.0 / 10.0);
        return new Coordinate(lat, lon);
    }

    public static Coordinate loadV3(RandomAccessFile f) throws IOException {
        return new Coordinate(10 * f.readInt(), 10 * f.readInt());
    }
}

