/*
 * Decompiled with CFR 0.152.
 */
package glider.data;

import glider.COMMON;
import glider.data.ContestClassData;
import glider.data.DayResult;
import glider.data.Plane;
import glider.data.PlaneResult;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class ContestClass
extends ContestClassData {
    public ContestClass() {
        this.planeList = new Vector();
        this.dayResultList = new Vector();
    }

    public ContestClass(ContestClassData cd) {
        this.name = cd.name;
        this.planeList = cd.planeList;
        this.dayResultList = cd.dayResultList;
    }

    public ContestClass(String name) {
        this();
        this.name = name;
    }

    public DayResult getDayResult(int day0) {
        if (day0 >= this.dayResultList.size()) {
            return null;
        }
        return (DayResult)this.dayResultList.elementAt(day0);
    }

    public int getHandicap(String contestNumber) {
        for (int i = 0; i < this.planeList.size(); ++i) {
            Plane p = (Plane)this.planeList.elementAt(i);
            if (!p.contestNumber.equals(contestNumber)) continue;
            return p.handicap;
        }
        return 100;
    }

    public String getName() {
        return this.name;
    }

    public String getPilot(String contestNumber) {
        for (int i = 0; i < this.planeList.size(); ++i) {
            Plane p = (Plane)this.planeList.elementAt(i);
            if (!p.contestNumber.equals(contestNumber)) continue;
            return p.pilot;
        }
        return "Ukendt pilot";
    }

    public Plane getPlane(int number) {
        if (this.planeList.size() > number) {
            return (Plane)this.planeList.elementAt(number);
        }
        return null;
    }

    public Plane getPlane(String id) {
        Plane plane = null;
        for (int l = 0; l < this.planeList.size(); ++l) {
            Plane p = (Plane)this.planeList.elementAt(l);
            if (p == null) continue;
            if (p.contestNumber.equals(id)) {
                plane = p;
                break;
            }
            if (!p.registration.equals(id)) continue;
            plane = p;
            break;
        }
        return plane;
    }

    public DayResult getResult(int i) {
        if (this.dayResultList.size() > i) {
            return (DayResult)this.dayResultList.elementAt(i);
        }
        return null;
    }

    public int getResults() {
        return this.dayResultList.size();
    }

    public boolean isMember(String number) {
        for (int i = 0; i < this.planeList.size(); ++i) {
            Plane pl = (Plane)this.planeList.elementAt(i);
            if (pl.registration.equals(number)) {
                return true;
            }
            if (!pl.contestNumber.equals(number)) continue;
            return true;
        }
        return false;
    }

    public boolean addPlane(Plane newPlane) {
        if (this.isMember(newPlane.registration)) {
            return false;
        }
        this.planeList.addElement(newPlane);
        if (this.dayResultList.size() == 0) {
            this.dayResultList.addElement(new DayResult(newPlane.contestNumber));
        } else {
            for (int i = 0; i < this.dayResultList.size(); ++i) {
                DayResult dr = (DayResult)this.dayResultList.elementAt(i);
                dr.getPlaneResultList().addElement(new PlaneResult(newPlane.contestNumber));
            }
        }
        return true;
    }

    public void addResult(DayResult dayResult) {
        this.dayResultList.addElement(dayResult);
    }

    public void calculateClass() {
        for (int j = 0; j < this.planeList.size(); ++j) {
            Plane p = (Plane)this.planeList.elementAt(j);
            int total = 0;
            for (int k = 0; k <= COMMON.currentDay.getSelectedIndex(); ++k) {
                DayResult dr = (DayResult)this.dayResultList.elementAt(k);
                for (int l = 0; l < dr.getPlaneResultList().size(); ++l) {
                    PlaneResult pr = (PlaneResult)dr.getPlaneResultList().elementAt(l);
                    if (!pr.contestNumber.equals(p.contestNumber)) continue;
                    total += pr.finalPoints;
                }
            }
            p.totalPoints = total;
        }
    }

    public boolean changePlane(Plane plane) {
        for (int j = 0; j < this.planeList.size(); ++j) {
            Plane pl = (Plane)this.planeList.elementAt(j);
            if (!pl.registration.equals(plane.registration)) continue;
            pl.contestNumber = plane.contestNumber;
            pl.handicap = plane.handicap;
            pl.pilot = plane.pilot;
            return true;
        }
        return false;
    }

    public boolean changePlaneRegistration(Plane plane) {
        for (int j = 0; j < this.planeList.size(); ++j) {
            Plane pl = (Plane)this.planeList.elementAt(j);
            if (!pl.contestNumber.equals(plane.contestNumber)) continue;
            pl.handicap = plane.handicap;
            pl.pilot = plane.pilot;
            pl.registration = plane.registration;
            return true;
        }
        return false;
    }

    public int dayCount() {
        return this.dayResultList.size();
    }

    public int planeCount() {
        return this.planeList.size();
    }

    public void removeAllElements() {
        this.planeList.removeAllElements();
        for (int i = 0; i < this.dayResultList.size(); ++i) {
            ((DayResult)this.dayResultList.elementAt(i)).removeAllElements();
        }
        this.dayResultList.removeAllElements();
    }

    public boolean removePlane(Plane oldPlane) {
        if (oldPlane == null) {
            return false;
        }
        if (!this.isMember(oldPlane.contestNumber)) {
            return false;
        }
        this.planeList.removeElement(oldPlane);
        for (int i = 0; i < this.dayResultList.size(); ++i) {
            ((DayResult)this.dayResultList.elementAt(i)).removeElement(oldPlane);
        }
        return true;
    }

    public boolean removePlane(String contestNumber) {
        return this.removePlane(this.getPlane(contestNumber));
    }

    public boolean sort() {
        boolean modified = false;
        for (int j = 0; j < this.dayResultList.size(); ++j) {
            DayResult d = (DayResult)this.dayResultList.elementAt(j);
            boolean sorted = false;
            while (!sorted) {
                sorted = true;
                for (int k = 0; k < d.getPlaneResultList().size() - 1; ++k) {
                    Vector list = d.getPlaneResultList();
                    PlaneResult pr = (PlaneResult)list.elementAt(k);
                    PlaneResult pr2 = (PlaneResult)list.elementAt(k + 1);
                    if (pr.finalPoints >= pr2.finalPoints) continue;
                    list.insertElementAt(list.elementAt(k + 1), k);
                    list.removeElementAt(k + 2);
                    sorted = false;
                    modified = true;
                }
            }
        }
        boolean sorted = false;
        while (!sorted) {
            sorted = true;
            for (int j = 0; j < this.planeList.size() - 1; ++j) {
                Vector list = this.planeList;
                Plane p = (Plane)list.elementAt(j);
                Plane p2 = (Plane)list.elementAt(j + 1);
                if (p.totalPoints >= p2.totalPoints) continue;
                list.insertElementAt(list.elementAt(j + 1), j);
                list.removeElementAt(j + 2);
                sorted = false;
                modified = true;
            }
        }
        int position = 0;
        int lastPoints = -1;
        for (int j = 0; j < this.planeList.size(); ++j) {
            Plane p = (Plane)this.planeList.elementAt(j);
            if (p.totalPoints != lastPoints) {
                // empty if block
            }
            p.position = ++position;
            lastPoints = p.totalPoints;
        }
        return modified;
    }

    public static ContestClass loadV3(RandomAccessFile f) throws IOException {
        int i;
        ContestClassData contestClassData = new ContestClassData();
        contestClassData.name = f.readUTF();
        contestClassData.dayResultList = new Vector();
        contestClassData.planeList = new Vector();
        int size = f.readInt();
        for (i = 0; i < size; ++i) {
            Plane plane = Plane.loadV3(f);
            contestClassData.planeList.addElement(plane);
        }
        size = f.readInt();
        for (i = 0; i < size; ++i) {
            DayResult dayResult = DayResult.loadV3(f);
            contestClassData.dayResultList.addElement(dayResult);
        }
        return new ContestClass(contestClassData);
    }
}

