/*
 * Decompiled with CFR 0.152.
 */
package glider.data;

import glider.COMMON;
import glider.Day;
import glider.GDialog;
import glider.Home;
import glider.Out;
import glider.Sample;
import glider.Track;
import glider.data.ContestChangeListener;
import glider.data.ContestClass;
import glider.data.ContestClassData;
import glider.data.ContestData;
import glider.data.Coordinate;
import glider.data.DayResult;
import glider.data.Plane;
import glider.data.PlaneResult;
import glider.data.Task;
import glider.data.TurnPoint;
import glider.data.TurnPoints;
import glider.utils.Utils;
import java.awt.Point;
import java.awt.Polygon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import splash.Version;

public class Contest {
    private ContestData data;
    Vector<ContestChangeListener> listeners = new Vector();
    private boolean modified = false;
    private Task rememberedTask = null;
    private static Contest instance = new Contest();

    protected Contest() {
        this.data = new ContestData();
        this.data.contestClassList = new Vector();
        this.data.dmRules = false;
        this.data.minDistance = 100.0;
        this.data.Pm2Const = 5.0;
        this.data.Pm3Const = 400.0;
    }

    public void setDisqualified() {
        PlaneResult p = this.getPlaneResult();
        if (p != null) {
            p.disqualified = true;
            this.setModified();
        }
    }

    public void setDmRules(boolean value) {
        this.data.dmRules = value;
        this.setModified();
    }

    public void setMinDistance(double minDistance) {
        this.data.minDistance = minDistance;
        this.setModified();
    }

    private void setModified() {
        this.modified = true;
        this.fireChange();
    }

    public void setName(String newName) {
        this.data.name = newName;
    }

    public void setPenaltyPoint(int penalty) {
        PlaneResult p = this.getPlaneResult();
        if (p != null) {
            p.penaltyPoint = penalty;
            this.setModified();
        }
    }

    public void setPm2(double newValue) {
        this.data.Pm2Const = newValue;
    }

    public void setPm3(double newValue) {
        this.data.Pm3Const = newValue;
    }

    public void setTask(Task task) {
        ContestClass c = this.getCurrentClass();
        if (c != null) {
            if (c.getResults() == 0) {
                c.addResult(new DayResult());
            }
            DayResult d = c.getDayResult(COMMON.currentDay.getSelectedIndex());
            d.setTask(task);
            this.setModified();
        }
    }

    public ContestClass getContestClass(int i) {
        if (this.data.contestClassList.size() > i) {
            return new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i));
        }
        return null;
    }

    public ContestClass getContestClass(String number) {
        Vector cl = this.data.contestClassList;
        for (int i = 0; i < cl.size(); ++i) {
            ContestClass c = new ContestClass((ContestClassData)cl.elementAt(i));
            if (!c.isMember(number)) continue;
            return c;
        }
        return null;
    }

    public ContestClass getCurrentClass() {
        if (this.getCurrentClassName() == null) {
            return null;
        }
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            ContestClassData c = (ContestClassData)this.data.contestClassList.elementAt(i);
            if (!c.name.equals(this.getCurrentClassName())) continue;
            return new ContestClass(c);
        }
        return null;
    }

    public String getCurrentClassName() {
        if (COMMON.currentClassBox != null && COMMON.currentClassBox.getItemCount() > 0) {
            return (String)COMMON.currentClassBox.getSelectedItem();
        }
        return null;
    }

    public DayResult getDayResult() {
        if (COMMON.currentDay == null || COMMON.currentDay.getSelectedIndex() < 0) {
            return null;
        }
        return this.getDayResult(COMMON.currentDay.getSelectedIndex());
    }

    public DayResult getDayResult(int day0) {
        if (this.getCurrentClass() != null) {
            return this.getCurrentClass().getDayResult(day0);
        }
        return null;
    }

    public boolean getDmRules() {
        return this.data.dmRules;
    }

    public double getLength() {
        ContestClass c = this.getCurrentClass();
        if (c != null) {
            return c.getDayResult(COMMON.currentDay.getSelectedIndex()).getTask().length();
        }
        return 0.0;
    }

    public int getMaxpoints() {
        return this.getMaxpoints(COMMON.currentDay.getSelectedIndex());
    }

    public int getMaxpoints(int day0) {
        int maxpoints = 0;
        Vector planeResultList = this.getDayResult(day0).getPlaneResultList();
        for (int i = 0; i < planeResultList.size(); ++i) {
            PlaneResult p = (PlaneResult)planeResultList.elementAt(i);
            if (p.points <= maxpoints) continue;
            maxpoints = p.points;
        }
        return maxpoints;
    }

    public double getMinDistance() {
        return this.data.minDistance;
    }

    public String getName() {
        return this.data.name;
    }

    public int getPenaltyPoint() {
        PlaneResult p = this.getPlaneResult();
        if (p != null) {
            return p.penaltyPoint;
        }
        return 0;
    }

    public String getPilot(ContestClass contestClass, String contestNumber) {
        return contestClass.getPilot(contestNumber);
    }

    public Plane getPlane() {
        ContestClass c = this.getCurrentClass();
        if (c == null) {
            return null;
        }
        return this.getCurrentClass().getPlane((String)COMMON.currentContestNumber.getSelectedItem());
    }

    public Plane getPlane(String id) {
        Vector cl = this.data.contestClassList;
        for (int i = 0; i < cl.size(); ++i) {
            ContestClass c = new ContestClass((ContestClassData)cl.elementAt(i));
            Plane plane = c.getPlane(id);
            if (plane == null) continue;
            return plane;
        }
        return null;
    }

    public PlaneResult getPlaneResult() {
        try {
            PlaneResult p;
            Vector l = this.getDayResult().getPlaneResultList();
            if (l == null) {
                return null;
            }
            for (int i = 0; i < l.size(); ++i) {
                p = (PlaneResult)l.elementAt(i);
                if (!p.contestNumber.equals(COMMON.currentContestNumber.getSelectedItem())) continue;
                return p;
            }
            p = new PlaneResult((String)COMMON.currentContestNumber.getSelectedItem());
            l.addElement(p);
            return p;
        }
        catch (Exception e) {
            return null;
        }
    }

    public double getPm2() {
        return this.data.Pm2Const;
    }

    public double getPm3() {
        return this.data.Pm3Const;
    }

    public int getPoints() {
        PlaneResult p = this.getPlaneResult();
        if (p != null) {
            return p.points;
        }
        return 0;
    }

    public String getRegistration() {
        Plane p = this.getPlane();
        if (p != null) {
            return p.registration;
        }
        return "";
    }

    public Task getTask() {
        ContestClass c = this.getCurrentClass();
        if (c == null) {
            return null;
        }
        return c.getDayResult(COMMON.currentDay.getSelectedIndex()).getTask();
    }

    public boolean isClass(String name) {
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            ContestClassData c = (ContestClassData)this.data.contestClassList.elementAt(i);
            if (!name.equals(c.name)) continue;
            return true;
        }
        return false;
    }

    public boolean isDefined() {
        return this.data.name != null && this.data.contestClassList != null && this.data.contestClassList.size() >= 1;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isPlaneAdded() {
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            ContestClass c = new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i));
            if (c.getPlane(0) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isTaskDefined() {
        try {
            ContestClass c = this.getCurrentClass();
            if (c == null) {
                return false;
            }
            if (c.getResults() < 1) {
                return false;
            }
            DayResult d = c.getDayResult(COMMON.currentDay.getSelectedIndex());
            return d.getTask() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void addClass(String name) {
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            ContestClassData c = (ContestClassData)this.data.contestClassList.elementAt(i);
            if (!name.equals(c.name)) continue;
            return;
        }
        Vector dayResultList = this.getContestClass((int)0).dayResultList;
        ContestClassData ccd = new ContestClassData();
        ccd.name = name;
        ccd.dayResultList = new Vector();
        for (int i = 0; i < dayResultList.size(); ++i) {
            DayResult oldDayResult = (DayResult)dayResultList.elementAt(i);
            DayResult newDayResult = new DayResult();
            newDayResult.setDate(oldDayResult.getDate());
            ccd.dayResultList.add(newDayResult);
        }
        ccd.planeList = new Vector();
        this.data.contestClassList.addElement(ccd);
        this.setModified();
        this.fireClassAddRemove();
    }

    public void addListener(ContestChangeListener listener) {
        this.listeners.addElement(listener);
    }

    public void addPlane(JFrame parent, Plane plane) {
        if (this.getCurrentClass().addPlane(plane)) {
            this.setModified();
        } else {
            GDialog.error(parent, plane.contestNumber + " findes allerede i " + this.data.name + " klassen");
        }
    }

    public void addPlane(JFrame parent, String registration, String contestNumber, String type, String pilot, String handicap) {
        Plane plane = new Plane(registration, contestNumber, type, pilot, Integer.parseInt(handicap));
        if (this.getCurrentClass().addPlane(plane)) {
            this.setModified();
        } else {
            GDialog.error(parent, contestNumber + " findes allerede i " + this.data.name + " klassen");
        }
    }

    private int getFirstStartPassage(Task task, Vector samples) {
        TurnPoint startP = task.getTurnpoint(0);
        TurnPoint firstTp = task.getTurnpoint(1);
        Coordinate coordStart = new Coordinate(startP.getLatitude(), startP.getLongitude());
        Coordinate coordFirst = new Coordinate(firstTp.getLatitude(), firstTp.getLongitude());
        double heading = Utils.heading(coordStart, coordFirst);
        heading = heading * Math.PI / 180.0;
        double p0x = Utils.latlong2x(coordStart);
        double p0y = Utils.latlong2y(coordStart);
        int WIDTH = 5;
        Point startLineP1 = new Point((int)Math.round(p0x + Math.cos(heading) * Utils.get1km() * (double)WIDTH), (int)Math.round(p0y + Math.sin(heading) * Utils.get1km() * (double)WIDTH));
        Point startLineP2 = new Point((int)Math.round(p0x - Math.cos(heading) * Utils.get1km() * (double)WIDTH), (int)Math.round(p0y - Math.sin(heading) * Utils.get1km() * (double)WIDTH));
        Point startLineP3 = new Point((int)Math.round(p0x - (Math.cos(heading) + Math.cos(heading - 1.5707963267948966)) * Utils.get1km() * (double)WIDTH), (int)Math.round(p0y - (Math.sin(heading) + Math.sin(heading - 1.5707963267948966)) * Utils.get1km() * (double)WIDTH));
        Point startLineP4 = new Point((int)Math.round(p0x + (Math.cos(heading) - Math.cos(heading - 1.5707963267948966)) * Utils.get1km() * (double)WIDTH), (int)Math.round(p0y + (Math.sin(heading) - Math.sin(heading - 1.5707963267948966)) * Utils.get1km() * (double)WIDTH));
        Polygon okStartPoly = new Polygon();
        okStartPoly.addPoint(startLineP1.x, startLineP1.y);
        okStartPoly.addPoint(startLineP2.x, startLineP2.y);
        okStartPoly.addPoint(startLineP3.x, startLineP3.y);
        okStartPoly.addPoint(startLineP4.x, startLineP4.y);
        startLineP3 = new Point((int)Math.round(p0x - (Math.cos(heading) + Math.cos(heading + 1.5707963267948966)) * Utils.get1km() * (double)WIDTH), (int)Math.round(p0y - (Math.sin(heading) + Math.sin(heading + 1.5707963267948966)) * Utils.get1km() * (double)WIDTH));
        startLineP4 = new Point((int)Math.round(p0x + (Math.cos(heading) - Math.cos(heading + 1.5707963267948966)) * Utils.get1km() * (double)WIDTH), (int)Math.round(p0y + (Math.sin(heading) - Math.sin(heading + 1.5707963267948966)) * Utils.get1km() * (double)WIDTH));
        Polygon startedPoly = new Polygon();
        startedPoly.addPoint(startLineP1.x, startLineP1.y);
        startedPoly.addPoint(startLineP2.x, startLineP2.y);
        startedPoly.addPoint(startLineP3.x, startLineP3.y);
        startedPoly.addPoint(startLineP4.x, startLineP4.y);
        for (int i = 0; i < samples.size() - 1; ++i) {
            Sample sample = (Sample)samples.elementAt(i);
            Coordinate coord = new Coordinate(sample.lat, sample.lon);
            Point p = coord.latlong2xy(1);
            if (!okStartPoly.contains(p)) continue;
            sample = (Sample)samples.elementAt(i + 1);
            coord = new Coordinate(sample.lat, sample.lon);
            p = coord.latlong2xy(1);
            if (!startedPoly.contains(p)) continue;
            return i;
        }
        return -1;
    }

    public double latlong2x(Coordinate coord) {
        Coordinate orig = new Coordinate(5747300, 759000);
        double yScale = 1306.0;
        double y = (orig.lat2double() - coord.lat2double()) * yScale;
        double xScale = 702.0 + y * 0.014;
        double x = (coord.lon2double() - orig.lon2double()) * xScale;
        y -= x / 50.0;
        return x -= y / 70.0;
    }

    public double latlong2y(Coordinate coord) {
        Coordinate orig = new Coordinate(5747300, 759000);
        double yScale = 1306.0;
        double y = (orig.lat2double() - coord.lat2double()) * yScale;
        double xScale = 702.0 + y * 0.014;
        double x = (coord.lon2double() - orig.lon2double()) * xScale;
        y -= x / 50.0;
        int deltaY = (int)((1760.0 - Math.abs(1760.0 - (x -= y / 70.0))) / 80.0);
        return y += (double)deltaY;
    }

    private int getStart(Task task, Vector samples, int index) {
        double heading = Utils.heading(task.coordinate(0), task.coordinate(1)) / 180.0 * Math.PI;
        double p0x = this.latlong2x(task.coordinate(0));
        double p0y = this.latlong2y(task.coordinate(0));
        double x1 = p0x + Math.cos(heading) * Utils.get1km() * 5.0;
        double y1 = p0y + Math.sin(heading) * Utils.get1km() * 5.0;
        double x2 = p0x - Math.cos(heading) * Utils.get1km() * 5.0;
        double y2 = p0y - Math.sin(heading) * Utils.get1km() * 5.0;
        double b1 = (x2 * y1 - x1 * y2) / (x2 - x1);
        double m1 = (y2 - y1) / (x2 - x1);
        while (index > 0) {
            double y;
            double x;
            Sample sample = (Sample)samples.elementAt(index--);
            Sample prev = (Sample)samples.elementAt(index);
            Coordinate coord = new Coordinate(sample.lat, sample.lon);
            Coordinate prevCoord = new Coordinate(prev.lat, prev.lon);
            double x3 = this.latlong2x(prevCoord);
            double y3 = this.latlong2y(prevCoord);
            double x4 = this.latlong2x(coord);
            double y4 = this.latlong2y(coord);
            if (x3 != x4) {
                double b2 = (x4 * y3 - x3 * y4) / (x4 - x3);
                double m2 = (y4 - y3) / (x4 - x3);
                if (m1 == m2) continue;
                x = (b1 - b2) / (m2 - m1);
                y = m1 * (b1 - b2) / (m2 - m1) + b1;
            } else {
                x = x3;
                y = m1 * x3 + b1;
            }
            if (!(x3 <= x4 && x3 <= x && x <= x4) && (!(x3 >= x4) || !(x3 >= x) || !(x >= x4)) || !(y3 <= y4 && y3 <= y && y <= y4) && (!(y3 >= y4) || !(y3 >= y) || !(y >= y4))) continue;
            double xdiff = Math.abs(x4 - x3);
            double ydiff = Math.abs(y4 - y3);
            double fact = 0.0;
            fact = xdiff > ydiff ? Math.abs((x3 - x) / xdiff) : Math.abs((y3 - y) / ydiff);
            try {
                long t1 = Utils.sdf.parse(prev.time).getTime();
                long t2 = Utils.sdf.parse(sample.time).getTime();
                long startTime = (long)((double)t1 + (double)(t2 - t1) * fact);
                startTime -= Utils.sdf.parse("000000").getTime();
                startTime = Math.round((double)startTime / 1000.0);
                return (int)(startTime += (long)(COMMON.config.UTC2local * 3600));
            }
            catch (Exception exception) {
            }
        }
        return -1;
    }

    private int getFinish(Task task, Vector samples, int index) {
        double heading = Utils.heading(task.coordinate(task.size() - 2), task.coordinate(task.size() - 1)) / 180.0 * Math.PI;
        Point p0 = task.coordinate(task.size() - 1).latlong2xy(1);
        Point p1 = new Point(p0.x + (int)Math.round(Math.cos(heading) * Utils.get1km() * 5.0), p0.y + (int)Math.round(Math.sin(heading) * Utils.get1km() * 5.0));
        Point p2 = new Point(p0.x - (int)Math.round(Math.cos(heading) * Utils.get1km() * 5.0), p0.y - (int)Math.round(Math.sin(heading) * Utils.get1km() * 5.0));
        int x1 = p1.x;
        int y1 = p1.y;
        int x2 = p2.x;
        int y2 = p2.y;
        double b1 = (double)(x2 * y1 - x1 * y2) / (double)(x2 - x1);
        double m1 = (double)(y2 - y1) / (double)(x2 - x1);
        while (index < samples.size() - 1) {
            Sample sample = (Sample)samples.elementAt(index++);
            Sample next = (Sample)samples.elementAt(index);
            Coordinate coord = new Coordinate(sample.lat, sample.lon);
            Coordinate nextCoord = new Coordinate(next.lat, next.lon);
            Point p3 = coord.latlong2xy(1);
            Point p4 = nextCoord.latlong2xy(1);
            int x3 = p3.x;
            int y3 = p3.y;
            int x4 = p4.x;
            int y4 = p4.y;
            double x = 0.0;
            double y = 0.0;
            if (x3 != x4) {
                double b2 = (double)(x4 * y3 - x3 * y4) / (double)(x4 - x3);
                double m2 = (double)(y4 - y3) / (double)(x4 - x3);
                if (m1 == m2) continue;
                x = (b1 - b2) / (m2 - m1);
                y = m1 * (b1 - b2) / (m2 - m1) + b1;
            } else {
                x = x3;
                y = m1 * (double)x3 + b1;
            }
            if (!(x3 <= x4 && (double)x3 <= x && x <= (double)x4) && (x3 < x4 || !((double)x3 >= x) || !(x >= (double)x4)) || !(y3 <= y4 && (double)y3 <= y && y <= (double)y4) && (y3 < y4 || !((double)y3 >= y) || !(y >= (double)y4))) continue;
            try {
                long finishTime = ((Utils.sdf.parse(sample.time).getTime() + Utils.sdf.parse(next.time).getTime()) / 2L - Utils.sdf.parse("000000").getTime()) / 1000L;
                return (int)(finishTime += (long)(COMMON.config.UTC2local * 3600));
            }
            catch (Exception exception) {
            }
        }
        return -1;
    }

    private int findFinishSampleIndex(int index, Vector<Integer> sequence, int[] correctSequence, Vector sequenceSampleIndex) {
        for (int i = 1; i < correctSequence.length; ++i) {
            int expected = correctSequence[i];
            while (sequence.elementAt(index) != expected) {
                if (++index < sequence.size()) continue;
                return -1;
            }
        }
        return index;
    }

    private long findElapsed(String start, String finish) {
        long startTime = 0L;
        long endTime = 0L;
        try {
            startTime = Utils.sdf.parse(start).getTime();
            endTime = Utils.sdf.parse(finish).getTime();
        }
        catch (Exception ex) {
            return Long.MAX_VALUE;
        }
        return endTime - startTime;
    }

    private Coordinate[] getCoords(Task task) {
        Coordinate[] coords = new Coordinate[task.size()];
        for (int i = 0; i < task.size(); ++i) {
            coords[i] = new Coordinate(task.getTurnpoint(i).getCoordinate());
        }
        return coords;
    }

    private int[] getCorrectSequence(Task task) {
        int[] correctSequence = new int[task.size()];
        block0: for (int i = 0; i < task.size(); ++i) {
            correctSequence[i] = i;
            for (int j = 0; j < i; ++j) {
                if (task.getTurnpoint(j).getName() != task.getTurnpoint(i).getName()) continue;
                correctSequence[i] = j;
                continue block0;
            }
        }
        return correctSequence;
    }

    private void getBestSequence(Vector<Integer> sequence, Vector<Integer> sequenceSampleIndex, Vector samples, Coordinate[] coords, double tpDistance, int startIndex) {
        block0: for (int i = startIndex; i < samples.size(); ++i) {
            Sample s = (Sample)samples.elementAt(i);
            Coordinate coord = new Coordinate(s.lat, s.lon);
            for (int j = 0; j < coords.length; ++j) {
                if (!(Utils.distance(coords[j], coord) <= tpDistance)) continue;
                if (sequence.size() != 0 && sequence.lastElement() == j) continue block0;
                sequence.addElement(new Integer(j));
                sequenceSampleIndex.addElement(new Integer(i));
                continue block0;
            }
        }
    }

    private double getReducedDistance(int numPoints, Coordinate coord) {
        double d;
        Coordinate t2;
        Coordinate t1;
        double reducedDistance = 0.0;
        Task t = COMMON.getCurrentTask();
        for (int i = 0; i < numPoints; ++i) {
            t1 = t.coordinate(i);
            t2 = t.coordinate(i + 1);
            d = Utils.distance(t1, t2);
            reducedDistance += d;
        }
        t1 = t.coordinate(numPoints);
        d = Utils.distance(t1, t2 = t.coordinate(numPoints + 1)) - Utils.distance(coord, t2);
        if (d > 0.0) {
            reducedDistance += d;
        }
        return reducedDistance;
    }

    private double processOutLanding(PlaneResult planeResult, Task task, Coordinate[] coords, int[] correctSequence, Vector samples, int startIndex, double tpDistance) {
        Vector<Integer> sequence = new Vector<Integer>();
        Vector<Integer> sequenceSampleIndex = new Vector<Integer>();
        this.getBestSequence(sequence, sequenceSampleIndex, samples, coords, tpDistance, startIndex);
        StringBuilder sb = new StringBuilder("Afstand: " + tpDistance + "\n");
        sb.append("Correct sequence:");
        for (int aCorrectSequence : correctSequence) {
            sb.append(" ").append(aCorrectSequence);
        }
        sb = new StringBuilder("        sequence:");
        for (int i = 0; i < sequence.size(); ++i) {
            sb.append(" ").append(sequence.elementAt(i));
        }
        int end = 0;
        int numTp = 0;
        int lastCorrectTp = 0;
        int lastSequenceTp = 0;
        block2: for (int i = 1; i < correctSequence.length; ++i) {
            while (end < sequence.size()) {
                if (sequence.elementAt(end) == correctSequence[i]) {
                    ++numTp;
                    lastCorrectTp = i;
                    lastSequenceTp = end;
                    continue block2;
                }
                ++end;
            }
        }
        Coordinate nextCoord = new Coordinate(task.getTurnpoint(correctSequence[lastCorrectTp + 1]).getCoordinate());
        int index = 0;
        if (sequenceSampleIndex.size() > 0) {
            index = sequenceSampleIndex.elementAt(lastSequenceTp);
        }
        double minDist = Double.MAX_VALUE;
        Coordinate nearest = null;
        while (index < samples.size()) {
            Sample s = (Sample)samples.elementAt(index);
            Coordinate coord = new Coordinate(s.lat, s.lon);
            double dist = Utils.distance(coord, nextCoord);
            if (dist < minDist) {
                minDist = dist;
                nearest = coord;
            }
            ++index;
        }
        if (nearest != null) {
            planeResult.setLandingSpot(nearest);
            planeResult.numberOfTurnPoints = numTp;
            planeResult.finished = false;
            planeResult.endTime = 0;
            planeResult.duration = 0;
            COMMON.getContest().planeDistanceResult(this.getReducedDistance(numTp, nearest), nearest, numTp);
            COMMON.getUpdater().lengthChanged();
            return minDist;
        }
        return 0.0;
    }

    private boolean processTrip(PlaneResult planeResult, Task task, Coordinate[] coords, int[] correctSequence, Vector samples, int startIndex, double tpDistance) {
        Vector<Integer> sequence = new Vector<Integer>();
        Vector<Integer> sequenceSampleIndex = new Vector<Integer>();
        this.getBestSequence(sequence, sequenceSampleIndex, samples, coords, tpDistance, startIndex);
        StringBuilder sb = new StringBuilder("Correct sequence:");
        for (int aCorrectSequence : correctSequence) {
            sb.append(" ").append(aCorrectSequence);
        }
        sb = new StringBuilder("        sequence:");
        for (int i = 0; i < sequence.size(); ++i) {
            sb.append(" ").append(sequence.elementAt(i));
        }
        int end = 0;
        for (int i = 1; i < correctSequence.length; ++i) {
            while (end < sequence.size() && sequence.elementAt(end) != correctSequence[i]) {
                ++end;
            }
        }
        if (end >= sequence.size()) {
            return false;
        }
        int start = end;
        for (int i = correctSequence.length - 1; i > 0; --i) {
            while (start >= 0 && sequence.elementAt(start) != correctSequence[i]) {
                --start;
            }
        }
        if (start < 0) {
            return false;
        }
        int bestStartIndex = sequenceSampleIndex.elementAt(start);
        int bestFinishIndex = sequenceSampleIndex.elementAt(end);
        start = this.getStart(task, samples, bestStartIndex);
        if (start < 0) {
            return false;
        }
        planeResult.started = true;
        planeResult.startTime = start;
        end = this.getFinish(task, samples, bestFinishIndex);
        if (end < 0) {
            return false;
        }
        planeResult.finished = true;
        planeResult.endTime = end;
        planeResult.duration = planeResult.endTime - planeResult.startTime;
        this.setModified();
        COMMON.getUpdater().updateResult();
        return true;
    }

    private void processIGCfile(Task task, PlaneResult planeResult, Vector samples) {
        int[] correctSequence;
        int startIndex = this.getFirstStartPassage(task, samples);
        if (startIndex < 0) {
            planeResult.started = false;
            planeResult.distance = 0.0;
            planeResult.duration = 0;
            planeResult.endTime = 0;
            planeResult.finished = false;
            planeResult.startTime = 0;
            return;
        }
        Coordinate[] tpCoords = this.getCoords(task);
        if (this.processTrip(planeResult, task, tpCoords, correctSequence = this.getCorrectSequence(task), samples, startIndex, 0.5)) {
            return;
        }
        if (this.processTrip(planeResult, task, tpCoords, correctSequence, samples, startIndex, 1.0)) {
            return;
        }
        PlaneResult pres = new PlaneResult();
        double dist1 = this.processOutLanding(planeResult, task, tpCoords, correctSequence, samples, startIndex, 0.5);
        double dist2 = this.processOutLanding(pres, task, tpCoords, correctSequence, samples, startIndex, 1.0);
        if (dist2 > dist1) {
            planeResult.numberOfTurnPoints = pres.getNumberOfTurnPoints();
            planeResult.setLandingSpot(pres.getLandingSpot());
        }
    }

    private void processIGCfiles() {
        int day = COMMON.currentDay.getSelectedIndex();
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            ContestClass c = new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i));
            DayResult dayResult = c.getDayResult(day);
            for (int j = 0; j < c.planeList.size(); ++j) {
                PlaneResult planeResult;
                Plane p = c.getPlane(j);
                String filename = Home.getHome() + this.getName() + File.separatorChar + "Dag " + (day + 1) + File.separatorChar + p.getContestNumber() + ".igc";
                if (j >= dayResult.getPlaneResultList().size()) {
                    planeResult = new PlaneResult(p.getContestNumber());
                    dayResult.getPlaneResultList().addElement(planeResult);
                }
                planeResult = (PlaneResult)dayResult.getPlaneResultList().elementAt(j);
                Task task = dayResult.getTask();
                File igcFile = new File(filename);
                if (!igcFile.isFile()) continue;
                Track.getInstance().newTrack(null, igcFile);
                this.processIGCfile(task, planeResult, Track.getInstance().getSamples());
            }
        }
    }

    public void calculate(boolean detail) {
        int day = COMMON.currentDay.getSelectedIndex() + 1;
        int last = this.getCurrentClass().getResults();
        if (last > day) {
            GDialog.warning("NB: De beregnede resultater er for dag " + day + "\nV\u00e6lg dag " + last + " for at f\u00e5 den samlede stilling");
            this.processIGCfiles();
        }
        if (this.data.dmRules) {
            this.calculateDaysDM(detail);
        } else {
            this.calculateDaysAA(detail);
        }
        this.calculateContest();
        this.printDayResult();
    }

    public void calculateContest() {
        Vector<String> content = new Vector<String>();
        this.headLine(content);
        content.addElement("Samlet resultat.");
        this.ruleText(content);
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            ContestClass c = new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i));
            c.calculateClass();
        }
        String s2 = "============================================================================";
        this.sort();
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            Plane p;
            content.addElement(" ");
            content.addElement(" ");
            ContestClass c = new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i));
            String s = c.name;
            content.addElement(s);
            content.addElement(s2.substring(0, s.length()));
            s = "   NR  FLY  PILOT                     ";
            for (int n = 0; n <= COMMON.currentDay.getSelectedIndex(); ++n) {
                s = s + " DAG" + (n + 1);
            }
            s = s + "    IALT";
            content.addElement(s);
            content.addElement(" ");
            int pNum = 0;
            while ((p = c.getPlane(pNum++)) != null) {
                s = this.format(p.position, 5) + "   " + this.formatString(p.contestNumber, 2) + "   ";
                s = s + this.formatStringLeft(this.getPilot(c, p.contestNumber), 25);
                for (int k = 0; k <= COMMON.currentDay.getSelectedIndex(); ++k) {
                    DayResult dr = c.getResult(k);
                    for (int l = 0; l < dr.getPlaneResultList().size(); ++l) {
                        PlaneResult pr = (PlaneResult)dr.getPlaneResultList().elementAt(l);
                        if (!pr.contestNumber.equals(p.contestNumber)) continue;
                        int size = k < 9 ? 5 : 6;
                        s = s + this.format(pr.finalPoints, size);
                    }
                }
                s = s + "   " + this.format(p.totalPoints, 5);
                content.addElement(s);
            }
        }
        String filename = Home.getContestHome(this.data.name) + "SamletResultat.txt";
        Out.show(filename, content);
    }

    public void calculateDaysDM(boolean detail) {
        Vector<String> content = new Vector<String>();
        block0: for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            ContestClass c = new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i));
            this.details(detail, content, "Resultat for " + c.name);
            for (int day0 = 0; day0 <= COMMON.currentDay.getSelectedIndex(); ++day0) {
                double v;
                PlaneResult pr;
                int k;
                DayResult dr = c.getResult(day0);
                this.details(detail, content, "  Dag " + (day0 + 1) + ",  " + dr.date);
                if (c.getResults() < 1) {
                    this.details(detail, content, "     Ingen resultater");
                    continue block0;
                }
                if (dr.getTask() == null) {
                    this.details(detail, content, "     Ingen opgave defineret");
                    continue block0;
                }
                this.details(detail, content, "    Opgave: " + this.format(dr.getTask().length(), 2, 7));
                double D = 0.0;
                double V = 0.0;
                int N1 = 0;
                int N2 = 0;
                int n = 0;
                int maxpoints = 0;
                for (k = 0; k < dr.getPlaneResultList().size(); ++k) {
                    pr = (PlaneResult)dr.getPlaneResultList().elementAt(k);
                    pr.points = 0;
                    if (pr.distance > D) {
                        D = pr.distance;
                    }
                    if (pr.finished) {
                        v = dr.getTask().length() * 3600.0 / (double)pr.duration;
                        ++n;
                    } else {
                        v = 0.0;
                    }
                    if (v > V) {
                        V = v;
                    }
                    if (pr.distance >= this.data.minDistance) {
                        ++N1;
                    }
                    if (!pr.started) continue;
                    ++N2;
                }
                if (N2 != 0 && (double)N1 / (double)N2 > 0.25) {
                    double F = 1.25 * (double)N1 / (double)N2;
                    if (F > 1.0) {
                        F = 1.0;
                    }
                    double Pm1 = 1000.0;
                    double Pm2 = this.data.Pm2Const * D - 250.0;
                    double Pm3 = this.data.Pm3Const * D / V - 200.0;
                    double Pm4 = 1000.0 * (double)n / (double)N2 + 500.0;
                    this.details(detail, content, "    Pm1 = " + this.format(Pm1, 2, 7) + " Pm2 = " + this.format(Pm2, 2, 7) + " Pm3 = " + this.format(Pm3, 2, 7) + " Pm4 = " + this.format(Pm4, 2, 7));
                    double Pm = Pm1;
                    if (Pm > Pm2) {
                        Pm = Pm2;
                    }
                    if (Pm > Pm3) {
                        Pm = Pm3;
                    }
                    if (Pm > Pm4) {
                        Pm = Pm4;
                    }
                    int nTick = 0;
                    for (int k2 = 0; k2 < dr.getPlaneResultList().size(); ++k2) {
                        PlaneResult pr2 = (PlaneResult)dr.getPlaneResultList().elementAt(k2);
                        v = pr2.finished ? dr.getTask().length() * 3600.0 / (double)pr2.duration : 0.0;
                        if (!(v > 2.0 * V / 3.0)) continue;
                        ++nTick;
                    }
                    this.details(detail, content, "    F= " + this.format(F, 4, 6) + ",  Pm= " + this.format(Pm, 2, 6) + ",  D= " + this.format(D, 2, 6) + ", V= " + this.format(V, 2, 6) + ", n= " + n + ", N2= " + N2 + ", n'= " + nTick);
                    double firstPart = 0.0;
                    double secondPart = 0.0;
                    for (int k3 = 0; k3 < dr.getPlaneResultList().size(); ++k3) {
                        PlaneResult pr3 = (PlaneResult)dr.getPlaneResultList().elementAt(k3);
                        v = pr3.finished ? dr.getTask().length() * 3600.0 / (double)pr3.duration : 0.0;
                        double d = pr3.distance;
                        firstPart = d / D * (1.0 - 2.0 * (double)nTick / (3.0 * (double)N2));
                        secondPart = 0.0;
                        if (pr3.finished) {
                            secondPart = 2.0 * (v / V - 0.6666666666666666) * (double)nTick / (double)N2;
                        }
                        if (secondPart < 0.0) {
                            secondPart = 0.0;
                        }
                        Plane plane = c.getPlane(pr3.contestNumber);
                        pr3.points = (int)Math.round(F * Pm * (firstPart + secondPart) * 100.0 / (double)plane.handicap);
                        this.details(detail, content, "      " + this.formatString(pr3.contestNumber, 2) + ": " + this.format(F, 4, 6) + " * " + this.format(Pm, 2, 6) + " * (" + this.format(firstPart, 4, 6) + " + " + this.format(secondPart, 4, 6) + ") * 100 / " + plane.handicap + " = " + pr3.points);
                        if (pr3.points <= maxpoints) continue;
                        maxpoints = pr3.points;
                    }
                }
                this.details(detail, content, "     Strafpoint:");
                for (k = 0; k < dr.getPlaneResultList().size(); ++k) {
                    pr = (PlaneResult)dr.getPlaneResultList().elementAt(k);
                    int deduction = (int)Math.round((double)(pr.penaltyPoint * maxpoints) / 100.0);
                    if (pr.disqualified) {
                        deduction = pr.points;
                    }
                    pr.finalPoints = pr.points - deduction;
                    if (pr.finalPoints < 0) {
                        pr.finalPoints = 0;
                    }
                    this.details(detail, content, "      " + this.formatString(pr.contestNumber, 2) + ": " + pr.points + " - " + deduction + " = " + pr.finalPoints);
                }
            }
        }
        if (detail) {
            String filename = Home.getContestHome(this.data.name) + "Detaljer.txt";
            Out.show(filename, content);
        }
    }

    public void calculateDaysAA(boolean detail) {
        Vector<String> content = new Vector<String>();
        block0: for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            ContestClass c = new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i));
            this.details(detail, content, "Resultat for " + c.name);
            for (int day0 = 0; day0 <= COMMON.currentDay.getSelectedIndex(); ++day0) {
                double vr;
                double dr;
                int h;
                PlaneResult pr;
                int k;
                DayResult dres = c.getResult(day0);
                this.details(detail, content, "  Dag " + (day0 + 1) + ",  " + dres.date);
                if (c.getResults() < 1) {
                    this.details(detail, content, "     Ingen resultater");
                    continue block0;
                }
                if (dres.getTask() == null) {
                    this.details(detail, content, "     Ingen opgave defineret");
                    continue block0;
                }
                this.details(detail, content, "    Opgave: " + this.format(dres.getTask().length(), 2, 7));
                double Dr = 0.0;
                double Vr = 0.0;
                int N1 = 0;
                int N2 = 0;
                int n = 0;
                int maxpoints = 0;
                for (k = 0; k < dres.getPlaneResultList().size(); ++k) {
                    pr = (PlaneResult)dres.getPlaneResultList().elementAt(k);
                    h = c.getHandicap(pr.contestNumber);
                    pr.points = 0;
                    dr = pr.distance * 100.0 / (double)h;
                    if (dr > Dr) {
                        Dr = dr;
                    }
                    if (pr.finished) {
                        vr = dres.getTask().length() * 3600.0 / (double)pr.duration * 100.0 / (double)h;
                        ++n;
                    } else {
                        vr = 0.0;
                    }
                    if (vr > Vr) {
                        Vr = vr;
                    }
                    if (dr >= this.data.minDistance) {
                        ++N1;
                    }
                    if (!pr.started) continue;
                    ++N2;
                }
                if (N2 != 0 && (double)N1 / (double)N2 > 0.25) {
                    double F = 1.25 * (double)N1 / (double)N2;
                    if (F > 1.0) {
                        F = 1.0;
                    }
                    double Pm1 = 1000.0;
                    double Pm2 = this.data.Pm2Const * Dr - 250.0;
                    double Pm3 = this.data.Pm3Const * Dr / Vr - 200.0;
                    double Pm4 = 1000.0 * (double)n / (double)N2 + 500.0;
                    this.details(detail, content, "    Pm1 = " + this.format(Pm1, 2, 7) + " Pm2 = " + this.format(Pm2, 2, 7) + " Pm3 = " + this.format(Pm3, 2, 7) + " Pm4 = " + this.format(Pm4, 2, 7));
                    double Pm = Pm1;
                    if (Pm > Pm2) {
                        Pm = Pm2;
                    }
                    if (Pm > Pm3) {
                        Pm = Pm3;
                    }
                    if (Pm > Pm4) {
                        Pm = Pm4;
                    }
                    int nTick = 0;
                    for (int k2 = 0; k2 < dres.getPlaneResultList().size(); ++k2) {
                        PlaneResult pr2 = (PlaneResult)dres.getPlaneResultList().elementAt(k2);
                        h = c.getHandicap(pr2.contestNumber);
                        vr = pr2.finished ? dres.getTask().length() * 3600.0 / (double)pr2.duration * 100.0 / (double)h : 0.0;
                        if (!(vr > 2.0 * Vr / 3.0)) continue;
                        ++nTick;
                    }
                    this.details(detail, content, "    F= " + this.format(F, 4, 6) + ",  Pm= " + this.format(Pm, 2, 6) + ",  Dr= " + this.format(Dr, 2, 6) + ", Vr= " + this.format(Vr, 2, 6) + ", n= " + n + ", N2= " + N2 + ", n'= " + nTick);
                    double firstPart = 0.0;
                    double secondPart = 0.0;
                    for (int k3 = 0; k3 < dres.getPlaneResultList().size(); ++k3) {
                        PlaneResult pr3 = (PlaneResult)dres.getPlaneResultList().elementAt(k3);
                        h = c.getHandicap(pr3.contestNumber);
                        vr = pr3.finished ? dres.getTask().length() * 3600.0 / (double)pr3.duration * 100.0 / (double)h : 0.0;
                        dr = pr3.distance * 100.0 / (double)h;
                        double d2r = pr3.finished ? Dr : dr;
                        firstPart = d2r / Dr * (1.0 - 2.0 * (double)nTick / (3.0 * (double)N2));
                        secondPart = 0.0;
                        if (pr3.finished) {
                            secondPart = 2.0 * (vr / Vr - 0.6666666666666666) * (double)nTick / (double)N2;
                        }
                        if (secondPart < 0.0) {
                            secondPart = 0.0;
                        }
                        Plane plane = c.getPlane(pr3.contestNumber);
                        pr3.points = (int)Math.round(F * Pm * (firstPart + secondPart));
                        this.details(detail, content, "      " + this.formatString(pr3.contestNumber, 2) + ": " + this.format(F, 4, 6) + " * " + this.format(Pm, 2, 6) + " * (" + this.format(firstPart, 4, 6) + " + " + this.format(secondPart, 4, 6) + ") = " + pr3.points);
                        if (pr3.points <= maxpoints) continue;
                        maxpoints = pr3.points;
                    }
                }
                this.details(detail, content, "     Strafpoint:");
                for (k = 0; k < dres.getPlaneResultList().size(); ++k) {
                    pr = (PlaneResult)dres.getPlaneResultList().elementAt(k);
                    int deduction = (int)Math.round((double)(pr.penaltyPoint * maxpoints) / 100.0);
                    if (pr.disqualified) {
                        deduction = pr.points;
                    }
                    pr.finalPoints = pr.points - deduction;
                    if (pr.finalPoints < 0) {
                        pr.finalPoints = 0;
                    }
                    this.details(detail, content, "      " + this.formatString(pr.contestNumber, 2) + ": " + pr.points + " - " + deduction + " = " + pr.finalPoints);
                }
            }
        }
        if (detail) {
            String filename = Home.getContestHome(this.data.name) + "Detaljer.txt";
            Out.show(filename, content);
        }
    }

    public void changeClass(Plane p, String newClassStr) {
        ContestClass newClass = null;
        ContestClass oldClass = null;
        Object pl = null;
        boolean pos = false;
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            ContestClass c = new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i));
            if (c.name.equals(newClassStr)) {
                newClass = c;
            }
            if (!c.isMember(p.registration)) continue;
            oldClass = c;
        }
        if (oldClass == null || newClass == null) {
            return;
        }
        if (oldClass == newClass) {
            return;
        }
        newClass.addPlane(p);
        oldClass.removePlane(p);
        this.setModified();
    }

    public void changeDate(String newDate) {
        String currentDate = this.getDayResult((int)COMMON.currentDay.getSelectedIndex()).date;
        if (!currentDate.equals(newDate)) {
            this.getDayResult((int)COMMON.currentDay.getSelectedIndex()).date = newDate;
            ((Day)COMMON.currentDay.getSelectedItem()).setDate(newDate);
            this.setModified();
        }
    }

    public void changePlane(String contestClass, Plane p) {
        Object pl = null;
        boolean pos = false;
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            ContestClass c = new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i));
            if (!c.name.equals(contestClass) || !c.changePlane(p)) continue;
            this.setModified();
        }
    }

    public void changePlaneRegistration(String contestClass, Plane p) {
        Object pl = null;
        boolean pos = false;
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            ContestClass c = new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i));
            if (!c.name.equals(contestClass) || !c.changePlaneRegistration(p)) continue;
            this.setModified();
        }
    }

    public int classCount() {
        return this.data.contestClassList.size();
    }

    public void delete() {
        if (this.data.name != null) {
            File dir = new File(Home.getContestHome(this.data.name));
            String[] dirList = dir.list();
            if (dirList != null) {
                for (int i = 0; i < dirList.length; ++i) {
                    File file = new File(dir + File.separatorChar + dirList[i]);
                    boolean fail = false;
                    if (file.isFile()) {
                        fail = !file.delete();
                    } else {
                        String[] fileList = file.list();
                        if (fileList != null) {
                            for (int j = 0; j < fileList.length; ++j) {
                                File file2 = new File(file + File.separator + fileList[j]);
                                boolean bl = fail = !file2.delete();
                                if (!fail) continue;
                                GDialog.error(COMMON.topFrame, "Kunne ikke slette " + file2);
                            }
                            boolean bl = fail = !file.delete();
                        }
                    }
                    if (!fail) continue;
                    GDialog.error(COMMON.topFrame, "Kunne ikke slette " + file);
                }
            }
            if (!dir.delete()) {
                GDialog.error(COMMON.topFrame, "Kunne ikke slette " + dir);
            }
        }
        this.removeAllElements();
        this.data.name = null;
        this.resetModified();
    }

    private void details(boolean detail, Vector<String> content, String s) {
        if (!detail) {
            return;
        }
        content.addElement(s);
    }

    private void fireChange() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ContestChangeListener l = this.listeners.elementAt(i);
            l.changeEvent(this.modified);
        }
    }

    private void fireClassAddRemove() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ContestChangeListener l = this.listeners.elementAt(i);
            l.classAddRemove();
        }
    }

    public String format(double d, int decimals, int length) {
        return this.format(d, decimals, length, ',');
    }

    public String format(double d, int decimals, int length, char separater) {
        int exp = 1;
        for (int i = 0; i < decimals; ++i) {
            exp *= 10;
        }
        int rounded = (int)Math.round(d * (double)exp);
        String s = "" + rounded;
        while (decimals >= s.length()) {
            s = "0" + s;
        }
        String s1 = s.substring(0, s.length() - decimals);
        String s2 = s.substring(s.length() - decimals);
        s = s1 + separater + s2;
        return this.formatString(s, length);
    }

    public String format(int r, int length) {
        return this.formatString("" + r, length);
    }

    public String formatCoord(Coordinate coord) {
        if (coord == null) {
            return "";
        }
        return this.formatLatLon(coord.latitude) + "N" + this.formatLatLon(coord.longitude) + "E";
    }

    public String formatLatLon(int latLon) {
        String s = "000000" + latLon;
        return s.substring(s.length() - 6);
    }

    public String formatString(String s, int length) {
        if (s.length() > length) {
            return s.substring(0, length);
        }
        String s2 = "                                         ";
        return s2.substring(0, length - s.length()) + s;
    }

    public String formatStringLeft(String s, int length) {
        if (s.length() > length) {
            return s.substring(0, length);
        }
        String s2 = "                                         ";
        return s + s2.substring(0, length - s.length());
    }

    public String formatTime(int t) {
        if (t == 0) {
            return "        ";
        }
        int h = t / 3600;
        int m = t % 3600 / 60;
        int s = t % 60;
        String tmp = "00" + h;
        String out = tmp.substring(tmp.length() - 2) + ":";
        tmp = "00" + m;
        out = out + tmp.substring(tmp.length() - 2) + ":";
        tmp = "00" + s;
        out = out + tmp.substring(tmp.length() - 2);
        return out;
    }

    public void headLine(Vector<String> content) {
        int lineLgt = 90;
        StringBuffer sb = new StringBuffer(90);
        sb.insert(0, this.getName());
        String s = "Beregnet af Glider (version " + Version.get() + ")";
        sb.setLength(90 - s.length());
        sb.append(s);
        content.addElement(sb.toString());
        sb = new StringBuffer(90);
        sb.setLength(90 - s.length());
        sb.append(this.now());
        content.addElement(sb.toString());
    }

    public void load(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.data = (ContestData)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            this.loadOld(file);
        }
        this.resetModified();
    }

    public void loadOld(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.data.dmRules = ois.readBoolean();
            this.data.minDistance = ois.readDouble();
            this.data.Pm2Const = ois.readDouble();
            this.data.Pm3Const = ois.readDouble();
            this.data.name = (String)ois.readObject();
            this.data.contestHome = (String)ois.readObject();
            this.data.contestClassList = (Vector)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            this.loadV3(file);
        }
    }

    public void loadV3(File file) {
    }

    public boolean newContest(String name, Vector classList) {
        if (classList.size() < 1) {
            GDialog.info(name + "Opret en klasse f\u00f8rst");
            this.resetModified();
            return false;
        }
        this.removeAllElements();
        this.data.name = name;
        File dir = new File(Home.getContestHome(this.data.name));
        if (dir.exists()) {
            GDialog.warning(name + " findes i forvejen, v\u00e6lg et andet navn");
            this.resetModified();
            return false;
        }
        if (!dir.mkdir()) {
            // empty if block
        }
        if (!(dir = new File(Home.getContestHome(this.data.name) + "/Dag 1")).mkdir()) {
            // empty if block
        }
        this.data.contestClassList = new Vector();
        COMMON.currentClassBox.removeAllItems();
        for (int i = 0; i < classList.size(); ++i) {
            ContestClassData c = new ContestClassData();
            c.name = (String)classList.elementAt(i);
            c.dayResultList = new Vector();
            c.planeList = new Vector();
            this.data.contestClassList.addElement(c);
            COMMON.currentClassBox.addItem(c.name);
        }
        COMMON.currentDay.removeAllItems();
        Date now = Calendar.getInstance().getTime();
        COMMON.currentDay.addItem(new Day(1, now));
        COMMON.currentClassBox.setSelectedIndex(0);
        COMMON.currentDay.setSelectedIndex(0);
        this.save(new File(Home.getContestHome(this.data.name) + name + ".kon"));
        COMMON.topFrame.setTitle(name);
        this.resetModified();
        return true;
    }

    public void newDay(JComboBox choiceDay) {
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            Plane p;
            ContestClass c = new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i));
            DayResult dr = new DayResult();
            int pNum = 0;
            while ((p = c.getPlane(pNum++)) != null) {
                PlaneResult pr = new PlaneResult(p.contestNumber);
                dr.getPlaneResultList().addElement(pr);
            }
            c.addResult(dr);
        }
        COMMON.getUpdater().updateAll();
        int d = choiceDay.getItemCount();
        choiceDay.setSelectedIndex(d - 1);
        String dirName = Home.getContestHome(this.data.name) + "Dag " + d;
        File dir = new File(dirName);
        if (!dir.mkdir()) {
            // empty if block
        }
        this.setModified();
    }

    public String now() {
        Date date = new Date();
        return DateFormat.getDateInstance().format(date) + " " + DateFormat.getTimeInstance().format(date);
    }

    public void planeDistanceResult(double distance, Coordinate coord, int numberOfTurnPoints) {
        PlaneResult pr = this.getPlaneResult();
        if (pr == null) {
            DayResult d = this.getDayResult(COMMON.currentDay.getSelectedIndex());
            Plane p = this.getPlane();
            d.getPlaneResultList().addElement(new PlaneResult(p.contestNumber));
        }
        if ((pr = this.getPlaneResult()) == null) {
            return;
        }
        pr.endTime = 0;
        pr.duration = 0;
        pr.started = true;
        pr.finished = false;
        pr.distance = distance;
        pr.landingSpot = new Coordinate(coord.latitude, coord.longitude);
        pr.numberOfTurnPoints = numberOfTurnPoints;
        this.setModified();
    }

    public void planeResult(int startTime, int endTime, int duration, boolean started, boolean finished, double distance) {
        PlaneResult pr = this.getPlaneResult();
        pr.startTime = startTime;
        pr.endTime = endTime;
        pr.duration = duration;
        pr.started = started;
        pr.finished = finished;
        pr.distance = distance;
        pr.numberOfTurnPoints = -1;
        pr.landingSpot = null;
        this.setModified();
    }

    public void planeSpeedResult(int startTime, int endTime, int duration, boolean completed) {
        if (completed) {
            this.planeResult(startTime, endTime, duration, true, completed, COMMON.getCurrentTask().length());
        } else {
            this.planeResult(startTime, endTime, duration, true, completed, 0.0);
        }
    }

    public void printDayResult() {
        int day0 = COMMON.currentDay.getSelectedIndex();
        String spacing = "  ";
        String s2 = "============================================================================";
        this.sort();
        Vector<String> content = new Vector<String>();
        this.headLine(content);
        String date = COMMON.getContest().getDayResult((int)day0).date;
        content.addElement("Resultater for dag " + (day0 + 1) + ",  " + date);
        this.ruleText(content);
        TurnPoints turnpoints = COMMON.getTurnPoints();
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            ContestClass c = new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i));
            content.addElement(" ");
            content.addElement(" ");
            String s = c.name;
            content.addElement(s);
            content.addElement(s2.substring(0, s.length()));
            if (c.getResults() < 1) {
                content.addElement("Ingen resultater");
                continue;
            }
            DayResult dr = c.getDayResult(day0);
            Task t = dr.getTask();
            if (t == null) {
                content.addElement("Ingen opgave defineret");
                continue;
            }
            s = "Opgave: " + this.format(t.length(), 1, 6) + " km";
            content.addElement(s);
            for (int n = 0; n < t.size(); ++n) {
                Coordinate tp = t.coordinate(n);
                s = "   " + turnpoints.getNearest((Coordinate)tp).description;
                content.addElement(s);
            }
            content.addElement(" ");
            s = "   NR  FLY  PILOT                    UD        HJEM      TID        DIST.   HAST. POINT  STRAF";
            content.addElement(s);
            content.addElement(" ");
            for (int k = 0; k < dr.getPlaneResultList().size(); ++k) {
                PlaneResult pr = (PlaneResult)dr.getPlaneResultList().elementAt(k);
                if (!pr.started) continue;
                s = this.format(k + 1, 5) + "   " + this.formatString(pr.contestNumber, 2) + spacing;
                s = s + this.formatStringLeft(this.getPilot(c, pr.contestNumber), 25);
                s = s + this.formatTime(pr.startTime) + spacing;
                double speed = 0.0;
                if (pr.finished) {
                    s = s + this.formatTime(pr.endTime) + spacing;
                    s = s + this.formatTime(pr.duration) + spacing;
                    s = s + this.format(t.length(), 1, 6) + spacing;
                    speed = t.length() * 3600.0 / (double)pr.duration;
                } else if (pr.numberOfTurnPoints >= 0) {
                    s = s + pr.numberOfTurnPoints + " / ";
                    s = s + this.formatCoord(new Coordinate(pr.landingSpot)) + spacing;
                    s = s + this.format(pr.distance, 1, 6) + spacing;
                } else {
                    s = s + "                            ";
                }
                s = s + this.format(speed, 1, 5);
                s = s + this.format(pr.finalPoints, 6) + spacing;
                if (pr.disqualified) {
                    s = s + " DISQ";
                } else {
                    s = s + this.format(pr.penaltyPoint, 2);
                    if (pr.penaltyPoint > 0) {
                        s = s + " %";
                    }
                }
                content.addElement(s);
            }
        }
        String filename = Home.getContestHome(this.data.name) + "DagsResultat.txt";
        Out.show(filename, content);
    }

    public void rememberTask() {
        this.rememberedTask = this.getTask();
    }

    public void removeAllElements() {
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i)).removeAllElements();
        }
        this.data.contestClassList.removeAllElements();
        this.fireClassAddRemove();
    }

    public void removeClass() {
        if (this.getCurrentClassName() == null) {
            return;
        }
        this.removeClass(this.getCurrentClassName());
    }

    public void removeClass(String name) {
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            ContestClass c = new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i));
            if (!name.equals(c.name)) continue;
            c.removeAllElements();
            this.data.contestClassList.removeElementAt(i);
            COMMON.currentClassBox.removeItem(c.name);
            this.setModified();
            COMMON.getUpdater().updateAll();
            return;
        }
        this.fireClassAddRemove();
    }

    public void removePlane(String contestNumber) {
        for (int h = 0; h < this.data.contestClassList.size(); ++h) {
            ContestClass c = new ContestClass((ContestClassData)this.data.contestClassList.elementAt(h));
            if (!c.removePlane(contestNumber)) continue;
            this.setModified();
            COMMON.getUpdater().updateAll();
        }
    }

    private void resetModified() {
        this.modified = false;
        this.fireChange();
    }

    public void restoreTask() {
        ContestClass c = this.getCurrentClass();
        if (c != null) {
            if (c.getResults() == 0) {
                c.addResult(new DayResult());
            }
            DayResult d = c.getDayResult(COMMON.currentDay.getSelectedIndex());
            d.setTask(this.rememberedTask);
        }
    }

    public void ruleText(Vector<String> content) {
        String rules = this.data.dmRules ? "DM regler" : "A\u00c5 regler";
        if (this.data.minDistance != 100.0 || this.data.Pm2Const != 5.0 || this.data.Pm3Const != 400.0) {
            rules = "*** " + rules + ", p\u00e5n\u00e6r:";
        }
        if (this.data.minDistance != 100.0) {
            rules = rules + " min dist = " + this.data.minDistance + " km.";
        }
        if (this.data.Pm2Const != 5.0) {
            rules = rules + " Pm2 = " + this.data.Pm2Const + " * D - 250.";
        }
        if (this.data.Pm3Const != 400.0) {
            rules = rules + " Pm3 = " + this.data.Pm3Const + " * D / V - 200.";
        }
        content.addElement(rules);
    }

    public void backup(File file) {
        if (!file.exists()) {
            return;
        }
        File backup = new File(file.getAbsolutePath() + ".bak");
        backup.delete();
        if (!file.renameTo(backup)) {
            // empty if block
        }
    }

    public void save(File file) {
        this.backup(file);
        this.resetModified();
        try {
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.data);
            oos.close();
        }
        catch (Exception e) {
            GDialog.error(COMMON.topFrame, "Kunne ikke skrive " + file + "\n" + e);
        }
    }

    public void sort() {
        for (int i = 0; i < this.data.contestClassList.size(); ++i) {
            ContestClass c = new ContestClass((ContestClassData)this.data.contestClassList.elementAt(i));
            if (!c.sort()) continue;
            this.setModified();
        }
    }

    public static Contest getInstance() {
        return instance;
    }
}

