/*
 * Decompiled with CFR 0.152.
 */
package glider.data;

import glider.data.TpNames;
import glider.data.TurnPoint;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Vector;

public class CSVTurnpoints {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");

    public static void read(BufferedReader br, Vector tpList) {
        TpNames tpNames = TpNames.getInstance();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                TurnPoint tp;
                String[] items = line.split(",");
                if (items.length < 20 || (tp = CSVTurnpoints.extractTurnpoint(items)) == null) continue;
                tpNames.reUseName(tp);
                tpList.add(tp);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static TurnPoint extractTurnpoint(String[] items) {
        String now = sdf.format(Calendar.getInstance().getTime());
        TurnPoint tp = null;
        try {
            int number = Integer.parseInt(items[0]);
            String fullName = items[1];
            if (!items[2].equals("N")) {
                throw new ParseException("Missing N", 2);
            }
            if (!items[8].equals("E")) {
                throw new ParseException("Missing E", 8);
            }
            float decMin = (float)Integer.parseInt(items[5]) * 10.0f / 6.0f;
            int rounded = Math.round(decMin);
            float lat = (float)(Integer.parseInt(items[3]) * 100 + Integer.parseInt(items[4])) + (float)rounded / 100.0f;
            decMin = (float)Integer.parseInt(items[11]) * 10.0f / 6.0f;
            rounded = Math.round(decMin);
            float lon = (float)(Integer.parseInt(items[9]) * 100 + Integer.parseInt(items[10])) + (float)rounded / 100.0f;
            String abbrName = items[18];
            while (abbrName.length() < 6) {
                abbrName = abbrName + "-";
            }
            abbrName = abbrName.substring(0, 6);
            tp = new TurnPoint(number, now, abbrName, lat, lon, fullName, "", false);
        }
        catch (Throwable t) {
            tp = null;
        }
        return tp;
    }
}

