/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.Barogram;
import glider.COMMON;
import glider.CloseUp;
import glider.Day;
import glider.OutLanding;
import glider.Penalty;
import glider.Track;
import glider.TripTime;
import glider.UpdateListener;
import glider.data.ContestClass;
import glider.data.DayResult;
import glider.data.Plane;
import glider.data.PlaneResult;
import glider.data.Task;
import java.awt.Color;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class Updater {
    static JComboBox choicePlane = null;
    static JComboBox choiceClass = null;
    static JComboBox choiceDay = null;
    JTextField textFieldLength = null;
    private JTextField textFieldResult = null;
    private OutLanding outLanding = null;
    private Penalty penalty = null;
    private TripTime tripTime = null;
    private Barogram barogram = null;
    private CloseUp closeUp = null;
    private UpdateListener updateListener = null;

    public void classChanged() {
        this.updatePlane();
        this.updateLength();
        this.updateResult();
        this.reCalculate();
    }

    public void dayChanged() {
        this.updateLength();
        this.updateResult();
        this.reCalculate();
        COMMON.getMapViewer().setContestList(COMMON.getCurrentTask());
    }

    public void init(JComboBox choiceClass, JComboBox choiceDay, JComboBox choicePlane, JTextField textFieldLength, JTextField textFieldResult, OutLanding outLanding, Penalty penalty, TripTime tripTime, Barogram barogram, CloseUp closeUp) {
        Updater.choiceClass = choiceClass;
        Updater.choiceDay = choiceDay;
        Updater.choicePlane = choicePlane;
        this.textFieldLength = textFieldLength;
        this.textFieldResult = textFieldResult;
        this.outLanding = outLanding;
        this.penalty = penalty;
        this.tripTime = tripTime;
        this.barogram = barogram;
        this.closeUp = closeUp;
    }

    public void lengthChanged() {
        this.updateLength();
        this.updateResult();
    }

    public void planeChanged() {
        this.updateResult();
        this.reCalculate();
    }

    public void reCalculate() {
        int day = COMMON.currentDay.getSelectedIndex() + 1;
        String cid = (String)choicePlane.getSelectedItem();
        File igc = new File(COMMON.getDir() + File.separator + "Dag " + day + File.separator + cid + ".igc");
        if (!igc.exists()) {
            Track.getInstance().removeTrack();
            return;
        }
        Track.getInstance().newTrack(null, igc);
    }

    public void updateAll() {
        this.updateClass();
        this.updateDay();
        this.updateLength();
        this.updatePlane();
        this.updateResult();
        this.reCalculate();
    }

    public void updateClass() {
        choiceClass.removeAllItems();
        if (COMMON.getContest().isDefined()) {
            ContestClass c;
            int cNum = 0;
            while ((c = COMMON.getContest().getContestClass(cNum++)) != null) {
                choiceClass.addItem(c.getName());
            }
        }
        choiceClass.repaint();
    }

    public void updateDay() {
        choiceDay.removeAllItems();
        if (COMMON.getContest().isDefined()) {
            int days = COMMON.getContest().getCurrentClass().getResults();
            for (int i = 1; i <= days; ++i) {
                String date = COMMON.getContest().getDayResult(i - 1).getDate();
                choiceDay.addItem(new Day(i, date));
            }
        }
        choiceDay.repaint();
    }

    public void updateLength() {
        if (choiceClass.getSelectedItem() == null) {
            return;
        }
        if (COMMON.getContest().isDefined()) {
            ContestClass c;
            int cNum = 0;
            while ((c = COMMON.getContest().getContestClass(cNum++)) != null) {
                DayResult d;
                Task t;
                if (!c.getName().equals((String)choiceClass.getSelectedItem())) continue;
                if (c.getResults() < 1) {
                    this.textFieldLength.setText("");
                    return;
                }
                int day0 = COMMON.currentDay.getSelectedIndex();
                if (day0 < 0) {
                    day0 = 0;
                }
                if (day0 > c.getResults() - 1) {
                    day0 = c.getResults() - 1;
                }
                if ((t = (d = c.getDayResult(day0)).getTask()) == null) {
                    this.textFieldLength.setText("");
                    return;
                }
                this.textFieldLength.setText(COMMON.getContest().format(d.getTask().length(), 1, 5) + " km");
                COMMON.getMapViewer().setContestList(d.getTask());
                COMMON.getMapViewer().repaint();
            }
        }
    }

    public void updatePlane() {
        choicePlane.removeAllItems();
        if (COMMON.getContest().isDefined()) {
            Plane p;
            ContestClass c = COMMON.getContest().getCurrentClass();
            if (c == null) {
                return;
            }
            int pNum = 0;
            while ((p = c.getPlane(pNum++)) != null) {
                choicePlane.addItem(p.getContestNumber());
            }
        }
        choicePlane.repaint();
    }

    public void updateResult() {
        this.textFieldResult.setText("");
        if (choiceClass.getSelectedItem() == null) {
            return;
        }
        if (COMMON.getContest().isDefined()) {
            ContestClass c;
            int cNum = 0;
            while ((c = COMMON.getContest().getContestClass(cNum++)) != null) {
                if (!c.getName().equals((String)choiceClass.getSelectedItem())) continue;
                if (c.getResults() < 1) {
                    return;
                }
                int day0 = COMMON.currentDay.getSelectedIndex();
                if (day0 < 0) {
                    day0 = 0;
                }
                if (day0 > c.getResults() - 1) {
                    day0 = c.getResults() - 1;
                }
                DayResult dr = c.getDayResult(day0);
                for (int j = 0; j < dr.getPlaneResultList().size(); ++j) {
                    if (choicePlane.getSelectedItem() == null) {
                        return;
                    }
                    PlaneResult pr = (PlaneResult)dr.getPlaneResultList().elementAt(j);
                    if (pr == null || pr.getContestNumber() == null) {
                        return;
                    }
                    if (!pr.getContestNumber().equals((String)choicePlane.getSelectedItem())) continue;
                    if (pr.isFinished()) {
                        this.textFieldResult.setForeground(Color.green);
                        this.textFieldResult.setText(COMMON.getContest().format(3600.0 * dr.getTask().length() / (double)pr.getDuration(), 1, 5) + " km/t");
                        continue;
                    }
                    this.textFieldResult.setForeground(Color.yellow);
                    this.textFieldResult.setText(COMMON.getContest().format(pr.getDistance(), 1, 5) + " km");
                }
            }
        }
    }
}

