/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.GDialog;
import glider.Sample;
import glider.TrackListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;

public class Track {
    private Vector pilotEvents = new Vector();
    private Vector rawSamples = new Vector();
    private Vector samples = new Vector();
    private int sampleStart = 0;
    private int sampleEnd = 0;
    private int sampleDetailStart = 0;
    private int sampleDetailEnd = 0;
    private int selectedSampleIndex = 0;
    private Vector listeners = new Vector();
    private String filename = null;
    private static Track instance = null;
    private int enlStart = 38;
    private int enlEnd = 41;

    private Track() {
    }

    public void setDetailEnd(int end) {
        if (this.sampleDetailEnd != end) {
            this.sampleDetailEnd = end;
        }
    }

    public void setDetailStart(int start) {
        if (this.sampleDetailStart != start) {
            this.sampleDetailStart = start;
        }
    }

    public void setSampleEnd(int end) {
        if (this.sampleEnd != end) {
            this.sampleEnd = end;
            this.detailChanged();
        }
    }

    public void setSampleStart(int start) {
        if (this.sampleStart != start) {
            this.sampleStart = start;
            this.detailChanged();
        }
    }

    public void setSelectedSampleIndex(int selectedSampleIndex) {
        if (this.selectedSampleIndex != selectedSampleIndex && selectedSampleIndex < this.sampleEnd) {
            this.selectedSampleIndex = selectedSampleIndex;
            this.selectedChanged();
        }
    }

    public int getAdjustedSize() {
        return this.samples.size();
    }

    public int getDetailEnd() {
        return this.sampleDetailEnd;
    }

    public int getDetailStart() {
        return this.sampleDetailStart;
    }

    public int getEnd() {
        return this.sampleEnd;
    }

    public String getFilename() {
        return this.filename;
    }

    public Vector getPilotEvents() {
        return this.pilotEvents;
    }

    public Vector getRawSamples() {
        return this.rawSamples;
    }

    public Vector getSamples() {
        return this.samples;
    }

    public int getSelectedSampleIndex() {
        return this.selectedSampleIndex;
    }

    public Sample getSelectedSample() {
        if (this.selectedSampleIndex < 0 || this.selectedSampleIndex >= this.samples.size()) {
            return null;
        }
        return (Sample)this.samples.elementAt(this.selectedSampleIndex);
    }

    public int getSize() {
        return this.rawSamples.size();
    }

    public int getStart() {
        return this.sampleStart;
    }

    public void addListener(TrackListener listener) {
        this.listeners.addElement(listener);
    }

    void adjustAltitude(JFrame parent, File file, Vector samples) {
        Sample s;
        int i;
        if (file == null) {
            return;
        }
        if (samples == null) {
            return;
        }
        int minStart = 10000;
        int minEnd = 10000;
        for (i = 0; i < samples.size() / 2; ++i) {
            s = (Sample)samples.elementAt(i);
            if (s.pressAltitude >= minStart) continue;
            minStart = s.pressAltitude;
        }
        for (i = samples.size() / 2; i < samples.size(); ++i) {
            s = (Sample)samples.elementAt(i);
            if (s.pressAltitude >= minEnd) continue;
            minEnd = s.pressAltitude;
        }
        int meanGND = (minStart + minEnd) / 2;
        if (minStart - minEnd > 100 || minEnd - minStart > 100) {
            meanGND = minStart > minEnd ? minEnd : minStart;
        }
        for (i = 0; i < samples.size(); ++i) {
            s = (Sample)samples.elementAt(i);
            s.qfeAltitude = s.pressAltitude - meanGND;
        }
    }

    private void detailChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TrackListener tl = (TrackListener)this.listeners.elementAt(i);
            tl.detailChanged();
        }
    }

    void generateIgcFile(JFrame parent, File file) {
        this.filename = file.getAbsolutePath();
        String saveName = this.filename.substring(0, this.filename.indexOf(46)) + ".org";
        File newFile = new File(saveName);
        if (!newFile.canRead()) {
            file.renameTo(new File(saveName));
        }
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(saveName));
            bw = new BufferedWriter(new FileWriter(this.filename));
            while ((line = br.readLine()) != null) {
                if (line.length() == 0) continue;
                if (line.indexOf("B") == 0) {
                    if (line.indexOf(32) > 0) {
                        line = line.substring(0, line.indexOf(32));
                    }
                    if (line.length() < 24) {
                        line = line + "EA00000";
                    }
                    if (line.length() < 35) {
                        line = line + "00000";
                    }
                }
                if (line.charAt(0) != 'A' && line.charAt(0) != 'B' && line.charAt(0) != 'C' && line.charAt(0) != 'D' && line.charAt(0) != 'E' && line.charAt(0) != 'F' && line.charAt(0) != 'H' && line.charAt(0) != 'I' && line.charAt(0) != 'J' && line.charAt(0) != 'K' && line.charAt(0) != 'L' && line.charAt(0) != 'M') continue;
                bw.write(line);
                bw.newLine();
            }
            br.close();
            bw.close();
        }
        catch (IOException ioe) {
            GDialog.error(parent, "Kunne ikke generere " + this.filename);
            try {
                br.close();
                bw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void pilotEvent() {
        if (this.rawSamples.size() > 0) {
            Sample s = (Sample)this.rawSamples.elementAt(this.rawSamples.size() - 1);
            this.pilotEvents.addElement(s);
        }
    }

    private void iRecord(String line) {
        int index = line.indexOf("ENL");
        if (index > 4) {
            String s = line.substring(index - 4, index - 2);
            this.enlStart = Integer.parseInt(s);
            s = line.substring(index - 2, index);
            this.enlEnd = Integer.parseInt(s);
        }
    }

    public void newTrack(JFrame parent, File file) {
        if (file == null) {
            return;
        }
        boolean acceptUpdate = false;
        boolean updateFile = false;
        int errors = 0;
        int lineNo = 0;
        try {
            String line;
            this.pilotEvents.removeAllElements();
            this.rawSamples.removeAllElements();
            lineNo = 0;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                ++lineNo;
                if (line.length() < 1) continue;
                if (line.charAt(0) != 'B') {
                    if (line.charAt(0) == 'E') {
                        this.pilotEvent();
                        continue;
                    }
                    if (line.charAt(0) != 'I') continue;
                    this.iRecord(line);
                    continue;
                }
                if (line.charAt(14) != 'N' || line.charAt(23) != 'E' || line.charAt(24) != 'A' && line.charAt(24) != 'V') continue;
                try {
                    int gnssAltitude;
                    int pressureAltitude;
                    int lon;
                    int lat;
                    String time;
                    block16: {
                        time = line.substring(1, 7);
                        lat = new Integer(line.substring(7, 14));
                        lon = new Integer(line.substring(15, 23));
                        pressureAltitude = 0;
                        gnssAltitude = 0;
                        try {
                            pressureAltitude = new Integer(line.substring(25, 30));
                            gnssAltitude = new Integer(line.substring(30, 35));
                        }
                        catch (Exception e3) {
                            String ok = "Ignorer";
                            String cancel = "Afbryd indl\u00e6sning";
                            updateFile = true;
                            String tooMany = "";
                            if (errors == 2) {
                                ok = "OK";
                                cancel = "Reformater IKKE";
                                tooMany = "\nFor mange fejl, resterende fejl ignoreres\nDet anbefales at gemme filen i IGC format. Den originale gemmes s\u00e5 som *.org\nTryk OK for at reformatere filen til IGC format";
                            }
                            if (errors++ >= 3) break block16;
                            if (GDialog.accept(ok, cancel, parent, "Linie " + lineNo + "\nManglende h\u00f8jde angivelse\n" + line + tooMany, file.getName())) {
                                acceptUpdate = true;
                            }
                            this.pilotEvents.removeAllElements();
                            this.rawSamples.removeAllElements();
                            br.close();
                            return;
                        }
                    }
                    int enl = 0;
                    try {
                        enl = Integer.parseInt(line.substring(this.enlStart, this.enlEnd));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.rawSamples.addElement(new Sample(time, lat, lon, pressureAltitude, gnssAltitude, enl));
                }
                catch (Exception e2) {
                    if (GDialog.accept("Ignorer", "Afbryd indl\u00e6sning", parent, "Fejl i linie " + lineNo + "\n" + line, file.getName())) continue;
                    this.pilotEvents.removeAllElements();
                    this.rawSamples.removeAllElements();
                    br.close();
                    return;
                }
            }
            br.close();
            if (updateFile && !acceptUpdate) {
                updateFile = GDialog.accept("OK", "Tilf\u00f8j IKKE", parent, "Der manglede identifikation i filen.\nDet anbefales at tilf\u00f8je denne til filen. Den originale gemmes s\u00e5 som *.org\nNB: Den nye fil vil IKKE kunne best\u00e5 et validerings check.\nTryk OK for at tilf\u00f8je identifikation", file.getName());
            }
            this.filename = file.getAbsolutePath();
        }
        catch (Exception e) {
            GDialog.warning(parent, "Kunne ikke l\u00e6se filen " + file.getName() + "\n" + e);
            this.pilotEvents.removeAllElements();
            this.rawSamples.removeAllElements();
        }
        if (updateFile) {
            this.generateIgcFile(parent, file);
        }
        this.samples.removeAllElements();
        this.samples = (Vector)this.rawSamples.clone();
        this.adjustAltitude(parent, file, this.samples);
        this.sampleStart = 0;
        this.sampleEnd = this.rawSamples.size() - 1;
        this.sampleDetailStart = 0;
        this.sampleDetailEnd = this.rawSamples.size() - 1;
        this.selectedSampleIndex = 0;
        this.trackChanged();
    }

    public void reduceEnd(int sampleEnd) {
        if (this.sampleEnd != sampleEnd) {
            this.sampleEnd = sampleEnd;
            this.samples.removeAllElements();
            for (int i = this.sampleStart; i <= sampleEnd; ++i) {
                this.samples.addElement(this.rawSamples.elementAt(i));
            }
        }
        this.trackChanged();
    }

    public void reduceStart(int sampleStart) {
        if (this.sampleStart != sampleStart) {
            this.sampleStart = sampleStart;
            this.samples.removeAllElements();
            for (int i = sampleStart; i <= this.sampleEnd; ++i) {
                this.samples.addElement(this.rawSamples.elementAt(i));
            }
        }
        this.trackChanged();
    }

    public void removeListener(TrackListener listener) {
        this.listeners.removeElement(listener);
    }

    public void removeTrack() {
        this.pilotEvents.removeAllElements();
        this.rawSamples.removeAllElements();
        this.samples.removeAllElements();
        this.sampleStart = 0;
        this.sampleEnd = 0;
        this.sampleDetailStart = 0;
        this.sampleDetailEnd = 0;
        this.selectedSampleIndex = -1;
        this.trackChanged();
    }

    private void selectedChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TrackListener tl = (TrackListener)this.listeners.elementAt(i);
            tl.selectedChanged();
        }
    }

    public void trackChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            TrackListener tl = (TrackListener)this.listeners.elementAt(i);
            tl.trackChanged();
        }
    }

    public static Track getInstance() {
        if (instance == null) {
            instance = new Track();
        }
        return instance;
    }
}

