/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import glider.Sample;
import glider.TextFieldCapital;
import glider.TextFieldName;
import glider.TpDataModel;
import glider.TpManager;
import glider.TpTypes;
import glider.Track;
import glider.data.TurnPoint;
import glider.data.TurnPoints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class TpNew
extends JFrame
implements TpTypes {
    private TpManager parent = null;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JLabel jLabelStatus = new JLabel();
    JPanel jPanel3 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    JPanel jPanel4 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JButton jButtonAdd = new JButton();
    JButton jButtonEnd = new JButton();
    JButton jButtonClear = new JButton();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel7 = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    JLabel jLabel2 = new JLabel();
    TextFieldName textFieldNameDesc = new TextFieldName();
    JCheckBox jCheckBoxLandable = new JCheckBox();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    TextFieldCapital textFieldCapitalName = new TextFieldCapital();
    JComboBox jComboBoxType = new JComboBox();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JTextField jTextFieldLat = new JTextField();
    JLabel jLabel7 = new JLabel();
    JTextField jTextFieldLatDec = new JTextField();
    JLabel jLabel8 = new JLabel();
    JTextField jTextFieldLon = new JTextField();
    JLabel jLabel9 = new JLabel();
    JTextField jTextFieldLonDec = new JTextField();
    JLabel jLabel10 = new JLabel();
    GridBagLayout gridBagLayout6 = new GridBagLayout();
    JLabel jLabel11 = new JLabel();
    JTextField jTextFieldNumber = new JTextField();
    JLabel jLabel12 = new JLabel();
    JTextField jTextFieldDetail = new JTextField();
    Border border1;
    Border border2;
    Border border3;
    TitledBorder titledBorder1;
    JComboBox jComboBoxPilotEvents = new JComboBox();
    PilotComboListener pilotComboListener = new PilotComboListener();

    public TpNew() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            COMMON.errorLog(this.getClass().getName(), e);
        }
    }

    public void setType() {
        char type = "ABCDFGHJKNRSTVXY0-".charAt(this.jComboBoxType.getSelectedIndex());
        String s = this.textFieldCapitalName.getText();
        if (s.length() < 6) {
            return;
        }
        s = this.textFieldCapitalName.getText().substring(0, 5) + type;
        this.textFieldCapitalName.setText(s);
        this.check(s);
    }

    private String[] getTokens(String s) {
        s = s.replace('-', ' ');
        int cnt = 1;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != ' ') continue;
            ++cnt;
        }
        String[] result = new String[cnt];
        for (int i = 0; i < cnt - 1; ++i) {
            result[i] = s.substring(0, s.indexOf(32));
            s = s.substring(s.indexOf(32) + 1);
        }
        result[cnt - 1] = s.substring(0);
        return result;
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border2 = BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Optionelt"), BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border3 = BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151));
        this.titledBorder1 = new TitledBorder(this.border3, "Beskrivelse");
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.jLabelStatus.setFont(new Font("Dialog", 1, 12));
        this.jLabelStatus.setForeground(Color.red);
        this.jLabelStatus.setText("AAA er");
        this.jPanel3.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(2);
        this.jPanel4.setLayout(this.gridLayout1);
        this.gridLayout1.setHgap(5);
        this.jButtonAdd.setText("Tilf\u00f8j");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TpNew.this.jButtonAdd_actionPerformed(e);
            }
        });
        this.jButtonEnd.setText("Slut");
        this.jButtonEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TpNew.this.jButtonEnd_actionPerformed(e);
            }
        });
        this.jButtonClear.setText("Ryd");
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TpNew.this.jButtonClear_actionPerformed(e);
            }
        });
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jPanel7.setLayout(this.gridBagLayout3);
        this.jPanel6.setLayout(this.gridBagLayout4);
        this.jPanel5.setLayout(this.gridBagLayout5);
        this.jLabel2.setText("Eksempel: Egeskov Slot. (Max 20 tegn)");
        this.jCheckBoxLandable.setText("Landbar");
        this.textFieldNameDesc.setMinimumSize(new Dimension(160, 21));
        this.textFieldNameDesc.setPreferredSize(new Dimension(160, 21));
        this.textFieldNameDesc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TpNew.this.textFieldNameDesc_actionPerformed(e);
            }
        });
        this.jLabel3.setText("Navn. (Max 6 tegn)");
        this.jLabel4.setText("Type");
        this.textFieldCapitalName.setMinimumSize(new Dimension(60, 21));
        this.textFieldCapitalName.setPreferredSize(new Dimension(60, 21));
        this.textFieldCapitalName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TpNew.this.textFieldCapitalName_actionPerformed(e);
            }
        });
        this.jLabel5.setText("Bredde. Eksempel: 5510,560");
        this.jLabel6.setText("L\u00e6ngde. Eksempel: 1029,420");
        this.jTextFieldLat.setMinimumSize(new Dimension(40, 21));
        this.jTextFieldLat.setPreferredSize(new Dimension(40, 21));
        this.jLabel7.setText(",");
        this.jTextFieldLatDec.setMinimumSize(new Dimension(30, 21));
        this.jTextFieldLatDec.setPreferredSize(new Dimension(30, 21));
        this.jLabel8.setText("N");
        this.jLabel9.setText(",");
        this.jTextFieldLonDec.setMinimumSize(new Dimension(30, 21));
        this.jTextFieldLonDec.setPreferredSize(new Dimension(30, 21));
        this.jLabel10.setText("E");
        this.jTextFieldLon.setMinimumSize(new Dimension(40, 21));
        this.jTextFieldLon.setPreferredSize(new Dimension(40, 21));
        this.jPanel2.setLayout(this.gridBagLayout6);
        this.jLabel11.setText("Nummer:");
        this.jTextFieldNumber.setMinimumSize(new Dimension(40, 21));
        this.jTextFieldNumber.setPreferredSize(new Dimension(40, 21));
        this.jLabel12.setText("Detaljer. F. eks.: Ved Kv\u00e6rndrup - Fyn (Max 50 tegn)");
        this.jPanel7.setBorder(this.border1);
        this.jPanel6.setBorder(this.border1);
        this.jPanel5.setBorder(this.border1);
        this.jPanel2.setBorder(this.border2);
        this.jPanel1.setBorder(this.titledBorder1);
        this.setTitle("Nyt Vendepunkt");
        this.jComboBoxType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TpNew.this.jComboBoxType_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, new MyGridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel1.add((Component)this.jPanel5, new MyGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jLabel2, new MyGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.textFieldNameDesc, new MyGridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jCheckBoxLandable, new MyGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel6, new MyGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel6.add((Component)this.jLabel3, new MyGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel6.add((Component)this.jLabel4, new MyGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel6.add((Component)this.textFieldCapitalName, new MyGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel6.add((Component)this.jComboBoxType, new MyGridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel7, new MyGridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel7.add((Component)this.jLabel5, new MyGridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 10), 4, 0));
        this.jPanel7.add((Component)this.jLabel6, new MyGridBagConstraints(4, 0, 4, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel7.add((Component)this.jTextFieldLat, new MyGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel7.add((Component)this.jLabel7, new MyGridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanel7.add((Component)this.jTextFieldLatDec, new MyGridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel7.add((Component)this.jLabel8, new MyGridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel7.add((Component)this.jTextFieldLon, new MyGridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel7.add((Component)this.jLabel9, new MyGridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.jPanel7.add((Component)this.jTextFieldLonDec, new MyGridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel7.add((Component)this.jLabel10, new MyGridBagConstraints(7, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jPanel2, new MyGridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel2.add((Component)this.jLabel11, new MyGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(0, 0, 10, 5), 0, 0));
        this.jPanel2.add((Component)this.jTextFieldNumber, new MyGridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.jPanel2.add((Component)this.jLabel12, new MyGridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.jTextFieldDetail, new MyGridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jLabelStatus, new MyGridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jPanel3, new MyGridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.jButtonAdd, null);
        this.jPanel4.add((Component)this.jButtonClear, null);
        this.jPanel4.add((Component)this.jButtonEnd, null);
        for (int i = 0; i < TpTypes.type.length; ++i) {
            this.jComboBoxType.addItem(TpTypes.type[i]);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.black);
        Point p0 = this.jPanel1.getLocation();
        p0.x += 5;
        p0.y += 30;
        p0.x += this.jPanel6.getLocation().x;
        p0.y += this.jPanel6.getLocation().y;
        p0.y += this.getContentPane().getLocation().y;
        Point p1 = this.jComboBoxType.getLocation();
        p1.x += p0.x;
        p1.y += p0.y + this.jComboBoxType.getSize().height / 2;
        Point p5 = this.textFieldCapitalName.getLocation();
        FontMetrics fm = this.textFieldCapitalName.getFontMetrics(this.textFieldCapitalName.getFont());
        int sixtChar = fm.stringWidth("KALDRH") - fm.charWidth('H') / 2;
        p5.x += p0.x + sixtChar;
        p5.y += p0.y + this.textFieldCapitalName.getSize().height;
        Point p2 = new Point(p5.x + (p1.x - p5.x) / 2, p1.y);
        Point p3 = new Point(p2.x, p5.y + 10);
        Point p4 = new Point(p5.x, p3.y);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
        g.drawLine(p2.x, p2.y, p3.x, p3.y);
        g.drawLine(p3.x, p3.y, p4.x, p4.y);
        g.drawLine(p4.x, p4.y, p5.x, p5.y);
        g.drawLine(p5.x, p5.y, p5.x - 3, p5.y + 5);
        g.drawLine(p5.x, p5.y, p5.x + 3, p5.y + 5);
    }

    public void abbreviate() {
        String[] tokens;
        String lastToken;
        class Abbr {
            String text;
            char type;

            Abbr(char type, String text) {
                this.text = text;
                this.type = type;
            }

            boolean match(String token) {
                return token.equals(this.text);
            }
        }
        Abbr[] abbr = new Abbr[]{new Abbr('A', "Lufthavn"), new Abbr('B', "Bro"), new Abbr('B', "Lilleb\u00e6ltsbro"), new Abbr('B', "Motorvejsbro"), new Abbr('B', "Bromidte"), new Abbr('B', "Motorvbro"), new Abbr('B', "Jernb./vejbro"), new Abbr('G', "Fr\u00f8slev"), new Abbr('G', "Petersg\u00e5rd"), new Abbr('J', "Stn"), new Abbr('J', "Stn."), new Abbr('J', "Station"), new Abbr('J', "Jernbanestation"), new Abbr('J', "Jernbanestn"), new Abbr('J', "Jernbanestn."), new Abbr('K', "Domkirke"), new Abbr('T', "T"), new Abbr('X', "X"), new Abbr('X', "Motorv. Afk."), new Abbr('Y', "Y")};
        char[] name = new char[6];
        String s = this.textFieldNameDesc.getText();
        if (this.textFieldCapitalName.getText().length() < 6) {
            this.textFieldCapitalName.setText("??????");
        }
        if ((lastToken = (tokens = this.getTokens(s))[tokens.length - 1]).length() < 1) {
            return;
        }
        char type = lastToken.charAt(0);
        for (int i = 0; i < abbr.length; ++i) {
            if (!abbr[i].match(lastToken)) continue;
            type = abbr[i].type;
            break;
        }
        if ("ABCDFGHJKNRSTVXY0-".indexOf(type) < 0) {
            type = '?';
            this.dispatchEvent(new KeyEvent(this, 401, 0L, 0, 9, '\uffff'));
            this.dispatchEvent(new KeyEvent(this, 402, 0L, 0, 9, '\uffff'));
            this.dispatchEvent(new KeyEvent(this, 401, 0L, 0, 9, '\uffff'));
            this.dispatchEvent(new KeyEvent(this, 402, 0L, 0, 9, '\uffff'));
            this.jComboBoxType.getUI().setPopupVisible(this.jComboBoxType, true);
        } else {
            this.jComboBoxType.setSelectedIndex("ABCDFGHJKNRSTVXY0-".indexOf(type));
            this.jComboBoxType.repaint();
        }
        s = s.toUpperCase();
        s = TpDataModel.validChar(s);
        if (s.length() > 5) {
            s = s.substring(0, 5) + type;
        }
        this.textFieldCapitalName.setText(s);
        if (s.length() > 5) {
            this.check(s);
        }
    }

    public void addTp() {
        this.jLabelStatus.setText(" ");
        TurnPoint tp = new TurnPoint();
        tp.description = this.textFieldNameDesc.getText();
        tp.setName(this.textFieldCapitalName.getText());
        tp.detail = this.jTextFieldDetail.getText();
        tp.landable = this.jCheckBoxLandable.isSelected();
        try {
            tp.setLat(this.jTextFieldLat.getText() + "." + this.jTextFieldLatDec.getText());
        }
        catch (Exception e) {
            this.jLabelStatus.setText("Fejl i bredde angivelsen");
            return;
        }
        try {
            tp.setLon(this.jTextFieldLon.getText() + "." + this.jTextFieldLonDec.getText());
        }
        catch (Exception e) {
            this.jLabelStatus.setText("Fejl i l\u00e6ngde angivelsen");
            return;
        }
        try {
            tp.setNumber(Integer.parseInt(this.jTextFieldNumber.getText()));
        }
        catch (Exception e) {
            if (this.jTextFieldNumber.getText().length() > 0) {
                this.jLabelStatus.setText("Fejl i nummeret");
                return;
            }
            tp.setNumber(-1);
        }
        COMMON.getTurnPoints().add(tp);
        this.clean();
        this.parent.refresh();
        this.parent.showLast();
    }

    private void nextField() {
        this.dispatchEvent(new KeyEvent(this, 401, 0L, 0, 9, '\uffff'));
        this.dispatchEvent(new KeyEvent(this, 402, 0L, 0, 9, '\uffff'));
    }

    private void check() {
        this.check(this.textFieldCapitalName.getText());
    }

    private void check(String s) {
        COMMON.getTurnPoints();
        if (TurnPoints.isUsed(s)) {
            this.jLabelStatus.setText(s + " er benyttet allerede, v\u00e6lg andet navn");
            this.jButtonAdd.setEnabled(false);
            this.textFieldCapitalName.requestFocus();
            this.textFieldCapitalName.setSelectionStart(0);
            this.textFieldCapitalName.setSelectionEnd(this.textFieldCapitalName.getText().length() - 1);
        } else if (s.length() < 6) {
            this.jLabelStatus.setText(s + " er kortere end 6 tegn");
            this.jButtonAdd.setEnabled(false);
            this.textFieldCapitalName.requestFocus();
            this.textFieldCapitalName.setSelectionStart(0);
            this.textFieldCapitalName.setSelectionEnd(this.textFieldCapitalName.getText().length() - 1);
        } else if ("ABCDFGHJKNRSTVXY0-".indexOf(s.charAt(5)) < 0) {
            this.jLabelStatus.setText(s + " ender ikke med et af tegnene: " + "ABCDFGHJKNRSTVXY0-");
            this.jButtonAdd.setEnabled(false);
            this.textFieldCapitalName.requestFocus();
            this.textFieldCapitalName.setSelectionStart(0);
            this.textFieldCapitalName.setSelectionEnd(this.textFieldCapitalName.getText().length() - 1);
        } else {
            this.nextField();
            this.jLabelStatus.setText(" ");
            this.jButtonAdd.setEnabled(true);
        }
    }

    public void clean() {
        this.textFieldNameDesc.setText("");
        this.textFieldCapitalName.setText("");
        this.jTextFieldDetail.setText("");
        this.jTextFieldLat.setText("");
        this.jTextFieldLatDec.setText("");
        this.jTextFieldLon.setText("");
        this.jTextFieldLonDec.setText("");
        this.jTextFieldNumber.setText("");
        this.textFieldNameDesc.requestFocus();
        this.jLabelStatus.setText(" ");
    }

    void textFieldNameDesc_actionPerformed(ActionEvent e) {
        this.abbreviate();
    }

    void jComboBoxType_actionPerformed(ActionEvent e) {
        this.setType();
    }

    void textFieldCapitalName_actionPerformed(ActionEvent e) {
        this.check();
    }

    void jButtonAdd_actionPerformed(ActionEvent e) {
        this.addTp();
    }

    void jButtonClear_actionPerformed(ActionEvent e) {
        this.clean();
    }

    void jButtonEnd_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    public void show(TpManager parent) {
        super.setVisible(true);
        this.parent = parent;
        this.getRootPane().setDefaultButton(null);
        this.getRootPane().setEnabled(false);
        this.textFieldNameDesc.requestFocus();
        this.jLabelStatus.setText(" ");
        this.fillPilotEventCombo();
        this.pack();
        Dimension scrsize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(scrsize.width - this.getSize().width, scrsize.height - this.getSize().height - 30);
    }

    void fillPilotEventCombo() {
        this.jComboBoxPilotEvents.removeActionListener(this.pilotComboListener);
        this.jComboBoxPilotEvents.removeAllItems();
        Vector pilotEvents = Track.getInstance().getPilotEvents();
        this.getContentPane().remove(this.jComboBoxPilotEvents);
        if (pilotEvents != null && pilotEvents.size() > 0) {
            this.getContentPane().add((Component)this.jComboBoxPilotEvents, new MyGridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            for (int i = 1; i <= pilotEvents.size(); ++i) {
                this.jComboBoxPilotEvents.addItem("Pilot Event " + i);
            }
            this.jComboBoxPilotEvents.setSelectedIndex(-1);
            this.jComboBoxPilotEvents.addActionListener(this.pilotComboListener);
        }
    }

    private class MyGridBagConstraints
    extends GridBagConstraints {
        public MyGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets, int ipadx, int ipady) {
            this.gridx = gridx;
            this.gridy = gridy;
            this.gridwidth = gridwidth;
            this.gridheight = gridheight;
            this.fill = fill;
            this.ipadx = ipadx;
            this.ipady = ipady;
            this.insets = insets;
            this.anchor = anchor;
            this.weightx = weightx;
            this.weighty = weighty;
        }
    }

    protected class PilotComboListener
    implements ActionListener {
        protected PilotComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = TpNew.this.jComboBoxPilotEvents.getSelectedIndex();
            Sample s = (Sample)Track.getInstance().getPilotEvents().elementAt(index);
            int lat = Math.round(s.lat / 10) * 10;
            int lon = Math.round(s.lon / 10) * 10;
            TpNew.this.textFieldNameDesc.setText("P" + ++index + "event");
            TpNew.this.textFieldCapitalName.setText("P" + index + "EVE-");
            TpNew.this.jTextFieldLat.setText("" + lat / 1000);
            TpNew.this.jTextFieldLatDec.setText("" + lat % 1000);
            TpNew.this.jTextFieldLon.setText("" + lon / 1000);
            TpNew.this.jTextFieldLonDec.setText("" + lon % 1000);
            TpNew.this.jTextFieldDetail.setText("Pilot Event " + index);
        }
    }
}

