/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import glider.GDialog;
import glider.Home;
import glider.TpDataModel;
import glider.TpNew;
import glider.data.CSVTurnpoints;
import glider.data.Coordinate;
import glider.data.IGCturnpoints;
import glider.data.TurnPoint;
import glider.data.TurnPoints;
import glider.table.TableSorter;
import gui.JJDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class TpManager
extends JJDialog {
    private JPanel ivjJFrameContentPane = null;
    private JMenu ivjJMenuFile = null;
    private JMenu ivjJMenuGenerate = null;
    private JMenuItem ivjJMenuItemReadIGC = null;
    private JMenuItem ivjJMenuItemReadCSV = null;
    private JMenuItem ivjJMenuItemSave = null;
    private JMenuItem ivjJMenuItemSaveAs = null;
    private JScrollPane ivjJScrollPane1 = null;
    private JTable ivjScrollPaneTable = null;
    private JMenuBar ivjTpManagerJMenuBar = null;
    private JButton ivjJButton1 = null;
    private JButton ivjJButton2 = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JCheckBox ivjJCheckBoxFuen = null;
    private JCheckBox ivjJCheckBoxJutland = null;
    private JCheckBox ivjJCheckBoxZealand = null;
    private JCheckBox ivjJCheckBoxForeign = null;
    private JMenuItem ivjJMenuItem2 = null;
    private JLabel ivjJLabel1 = null;
    private TpDataModel ivjTpDataModel = null;
    private JSeparator ivjJSeparator1 = null;
    private JPanel ivjJPanel1 = null;
    private JSeparator ivjJSeparator2 = null;
    private boolean modified = false;
    private JMenuItem ivjJMenuItem1 = null;
    private TableSorter ivjTableSorter = null;
    private TableSorter ivjTableSorterFac = null;
    private JMenuItem ivjJMenuItemDM = null;
    private JSeparator ivjJSeparator3 = null;
    private TpNew ivjTpNew = null;
    private TpDataModel ivjTpDataModelFac = null;
    private JPanel ivjJPanel2 = null;
    private GridLayout ivjJPanel2GridLayout = null;
    private TableColumn ivjTcDate = null;
    private TableColumn ivjTcDescription = null;
    private TableColumn ivjTcDetail = null;
    private TableColumn ivjTcLandable = null;
    private TableColumn ivjTcLat = null;
    private TableColumn ivjTcLon = null;
    private TableColumn ivjTcName = null;
    private TableColumn ivjTcNumber = null;
    private JMenuItem ivjJMenuItemGPSLog = null;
    private JMenu ivjJMenu1 = null;

    public TpManager() {
        this.initialize();
    }

    public TpManager(Frame owner) {
        super(owner, "Vendepunkt Jongl\u00f8r", false, false);
        this.initialize();
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.natcat();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC10(ActionEvent arg1) {
        try {
            this.dm();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC11(ActionEvent arg1) {
        try {
            this.generateGpsLog();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.generateDbt();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.generateIGC();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(ActionEvent arg1) {
        try {
            this.delete();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(ActionEvent arg1) {
        try {
            this.natcatPFG();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7(ActionEvent arg1) {
        try {
            this.importIGC();
            this.setModified(true);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void readCSV(ActionEvent arg1) {
        try {
            this.importCSV();
            this.setModified(true);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC8(WindowEvent arg1) {
        try {
            this.updateConfig();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC9(WindowEvent arg1) {
        try {
            this.tpManager_WindowClosing();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(ActionEvent arg1) {
        try {
            this.reSize();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM10() {
        try {
            if (this.getTableSorter() != null) {
                this.getScrollPaneTable().setModel(this.getTableSorter());
            }
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM11(TableModelEvent arg1) {
        try {
            this.setModified(true);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2(ActionEvent arg1) {
        try {
            this.reSize();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM3(ActionEvent arg1) {
        try {
            this.reSize();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM4(ActionEvent arg1) {
        try {
            this.reSize();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM5(ActionEvent arg1) {
        try {
            this.getTpNew().show(this);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM7() {
        TpDataModel localValue = null;
        try {
            localValue = new TpDataModel(this.getJCheckBoxJutland(), this.getJCheckBoxFuen(), this.getJCheckBoxZealand(), this.getJCheckBoxForeign());
            this.setTpDataModel(localValue);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setTpDataModelFac(localValue);
    }

    private void connEtoM8() {
        TableSorter localValue = null;
        try {
            localValue = new TableSorter(this.getScrollPaneTable(), this.getTpDataModel());
            this.setTableSorter(localValue);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setTableSorterFac(localValue);
    }

    public void delete() {
        int row = this.getScrollPaneTable().getSelectedRow();
        String name = (String)this.getScrollPaneTable().getValueAt(row, 1);
        COMMON.getTurnPoints().remove(name);
        this.refresh();
    }

    public void dm() {
        if (GDialog.accept(this, "Opretter nye vendepunkter\n\nDe nye er DM vendepunkterne pr. " + COMMON.getTurnPoints().getDateDm() + "\nDet kan v\u00e6re en god ide, at gemme de nuv\u00e6rende, f\u00f8r du laver nye\n\nNB: DE NUV\u00c6RENDE SLETTES!", "Generer Vendepunkter")) {
            this.setCursor(new Cursor(3));
            COMMON.getTurnPoints().dm();
            this.refresh();
            this.setCursor(new Cursor(0));
        }
    }

    public void generateDbt() {
        if (this.getJCheckBoxForeign().isSelected() && this.getJCheckBoxFuen().isSelected() && this.getJCheckBoxJutland().isSelected() && this.getJCheckBoxZealand().isSelected()) {
            GDialog.info(this, "NB: Alle vendepunkter medtages,\novervej evt. kun at medtage dem,\ndu har brug for, f.eks. sj\u00e6llandske");
        }
        this.setCursor(new Cursor(3));
        File dbtFile = new File(Home.getResources() + "glider.dbt");
        TpDataModel model = this.getTpDataModel();
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(dbtFile));
            bw.write("500,3");
            bw.newLine();
            TurnPoints turnpoints = COMMON.getTurnPoints();
            for (int i = 0; i < model.getRowCount(); ++i) {
                TurnPoint tp = TurnPoints.get((String)model.getValueAt(i, 1));
                String type = tp.isLandable() ? ",X005" : ",X000";
                bw.write("1," + tp.getName() + "," + tp.getLatitude() + "," + tp.getLongitude() + type);
                bw.newLine();
            }
            bw.close();
            this.setCursor(new Cursor(0));
            GDialog.info(this, "Filen " + dbtFile + " er genereret.\nDen kan importeres i\nVL->catalogs->import from external files");
        }
        catch (IOException ioe) {
            this.setCursor(new Cursor(0));
            ioe.printStackTrace();
        }
    }

    public void generateGlider3file() {
        DecimalFormat dfLon = new DecimalFormat("0000000");
        File file = new File(Home.getResources() + "vendepkt.dat");
        this.setCursor(new Cursor(3));
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            TurnPoints turnpoints = COMMON.getTurnPoints();
            for (int i = 0; i < turnpoints.getTpSize(); ++i) {
                TurnPoint tp = TurnPoints.get(i);
                String num = "   " + tp.number;
                num = num.substring(num.length() - 3);
                bw.write(num + ";");
                Coordinate latlon = new Coordinate(tp.latlon);
                bw.write(latlon.getLatitude() / 10 + "N;");
                bw.write(dfLon.format((double)latlon.getLongitude() / 10.0) + "E;");
                bw.write(tp.description + ";");
                bw.newLine();
            }
            bw.close();
            this.setModified(false);
            this.setCursor(new Cursor(0));
            GDialog.info(this, "Filen " + file + " er genereret.\nDen kan anvendes i Glider version 2 og 3");
        }
        catch (IOException ioe) {
            this.setCursor(new Cursor(0));
            ioe.printStackTrace();
        }
    }

    public void generateGpsLog() {
        if (this.getJCheckBoxForeign().isSelected() && this.getJCheckBoxFuen().isSelected() && this.getJCheckBoxJutland().isSelected() && this.getJCheckBoxZealand().isSelected()) {
            GDialog.info(this, "NB: Alle vendepunkter medtages,\novervej evt. kun at medtage dem,\ndu har brug for, f.eks. sj\u00e6llandske");
        }
        this.setCursor(new Cursor(3));
        File gpsLogFile = new File(Home.getResources() + "waypoints.dta");
        TpDataModel model = this.getTpDataModel();
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(gpsLogFile));
            bw.write("500,3");
            bw.newLine();
            TurnPoints turnpoints = COMMON.getTurnPoints();
            for (int i = 0; i < model.getRowCount(); ++i) {
                TurnPoint tp = TurnPoints.get((String)model.getValueAt(i, 1));
                if (tp.isLandable()) {
                    bw.write("^");
                }
                bw.write(tp.getName() + "," + tp.getLatitude() / 100000 + "," + tp.getLatitude() / 1000 % 100 + "," + tp.getLatitude() / 10 % 100 + ",-" + tp.getLongitude() / 100000 + "," + tp.getLongitude() / 1000 % 100 + "," + tp.getLongitude() / 10 % 100 + ",0M");
                bw.newLine();
            }
            bw.close();
            this.setCursor(new Cursor(0));
            GDialog.info(this, "Filen " + gpsLogFile + " er genereret.\nDen kan indl\u00e6ses af Gps-log programmet");
        }
        catch (IOException ioe) {
            this.setCursor(new Cursor(0));
            ioe.printStackTrace();
        }
    }

    public void generateIGC() {
        File file = new File(Home.getResources() + "vendepkt.vpi");
        this.setCursor(new Cursor(3));
        JCheckBox ckBox = new JCheckBox();
        ckBox.setSelected(true);
        TpDataModel model = new TpDataModel(ckBox, ckBox, ckBox, ckBox);
        TableSorter ts = new TableSorter(this.getScrollPaneTable(), model);
        ts.ascending = true;
        ts.sortColumn = 3;
        ts.sort();
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            TurnPoints turnpoints = COMMON.getTurnPoints();
            for (int i = 0; i < turnpoints.getTpSize(); ++i) {
                TurnPoint tp = TurnPoints.get((String)ts.getValueAt(i, 1));
                IGCturnpoints.write(bw, tp);
            }
            bw.close();
            this.setModified(false);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    private JButton getJButton1() {
        if (this.ivjJButton1 == null) {
            try {
                this.ivjJButton1 = new JButton();
                this.ivjJButton1.setName("JButton1");
                this.ivjJButton1.setText("Tilf\u00f8j");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButton1;
    }

    private JButton getJButton2() {
        if (this.ivjJButton2 == null) {
            try {
                this.ivjJButton2 = new JButton();
                this.ivjJButton2.setName("JButton2");
                this.ivjJButton2.setText("Slet");
                this.ivjJButton2.setBackground(Color.red);
                this.ivjJButton2.setForeground(Color.white);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButton2;
    }

    private JCheckBox getJCheckBoxForeign() {
        if (this.ivjJCheckBoxForeign == null) {
            try {
                this.ivjJCheckBoxForeign = new JCheckBox();
                this.ivjJCheckBoxForeign.setName("JCheckBoxForeign");
                this.ivjJCheckBoxForeign.setText("Udland");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBoxForeign;
    }

    private JCheckBox getJCheckBoxFuen() {
        if (this.ivjJCheckBoxFuen == null) {
            try {
                this.ivjJCheckBoxFuen = new JCheckBox();
                this.ivjJCheckBoxFuen.setName("JCheckBoxFuen");
                this.ivjJCheckBoxFuen.setSelected(true);
                this.ivjJCheckBoxFuen.setText("Fyn");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBoxFuen;
    }

    private JCheckBox getJCheckBoxJutland() {
        if (this.ivjJCheckBoxJutland == null) {
            try {
                this.ivjJCheckBoxJutland = new JCheckBox();
                this.ivjJCheckBoxJutland.setName("JCheckBoxJutland");
                this.ivjJCheckBoxJutland.setSelected(true);
                this.ivjJCheckBoxJutland.setText("Jylland");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBoxJutland;
    }

    private JCheckBox getJCheckBoxZealand() {
        if (this.ivjJCheckBoxZealand == null) {
            try {
                this.ivjJCheckBoxZealand = new JCheckBox();
                this.ivjJCheckBoxZealand.setName("JCheckBoxZealand");
                this.ivjJCheckBoxZealand.setSelected(true);
                this.ivjJCheckBoxZealand.setText("Sj\u00e6lland");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBoxZealand;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJScrollPane1 = new GridBagConstraints();
                constraintsJScrollPane1.gridx = 0;
                constraintsJScrollPane1.gridy = 2;
                constraintsJScrollPane1.gridwidth = 4;
                constraintsJScrollPane1.fill = 1;
                constraintsJScrollPane1.weightx = 1.0;
                constraintsJScrollPane1.weighty = 1.0;
                constraintsJScrollPane1.insets = new Insets(4, 4, 4, 4);
                this.getJFrameContentPane().add((Component)this.getJScrollPane1(), constraintsJScrollPane1);
                GridBagConstraints constraintsJCheckBoxJutland = new GridBagConstraints();
                constraintsJCheckBoxJutland.gridx = 0;
                constraintsJCheckBoxJutland.gridy = 1;
                constraintsJCheckBoxJutland.weightx = 1.0;
                constraintsJCheckBoxJutland.insets = new Insets(4, 4, 4, 4);
                this.getJFrameContentPane().add((Component)this.getJCheckBoxJutland(), constraintsJCheckBoxJutland);
                GridBagConstraints constraintsJCheckBoxFuen = new GridBagConstraints();
                constraintsJCheckBoxFuen.gridx = 1;
                constraintsJCheckBoxFuen.gridy = 1;
                constraintsJCheckBoxFuen.weightx = 1.0;
                constraintsJCheckBoxFuen.insets = new Insets(4, 4, 4, 4);
                this.getJFrameContentPane().add((Component)this.getJCheckBoxFuen(), constraintsJCheckBoxFuen);
                GridBagConstraints constraintsJCheckBoxZealand = new GridBagConstraints();
                constraintsJCheckBoxZealand.gridx = 2;
                constraintsJCheckBoxZealand.gridy = 1;
                constraintsJCheckBoxZealand.weightx = 1.0;
                constraintsJCheckBoxZealand.insets = new Insets(4, 4, 4, 4);
                this.getJFrameContentPane().add((Component)this.getJCheckBoxZealand(), constraintsJCheckBoxZealand);
                GridBagConstraints constraintsJCheckBoxForeign = new GridBagConstraints();
                constraintsJCheckBoxForeign.gridx = 3;
                constraintsJCheckBoxForeign.gridy = 1;
                constraintsJCheckBoxForeign.weightx = 1.0;
                constraintsJCheckBoxForeign.insets = new Insets(4, 4, 4, 4);
                this.getJFrameContentPane().add((Component)this.getJCheckBoxForeign(), constraintsJCheckBoxForeign);
                GridBagConstraints constraintsJLabel1 = new GridBagConstraints();
                constraintsJLabel1.gridx = 0;
                constraintsJLabel1.gridy = 0;
                constraintsJLabel1.gridwidth = 4;
                constraintsJLabel1.fill = 2;
                constraintsJLabel1.weightx = 1.0;
                constraintsJLabel1.insets = new Insets(4, 4, 0, 4);
                this.getJFrameContentPane().add((Component)this.getJLabel1(), constraintsJLabel1);
                GridBagConstraints constraintsJPanel1 = new GridBagConstraints();
                constraintsJPanel1.gridx = 0;
                constraintsJPanel1.gridy = 3;
                constraintsJPanel1.gridwidth = 4;
                constraintsJPanel1.fill = 1;
                constraintsJPanel1.weightx = 1.0;
                this.getJFrameContentPane().add((Component)this.getJPanel1(), constraintsJPanel1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setText("Klik (evt. med shift) p\u00e5 en overskrift for at sortere. Du kan ogs\u00e5 flytte kollonner ved at tr\u00e6kke med musen");
                this.ivjJLabel1.setHorizontalAlignment(0);
                this.ivjJLabel1.setHorizontalTextPosition(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel1;
    }

    private JMenu getJMenu1() {
        if (this.ivjJMenu1 == null) {
            try {
                this.ivjJMenu1 = new JMenu();
                this.ivjJMenu1.setName("JMenu1");
                this.ivjJMenu1.setText("H\u00e5ndholdt PC");
                this.ivjJMenu1.add(this.getJMenuItemGPSLog());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenu1;
    }

    private JMenu getJMenuFile() {
        if (this.ivjJMenuFile == null) {
            try {
                this.ivjJMenuFile = new JMenu();
                this.ivjJMenuFile.setName("JMenuFile");
                this.ivjJMenuFile.setText("Vendepunkter");
                this.ivjJMenuFile.add(this.getJMenuItemSave());
                this.ivjJMenuFile.add(this.getJSeparator2());
                this.ivjJMenuFile.add(this.getJMenuItemReadIGC());
                this.ivjJMenuFile.add(this.getJMenuItemReadCSV());
                this.ivjJMenuFile.add(this.getJSeparator1());
                this.ivjJMenuFile.add(this.getJMenuItemSaveAs());
                this.ivjJMenuFile.add(this.getJMenuItem1());
                this.ivjJMenuFile.add(this.getJSeparator3());
                this.ivjJMenuFile.add(this.getJMenuItemDM());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenuFile;
    }

    private JMenu getJMenuGenerate() {
        if (this.ivjJMenuGenerate == null) {
            try {
                this.ivjJMenuGenerate = new JMenu();
                this.ivjJMenuGenerate.setName("JMenuGenerate");
                this.ivjJMenuGenerate.setText("Generer andre formater");
                this.ivjJMenuGenerate.add(this.getJMenuItem2());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenuGenerate;
    }

    private JMenuItem getJMenuItem1() {
        if (this.ivjJMenuItem1 == null) {
            try {
                this.ivjJMenuItem1 = new JMenuItem();
                this.ivjJMenuItem1.setName("JMenuItem1");
                this.ivjJMenuItem1.setText("National katalog");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenuItem1;
    }

    private JMenuItem getJMenuItem2() {
        if (this.ivjJMenuItem2 == null) {
            try {
                this.ivjJMenuItem2 = new JMenuItem();
                this.ivjJMenuItem2.setName("JMenuItem2");
                this.ivjJMenuItem2.setText("Volkslogger dbt fil");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenuItem2;
    }

    private JMenuItem getJMenuItemDM() {
        if (this.ivjJMenuItemDM == null) {
            try {
                this.ivjJMenuItemDM = new JMenuItem();
                this.ivjJMenuItemDM.setName("JMenuItemDM");
                this.ivjJMenuItemDM.setText("DM Vendepunkter");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenuItemDM;
    }

    private JMenuItem getJMenuItemGPSLog() {
        if (this.ivjJMenuItemGPSLog == null) {
            try {
                this.ivjJMenuItemGPSLog = new JMenuItem();
                this.ivjJMenuItemGPSLog.setName("JMenuItemGPSLog");
                this.ivjJMenuItemGPSLog.setText("Gps-log vendepunkt fil");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenuItemGPSLog;
    }

    private JMenuItem getJMenuItemReadIGC() {
        if (this.ivjJMenuItemReadIGC == null) {
            try {
                this.ivjJMenuItemReadIGC = new JMenuItem();
                this.ivjJMenuItemReadIGC.setName("JMenuItemOpen");
                this.ivjJMenuItemReadIGC.setText("Importer IGC vp fil...");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenuItemReadIGC;
    }

    private JMenuItem getJMenuItemReadCSV() {
        if (this.ivjJMenuItemReadCSV == null) {
            try {
                this.ivjJMenuItemReadCSV = new JMenuItem();
                this.ivjJMenuItemReadCSV.setName("JMenuItemReadCSV");
                this.ivjJMenuItemReadCSV.setText("Importer CSV vp fil...");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenuItemReadCSV;
    }

    private JMenuItem getJMenuItemSave() {
        if (this.ivjJMenuItemSave == null) {
            try {
                this.ivjJMenuItemSave = new JMenuItem();
                this.ivjJMenuItemSave.setName("JMenuItemSave");
                this.ivjJMenuItemSave.setText("Gem vendepunkter");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenuItemSave;
    }

    private JMenuItem getJMenuItemSaveAs() {
        if (this.ivjJMenuItemSaveAs == null) {
            try {
                this.ivjJMenuItemSaveAs = new JMenuItem();
                this.ivjJMenuItemSaveAs.setName("JMenuItemSaveAs");
                this.ivjJMenuItemSaveAs.setText("Termik Liga / Sj\u00e6lland");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJMenuItemSaveAs;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJButton1 = new GridBagConstraints();
                constraintsJButton1.gridx = 1;
                constraintsJButton1.gridy = 0;
                constraintsJButton1.weightx = 1.0;
                constraintsJButton1.weighty = 1.0;
                this.getJPanel1().add((Component)this.getJButton1(), constraintsJButton1);
                GridBagConstraints constraintsJButton2 = new GridBagConstraints();
                constraintsJButton2.gridx = 2;
                constraintsJButton2.gridy = 0;
                constraintsJButton2.weightx = 1.0;
                constraintsJButton2.weighty = 1.0;
                this.getJPanel1().add((Component)this.getJButton2(), constraintsJButton2);
                GridBagConstraints constraintsJPanel2 = new GridBagConstraints();
                constraintsJPanel2.gridx = 0;
                constraintsJPanel2.gridy = 0;
                constraintsJPanel2.weightx = 1.0;
                constraintsJPanel2.weighty = 1.0;
                constraintsJPanel2.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJPanel2(), constraintsJPanel2);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setBorder(new TitledBorder("Uploades til logger"));
                this.ivjJPanel2.setLayout(this.getJPanel2GridLayout());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private GridLayout getJPanel2GridLayout() {
        GridLayout ivjJPanel2GridLayout = null;
        try {
            ivjJPanel2GridLayout = new GridLayout();
            ivjJPanel2GridLayout.setHgap(5);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjJPanel2GridLayout;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.ivjJScrollPane1.setVerticalScrollBarPolicy(22);
                this.ivjJScrollPane1.setHorizontalScrollBarPolicy(31);
                this.getJScrollPane1().setViewportView(this.getScrollPaneTable());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JSeparator getJSeparator1() {
        if (this.ivjJSeparator1 == null) {
            try {
                this.ivjJSeparator1 = new JSeparator();
                this.ivjJSeparator1.setName("JSeparator1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator1;
    }

    private JSeparator getJSeparator2() {
        if (this.ivjJSeparator2 == null) {
            try {
                this.ivjJSeparator2 = new JSeparator();
                this.ivjJSeparator2.setName("JSeparator2");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator2;
    }

    private JSeparator getJSeparator3() {
        if (this.ivjJSeparator3 == null) {
            try {
                this.ivjJSeparator3 = new JSeparator();
                this.ivjJSeparator3.setName("JSeparator3");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator3;
    }

    private JTable getScrollPaneTable() {
        if (this.ivjScrollPaneTable == null) {
            try {
                this.ivjScrollPaneTable = new JTable();
                this.ivjScrollPaneTable.setName("ScrollPaneTable");
                this.getJScrollPane1().setColumnHeaderView(this.ivjScrollPaneTable.getTableHeader());
                this.getJScrollPane1().getViewport().setScrollMode(2);
                this.ivjScrollPaneTable.setAutoResizeMode(3);
                this.ivjScrollPaneTable.setModel(new DefaultTableModel());
                this.ivjScrollPaneTable.setCellSelectionEnabled(true);
                this.ivjScrollPaneTable.setColumnSelectionAllowed(true);
                this.ivjScrollPaneTable.setColumnModel(new DefaultTableColumnModel());
                this.ivjScrollPaneTable.setAutoCreateColumnsFromModel(false);
                this.ivjScrollPaneTable.setBounds(0, 0, 200, 200);
                this.ivjScrollPaneTable.addColumn(this.getTcNumber());
                this.ivjScrollPaneTable.addColumn(this.getTcName());
                this.ivjScrollPaneTable.addColumn(this.getTcLandable());
                this.ivjScrollPaneTable.addColumn(this.getTcDescription());
                this.ivjScrollPaneTable.addColumn(this.getTcLat());
                this.ivjScrollPaneTable.addColumn(this.getTcLon());
                this.ivjScrollPaneTable.addColumn(this.getTcDate());
                this.ivjScrollPaneTable.addColumn(this.getTcDetail());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjScrollPaneTable;
    }

    private TableSorter getTableSorter() {
        return this.ivjTableSorter;
    }

    private TableSorter getTableSorterFac() {
        return this.ivjTableSorterFac;
    }

    private TableColumn getTcDate() {
        if (this.ivjTcDate == null) {
            try {
                this.ivjTcDate = new TableColumn();
                this.ivjTcDate.setModelIndex(6);
                this.ivjTcDate.setHeaderValue("Dato");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTcDate;
    }

    private TableColumn getTcDescription() {
        if (this.ivjTcDescription == null) {
            try {
                this.ivjTcDescription = new TableColumn();
                this.ivjTcDescription.setModelIndex(3);
                this.ivjTcDescription.setHeaderValue("Beskrivelse");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTcDescription;
    }

    private TableColumn getTcDetail() {
        if (this.ivjTcDetail == null) {
            try {
                this.ivjTcDetail = new TableColumn();
                this.ivjTcDetail.setModelIndex(7);
                this.ivjTcDetail.setHeaderValue("Detaljer");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTcDetail;
    }

    private TableColumn getTcLandable() {
        if (this.ivjTcLandable == null) {
            try {
                this.ivjTcLandable = new TableColumn();
                this.ivjTcLandable.setModelIndex(2);
                this.ivjTcLandable.setHeaderValue("Landbar");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTcLandable;
    }

    private TableColumn getTcLat() {
        if (this.ivjTcLat == null) {
            try {
                this.ivjTcLat = new TableColumn();
                this.ivjTcLat.setModelIndex(4);
                this.ivjTcLat.setHeaderValue("Bredde");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTcLat;
    }

    private TableColumn getTcLon() {
        if (this.ivjTcLon == null) {
            try {
                this.ivjTcLon = new TableColumn();
                this.ivjTcLon.setModelIndex(5);
                this.ivjTcLon.setHeaderValue("L\u00e6ngde");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTcLon;
    }

    private TableColumn getTcName() {
        if (this.ivjTcName == null) {
            try {
                this.ivjTcName = new TableColumn();
                this.ivjTcName.setModelIndex(1);
                this.ivjTcName.setHeaderValue("Navn");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTcName;
    }

    private TableColumn getTcNumber() {
        if (this.ivjTcNumber == null) {
            try {
                this.ivjTcNumber = new TableColumn();
                this.ivjTcNumber.setHeaderValue("Nummer");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTcNumber;
    }

    private TpDataModel getTpDataModel() {
        return this.ivjTpDataModel;
    }

    private TpDataModel getTpDataModelFac() {
        return this.ivjTpDataModelFac;
    }

    private JMenuBar getTpManagerJMenuBar() {
        if (this.ivjTpManagerJMenuBar == null) {
            try {
                this.ivjTpManagerJMenuBar = new JMenuBar();
                this.ivjTpManagerJMenuBar.setName("TpManagerJMenuBar");
                this.ivjTpManagerJMenuBar.add(this.getJMenuFile());
                this.ivjTpManagerJMenuBar.add(this.getJMenuGenerate());
                this.ivjTpManagerJMenuBar.add(this.getJMenu1());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTpManagerJMenuBar;
    }

    private TpNew getTpNew() {
        if (this.ivjTpNew == null) {
            try {
                this.ivjTpNew = new TpNew();
                this.ivjTpNew.setName("TpNew");
                this.ivjTpNew.setDefaultCloseOperation(2);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTpNew;
    }

    private void handleException(Throwable exception) {
        COMMON.errorLog(this.getClass().getName(), exception);
    }

    public void importIGC() {
        this.setCursor(new Cursor(3));
        TurnPoints tps = COMMON.getTurnPoints();
        tps.removeAllElements();
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(COMMON.getDir());
        fileChooser.rescanCurrentDirectory();
        fileChooser.setDialogTitle("Indl\u00e6s IGC vendepunkts fil");
        fileChooser.setApproveButtonText("\u00c5bn");
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            IGCturnpoints.read(br, tps.getTpList());
            this.getTpDataModel().tableChanged();
            this.reSize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    public void importCSV() {
        this.setCursor(new Cursor(3));
        TurnPoints tps = COMMON.getTurnPoints();
        TurnPoints.to_String();
        tps.removeAllElements();
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(COMMON.getDir());
        fileChooser.rescanCurrentDirectory();
        fileChooser.setDialogTitle("Indl\u00e6s CSV vendepunkts fil");
        fileChooser.setApproveButtonText("\u00c5bn");
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".csv");
            }

            @Override
            public String getDescription() {
                return "*.csv fil fra http://soaringweb.org/TP/EU.html#DK";
            }
        });
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            CSVTurnpoints.read(br, tps.getTpList());
            this.getTpDataModel().tableChanged();
            this.reSize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setCursor(new Cursor(0));
    }

    private void initConnections() throws Exception {
        this.getJCheckBoxJutland().addActionListener(this.ivjEventHandler);
        this.getJCheckBoxFuen().addActionListener(this.ivjEventHandler);
        this.getJCheckBoxZealand().addActionListener(this.ivjEventHandler);
        this.getJCheckBoxForeign().addActionListener(this.ivjEventHandler);
        this.getJMenuItem2().addActionListener(this.ivjEventHandler);
        this.getJMenuItemSave().addActionListener(this.ivjEventHandler);
        this.getJButton2().addActionListener(this.ivjEventHandler);
        this.getJMenuItemSaveAs().addActionListener(this.ivjEventHandler);
        this.getJMenuItemReadIGC().addActionListener(this.ivjEventHandler);
        this.getJMenuItemReadCSV().addActionListener(this.ivjEventHandler);
        this.addWindowListener(this.ivjEventHandler);
        this.getJButton1().addActionListener(this.ivjEventHandler);
        this.getJMenuItem1().addActionListener(this.ivjEventHandler);
        this.getJMenuItemDM().addActionListener(this.ivjEventHandler);
        this.getJMenuItemGPSLog().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("TpManager");
            this.setDefaultCloseOperation(2);
            this.setJMenuBar(this.getTpManagerJMenuBar());
            this.setSize(683, 441);
            this.setContentPane(this.getJFrameContentPane());
            this.initConnections();
            this.connEtoM7();
            this.connEtoM8();
            this.connEtoM10();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public static void main(String[] args) {
        try {
            TpManager aTpManager = new TpManager();
            aTpManager.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            aTpManager.setVisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void natcat() {
        if (GDialog.accept(this, "Opretter nye vendepunkter\n\nDe nye er fra national kataloget pr. " + COMMON.getTurnPoints().getDateNatCatE() + "\nDet kan v\u00e6re en god ide, at gemme de nuv\u00e6rende, f\u00f8r du laver nye\n\nNB: DE NUV\u00c6RENDE SLETTES!", "Generer Vendepunkter")) {
            this.setCursor(new Cursor(3));
            COMMON.getTurnPoints().nationalCatalog();
            this.refresh();
            this.setCursor(new Cursor(0));
        }
    }

    public void natcatPFG() {
        if (GDialog.accept(this, "Opretter nye vendepunkter\n\nDe nye er Sj\u00e6llandske fra Termik Ligaen pr. " + COMMON.getTurnPoints().getDateNatCatE() + "\nDet kan v\u00e6re en god ide, at gemme de nuv\u00e6rende, f\u00f8r du laver nye\n\nNB: DE NUV\u00c6RENDE SLETTES!", "Generer Vendepunkter")) {
            this.setCursor(new Cursor(3));
            COMMON.getTurnPoints().nationalCatalog();
            this.refresh();
            this.setCursor(new Cursor(0));
        }
    }

    public void refresh() {
        this.getTpDataModel().tableChanged();
        this.reSize();
        this.setModified(true);
    }

    public void reSize() {
        this.getScrollPaneTable().tableChanged(null);
    }

    public void setModified(boolean newValue) {
        this.modified = newValue;
        Color color = this.modified ? Color.red : Color.black;
        this.getJMenuFile().setForeground(color);
        this.getJMenuItemSave().setForeground(color);
        this.getJMenuFile().repaint();
        this.getJMenuItemSave().repaint();
    }

    private void setTableSorter(TableSorter newValue) {
        if (this.ivjTableSorter != newValue) {
            try {
                this.ivjTableSorter = newValue;
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    private void setTableSorterFac(TableSorter newValue) {
        if (this.ivjTableSorterFac != newValue) {
            try {
                this.ivjTableSorterFac = newValue;
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    private void setTpDataModel(TpDataModel newValue) {
        if (this.ivjTpDataModel != newValue) {
            try {
                if (this.ivjTpDataModel != null) {
                    this.ivjTpDataModel.removeTableModelListener(this.ivjEventHandler);
                }
                this.ivjTpDataModel = newValue;
                if (this.ivjTpDataModel != null) {
                    this.ivjTpDataModel.addTableModelListener(this.ivjEventHandler);
                }
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    private void setTpDataModelFac(TpDataModel newValue) {
        if (this.ivjTpDataModelFac != newValue) {
            try {
                this.ivjTpDataModelFac = newValue;
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(true);
        if (value) {
            this.getJCheckBoxForeign().setSelected(COMMON.config.TpForeign);
            this.getJCheckBoxFuen().setSelected(COMMON.config.TpFuen);
            this.getJCheckBoxJutland().setSelected(COMMON.config.TpJutland);
            this.getJCheckBoxZealand().setSelected(COMMON.config.TpZealand);
            this.getRootPane().setEnabled(false);
            this.reSize();
        }
    }

    public void showLast() {
        JScrollBar sb = this.getJScrollPane1().getVerticalScrollBar();
        sb.setValueIsAdjusting(true);
        sb.setValue(sb.getMaximum());
        sb.setValueIsAdjusting(false);
    }

    public void tpManager_WindowClosing() {
        if (this.isModified()) {
            if (GDialog.accept(this, "Skal \u00e6ndringerne gemmes?", "Ugemte \u00e6ndringer")) {
                this.generateIGC();
            } else {
                this.getTpDataModel().reread();
                COMMON.getTurnPoints().reread();
            }
            this.setModified(false);
        }
    }

    public void updateConfig() {
        COMMON.config.TpForeign = this.getJCheckBoxForeign().isSelected();
        COMMON.config.TpFuen = this.getJCheckBoxFuen().isSelected();
        COMMON.config.TpJutland = this.getJCheckBoxJutland().isSelected();
        COMMON.config.TpZealand = this.getJCheckBoxZealand().isSelected();
    }

    class IvjEventHandler
    implements TableModelListener,
    ActionListener,
    WindowListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TpManager.this.getJCheckBoxJutland()) {
                TpManager.this.connEtoM1(e);
            }
            if (e.getSource() == TpManager.this.getJCheckBoxFuen()) {
                TpManager.this.connEtoM2(e);
            }
            if (e.getSource() == TpManager.this.getJCheckBoxZealand()) {
                TpManager.this.connEtoM3(e);
            }
            if (e.getSource() == TpManager.this.getJCheckBoxForeign()) {
                TpManager.this.connEtoM4(e);
            }
            if (e.getSource() == TpManager.this.getJMenuItem2()) {
                TpManager.this.connEtoC2(e);
            }
            if (e.getSource() == TpManager.this.getJMenuItemSave()) {
                TpManager.this.connEtoC4(e);
            }
            if (e.getSource() == TpManager.this.getJButton2()) {
                TpManager.this.connEtoC5(e);
            }
            if (e.getSource() == TpManager.this.getJMenuItemSaveAs()) {
                TpManager.this.connEtoC6(e);
            }
            if (e.getSource() == TpManager.this.getJMenuItemReadIGC()) {
                TpManager.this.connEtoC7(e);
            }
            if (e.getSource() == TpManager.this.getJMenuItemReadCSV()) {
                TpManager.this.readCSV(e);
            }
            if (e.getSource() == TpManager.this.getJButton1()) {
                TpManager.this.connEtoM5(e);
            }
            if (e.getSource() == TpManager.this.getJMenuItem1()) {
                TpManager.this.connEtoC1(e);
            }
            if (e.getSource() == TpManager.this.getJMenuItemDM()) {
                TpManager.this.connEtoC10(e);
            }
            if (e.getSource() == TpManager.this.getJMenuItemGPSLog()) {
                TpManager.this.connEtoC11(e);
            }
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getSource() == TpManager.this.getTpDataModel()) {
                TpManager.this.connEtoM11(e);
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (e.getSource() == TpManager.this) {
                TpManager.this.connEtoC8(e);
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (e.getSource() == TpManager.this) {
                TpManager.this.connEtoC9(e);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }
}

