/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import glider.GDialog;
import glider.TpTypes;
import glider.data.TurnPoint;
import glider.data.TurnPoints;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class TpDataModel
extends AbstractTableModel
implements TpTypes {
    private int[] index = null;
    private JCheckBox showJutland = null;
    private JCheckBox showFuen = null;
    private JCheckBox showZealand = null;
    private JCheckBox showForeign = null;
    private boolean lastJutland = false;
    private boolean lastFuen = false;
    private boolean lastZealand = false;
    private boolean lastForeign = false;

    public TpDataModel(JCheckBox showJutland, JCheckBox showFuen, JCheckBox showZealand, JCheckBox showForeign) {
        this.showJutland = showJutland;
        this.showFuen = showFuen;
        this.showZealand = showZealand;
        this.showForeign = showForeign;
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return Integer.class;
        }
        if (column == 2) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return TurnPoint.getColumns();
    }

    @Override
    public int getRowCount() {
        if (this.showJutland.isSelected() != this.lastJutland) {
            this.index = null;
            this.lastJutland = this.showJutland.isSelected();
        }
        if (this.showFuen.isSelected() != this.lastFuen) {
            this.index = null;
            this.lastFuen = this.showFuen.isSelected();
        }
        if (this.showZealand.isSelected() != this.lastZealand) {
            this.index = null;
            this.lastZealand = this.showZealand.isSelected();
        }
        if (this.showForeign.isSelected() != this.lastForeign) {
            this.index = null;
            this.lastForeign = this.showForeign.isSelected();
        }
        if (this.index == null) {
            int i;
            TurnPoints turnpoints = COMMON.getTurnPoints();
            int[] tmp = new int[turnpoints.getTpSize()];
            int ind = 0;
            block6: for (i = 0; i < tmp.length; ++i) {
                TurnPoint tp = TurnPoints.get(i);
                switch (tp.location()) {
                    case 0: {
                        if (!this.lastJutland) continue block6;
                        tmp[ind++] = i;
                        continue block6;
                    }
                    case 1: {
                        if (!this.lastFuen) continue block6;
                        tmp[ind++] = i;
                        continue block6;
                    }
                    case 2: {
                        if (!this.lastZealand) continue block6;
                        tmp[ind++] = i;
                        continue block6;
                    }
                    case 3: {
                        if (!this.lastForeign) continue block6;
                        tmp[ind++] = i;
                    }
                }
            }
            this.index = new int[ind];
            for (i = 0; i < ind; ++i) {
                this.index[i] = tmp[i];
            }
        }
        return this.index.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        COMMON.getTurnPoints();
        TurnPoint tp = TurnPoints.get(this.index[row]);
        switch (column) {
            case 0: {
                return tp.getNumber();
            }
            case 1: {
                return tp.getName();
            }
            case 2: {
                return tp.getLandable();
            }
            case 3: {
                return tp.getDescription();
            }
            case 4: {
                return tp.getLat();
            }
            case 5: {
                return tp.getLon();
            }
            case 6: {
                return tp.getDate();
            }
            case 7: {
                return tp.getDetail();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void reread() {
        this.index = null;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (aValue.equals(this.getValueAt(row, column))) {
            return;
        }
        TurnPoints turnpoints = COMMON.getTurnPoints();
        TurnPoint tp = TurnPoints.get(this.index[row]);
        switch (column) {
            case 0: {
                try {
                    tp.setNumber(Integer.parseInt((String)aValue));
                }
                catch (NumberFormatException nfe) {
                    GDialog.error(this.showForeign.getParent(), "Nummeret skal v\u00e6re et heltal");
                }
                break;
            }
            case 1: {
                String name = ((String)aValue).toUpperCase();
                name = TpDataModel.validChar(name);
                if (name.equals(this.getValueAt(row, column))) {
                    return;
                }
                if (name.length() != 6) {
                    GDialog.error(this.showForeign.getParent(), "Der skal v\u00e6re 6 tegn i forkortelsen");
                    return;
                }
                char c = name.charAt(5);
                if ("ABCDFGHJKNRSTVXY0-".indexOf(c) < 0) {
                    String msg = "Det sidste tegn i forkortelsen\nskal v\u00e6re et af f\u00f8lgende:\n";
                    for (int i = 0; i < TpTypes.type.length; ++i) {
                        msg = msg + TpTypes.type[i] + "\n";
                    }
                    GDialog.error(this.showForeign.getParent(), msg);
                    return;
                }
                if (TurnPoints.isUsed(name)) {
                    GDialog.error(this.showForeign.getParent(), "Duplikeret forkortelse, anvend en anden");
                    break;
                }
                tp.setName(name);
                break;
            }
            case 2: {
                tp.setLandable((Boolean)aValue);
                break;
            }
            case 3: {
                tp.setDescription((String)aValue);
                break;
            }
            case 4: {
                try {
                    tp.setLat((String)aValue);
                }
                catch (NumberFormatException nfe) {
                    GDialog.error(this.showForeign.getParent(), "Forkert format.\nEksempel: 5545.123");
                }
                break;
            }
            case 5: {
                try {
                    tp.setLon((String)aValue);
                }
                catch (NumberFormatException nfe) {
                    GDialog.error(this.showForeign.getParent(), "Forkert format.\nEksempel: 947.123");
                }
                break;
            }
            case 6: {
                try {
                    SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
                    String dateS = (String)aValue;
                    if (dateS.length() == 0) {
                        dateS = df.format(new Date());
                    }
                    if (dateS.length() != 6) {
                        throw new NumberFormatException("how do");
                    }
                    if (df.parse(dateS) == null) {
                        throw new NumberFormatException("how do");
                    }
                    tp.setDate(dateS);
                }
                catch (Exception e) {
                    GDialog.error(this.showForeign.getParent(), "Forkert dato.\n\nSkal v\u00e6re DDMMYY, hvor\nDD=dag\nMM=m\u00e5ned\nYY=2 sidste cifre i \u00e5rstal\nEksempel: 240600 for 24/6 - 2000\n\nNB: Tomt felt giver dd.\n\nPS: Det er normalt ikke n\u00f8dvendigt at \u00e6ndre dette felt,\ndet opdateres automatisk til dd. ved \u00e6ndringer");
                }
                break;
            }
            case 7: {
                tp.setDetail((String)aValue);
            }
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void tableChanged() {
        this.lastJutland = false;
        this.lastFuen = false;
        this.lastZealand = false;
        this.lastForeign = false;
    }

    public static String validChar(String s) {
        s = s.replace('\u00c6', 'A');
        s = s.replace('\u00d8', '0');
        s = s.replace('\u00c5', 'A');
        return s;
    }
}

