/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import glider.GDialog;
import glider.Home;
import glider.Line;
import glider.data.Coordinate;
import glider.data.Task;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class Tasks {
    private static Vector taskList;
    private static String file;
    private static Line line;

    public Tasks() {
        this.load();
    }

    Coordinate getLatLong() {
        String cs = line.getItem();
        String lats = cs.substring(0, cs.indexOf(78));
        String longs = cs.substring(cs.indexOf(78) + 1, cs.indexOf(69));
        return new Coordinate(new Integer(lats) * 10, new Integer(longs) * 10);
    }

    int getNumber() {
        String ns = line.getItem();
        return new Integer(ns);
    }

    public Task getTask(int number) {
        if (number > taskList.size()) {
            return null;
        }
        if (number < 1) {
            return null;
        }
        return (Task)taskList.elementAt(--number);
    }

    private double getTaskLength() {
        String ls = line.getItem();
        return new Double(ls);
    }

    public int getTaskNumber(Task task) {
        Task t;
        int i;
        for (i = 0; i < taskList.size(); ++i) {
            t = (Task)taskList.elementAt(i);
            if (!t.equals(task)) continue;
            return i + 1;
        }
        for (i = 0; i < taskList.size(); ++i) {
            t = (Task)taskList.elementAt(i);
            if (!(t.length() > task.length())) continue;
            return i;
        }
        return -1;
    }

    private boolean isDuplicate(Task newTask) {
        for (int i = 0; i < taskList.size(); ++i) {
            Task t = (Task)taskList.elementAt(i);
            if (!t.equals(newTask)) continue;
            return true;
        }
        return false;
    }

    public void add(Task t) {
        if (this.isDuplicate(t)) {
            return;
        }
        taskList.addElement(t);
        this.sortTasks();
        this.save();
    }

    public int count() {
        return taskList.size();
    }

    public void delete(int number) {
        if (number > taskList.size()) {
            return;
        }
        if (number < 1) {
            return;
        }
        taskList.removeElementAt(number - 1);
        this.save();
    }

    void load() {
        if (taskList != null) {
            return;
        }
        taskList = new Vector();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            while (line.set(br.readLine()) != null) {
                Task t = new Task();
                int number = this.getNumber();
                t.setLength(this.getTaskLength());
                while (line.length() > 10) {
                    t.addTurnpoint(this.getLatLong());
                }
                taskList.addElement(t);
            }
            br.close();
        }
        catch (Exception e) {
            GDialog.error("Fejl ved l\u00e6sning af " + file + ":\n" + line + "\n" + e);
            try {
                br.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void save() {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < taskList.size(); ++i) {
                Task t = (Task)taskList.elementAt(i);
                bw.write(COMMON.getContest().formatString("" + (i + 1), 3));
                bw.write("\t");
                bw.write(COMMON.getContest().format(t.length(), 2, 6, '.'));
                for (int j = 0; j < t.size(); ++j) {
                    bw.write(" " + t.coordinate(j).getLatitude() / 10 + "N");
                    bw.write("" + t.coordinate(j).getLongitude() / 10 + "E");
                }
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            GDialog.error("Kunne ikke skrive " + file);
        }
    }

    private void sortTasks() {
        boolean unsorted = true;
        while (unsorted) {
            unsorted = false;
            for (int i = 0; i < taskList.size() - 1; ++i) {
                if (!(((Task)taskList.elementAt(i)).length() > ((Task)taskList.elementAt(i + 1)).length())) continue;
                unsorted = true;
                taskList.insertElementAt(taskList.elementAt(i + 1), i);
                taskList.removeElementAt(i + 2);
            }
        }
    }

    static {
        file = Home.getResources() + "opgaver.dat";
        line = new Line();
    }
}

