/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import glider.Tasks;
import glider.data.Contest;
import glider.data.Coordinate;
import glider.data.Task;
import glider.data.TurnPoints;
import glider.utils.Utils;
import java.awt.Color;
import java.awt.Font;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;

class TaskLister
extends JList {
    private static Tasks tasks = null;
    private static TurnPoints turnpoints = null;
    private static JLabel JLabelFAI = null;
    private static JTextField jTextFieldLength = null;
    private static final DefaultListModel model = new DefaultListModel();

    public TaskLister() {
        this.setBackground(Color.gray);
        this.setForeground(Color.green);
        this.setFont(new Font("monospaced", 0, 12));
        this.setModel(model);
    }

    public void init(Tasks tasks, JLabel JLabelFAI) {
        TaskLister.tasks = tasks;
        turnpoints = COMMON.getTurnPoints();
        TaskLister.JLabelFAI = JLabelFAI;
    }

    public void init(Tasks tasks, JLabel JLabelFAI, JTextField jTextFieldLength) {
        TaskLister.tasks = tasks;
        turnpoints = COMMON.getTurnPoints();
        TaskLister.JLabelFAI = JLabelFAI;
        TaskLister.jTextFieldLength = jTextFieldLength;
    }

    public void showTask(Task t) {
        int LINELGT = 27;
        double sum = 0.0;
        Coordinate prevPoint = null;
        Contest c = COMMON.getContest();
        model.removeAllElements();
        if (t == null) {
            jTextFieldLength.setText("");
            return;
        }
        for (int i = 0; i < t.size(); ++i) {
            Coordinate point = t.coordinate(i);
            String s = turnpoints.getTpName(point);
            String s2 = "";
            if (prevPoint != null) {
                double d = Utils.distance(prevPoint, point);
                sum += d;
                s2 = c.format(d, 2, 27 - s.length());
            }
            model.addElement(s + s2);
            prevPoint = point;
        }
        if (t.isFai()) {
            JLabelFAI.setForeground(Color.red);
        } else {
            JLabelFAI.setForeground(JLabelFAI.getBackground());
        }
        JLabelFAI.setText("FAI");
        model.addElement(c.formatString("-------", 27));
        String s = c.format(sum, 2, 27) + " km";
        model.addElement(s);
        if (jTextFieldLength != null) {
            jTextFieldLength.setText("" + Math.round(sum));
        }
        t.setLength(sum);
    }
}

