/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import glider.RoundButton;
import glider.TaskLister;
import glider.Tasks;
import glider.data.Task;
import glider.utils.Utils;
import gui.JJDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TaskBrowser
extends JJDialog
implements ActionListener,
FocusListener,
KeyListener,
WindowListener {
    private JButton jButtonOK = null;
    private JPanel ivjJFrameContentPane = null;
    private JLabel ivjJLabel6 = null;
    private JLabel ivjJLabel7 = null;
    private JLabel ivjJLabel8 = null;
    private JPanel ivjJPanel2 = null;
    private JTextField ivjJTextField1 = null;
    private JTextField ivjJTextField2 = null;
    private TaskLister ivjTaskLister = null;
    private JButton ivjJButton2 = null;
    private JPanel ivjJPanel3 = null;
    private RoundButton ivjRoundButton1 = null;
    private RoundButton ivjRoundButton2 = null;
    private JPanel ivjJPanel1 = null;

    public TaskBrowser(Frame owner) {
        super(owner, "V\u00e6lg Opgave", false, false);
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getJTextField1()) {
            this.connEtoC2(e);
        }
        if (e.getSource() == this.getJTextField2()) {
            this.connEtoC3(e);
        }
        if (e.getSource() == this.getJButtonOK()) {
            this.connEtoC4(e);
        }
        if (e.getSource() == this.getJButtonOK()) {
            this.connEtoM1(e);
        }
        if (e.getSource() == this.getJButton2()) {
            this.connEtoC6(e);
        }
        if (e.getSource() == this.getRoundButton1()) {
            this.connEtoC7(e);
        }
        if (e.getSource() == this.getRoundButton2()) {
            this.connEtoC1(e);
        }
    }

    public void checkKeyPress(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 40) {
            this.nextTask();
        } else if (keyEvent.getKeyCode() == 38) {
            this.previousTask();
        } else if (keyEvent.getKeyCode() == 34) {
            this.next10Task();
        } else if (keyEvent.getKeyCode() == 33) {
            this.previous10Task();
        } else if (keyEvent.getKeyCode() == 36) {
            this.firstTask();
        } else if (keyEvent.getKeyCode() == 35) {
            this.lastTask();
        }
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.previousTask();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.showTask(Integer.parseInt(this.getJTextField1().getText()));
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.findTask(this.getJTextField2().getText());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.setTask();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(WindowEvent arg1) {
        try {
            this.showCurrent();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(ActionEvent arg1) {
        try {
            this.delete();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7(ActionEvent arg1) {
        try {
            this.nextTask();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC8(KeyEvent arg1) {
        try {
            this.checkKeyPress(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(ActionEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2(WindowEvent arg1) {
        try {
            this.getJTextField2().requestFocus();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM3() {
        try {
            this.getTaskLister().init(this.connEtoM3_Tasks(), this.getJLabel8());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public Tasks connEtoM3_Tasks() {
        return COMMON.getTasks();
    }

    private void connEtoM5(FocusEvent arg1) {
        try {
            this.getJTextField1().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM6(FocusEvent arg1) {
        try {
            this.getJTextField2().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void delete() {
        int number;
        this.getJButtonOK().setEnabled(false);
        try {
            number = new Integer(this.getJTextField1().getText());
        }
        catch (Exception e) {
            return;
        }
        Tasks tasks = COMMON.getTasks();
        if (tasks.getTask(number) == null) {
            return;
        }
        tasks.delete(number);
        Task t = tasks.getTask(number);
        if (t == null && number > 0) {
            t = tasks.getTask(--number);
        }
        this.getJTextField1().setText("" + number);
        if (t != null) {
            this.getJButtonOK().setEnabled(true);
        }
        this.getTaskLister().showTask(t);
        COMMON.getMapViewer().setContestList(t);
    }

    void findTask(String length) {
        double l = new Double(length);
        for (int i = 1; i <= COMMON.getTasks().count(); ++i) {
            Task t = COMMON.getTasks().getTask(i);
            if (!(t.length() >= l)) continue;
            this.showTask(i);
            return;
        }
        this.showTask(COMMON.getTasks().count());
    }

    public void firstTask() {
        this.showTask(1);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.getJTextField1()) {
            this.connEtoM5(e);
        }
        if (e.getSource() == this.getJTextField2()) {
            this.connEtoM6(e);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private JButton getJButtonOK() {
        if (this.jButtonOK == null) {
            try {
                this.jButtonOK = new JButton();
                this.jButtonOK.setName("JButton1");
                this.jButtonOK.setText("OK");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.jButtonOK;
    }

    private JButton getJButton2() {
        if (this.ivjJButton2 == null) {
            try {
                this.ivjJButton2 = new JButton();
                this.ivjJButton2.setName("JButton2");
                this.ivjJButton2.setToolTipText("Sletter opgaven, dog ikke i konkurrencen");
                this.ivjJButton2.setText("Slet");
                this.ivjJButton2.setBackground(Color.red);
                this.ivjJButton2.setForeground(Color.white);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButton2;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJPanel2 = new GridBagConstraints();
                constraintsJPanel2.gridx = 0;
                constraintsJPanel2.gridy = 1;
                constraintsJPanel2.fill = 1;
                constraintsJPanel2.weightx = 1.0;
                constraintsJPanel2.weighty = 1.0;
                this.getJFrameContentPane().add((Component)this.getJPanel2(), constraintsJPanel2);
                GridBagConstraints constraintsJPanel3 = new GridBagConstraints();
                constraintsJPanel3.gridx = 1;
                constraintsJPanel3.gridy = 0;
                constraintsJPanel3.gridheight = 2;
                constraintsJPanel3.fill = 3;
                constraintsJPanel3.weighty = 1.0;
                this.getJFrameContentPane().add((Component)this.getJPanel3(), constraintsJPanel3);
                GridBagConstraints constraintsJPanel1 = new GridBagConstraints();
                constraintsJPanel1.gridx = 0;
                constraintsJPanel1.gridy = 0;
                constraintsJPanel1.fill = 2;
                this.getJFrameContentPane().add((Component)this.getJPanel1(), constraintsJPanel1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JLabel getJLabel6() {
        if (this.ivjJLabel6 == null) {
            try {
                this.ivjJLabel6 = new JLabel();
                this.ivjJLabel6.setName("JLabel6");
                this.ivjJLabel6.setText("Opgave Nr:");
                this.ivjJLabel6.setHorizontalAlignment(4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel6;
    }

    private JLabel getJLabel7() {
        if (this.ivjJLabel7 == null) {
            try {
                this.ivjJLabel7 = new JLabel();
                this.ivjJLabel7.setName("JLabel7");
                this.ivjJLabel7.setText("L\u00e6ngde:");
                this.ivjJLabel7.setHorizontalAlignment(4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel7;
    }

    private JLabel getJLabel8() {
        if (this.ivjJLabel8 == null) {
            try {
                this.ivjJLabel8 = new JLabel();
                this.ivjJLabel8.setName("JLabel8");
                this.ivjJLabel8.setToolTipText("Her vises om kravene til en FAI trekant er opfyldt");
                this.ivjJLabel8.setText("FAI");
                this.ivjJLabel8.setForeground(new Color(204, 204, 204));
                this.ivjJLabel8.setHorizontalAlignment(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel8;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJLabel6 = new GridBagConstraints();
                constraintsJLabel6.gridx = 0;
                constraintsJLabel6.gridy = 0;
                constraintsJLabel6.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJLabel6(), constraintsJLabel6);
                GridBagConstraints constraintsJTextField1 = new GridBagConstraints();
                constraintsJTextField1.gridx = 1;
                constraintsJTextField1.gridy = 0;
                constraintsJTextField1.fill = 2;
                constraintsJTextField1.weightx = 1.0;
                constraintsJTextField1.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJTextField1(), constraintsJTextField1);
                GridBagConstraints constraintsJLabel8 = new GridBagConstraints();
                constraintsJLabel8.gridx = 2;
                constraintsJLabel8.gridy = 0;
                constraintsJLabel8.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJLabel8(), constraintsJLabel8);
                GridBagConstraints constraintsJLabel7 = new GridBagConstraints();
                constraintsJLabel7.gridx = 3;
                constraintsJLabel7.gridy = 0;
                constraintsJLabel7.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJLabel7(), constraintsJLabel7);
                GridBagConstraints constraintsJTextField2 = new GridBagConstraints();
                constraintsJTextField2.gridx = 4;
                constraintsJTextField2.gridy = 0;
                constraintsJTextField2.fill = 2;
                constraintsJTextField2.weightx = 1.0;
                constraintsJTextField2.insets = new Insets(4, 4, 4, 4);
                this.getJPanel1().add((Component)this.getJTextField2(), constraintsJTextField2);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setLayout(new GridBagLayout());
                GridBagConstraints constraintsTaskLister = new GridBagConstraints();
                constraintsTaskLister.gridx = 0;
                constraintsTaskLister.gridy = -1;
                constraintsTaskLister.gridwidth = 5;
                constraintsTaskLister.gridheight = 0;
                constraintsTaskLister.fill = 1;
                constraintsTaskLister.weightx = 1.0;
                constraintsTaskLister.weighty = 1.0;
                this.getJPanel2().add((Component)this.getTaskLister(), constraintsTaskLister);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private JPanel getJPanel3() {
        if (this.ivjJPanel3 == null) {
            try {
                this.ivjJPanel3 = new JPanel();
                this.ivjJPanel3.setName("JPanel3");
                this.ivjJPanel3.setLayout(new GridBagLayout());
                GridBagConstraints constraintsRoundButton1 = new GridBagConstraints();
                constraintsRoundButton1.gridx = 1;
                constraintsRoundButton1.gridy = 2;
                constraintsRoundButton1.insets = new Insets(0, 0, 5, 0);
                this.getJPanel3().add((Component)this.getRoundButton1(), constraintsRoundButton1);
                GridBagConstraints constraintsRoundButton2 = new GridBagConstraints();
                constraintsRoundButton2.gridx = 1;
                constraintsRoundButton2.gridy = 1;
                constraintsRoundButton2.anchor = 11;
                constraintsRoundButton2.insets = new Insets(5, 0, 5, 0);
                this.getJPanel3().add((Component)this.getRoundButton2(), constraintsRoundButton2);
                GridBagConstraints constraintsJButton1 = new GridBagConstraints();
                constraintsJButton1.gridx = 1;
                constraintsJButton1.gridy = 3;
                constraintsJButton1.anchor = 15;
                constraintsJButton1.weighty = 1.0;
                constraintsJButton1.insets = new Insets(0, 0, 10, 0);
                this.getJPanel3().add((Component)this.getJButtonOK(), constraintsJButton1);
                GridBagConstraints constraintsJButton2 = new GridBagConstraints();
                constraintsJButton2.gridx = 1;
                constraintsJButton2.gridy = 0;
                constraintsJButton2.anchor = 11;
                constraintsJButton2.insets = new Insets(0, 0, 1, 0);
                this.getJPanel3().add((Component)this.getJButton2(), constraintsJButton2);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel3;
    }

    private JTextField getJTextField1() {
        if (this.ivjJTextField1 == null) {
            try {
                this.ivjJTextField1 = new JTextField();
                this.ivjJTextField1.setName("JTextField1");
                this.ivjJTextField1.setToolTipText("Indtast \u00f8nsket opgave nummer");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextField1;
    }

    public JTextField getJTextField2() {
        if (this.ivjJTextField2 == null) {
            try {
                this.ivjJTextField2 = new JTextField();
                this.ivjJTextField2.setName("JTextField2");
                this.ivjJTextField2.setToolTipText("Indtast \u00f8nsket opgave l\u00e6ngde");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextField2;
    }

    private RoundButton getRoundButton1() {
        if (this.ivjRoundButton1 == null) {
            try {
                this.ivjRoundButton1 = new RoundButton();
                this.ivjRoundButton1.setName("RoundButton1");
                this.ivjRoundButton1.setIcon(new ImageIcon(TaskBrowser.class.getClassLoader().getResource("glider/resourcer/bigger_up.png")));
                this.ivjRoundButton1.setSelectedIcon(new ImageIcon(TaskBrowser.class.getClassLoader().getResource("glider/resourcer/bigger_down.png")));
                this.ivjRoundButton1.setToolTipText("L\u00e6ngere opgave");
                this.ivjRoundButton1.setText("RoundButton1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRoundButton1;
    }

    private RoundButton getRoundButton2() {
        if (this.ivjRoundButton2 == null) {
            try {
                this.ivjRoundButton2 = new RoundButton();
                this.ivjRoundButton2.setName("RoundButton2");
                this.ivjRoundButton2.setIcon(new ImageIcon(TaskBrowser.class.getClassLoader().getResource("glider/resourcer/smaller_up.png")));
                this.ivjRoundButton2.setSelectedIcon(new ImageIcon(TaskBrowser.class.getClassLoader().getResource("glider/resourcer/smaller_down.png")));
                this.ivjRoundButton2.setToolTipText("Kortere opgave");
                this.ivjRoundButton2.setText("RoundButton2");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRoundButton2;
    }

    private TaskLister getTaskLister() {
        if (this.ivjTaskLister == null) {
            try {
                this.ivjTaskLister = new TaskLister();
                this.ivjTaskLister.setName("TaskLister");
                this.ivjTaskLister.setFont(new Font("monospaced", 0, 12));
                this.ivjTaskLister.setEnabled(true);
                this.ivjTaskLister.setRequestFocusEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTaskLister;
    }

    private void handleException(Throwable exception) {
        COMMON.errorLog(this.getClass().getName(), exception);
    }

    private void initConnections() throws Exception {
        this.getJTextField1().addActionListener(this);
        this.getJTextField2().addActionListener(this);
        this.getJTextField1().addFocusListener(this);
        this.getJTextField2().addFocusListener(this);
        this.getJButtonOK().addActionListener(this);
        this.addWindowListener(this);
        this.getJButton2().addActionListener(this);
        this.getRoundButton1().addActionListener(this);
        this.getRoundButton2().addActionListener(this);
        this.getJTextField1().addKeyListener(this);
        this.getJTextField2().addKeyListener(this);
        this.getJButtonOK().addKeyListener(this);
        this.getJButton2().addKeyListener(this);
        this.getRoundButton1().addKeyListener(this);
        this.getRoundButton2().addKeyListener(this);
    }

    private void initialize() {
        try {
            this.setName("TaskBrowser");
            this.setDefaultCloseOperation(2);
            this.setSize(280, 177);
            this.setContentPane(this.getJFrameContentPane());
            this.initConnections();
            this.connEtoM3();
            this.showTask(1);
            this.getRootPane().setDefaultButton(this.getJButtonOK());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setLocation(10, 10);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.connEtoC8(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void lastTask() {
        this.showTask(COMMON.getTasks().count());
    }

    public void next10Task() {
        int number;
        String s = this.getJTextField1().getText();
        try {
            number = new Integer(s);
            if ((number += 10) > COMMON.getTasks().count()) {
                --number;
            }
        }
        catch (Exception e) {
            number = 1;
        }
        this.showTask(number);
    }

    public void nextTask() {
        int number;
        String s = this.getJTextField1().getText();
        try {
            number = new Integer(s);
            if (++number > COMMON.getTasks().count()) {
                --number;
            }
        }
        catch (Exception e) {
            number = 1;
        }
        this.showTask(number);
    }

    public void previous10Task() {
        int number;
        String s = this.getJTextField1().getText();
        try {
            number = new Integer(s);
            if ((number -= 10) > COMMON.getTasks().count()) {
                --number;
            }
        }
        catch (Exception e) {
            number = 1;
        }
        this.showTask(number);
    }

    public void previousTask() {
        int number;
        String s = this.getJTextField1().getText();
        try {
            number = new Integer(s);
            if (--number < 1) {
                number = 1;
            }
        }
        catch (Exception e) {
            number = 1;
        }
        this.showTask(number);
    }

    public void setTask(Task task) {
        Utils.setTask(task);
    }

    public void setTask() {
        int number;
        try {
            number = new Integer(this.getJTextField1().getText());
        }
        catch (Exception e) {
            return;
        }
        Task task = COMMON.getTasks().getTask(number);
        this.setTask(task);
    }

    public void showCurrent() {
        Task t = COMMON.getCurrentTask();
        if (t == null) {
            Tasks tasks = COMMON.getTasks();
            if (tasks != null) {
                t = tasks.getTask(1);
            }
        } else {
            this.showTask(COMMON.getTasks().getTaskNumber(t));
        }
    }

    void showTask(int number) {
        int lines;
        double sum = 0.0;
        Object prevPoint = null;
        this.getJTextField1().setText(new String("" + number));
        Task t = COMMON.getTasks().getTask(number);
        if (t == null) {
            this.getJTextField2().setText("");
            return;
        }
        this.getJTextField2().setText("" + (int)t.length());
        this.getTaskLister().showTask(t);
        if (COMMON.getMapViewer() != null) {
            COMMON.getMapViewer().setContestList(t);
        }
        if ((lines = t.size()) < 5) {
            lines = 5;
        }
        this.pack();
    }

    void showTask(String number) {
        int i;
        try {
            i = new Integer(number);
        }
        catch (Exception e) {
            i = 0;
        }
        this.showTask(i);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        COMMON.getContest().rememberTask();
        this.showCurrent();
    }

    @Override
    public void windowClosed(WindowEvent e) {
        COMMON.getContest().restoreTask();
        if (e.getSource() == this) {
            this.connEtoC5(e);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (e.getSource() == this) {
            this.connEtoM2(e);
        }
    }
}

