/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import glider.Panel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JScrollPane;

public class ScrollPanel
extends JScrollPane
implements ComponentListener {
    private int panelWidth;
    private int panelHeight;
    private Panel ivjPanelMap = null;

    public ScrollPanel() {
        this.initialize();
    }

    public ScrollPanel(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
    }

    public ScrollPanel(Component view) {
        super(view);
    }

    public ScrollPanel(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getSource() == this) {
            this.connEtoC1(e);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private void connEtoC1(ComponentEvent arg1) {
        try {
            this.scrollPanel_ComponentResized();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public Point getOrigin() {
        int x = this.getPanelMap().getX();
        int y = this.getPanelMap().getY();
        return new Point(x, y);
    }

    public void getPanel() {
    }

    public Graphics getPanelGraphics() {
        Graphics g = this.getPanelMap().getGraphics();
        int x = this.getHorizontalScrollBar().getValue();
        int y = this.getVerticalScrollBar().getValue();
        int width = this.getViewport().getBounds().width;
        int height = this.getViewport().getBounds().height;
        g.setClip(x, y, width, height);
        return g;
    }

    private Panel getPanelMap() {
        if (this.ivjPanelMap == null) {
            try {
                this.ivjPanelMap = new Panel();
                this.ivjPanelMap.setName("PanelMap");
                this.ivjPanelMap.setBounds(0, 0, 10, 10);
                this.ivjPanelMap.setBackground(Color.gray);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPanelMap;
    }

    public Dimension getPanelSize() {
        return this.getPanelMap().getSize();
    }

    private void handleException(Throwable exception) {
        COMMON.errorLog(this.getClass().getName(), exception);
    }

    private void initConnections() throws Exception {
        this.addComponentListener(this);
    }

    private void initialize() {
        try {
            this.setName("ScrollPanel");
            this.setVerticalScrollBarPolicy(22);
            this.setHorizontalScrollBarPolicy(32);
            this.setSize(160, 120);
            this.setViewportView(this.getPanelMap());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getPanelMap().setScrollPanel(this);
    }

    public void panelPaint(Graphics g) {
    }

    public void scrollPanel_ComponentResized() {
        this.setPanelSize(this.panelWidth, this.panelHeight);
    }

    public void setPanelSize(int width, int height) {
        this.panelWidth = width;
        this.panelHeight = height;
        this.getPanelMap().setSize(width, height);
        this.getPanelMap().setPreferredSize(new Dimension(width, height));
        this.getPanelMap().setMaximumSize(new Dimension(width, height));
        this.getPanelMap().setMinimumSize(new Dimension(width, height));
        this.doLayout();
    }
}

