/*
 * Decompiled with CFR 0.152.
 */
package glider;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;

public class RoundButton
extends JButton
implements MouseListener {
    Shape shape = null;
    Cursor oldCursor = this.getCursor();
    boolean selected = false;

    public RoundButton() {
        Dimension size = this.getPreferredSize();
        size.width = size.height = Math.max(size.width, size.height);
        this.setPreferredSize(size);
        this.addMouseListener(this);
        this.setMinimumSize(new Dimension(35, 35));
        this.setCursor(new Cursor(0));
        this.setMaximumSize(new Dimension(35, 35));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.oldCursor = this.getCursor();
        this.setCursor(new Cursor(12));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(this.oldCursor);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Icon icon = null;
        ButtonModel model = this.getModel();
        if (model.isEnabled()) {
            icon = model.isPressed() && model.isArmed() ? this.getSelectedIcon() : this.getIcon();
            this.selected = true;
        } else {
            icon = this.getDisabledIcon();
            this.selected = false;
        }
        if (icon != null) {
            icon.paintIcon(this, g, 0, 0);
            if (this.isFocusOwner()) {
                Color savedColor = g.getColor();
                g.setColor(new Color(153, 153, 204));
                g.drawOval(4, 4, 25, 25);
                g.setColor(savedColor);
            }
        } else {
            super.paintComponent(g);
        }
    }
}

