/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.MapColor;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;

class Pixels
implements Serializable {
    public int height;
    public int width;
    private int[] pixels;
    private int[] scanLine;
    private final int pixPrInt = 10;

    public Pixels(int w, int h) {
        this.width = w;
        this.height = h;
        this.pixels = new int[w * h / 10];
        this.scanLine = new int[w];
    }

    public int[] get(int y) {
        int index = y * this.width / 10;
        for (int i = 0; i < this.width / 10; ++i) {
            int comp = this.pixels[index++];
            for (int j = 0; j < 10; ++j) {
                this.scanLine[i * 10 + j] = MapColor.decode((byte)(comp & 7));
                comp >>= 3;
            }
        }
        return this.scanLine;
    }

    public void fill(byte value) {
        int i;
        int word = 0;
        for (i = 0; i < 10; ++i) {
            word += value;
            word <<= 3;
        }
        for (i = 0; i < this.width * this.height / 10; ++i) {
            this.pixels[i] = word;
        }
    }

    public void read(String mapName) {
        try {
            URL url = Pixels.class.getClassLoader().getResource("glider/resourcer/" + mapName);
            InputStream is = url.openStream();
            ObjectInputStream ois = new ObjectInputStream(is);
            this.pixels = (int[])ois.readObject();
            ois.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

