/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import glider.data.Contest;
import gui.JJDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Penalty
extends JJDialog
implements ActionListener,
KeyListener,
WindowListener {
    private int maxpoints;
    private JButton jButtonOK = null;
    private JCheckBox ivjJCheckBoxDisq = null;
    private JPanel ivjJFrameContentPane = null;
    private JLabel ivjJLabel1 = null;
    private JLabel ivjJLabel2 = null;
    private JLabel ivjJLabel3 = null;
    private JLabel ivjJLabel4 = null;
    private JLabel ivjJLabelNum = null;
    private JLabel ivjJLabelPercent = null;
    private JLabel ivjJLabelReg = null;
    private JTextField ivjJTextFieldOriginal = null;
    private JTextField ivjJTextFieldPenalty = null;
    private JTextField ivjJTextFieldResult = null;
    private JPanel ivjJPanel1 = null;
    private FlowLayout ivjJPanel1FlowLayout = null;
    private JPanel ivjJPanel2 = null;
    private GridLayout ivjJPanel2GridLayout = null;
    private JButton ivjJButton2 = null;
    private JPanel ivjJPanel3 = null;

    public Penalty() {
        this.initialize();
    }

    public Penalty(Frame owner) {
        super(owner, "Straf Point >:-(");
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getJButtonOK()) {
            this.connEtoC7(e);
        }
        if (e.getSource() == this.getJTextFieldPenalty()) {
            this.connEtoC1(e);
        }
        if (e.getSource() == this.getJCheckBoxDisq()) {
            this.connEtoC3(e);
        }
        if (e.getSource() == this.getJCheckBoxDisq()) {
            this.connEtoM2(e);
        }
        if (e.getSource() == this.getJButton2()) {
            this.connEtoM5(e);
        }
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.result();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(KeyEvent arg1) {
        try {
            this.update();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.update();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7(ActionEvent arg1) {
        try {
            this.result();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(WindowEvent arg1) {
        try {
            this.getJTextFieldPenalty().requestFocus();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2(ActionEvent arg1) {
        try {
            this.getJButtonOK().setEnabled(true);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM3(WindowEvent arg1) {
        try {
            this.getJButtonOK().setEnabled(false);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM4(KeyEvent arg1) {
        try {
            this.getJButtonOK().setEnabled(true);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM5(ActionEvent arg1) {
        try {
            this.setVisible(false);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JButton getJButtonOK() {
        if (this.jButtonOK == null) {
            try {
                this.jButtonOK = new JButton();
                this.jButtonOK.setName("JButton1");
                this.jButtonOK.setText("OK");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.jButtonOK;
    }

    private JButton getJButton2() {
        if (this.ivjJButton2 == null) {
            try {
                this.ivjJButton2 = new JButton();
                this.ivjJButton2.setName("JButton2");
                this.ivjJButton2.setText("Fortryd");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButton2;
    }

    private JCheckBox getJCheckBoxDisq() {
        if (this.ivjJCheckBoxDisq == null) {
            try {
                this.ivjJCheckBoxDisq = new JCheckBox();
                this.ivjJCheckBoxDisq.setName("JCheckBoxDisq");
                this.ivjJCheckBoxDisq.setText("Diskvalificeret");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBoxDisq;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJCheckBoxDisq = new GridBagConstraints();
                constraintsJCheckBoxDisq.gridx = 0;
                constraintsJCheckBoxDisq.gridy = 1;
                constraintsJCheckBoxDisq.insets = new Insets(0, 5, 0, 0);
                this.getJFrameContentPane().add((Component)this.getJCheckBoxDisq(), constraintsJCheckBoxDisq);
                GridBagConstraints constraintsJPanel1 = new GridBagConstraints();
                constraintsJPanel1.gridx = 1;
                constraintsJPanel1.gridy = 1;
                constraintsJPanel1.fill = 2;
                constraintsJPanel1.weightx = 1.0;
                this.getJFrameContentPane().add((Component)this.getJPanel1(), constraintsJPanel1);
                GridBagConstraints constraintsJPanel3 = new GridBagConstraints();
                constraintsJPanel3.gridx = 0;
                constraintsJPanel3.gridy = 0;
                constraintsJPanel3.gridwidth = 2;
                constraintsJPanel3.fill = 1;
                constraintsJPanel3.weightx = 1.0;
                constraintsJPanel3.weighty = 1.0;
                this.getJFrameContentPane().add((Component)this.getJPanel3(), constraintsJPanel3);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setText("Fly:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel1;
    }

    private JLabel getJLabel2() {
        if (this.ivjJLabel2 == null) {
            try {
                this.ivjJLabel2 = new JLabel();
                this.ivjJLabel2.setName("JLabel2");
                this.ivjJLabel2.setText("Strafpoint:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel2;
    }

    private JLabel getJLabel3() {
        if (this.ivjJLabel3 == null) {
            try {
                this.ivjJLabel3 = new JLabel();
                this.ivjJLabel3.setName("JLabel3");
                this.ivjJLabel3.setText("Oprindelige Point:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel3;
    }

    private JLabel getJLabel4() {
        if (this.ivjJLabel4 == null) {
            try {
                this.ivjJLabel4 = new JLabel();
                this.ivjJLabel4.setName("JLabel4");
                this.ivjJLabel4.setText("Resulterende Point:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel4;
    }

    private JLabel getJLabelNum() {
        if (this.ivjJLabelNum == null) {
            try {
                this.ivjJLabelNum = new JLabel();
                this.ivjJLabelNum.setName("JLabelNum");
                this.ivjJLabelNum.setText("");
                this.ivjJLabelNum.setForeground(Color.black);
                this.ivjJLabelNum.setHorizontalTextPosition(2);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelNum;
    }

    private JLabel getJLabelPercent() {
        if (this.ivjJLabelPercent == null) {
            try {
                this.ivjJLabelPercent = new JLabel();
                this.ivjJLabelPercent.setName("JLabelPercent");
                this.ivjJLabelPercent.setFont(new Font("dialog", 1, 12));
                this.ivjJLabelPercent.setText("% af ");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelPercent;
    }

    private JLabel getJLabelReg() {
        if (this.ivjJLabelReg == null) {
            try {
                this.ivjJLabelReg = new JLabel();
                this.ivjJLabelReg.setName("JLabelReg");
                this.ivjJLabelReg.setText("");
                this.ivjJLabelReg.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelReg;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(this.getJPanel1FlowLayout());
                this.getJPanel1().add((Component)this.getJPanel2(), this.getJPanel2().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private FlowLayout getJPanel1FlowLayout() {
        FlowLayout ivjJPanel1FlowLayout = null;
        try {
            ivjJPanel1FlowLayout = new FlowLayout();
            ivjJPanel1FlowLayout.setAlignment(2);
            ivjJPanel1FlowLayout.setVgap(10);
            ivjJPanel1FlowLayout.setHgap(10);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjJPanel1FlowLayout;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setLayout(this.getJPanel2GridLayout());
                this.getJPanel2().add((Component)this.getJButtonOK(), this.getJButtonOK().getName());
                this.getJPanel2().add((Component)this.getJButton2(), this.getJButton2().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private GridLayout getJPanel2GridLayout() {
        GridLayout ivjJPanel2GridLayout = null;
        try {
            ivjJPanel2GridLayout = new GridLayout();
            ivjJPanel2GridLayout.setHgap(5);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjJPanel2GridLayout;
    }

    private JPanel getJPanel3() {
        if (this.ivjJPanel3 == null) {
            try {
                this.ivjJPanel3 = new JPanel();
                this.ivjJPanel3.setName("JPanel3");
                this.ivjJPanel3.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJLabel1 = new GridBagConstraints();
                constraintsJLabel1.gridx = 0;
                constraintsJLabel1.gridy = 0;
                constraintsJLabel1.anchor = 13;
                constraintsJLabel1.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJLabel1(), constraintsJLabel1);
                GridBagConstraints constraintsJLabel3 = new GridBagConstraints();
                constraintsJLabel3.gridx = 0;
                constraintsJLabel3.gridy = 1;
                constraintsJLabel3.anchor = 13;
                constraintsJLabel3.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJLabel3(), constraintsJLabel3);
                GridBagConstraints constraintsJTextFieldOriginal = new GridBagConstraints();
                constraintsJTextFieldOriginal.gridx = 1;
                constraintsJTextFieldOriginal.gridy = 1;
                constraintsJTextFieldOriginal.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJTextFieldOriginal(), constraintsJTextFieldOriginal);
                GridBagConstraints constraintsJLabel2 = new GridBagConstraints();
                constraintsJLabel2.gridx = 0;
                constraintsJLabel2.gridy = 2;
                constraintsJLabel2.anchor = 13;
                constraintsJLabel2.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJLabel2(), constraintsJLabel2);
                GridBagConstraints constraintsJTextFieldPenalty = new GridBagConstraints();
                constraintsJTextFieldPenalty.gridx = 1;
                constraintsJTextFieldPenalty.gridy = 2;
                constraintsJTextFieldPenalty.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJTextFieldPenalty(), constraintsJTextFieldPenalty);
                GridBagConstraints constraintsJLabelPercent = new GridBagConstraints();
                constraintsJLabelPercent.gridx = 2;
                constraintsJLabelPercent.gridy = 2;
                constraintsJLabelPercent.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJLabelPercent(), constraintsJLabelPercent);
                GridBagConstraints constraintsJLabel4 = new GridBagConstraints();
                constraintsJLabel4.gridx = 0;
                constraintsJLabel4.gridy = 3;
                constraintsJLabel4.anchor = 13;
                constraintsJLabel4.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJLabel4(), constraintsJLabel4);
                GridBagConstraints constraintsJTextFieldResult = new GridBagConstraints();
                constraintsJTextFieldResult.gridx = 1;
                constraintsJTextFieldResult.gridy = 3;
                constraintsJTextFieldResult.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJTextFieldResult(), constraintsJTextFieldResult);
                GridBagConstraints constraintsJLabelReg = new GridBagConstraints();
                constraintsJLabelReg.gridx = 2;
                constraintsJLabelReg.gridy = 0;
                this.getJPanel3().add((Component)this.getJLabelReg(), constraintsJLabelReg);
                GridBagConstraints constraintsJLabelNum = new GridBagConstraints();
                constraintsJLabelNum.gridx = 1;
                constraintsJLabelNum.gridy = 0;
                this.getJPanel3().add((Component)this.getJLabelNum(), constraintsJLabelNum);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel3;
    }

    private JTextField getJTextFieldOriginal() {
        if (this.ivjJTextFieldOriginal == null) {
            try {
                this.ivjJTextFieldOriginal = new JTextField();
                this.ivjJTextFieldOriginal.setName("JTextFieldOriginal");
                this.ivjJTextFieldOriginal.setBackground(Color.gray);
                this.ivjJTextFieldOriginal.setForeground(Color.green);
                this.ivjJTextFieldOriginal.setPreferredSize(new Dimension(50, 19));
                this.ivjJTextFieldOriginal.setMinimumSize(new Dimension(50, 19));
                this.ivjJTextFieldOriginal.setHorizontalAlignment(4);
                this.ivjJTextFieldOriginal.setRequestFocusEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldOriginal;
    }

    private JTextField getJTextFieldPenalty() {
        if (this.ivjJTextFieldPenalty == null) {
            try {
                this.ivjJTextFieldPenalty = new JTextField();
                this.ivjJTextFieldPenalty.setName("JTextFieldPenalty");
                this.ivjJTextFieldPenalty.setPreferredSize(new Dimension(50, 19));
                this.ivjJTextFieldPenalty.setMinimumSize(new Dimension(50, 19));
                this.ivjJTextFieldPenalty.setHorizontalAlignment(4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldPenalty;
    }

    private JTextField getJTextFieldResult() {
        if (this.ivjJTextFieldResult == null) {
            try {
                this.ivjJTextFieldResult = new JTextField();
                this.ivjJTextFieldResult.setName("JTextFieldResult");
                this.ivjJTextFieldResult.setText("");
                this.ivjJTextFieldResult.setBackground(Color.gray);
                this.ivjJTextFieldResult.setForeground(Color.green);
                this.ivjJTextFieldResult.setPreferredSize(new Dimension(50, 19));
                this.ivjJTextFieldResult.setEditable(false);
                this.ivjJTextFieldResult.setMinimumSize(new Dimension(50, 19));
                this.ivjJTextFieldResult.setRequestFocusEnabled(false);
                this.ivjJTextFieldResult.setHorizontalAlignment(4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldResult;
    }

    private void handleException(Throwable exception) {
        COMMON.errorLog(this.getClass().getName(), exception);
    }

    private void initConnections() throws Exception {
        this.getJButtonOK().addActionListener(this);
        this.addWindowListener(this);
        this.getJTextFieldPenalty().addKeyListener(this);
        this.getJTextFieldPenalty().addActionListener(this);
        this.getJCheckBoxDisq().addActionListener(this);
        this.getJButton2().addActionListener(this);
    }

    private void initialize() {
        try {
            this.setName("TripTime");
            this.setDefaultCloseOperation(2);
            this.setSize(293, 178);
            this.setContentPane(this.getJFrameContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setLocation(100, 100);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.getJTextFieldPenalty()) {
            this.connEtoM4(e);
        }
        if (e.getSource() == this.getJTextFieldPenalty()) {
            this.connEtoC2(e);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void reCalculate() {
        if (this.isVisible()) {
            this.setVisible(true);
        }
    }

    void result() {
        int penalty = 0;
        try {
            penalty = new Integer(this.getJTextFieldPenalty().getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getJCheckBoxDisq().isSelected()) {
            COMMON.getContest().setDisqualified();
        } else {
            COMMON.getContest().setPenaltyPoint(penalty);
        }
        this.dispose();
    }

    @Override
    public void setVisible(boolean value) {
        if (value) {
            Contest contest = COMMON.getContest();
            this.getJLabelNum().setForeground(Color.red);
            this.getJLabelReg().setForeground(Color.red);
            this.getJLabelNum().setText((String)COMMON.currentContestNumber.getSelectedItem());
            this.getJLabelReg().setText(contest.getRegistration());
            this.maxpoints = contest.getMaxpoints();
            this.getJLabelPercent().setText(" % af " + this.maxpoints);
            this.getJTextFieldOriginal().setText("" + contest.getPoints());
            int penalty = COMMON.getContest().getPenaltyPoint();
            if (penalty > 0) {
                this.getJTextFieldPenalty().setText("" + COMMON.getContest().getPenaltyPoint());
            } else {
                this.getJTextFieldPenalty().setText("");
            }
            this.update();
        }
        super.setVisible(value);
    }

    public void update() {
        int penalty;
        int original = new Integer(this.getJTextFieldOriginal().getText());
        try {
            penalty = new Integer(this.getJTextFieldPenalty().getText());
        }
        catch (Exception e) {
            penalty = 0;
        }
        int deduction = (int)Math.round((double)(this.maxpoints * penalty) / 100.0);
        int result = original - deduction;
        if (result < 0) {
            result = 0;
        }
        if (this.getJCheckBoxDisq().isSelected()) {
            result = 0;
        }
        this.getJTextFieldResult().setText("" + result);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        if (e.getSource() == this) {
            this.connEtoM1(e);
        }
        if (e.getSource() == this) {
            this.connEtoM3(e);
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.getRootPane().setDefaultButton(this.getJButtonOK());
    }
}

