/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import glider.LatLonTextField;
import glider.MapViewer;
import glider.data.Contest;
import glider.data.Coordinate;
import glider.data.PlaneResult;
import glider.data.Task;
import glider.utils.Utils;
import gui.JJDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class OutLanding
extends JJDialog
implements ActionListener,
KeyListener,
MouseListener,
WindowListener {
    private double reducedDistance = 0.0;
    private Coordinate coord = new Coordinate(0, 0);
    private int numPoints = 0;
    private JButton jButtonOK = null;
    private JCheckBox ivjJCheckBox1 = null;
    private JCheckBox ivjJCheckBox2 = null;
    private JCheckBox ivjJCheckBox3 = null;
    private JCheckBox ivjJCheckBox4 = null;
    private JCheckBox ivjJCheckBox5 = null;
    private JCheckBox ivjJCheckBox6 = null;
    private JCheckBox ivjJCheckBox7 = null;
    private JPanel ivjJFrameContentPane = null;
    private JLabel ivjJLabel1 = null;
    private JLabel ivjJLabel2 = null;
    private JLabel ivjJLabel3 = null;
    private JLabel ivjJLabel4 = null;
    private JLabel ivjJLabel5 = null;
    private JLabel ivjJLabel8 = null;
    private JLabel ivjJLabelNum = null;
    private JLabel ivjJLabelReg = null;
    private JTextField ivjJTextFieldDistance = null;
    private JRadioButton ivjJRadioButtonDecimal = null;
    private JRadioButton ivjJRadioButtonSeconds = null;
    private MapViewer ivjMapViewer1 = null;
    private LatLonTextField ivjJTextFieldLat = null;
    private LatLonTextField ivjJTextFieldLon = null;
    private ButtonGroup ivjButtonGroup1 = null;
    private JPanel ivjJPanel1 = null;
    private FlowLayout ivjJPanel1FlowLayout = null;
    private JPanel ivjJPanel2 = null;
    private GridLayout ivjJPanel2GridLayout = null;
    private JPanel ivjJPanel3 = null;
    private JButton ivjJButton2 = null;

    public OutLanding(Frame owner) {
        super(owner, "Udelanding", false, false);
        this.initialize();
    }

    public void accept() {
        if (!this.getJButtonOK().isEnabled()) {
            return;
        }
        COMMON.getContest().planeDistanceResult(this.reducedDistance, this.coord, this.numPoints);
        COMMON.getUpdater().lengthChanged();
        this.cleanUp();
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getJCheckBox2()) {
            this.setTurnPoints(2);
        }
        if (e.getSource() == this.getJCheckBox3()) {
            this.setTurnPoints(3);
        }
        if (e.getSource() == this.getJCheckBox4()) {
            this.setTurnPoints(4);
        }
        if (e.getSource() == this.getJCheckBox5()) {
            this.setTurnPoints(5);
        }
        if (e.getSource() == this.getJCheckBox6()) {
            this.setTurnPoints(6);
        }
        if (e.getSource() == this.getJCheckBox7()) {
            this.setTurnPoints(7);
        }
        if (e.getSource() == this.getJCheckBox1()) {
            this.connEtoC2(e);
        }
        if (e.getSource() == this.getJButtonOK()) {
            this.connEtoC14(e);
        }
        if (e.getSource() == this.getJRadioButtonDecimal()) {
            this.connEtoC1(e);
        }
        if (e.getSource() == this.getJRadioButtonSeconds()) {
            this.connEtoC11(e);
        }
        if (e.getSource() == this.getJButton2()) {
            this.connEtoM4(e);
        }
        if (e.getSource() == this.getJTextFieldLat()) {
            this.connEtoC5(e);
        }
        if (e.getSource() == this.getJTextFieldLon()) {
            this.connEtoC6(e);
        }
    }

    private void cleanUp() {
        COMMON.getMapViewer().setOutLanding(null);
        COMMON.setMouseOwner(0);
        this.coord.setLatitude(0);
        this.coord.setLongitude(0);
        this.reducedDistance = 0.0;
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.toggle(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC11(ActionEvent arg1) {
        try {
            this.toggle(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC12(WindowEvent arg1) {
        try {
            this.deselectTurnPoints();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC13(MouseEvent arg1) {
        try {
            this.landingSpot(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC14(ActionEvent arg1) {
        try {
            this.accept();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.setTurnPoints(1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(KeyEvent arg1) {
        try {
            this.setOutLanding();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(KeyEvent arg1) {
        try {
            this.setOutLanding();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(ActionEvent arg1) {
        try {
            this.accept();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(ActionEvent arg1) {
        try {
            this.accept();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1() {
        try {
            this.setMapViewer1(this.connEtoM1_Value());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public MapViewer connEtoM1_Value() {
        return COMMON.getMapViewer();
    }

    private void connEtoM2() {
        try {
            this.getButtonGroup1().add(this.getJRadioButtonDecimal());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM3() {
        try {
            this.getButtonGroup1().add(this.getJRadioButtonSeconds());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM4(ActionEvent arg1) {
        try {
            this.cleanUp();
            this.setVisible(false);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM9(WindowEvent arg1) {
        try {
            this.getJTextFieldDistance().setText("");
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    void deselectTurnPoints() {
        this.getJCheckBox1().setSelected(false);
        this.getJCheckBox2().setSelected(false);
        this.getJCheckBox3().setSelected(false);
        this.getJCheckBox4().setSelected(false);
        this.getJCheckBox5().setSelected(false);
        this.getJCheckBox6().setSelected(false);
        this.getJCheckBox7().setSelected(false);
    }

    void enableTurnpoints() {
        int size = COMMON.getCurrentTask().size();
        this.getJCheckBox1().setEnabled(size > 2);
        this.getJCheckBox2().setEnabled(size > 3);
        this.getJCheckBox3().setEnabled(size > 4);
        this.getJCheckBox4().setEnabled(size > 5);
        this.getJCheckBox5().setEnabled(size > 6);
        this.getJCheckBox6().setEnabled(size > 7);
        this.getJCheckBox7().setEnabled(size > 8);
        PlaneResult pr = COMMON.getContest().getPlaneResult();
        if (pr.getLandingSpot() != null) {
            this.coord = new Coordinate(pr.getLandingSpot());
            this.reducedDistance = pr.getDistance();
        } else {
            this.coord = new Coordinate(0, 0);
            this.reducedDistance = 0.0;
        }
        this.numPoints = pr.getNumberOfTurnPoints();
        if (this.numPoints < 0) {
            this.numPoints = 0;
        }
        if (this.numPoints == 1) {
            this.getJCheckBox1().setSelected(true);
        }
        if (pr.isStarted() && !pr.isFinished()) {
            if (pr.getLandingSpot() == null) {
                pr.setLandingSpot(new Coordinate(0, 0));
                this.coord.setLatitude(0);
                this.coord.setLongitude(0);
            } else {
                this.coord.setLatitude(pr.getLandingSpot().getLatitude());
                this.coord.setLongitude(pr.getLandingSpot().getLongitude());
            }
            if (this.coord.getLatitude() != 0 && this.coord.getLongitude() != 0) {
                if (this.getJRadioButtonDecimal().isSelected()) {
                    this.getJTextFieldLat().setText("" + this.coord.getLatitude());
                    this.getJTextFieldLon().setText("" + this.coord.getLongitude());
                } else {
                    this.getJTextFieldLat().setText("" + this.coord.toSeconds().getLatitude());
                    this.getJTextFieldLon().setText("" + this.coord.toSeconds().getLongitude());
                }
                COMMON.getMapViewer().setOutLanding(this.coord);
            }
        } else {
            this.getJTextFieldLat().setText("");
            this.getJTextFieldLon().setText("");
        }
        this.setTurnPoints(this.numPoints);
    }

    private ButtonGroup getButtonGroup1() {
        if (this.ivjButtonGroup1 == null) {
            try {
                this.ivjButtonGroup1 = new ButtonGroup();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonGroup1;
    }

    private JButton getJButtonOK() {
        if (this.jButtonOK == null) {
            try {
                this.jButtonOK = new JButton();
                this.jButtonOK.setName("JButton1");
                this.jButtonOK.setToolTipText("Angiv passerede vendepunkter og koordinater for landingen");
                this.jButtonOK.setText("OK");
                this.jButtonOK.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.jButtonOK;
    }

    private JButton getJButton2() {
        if (this.ivjJButton2 == null) {
            try {
                this.ivjJButton2 = new JButton();
                this.ivjJButton2.setName("JButton2");
                this.ivjJButton2.setText("Fortryd");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButton2;
    }

    private JCheckBox getJCheckBox1() {
        if (this.ivjJCheckBox1 == null) {
            try {
                this.ivjJCheckBox1 = new JCheckBox();
                this.ivjJCheckBox1.setName("JCheckBox1");
                this.ivjJCheckBox1.setText("Vendepunkt 1");
                this.ivjJCheckBox1.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBox1;
    }

    private JCheckBox getJCheckBox2() {
        if (this.ivjJCheckBox2 == null) {
            try {
                this.ivjJCheckBox2 = new JCheckBox();
                this.ivjJCheckBox2.setName("JCheckBox2");
                this.ivjJCheckBox2.setText("Vendepunkt  2");
                this.ivjJCheckBox2.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBox2;
    }

    private JCheckBox getJCheckBox3() {
        if (this.ivjJCheckBox3 == null) {
            try {
                this.ivjJCheckBox3 = new JCheckBox();
                this.ivjJCheckBox3.setName("JCheckBox3");
                this.ivjJCheckBox3.setText("Vendepunkt 3");
                this.ivjJCheckBox3.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBox3;
    }

    private JCheckBox getJCheckBox4() {
        if (this.ivjJCheckBox4 == null) {
            try {
                this.ivjJCheckBox4 = new JCheckBox();
                this.ivjJCheckBox4.setName("JCheckBox4");
                this.ivjJCheckBox4.setText("Vendepunkt 4");
                this.ivjJCheckBox4.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBox4;
    }

    private JCheckBox getJCheckBox5() {
        if (this.ivjJCheckBox5 == null) {
            try {
                this.ivjJCheckBox5 = new JCheckBox();
                this.ivjJCheckBox5.setName("JCheckBox5");
                this.ivjJCheckBox5.setText("Vendepunkt 5");
                this.ivjJCheckBox5.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBox5;
    }

    private JCheckBox getJCheckBox6() {
        if (this.ivjJCheckBox6 == null) {
            try {
                this.ivjJCheckBox6 = new JCheckBox();
                this.ivjJCheckBox6.setName("JCheckBox6");
                this.ivjJCheckBox6.setText("Vendepunkt 6");
                this.ivjJCheckBox6.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBox6;
    }

    private JCheckBox getJCheckBox7() {
        if (this.ivjJCheckBox7 == null) {
            try {
                this.ivjJCheckBox7 = new JCheckBox();
                this.ivjJCheckBox7.setName("JCheckBox7");
                this.ivjJCheckBox7.setText("Vendepunkt 7");
                this.ivjJCheckBox7.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJCheckBox7;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJLabel8 = new GridBagConstraints();
                constraintsJLabel8.gridx = 0;
                constraintsJLabel8.gridy = 0;
                constraintsJLabel8.weighty = 1.0;
                this.getJFrameContentPane().add((Component)this.getJLabel8(), constraintsJLabel8);
                GridBagConstraints constraintsJLabelNum = new GridBagConstraints();
                constraintsJLabelNum.gridx = 1;
                constraintsJLabelNum.gridy = 0;
                constraintsJLabelNum.fill = 2;
                constraintsJLabelNum.anchor = 17;
                constraintsJLabelNum.weightx = 1.0;
                this.getJFrameContentPane().add((Component)this.getJLabelNum(), constraintsJLabelNum);
                GridBagConstraints constraintsJLabelReg = new GridBagConstraints();
                constraintsJLabelReg.gridx = 2;
                constraintsJLabelReg.gridy = 0;
                constraintsJLabelReg.anchor = 17;
                this.getJFrameContentPane().add((Component)this.getJLabelReg(), constraintsJLabelReg);
                GridBagConstraints constraintsJLabel3 = new GridBagConstraints();
                constraintsJLabel3.gridx = 3;
                constraintsJLabel3.gridy = 6;
                constraintsJLabel3.insets = new Insets(4, 0, 4, 0);
                this.getJFrameContentPane().add((Component)this.getJLabel3(), constraintsJLabel3);
                GridBagConstraints constraintsJTextFieldLat = new GridBagConstraints();
                constraintsJTextFieldLat.gridx = 2;
                constraintsJTextFieldLat.gridy = 6;
                constraintsJTextFieldLat.insets = new Insets(4, 0, 4, 0);
                this.getJFrameContentPane().add((Component)this.getJTextFieldLat(), constraintsJTextFieldLat);
                GridBagConstraints constraintsJTextFieldLon = new GridBagConstraints();
                constraintsJTextFieldLon.gridx = 4;
                constraintsJTextFieldLon.gridy = 6;
                constraintsJTextFieldLon.insets = new Insets(4, 0, 4, 0);
                this.getJFrameContentPane().add((Component)this.getJTextFieldLon(), constraintsJTextFieldLon);
                GridBagConstraints constraintsJRadioButtonSeconds = new GridBagConstraints();
                constraintsJRadioButtonSeconds.gridx = 2;
                constraintsJRadioButtonSeconds.gridy = 5;
                constraintsJRadioButtonSeconds.gridwidth = 9;
                constraintsJRadioButtonSeconds.anchor = 17;
                constraintsJRadioButtonSeconds.insets = new Insets(4, 4, 4, 4);
                this.getJFrameContentPane().add((Component)this.getJRadioButtonSeconds(), constraintsJRadioButtonSeconds);
                GridBagConstraints constraintsJRadioButtonDecimal = new GridBagConstraints();
                constraintsJRadioButtonDecimal.gridx = 2;
                constraintsJRadioButtonDecimal.gridy = 4;
                constraintsJRadioButtonDecimal.gridwidth = 9;
                constraintsJRadioButtonDecimal.anchor = 17;
                constraintsJRadioButtonDecimal.insets = new Insets(4, 4, 4, 4);
                this.getJFrameContentPane().add((Component)this.getJRadioButtonDecimal(), constraintsJRadioButtonDecimal);
                GridBagConstraints constraintsJLabel4 = new GridBagConstraints();
                constraintsJLabel4.gridx = 5;
                constraintsJLabel4.gridy = 6;
                constraintsJLabel4.anchor = 17;
                constraintsJLabel4.weightx = 1.0;
                constraintsJLabel4.insets = new Insets(4, 0, 4, 0);
                this.getJFrameContentPane().add((Component)this.getJLabel4(), constraintsJLabel4);
                GridBagConstraints constraintsJLabel2 = new GridBagConstraints();
                constraintsJLabel2.gridx = 2;
                constraintsJLabel2.gridy = 7;
                constraintsJLabel2.gridwidth = 3;
                constraintsJLabel2.anchor = 15;
                constraintsJLabel2.insets = new Insets(4, 4, 4, 4);
                this.getJFrameContentPane().add((Component)this.getJLabel2(), constraintsJLabel2);
                GridBagConstraints constraintsJTextFieldDistance = new GridBagConstraints();
                constraintsJTextFieldDistance.gridx = 2;
                constraintsJTextFieldDistance.gridy = 8;
                constraintsJTextFieldDistance.gridwidth = 3;
                constraintsJTextFieldDistance.anchor = 11;
                constraintsJTextFieldDistance.insets = new Insets(4, 4, 4, 4);
                this.getJFrameContentPane().add((Component)this.getJTextFieldDistance(), constraintsJTextFieldDistance);
                GridBagConstraints constraintsJLabel5 = new GridBagConstraints();
                constraintsJLabel5.gridx = 1;
                constraintsJLabel5.gridy = 1;
                constraintsJLabel5.gridwidth = 9;
                constraintsJLabel5.insets = new Insets(4, 4, 4, 4);
                this.getJFrameContentPane().add((Component)this.getJLabel5(), constraintsJLabel5);
                GridBagConstraints constraintsJLabel1 = new GridBagConstraints();
                constraintsJLabel1.gridx = 1;
                constraintsJLabel1.gridy = 2;
                constraintsJLabel1.gridwidth = 9;
                constraintsJLabel1.insets = new Insets(4, 4, 4, 4);
                this.getJFrameContentPane().add((Component)this.getJLabel1(), constraintsJLabel1);
                GridBagConstraints constraintsJPanel1 = new GridBagConstraints();
                constraintsJPanel1.gridx = 1;
                constraintsJPanel1.gridy = 8;
                constraintsJPanel1.gridwidth = 5;
                constraintsJPanel1.fill = 2;
                constraintsJPanel1.anchor = 15;
                constraintsJPanel1.weightx = 1.0;
                constraintsJPanel1.weighty = 1.0;
                this.getJFrameContentPane().add((Component)this.getJPanel1(), constraintsJPanel1);
                GridBagConstraints constraintsJPanel3 = new GridBagConstraints();
                constraintsJPanel3.gridx = 0;
                constraintsJPanel3.gridy = 1;
                constraintsJPanel3.gridheight = 8;
                constraintsJPanel3.fill = 1;
                constraintsJPanel3.weightx = 1.0;
                constraintsJPanel3.weighty = 1.0;
                constraintsJPanel3.insets = new Insets(4, 4, 4, 4);
                this.getJFrameContentPane().add((Component)this.getJPanel3(), constraintsJPanel3);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setText("udelandingen eller klik p\u00e5 kortet");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel1;
    }

    private JLabel getJLabel2() {
        if (this.ivjJLabel2 == null) {
            try {
                this.ivjJLabel2 = new JLabel();
                this.ivjJLabel2.setName("JLabel2");
                this.ivjJLabel2.setText("Afstand");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel2;
    }

    private JLabel getJLabel3() {
        if (this.ivjJLabel3 == null) {
            try {
                this.ivjJLabel3 = new JLabel();
                this.ivjJLabel3.setName("JLabel3");
                this.ivjJLabel3.setText(" N ");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel3;
    }

    private JLabel getJLabel4() {
        if (this.ivjJLabel4 == null) {
            try {
                this.ivjJLabel4 = new JLabel();
                this.ivjJLabel4.setName("JLabel4");
                this.ivjJLabel4.setText(" E");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel4;
    }

    private JLabel getJLabel5() {
        if (this.ivjJLabel5 == null) {
            try {
                this.ivjJLabel5 = new JLabel();
                this.ivjJLabel5.setName("JLabel5");
                this.ivjJLabel5.setToolTipText("55 10 27 indtastes som 5510270");
                this.ivjJLabel5.setText("Indtast koordinater (x10) for");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel5;
    }

    private JLabel getJLabel8() {
        if (this.ivjJLabel8 == null) {
            try {
                this.ivjJLabel8 = new JLabel();
                this.ivjJLabel8.setName("JLabel8");
                this.ivjJLabel8.setText("Fly");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel8;
    }

    private JLabel getJLabelNum() {
        if (this.ivjJLabelNum == null) {
            try {
                this.ivjJLabelNum = new JLabel();
                this.ivjJLabelNum.setName("JLabelNum");
                this.ivjJLabelNum.setText("");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelNum;
    }

    private JLabel getJLabelReg() {
        if (this.ivjJLabelReg == null) {
            try {
                this.ivjJLabelReg = new JLabel();
                this.ivjJLabelReg.setName("JLabelReg");
                this.ivjJLabelReg.setText("");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabelReg;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(this.getJPanel1FlowLayout());
                this.getJPanel1().add((Component)this.getJPanel2(), this.getJPanel2().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private FlowLayout getJPanel1FlowLayout() {
        FlowLayout ivjJPanel1FlowLayout = null;
        try {
            ivjJPanel1FlowLayout = new FlowLayout();
            ivjJPanel1FlowLayout.setAlignment(2);
            ivjJPanel1FlowLayout.setVgap(10);
            ivjJPanel1FlowLayout.setHgap(10);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjJPanel1FlowLayout;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setLayout(this.getJPanel2GridLayout());
                this.getJPanel2().add((Component)this.getJButtonOK(), this.getJButtonOK().getName());
                this.getJPanel2().add((Component)this.getJButton2(), this.getJButton2().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private GridLayout getJPanel2GridLayout() {
        GridLayout ivjJPanel2GridLayout = null;
        try {
            ivjJPanel2GridLayout = new GridLayout();
            ivjJPanel2GridLayout.setHgap(5);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjJPanel2GridLayout;
    }

    private JPanel getJPanel3() {
        if (this.ivjJPanel3 == null) {
            try {
                this.ivjJPanel3 = new JPanel();
                this.ivjJPanel3.setName("JPanel3");
                this.ivjJPanel3.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJCheckBox1 = new GridBagConstraints();
                constraintsJCheckBox1.gridx = 0;
                constraintsJCheckBox1.gridy = 0;
                constraintsJCheckBox1.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJCheckBox1(), constraintsJCheckBox1);
                GridBagConstraints constraintsJCheckBox2 = new GridBagConstraints();
                constraintsJCheckBox2.gridx = 0;
                constraintsJCheckBox2.gridy = 1;
                constraintsJCheckBox2.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJCheckBox2(), constraintsJCheckBox2);
                GridBagConstraints constraintsJCheckBox3 = new GridBagConstraints();
                constraintsJCheckBox3.gridx = 0;
                constraintsJCheckBox3.gridy = 2;
                constraintsJCheckBox3.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJCheckBox3(), constraintsJCheckBox3);
                GridBagConstraints constraintsJCheckBox4 = new GridBagConstraints();
                constraintsJCheckBox4.gridx = 0;
                constraintsJCheckBox4.gridy = 3;
                constraintsJCheckBox4.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJCheckBox4(), constraintsJCheckBox4);
                GridBagConstraints constraintsJCheckBox5 = new GridBagConstraints();
                constraintsJCheckBox5.gridx = 0;
                constraintsJCheckBox5.gridy = 4;
                constraintsJCheckBox5.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJCheckBox5(), constraintsJCheckBox5);
                GridBagConstraints constraintsJCheckBox6 = new GridBagConstraints();
                constraintsJCheckBox6.gridx = 0;
                constraintsJCheckBox6.gridy = 5;
                constraintsJCheckBox6.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJCheckBox6(), constraintsJCheckBox6);
                GridBagConstraints constraintsJCheckBox7 = new GridBagConstraints();
                constraintsJCheckBox7.gridx = 0;
                constraintsJCheckBox7.gridy = 6;
                constraintsJCheckBox7.insets = new Insets(4, 4, 4, 4);
                this.getJPanel3().add((Component)this.getJCheckBox7(), constraintsJCheckBox7);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel3;
    }

    private JRadioButton getJRadioButtonDecimal() {
        if (this.ivjJRadioButtonDecimal == null) {
            try {
                this.ivjJRadioButtonDecimal = new JRadioButton();
                this.ivjJRadioButtonDecimal.setName("JRadioButtonDecimal");
                this.ivjJRadioButtonDecimal.setSelected(true);
                this.ivjJRadioButtonDecimal.setText("1/100 minutter");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJRadioButtonDecimal;
    }

    private JRadioButton getJRadioButtonSeconds() {
        if (this.ivjJRadioButtonSeconds == null) {
            try {
                this.ivjJRadioButtonSeconds = new JRadioButton();
                this.ivjJRadioButtonSeconds.setName("JRadioButtonSeconds");
                this.ivjJRadioButtonSeconds.setText("Sekunder");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJRadioButtonSeconds;
    }

    private JTextField getJTextFieldDistance() {
        if (this.ivjJTextFieldDistance == null) {
            try {
                this.ivjJTextFieldDistance = new JTextField();
                this.ivjJTextFieldDistance.setName("JTextFieldDistance");
                this.ivjJTextFieldDistance.setBackground(Color.gray);
                this.ivjJTextFieldDistance.setMaximumSize(new Dimension(70, 19));
                this.ivjJTextFieldDistance.setForeground(Color.yellow);
                this.ivjJTextFieldDistance.setPreferredSize(new Dimension(70, 19));
                this.ivjJTextFieldDistance.setMinimumSize(new Dimension(70, 19));
                this.ivjJTextFieldDistance.setHorizontalAlignment(0);
                this.ivjJTextFieldDistance.setEditable(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldDistance;
    }

    private LatLonTextField getJTextFieldLat() {
        if (this.ivjJTextFieldLat == null) {
            try {
                this.ivjJTextFieldLat = new LatLonTextField();
                this.ivjJTextFieldLat.setName("JTextFieldLat");
                this.ivjJTextFieldLat.setToolTipText("55 23 17 indtastes som 5523170");
                this.ivjJTextFieldLat.setPreferredSize(new Dimension(60, 19));
                this.ivjJTextFieldLat.setMaximumSize(new Dimension(60, 19));
                this.ivjJTextFieldLat.setMinimumSize(new Dimension(60, 19));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldLat;
    }

    private LatLonTextField getJTextFieldLon() {
        if (this.ivjJTextFieldLon == null) {
            try {
                this.ivjJTextFieldLon = new LatLonTextField();
                this.ivjJTextFieldLon.setName("JTextFieldLon");
                this.ivjJTextFieldLon.setToolTipText("11 23 45 indtastes som 1123450");
                this.ivjJTextFieldLon.setPreferredSize(new Dimension(60, 19));
                this.ivjJTextFieldLon.setMaximumSize(new Dimension(60, 19));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldLon;
    }

    private MapViewer getMapViewer1() {
        return this.ivjMapViewer1;
    }

    double getReducedDistance() {
        return this.reducedDistance;
    }

    private void handleException(Throwable exception) {
        COMMON.errorLog(this.getClass().getName(), exception);
    }

    private void initConnections() throws Exception {
        this.getJCheckBox2().addActionListener(this);
        this.getJCheckBox3().addActionListener(this);
        this.getJCheckBox4().addActionListener(this);
        this.getJCheckBox5().addActionListener(this);
        this.getJCheckBox6().addActionListener(this);
        this.getJCheckBox7().addActionListener(this);
        this.getJCheckBox1().addActionListener(this);
        this.addWindowListener(this);
        this.getJButtonOK().addActionListener(this);
        this.getJRadioButtonDecimal().addActionListener(this);
        this.getJRadioButtonSeconds().addActionListener(this);
        this.getJButton2().addActionListener(this);
        this.getJTextFieldLat().addKeyListener(this);
        this.getJTextFieldLat().addActionListener(this);
        this.getJTextFieldLon().addActionListener(this);
        this.getJTextFieldLon().addKeyListener(this);
    }

    private void initialize() {
        try {
            this.setName("OutLanding");
            this.setDefaultCloseOperation(2);
            this.setSize(426, 297);
            this.setContentPane(this.getJFrameContentPane());
            this.initConnections();
            this.connEtoM2();
            this.connEtoM3();
            this.connEtoM1();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.getJTextFieldLat()) {
            this.connEtoC4(e);
        }
        if (e.getSource() == this.getJTextFieldLon()) {
            this.connEtoC3(e);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void landingSpot(MouseEvent m) {
        if (COMMON.getMouseOwner() == 1 && m.getSource() == COMMON.getMapViewer()) {
            Coordinate c = new Coordinate(m.getX(), m.getY(), COMMON.getMapViewer().getOrigin(), COMMON.getMapViewer().reduction);
            this.setOutLanding(c.getLatitude(), c.getLongitude());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.getMapViewer1()) {
            this.connEtoC13(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void reCalculate() {
        if (this.isVisible()) {
            this.deselectTurnPoints();
            this.setVisible(true);
        }
    }

    private void setMapViewer1(MapViewer newValue) {
        if (this.ivjMapViewer1 != newValue) {
            try {
                if (this.ivjMapViewer1 != null) {
                    this.ivjMapViewer1.removeMouseListener(this);
                }
                this.ivjMapViewer1 = newValue;
                if (this.ivjMapViewer1 != null) {
                    this.ivjMapViewer1.addMouseListener(this);
                }
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
    }

    public void setOutLanding() {
        boolean seconds = this.getJRadioButtonSeconds().isSelected();
        if (this.getJTextFieldLat().isOk(seconds) && this.getJTextFieldLon().isOk(seconds)) {
            int lat = new Integer(this.getJTextFieldLat().getText());
            int lon = new Integer(this.getJTextFieldLon().getText());
            this.setOutLanding(lat, lon);
            this.getJButtonOK().setEnabled(true);
        } else {
            COMMON.getMapViewer().setOutLanding(null);
            this.getJButtonOK().setEnabled(false);
        }
    }

    public void setOutLanding(int lat, int lon) {
        this.coord.setLatitude(lat);
        this.coord.setLongitude(lon);
        if (this.getJRadioButtonSeconds().isSelected()) {
            this.coord = this.coord.toSeconds();
        }
        this.getJTextFieldLat().setText("" + this.coord.getLatitude());
        this.getJTextFieldLon().setText("" + this.coord.getLongitude());
        this.getJTextFieldLat().setForeground(Color.black);
        this.getJTextFieldLat().setBackground(Color.white);
        this.getJTextFieldLon().setForeground(Color.black);
        this.getJTextFieldLon().setBackground(Color.white);
        if (COMMON.getCurrentTask() != null) {
            this.setReducedDistance();
            this.setTurnPoints();
            COMMON.getMapViewer().setOutLanding(this.coord);
            this.getJButtonOK().setEnabled(true);
        }
    }

    void setReducedDistance() {
        double d;
        Coordinate t2;
        Coordinate t1;
        this.reducedDistance = 0.0;
        Task t = COMMON.getCurrentTask();
        for (int i = 0; i < this.numPoints; ++i) {
            t1 = t.coordinate(i);
            t2 = t.coordinate(i + 1);
            d = Utils.distance(t1, t2);
            this.reducedDistance += d;
        }
        if (this.coord == null) {
            this.coord = new Coordinate(0, 0);
        }
        try {
            this.coord.setLatitude(Integer.parseInt(this.getJTextFieldLat().getText()));
            this.coord.setLongitude(Integer.parseInt(this.getJTextFieldLon().getText()));
            if (this.getJRadioButtonSeconds().isSelected()) {
                this.coord = this.coord.toDecimal();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.coord.getLatitude() > 0 && this.coord.getLongitude() > 0 && t != null && (d = Utils.distance(t1 = t.coordinate(this.numPoints), t2 = t.coordinate(this.numPoints + 1)) - Utils.distance(this.coord, t2)) > 0.0) {
            this.reducedDistance += d;
        }
        this.getJTextFieldDistance().setText(COMMON.getContest().format(this.reducedDistance, 1, 5));
    }

    void setTurnPoints() {
        int points = 0;
        if (this.getJCheckBox1().isSelected()) {
            ++points;
        }
        if (this.getJCheckBox2().isSelected()) {
            ++points;
        }
        if (this.getJCheckBox3().isSelected()) {
            ++points;
        }
        if (this.getJCheckBox4().isSelected()) {
            ++points;
        }
        if (this.getJCheckBox5().isSelected()) {
            ++points;
        }
        if (this.getJCheckBox6().isSelected()) {
            ++points;
        }
        if (this.getJCheckBox7().isSelected()) {
            ++points;
        }
        COMMON.getMapViewer().setMaxPoints(points);
    }

    void setTurnPoints(int number) {
        this.numPoints = number;
        COMMON.getMapViewer().setMaxPoints(this.numPoints);
        this.getJButtonOK().setEnabled(true);
        if (this.numPoints == 1) {
            if (!this.getJCheckBox1().isSelected()) {
                this.numPoints = 0;
            }
            COMMON.getMapViewer().setMaxPoints(this.numPoints);
            this.getJCheckBox1().setSelected(this.getJCheckBox1().isSelected());
        }
        this.setReducedDistance();
        this.getJCheckBox2().setSelected(false);
        this.getJCheckBox3().setSelected(false);
        this.getJCheckBox4().setSelected(false);
        this.getJCheckBox5().setSelected(false);
        this.getJCheckBox6().setSelected(false);
        this.getJCheckBox7().setSelected(false);
        if (this.numPoints < 2) {
            return;
        }
        this.getJCheckBox1().setSelected(true);
        if (this.numPoints >= 2) {
            this.getJCheckBox2().setSelected(true);
        }
        if (this.numPoints >= 3) {
            this.getJCheckBox3().setSelected(true);
        }
        if (this.numPoints >= 4) {
            this.getJCheckBox4().setSelected(true);
        }
        if (this.numPoints >= 5) {
            this.getJCheckBox5().setSelected(true);
        }
        if (this.numPoints >= 6) {
            this.getJCheckBox6().setSelected(true);
        }
        if (this.numPoints >= 7) {
            this.getJCheckBox7().setSelected(true);
        }
    }

    @Override
    public void setVisible(boolean value) {
        if (value) {
            if (this.getJRadioButtonSeconds().isSelected()) {
                this.getJRadioButtonDecimal().setSelected(true);
                this.getJRadioButtonSeconds().setSelected(false);
            }
            this.enableTurnpoints();
            Contest contest = COMMON.getContest();
            this.getJLabelNum().setForeground(Color.red);
            this.getJLabelReg().setForeground(Color.red);
            this.getJLabelNum().setText((String)COMMON.currentContestNumber.getSelectedItem());
            this.getJLabelReg().setText(contest.getRegistration());
        }
        super.setVisible(value);
    }

    public void toggle(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.getJRadioButtonDecimal()) {
            this.getJTextFieldLat().setText("" + this.coord.getLatitude());
            this.getJTextFieldLon().setText("" + this.coord.getLongitude());
        } else {
            this.getJTextFieldLat().setText("" + this.coord.toSeconds().getLatitude());
            this.getJTextFieldLon().setText("" + this.coord.toSeconds().getLongitude());
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
        COMMON.setMouseOwner(1);
        this.getMapViewer1().setContestList(COMMON.getCurrentTask());
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.cleanUp();
        if (e.getSource() == this) {
            this.connEtoM9(e);
        }
        if (e.getSource() == this) {
            this.connEtoC12(e);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.getRootPane().setDefaultButton(this.getJButtonOK());
    }
}

