/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import glider.GDialog;
import glider.Home;
import glider.MapDecoder;
import glider.Sample;
import glider.ScrollPanel;
import glider.Track;
import glider.TrackListener;
import glider.data.Coordinate;
import glider.data.CoordinateData;
import glider.data.Task;
import glider.data.TurnPoint;
import glider.data.TurnPoints;
import glider.replay.PositionListener;
import glider.utils.Utils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class MapViewer
extends ScrollPanel
implements MouseListener,
MouseMotionListener,
TrackListener {
    private TpShower runner = null;
    private final int MAGNIFY = 5;
    private final int GLASSIZE = 140;
    private boolean magnify = false;
    private int magX = 0;
    private int magY = 0;
    private int mouseXpos;
    private int mouseYpos;
    private Image map = null;
    private Image map1 = null;
    private Image map2 = null;
    private Image[] tile4 = new Image[110];
    private Rectangle[] rect4 = new Rectangle[110];
    private Image[] tile8 = new Image[110];
    private Rectangle[] rect8 = new Rectangle[110];
    int reduction;
    private boolean showMap = true;
    private boolean showGrid = false;
    private boolean showCoords = false;
    private boolean showTask = true;
    private boolean showRestrict = false;
    private boolean showGPS = true;
    private Vector contestList = new Vector();
    private Point startLineP1;
    private Point startLineP2;
    private Vector coordinateList = null;
    private int maxPoints = -1;
    private Coordinate outLanding = null;
    private boolean scrolling = false;
    private Vector TMA = new Vector();
    private String name = null;
    private HashMap names = new HashMap();
    private Vector CTR = new Vector();
    private Vector RST = new Vector();
    private Vector DNG = new Vector();
    private Rectangle origin = null;
    private Coordinate investigatedTp = null;
    private Point cross = null;
    private static int mapHeight = 0;
    private static int mapWidth = 0;
    private static Vector[] tripSamples = new Vector[]{null, null};
    private static Vector[] prePostSamples = new Vector[]{null, null};
    private static Vector pilotEvents = null;
    private ArrayList movingPlanes = new ArrayList();
    private static Cursor grabCursor = Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(MapViewer.class.getClassLoader().getResource("glider/resourcer/grabcursor.png")).getImage(), new Point(0, 0), "custom cursor");
    private static int grabX = 0;
    private static int grabY = 0;
    static int[][][] plane = new int[360][6][2];
    boolean initialized = false;

    public MapViewer() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setVerticalScrollBarPolicy(21);
        this.setHorizontalScrollBarPolicy(31);
        for (int i = 0; i < 110; ++i) {
            String fileName = "tile8_" + i + ".map";
            this.tile8[i] = Toolkit.getDefaultToolkit().createImage(new MapDecoder(320, 420, fileName));
            this.rect8[i] = new Rectangle(i % 11 * 320, i / 11 * 420, 320, 420);
            fileName = "tile4_" + i + ".map";
            this.tile4[i] = Toolkit.getDefaultToolkit().createImage(new MapDecoder(160, 210, fileName));
            this.rect4[i] = new Rectangle(i % 11 * 160, i / 11 * 210, 160, 210);
        }
        Track.getInstance().addListener(this);
    }

    public void addMovingPlane(PositionListener plane) {
        this.movingPlanes.add(plane);
    }

    public void removeMovingPlanes() {
        this.movingPlanes.clear();
        this.repaint();
    }

    public void setContestList(Task t) {
        this.contestList.removeAllElements();
        if (t != null) {
            this.showTask = true;
            for (int i = 0; i < t.size(); ++i) {
                Point p = t.coordinate(i).latlong2xy(1);
                this.contestList.addElement(p);
            }
            if (t.size() > 1) {
                double heading = Utils.heading(t.coordinate(0), t.coordinate(1));
                heading = heading * Math.PI / 180.0;
                Point p0 = t.coordinate(0).latlong2xy(1);
                this.startLineP1 = new Point(p0.x + (int)Math.round(Math.cos(heading) * Utils.get1km() * 5.0), p0.y + (int)Math.round(Math.sin(heading) * Utils.get1km() * 5.0));
                this.startLineP2 = new Point(p0.x - (int)Math.round(Math.cos(heading) * Utils.get1km() * 5.0), p0.y - (int)Math.round(Math.sin(heading) * Utils.get1km() * 5.0));
            }
        } else {
            this.showTask = false;
        }
        this.repaint();
    }

    public void setInvestigatedTp(Coordinate tp) {
        this.investigatedTp = tp;
        this.repaint();
    }

    public void setMagnify(boolean value) {
        this.magnify = value;
        this.repaint();
    }

    public void setMaxPoints(int newValue) {
        this.maxPoints = newValue;
        this.repaint();
    }

    public void setOutLanding(Coordinate newValue) {
        this.outLanding = newValue;
        if (newValue == null) {
            this.maxPoints = -1;
        }
        this.repaint();
    }

    public void setShowCoords(boolean show) {
        this.showCoords = show;
        this.coordinateList = null;
        this.repaint();
    }

    public void setShowGPS(boolean show) {
        this.showGPS = show;
        this.repaint();
    }

    public void setShowGrid(boolean show) {
        this.showGrid = show;
        this.repaint();
    }

    public void setShowMap(boolean show) {
        this.showMap = show;
        this.repaint();
    }

    public void setShowRestrict(boolean show) {
        this.showRestrict = show;
        if (show) {
            this.readRestrict();
        }
        this.repaint();
    }

    public void setShowTask(boolean value) {
        this.showTask = value;
        this.repaint();
    }

    public void setZoom(int zoom) {
        this.reduction = 8 / zoom;
        switch (zoom) {
            case 1: {
                this.map = this.map1;
                break;
            }
            case 2: {
                this.map = this.map2;
            }
        }
        this.reSize();
        this.calcTrack();
    }

    public void getContestList(Task t) {
        this.contestList.removeAllElements();
        if (t != null) {
            for (int i = 0; i < t.size(); ++i) {
                Point p = t.coordinate(i).latlong2xy(1);
                this.contestList.addElement(p);
            }
        }
        this.repaint();
    }

    public Vector getCoordinateList() {
        return this.coordinateList;
    }

    @Override
    public Graphics getGraphics() {
        Graphics g = super.getGraphics();
        g.setClip(this.getHorizontalScrollBar().getValue(), this.getVerticalScrollBar().getValue(), this.getViewport().getWidth(), this.getViewport().getHeight());
        return g;
    }

    public int getMaxPoints() {
        return this.maxPoints;
    }

    Coordinate getOutLanding() {
        return this.outLanding;
    }

    boolean getShowRestrict() {
        return this.showRestrict;
    }

    public void addAllCoords() {
        if (this.coordinateList != null) {
            this.coordinateList.removeAllElements();
        }
        this.coordinateList = null;
        this.repaint();
    }

    public void addCoord(Coordinate coord) {
        Point p = coord.latlong2xy(1);
        if (this.coordinateList == null) {
            this.coordinateList = new Vector();
        }
        this.coordinateList.addElement(p);
        this.repaint();
    }

    private void addPolygon(PolyArray polyArray, int type) {
        boolean TMAt = false;
        boolean CTRt = true;
        int RSTt = 2;
        int DNGt = 3;
        if (polyArray == null) {
            return;
        }
        Polygon p = polyArray.poly[0];
        if (p.xpoints[0] == p.xpoints[p.npoints - 1] && p.ypoints[0] == p.ypoints[p.npoints - 1]) {
            --p.npoints;
        }
        p = polyArray.poly[1];
        if (p.xpoints[0] == p.xpoints[p.npoints - 1] && p.ypoints[0] == p.ypoints[p.npoints - 1]) {
            --p.npoints;
        }
        p = polyArray.poly[2];
        if (p.xpoints[0] == p.xpoints[p.npoints - 1] && p.ypoints[0] == p.ypoints[p.npoints - 1]) {
            --p.npoints;
        }
        p = polyArray.poly[3];
        if (p.xpoints[0] == p.xpoints[p.npoints - 1] && p.ypoints[0] == p.ypoints[p.npoints - 1]) {
            --p.npoints;
        }
        switch (type) {
            case 3: {
                this.DNG.addElement(polyArray);
                break;
            }
            case 2: {
                this.RST.addElement(polyArray);
                break;
            }
            case 1: {
                this.CTR.addElement(polyArray);
                break;
            }
            default: {
                this.TMA.addElement(polyArray);
                if (this.name == null) break;
                this.names.put(polyArray, this.name);
            }
        }
    }

    public void calcTrack() {
        Coordinate coord;
        Sample s;
        int i;
        if (Track.getInstance().getSize() < 1) {
            MapViewer.prePostSamples[0] = null;
            MapViewer.prePostSamples[1] = null;
            MapViewer.tripSamples[0] = null;
            MapViewer.tripSamples[1] = null;
            pilotEvents = null;
            this.repaint();
            return;
        }
        int INIT = -1;
        boolean PREPOST = false;
        boolean TRIP = true;
        int last = -1;
        int next = -1;
        int lastx = -1;
        int lasty = -1;
        int lastX = -1;
        int lastY = -1;
        MapViewer.tripSamples[0] = new Vector();
        MapViewer.tripSamples[1] = new Vector();
        MapViewer.prePostSamples[0] = new Vector();
        MapViewer.prePostSamples[1] = new Vector();
        Polygon[] poly = new Polygon[]{null, null};
        Vector p = Track.getInstance().getPilotEvents();
        pilotEvents = new Vector();
        if (p != null) {
            for (i = 0; i < p.size(); ++i) {
                s = (Sample)p.elementAt(i);
                coord = new Coordinate(s.lat, s.lon);
                Point point = coord.latlong2xy(1);
                pilotEvents.addElement(point);
            }
        }
        for (i = 0; i < Track.getInstance().getSize(); ++i) {
            s = (Sample)Track.getInstance().getSamples().elementAt(i);
            next = i < Track.getInstance().getStart() || i > Track.getInstance().getEnd() ? 0 : 1;
            if (next != last) {
                switch (last) {
                    case 0: {
                        prePostSamples[0].addElement(poly[0]);
                        prePostSamples[1].addElement(poly[1]);
                        break;
                    }
                    case 1: {
                        tripSamples[0].addElement(poly[0]);
                        tripSamples[1].addElement(poly[1]);
                        break;
                    }
                }
                poly[0] = new Polygon();
                poly[1] = new Polygon();
            }
            coord = new Coordinate(s.lat, s.lon);
            int x = coord.latlong2xy((int)this.reduction).x;
            int y = coord.latlong2xy((int)this.reduction).y;
            if (x != lastx || y != lasty) {
                poly[0].addPoint(x, y);
            }
            lastx = x;
            lasty = y;
            x = coord.latlong2xy((int)1).x * 5 / this.reduction;
            y = coord.latlong2xy((int)1).y * 5 / this.reduction;
            if (x != lastX || y != lastY) {
                poly[1].addPoint(x, y);
            }
            lastX = x;
            lastY = y;
            last = next;
        }
        switch (last) {
            case 0: {
                prePostSamples[0].addElement(poly[0]);
                prePostSamples[1].addElement(poly[1]);
                break;
            }
            case 1: {
                tripSamples[0].addElement(poly[0]);
                tripSamples[1].addElement(poly[1]);
                break;
            }
        }
        this.repaint();
    }

    private void circle(Graphics g, int x, int y, Color color) {
        Color saveColor = g.getColor();
        int size = 8 / this.reduction + 1;
        g.setColor(color);
        for (int i = -1; i < 1; ++i) {
            for (int j = -1; j < 1; ++j) {
                g.drawOval(x - size + i, y - size + j, 2 * size, 2 * size);
            }
        }
        g.setColor(saveColor);
    }

    private void circle(Graphics g, int x, int y) {
        this.circle(g, x, y, Color.red);
    }

    @Override
    public void detailChanged() {
        this.calcTrack();
    }

    void drawContest(Graphics g) {
        Point p2;
        boolean showOutLanding;
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        if (this.contestList.size() < 1) {
            return;
        }
        Point p1 = (Point)this.contestList.elementAt(0);
        this.circle(g, p1.x / this.reduction, p1.y / this.reduction);
        boolean bl = showOutLanding = COMMON.getMouseOwner() == 1;
        if (showOutLanding) {
            g.setColor(Color.yellow);
        } else {
            g.setColor(Color.white);
        }
        for (int i = 0; !(i >= this.contestList.size() - 1 || this.maxPoints >= 0 && i >= this.maxPoints && showOutLanding); ++i) {
            x1 = p1.x / this.reduction;
            y1 = p1.y / this.reduction;
            p2 = (Point)this.contestList.elementAt(i + 1);
            x2 = p2.x / this.reduction;
            y2 = p2.y / this.reduction;
            this.circle(g, x2, y2);
            g.drawLine(x1, y1, x2, y2);
            p1 = p2;
        }
        if (this.outLanding != null && showOutLanding) {
            x1 = p1.x / this.reduction;
            y1 = p1.y / this.reduction;
            p2 = this.outLanding.latlong2xy(1);
            x2 = p2.x / this.reduction;
            y2 = p2.y / this.reduction;
            g.drawLine(x1, y1, x2, y2);
            p2 = (Point)this.contestList.elementAt(this.maxPoints + 1);
            x2 = p2.x / this.reduction;
            y2 = p2.y / this.reduction;
            g.setColor(Color.cyan);
            g.drawLine(x1, y1, x2, y2);
            this.circle(g, x1, y1);
            this.circle(g, x2, y2);
        }
        g.setColor(Color.green);
        if (this.startLineP1 != null && this.startLineP2 != null) {
            g.drawLine(this.startLineP1.x / this.reduction, this.startLineP1.y / this.reduction, this.startLineP2.x / this.reduction, this.startLineP2.y / this.reduction);
        }
    }

    void drawCoords(Graphics g) {
        Point p;
        if (this.coordinateList == null) {
            this.coordinateList = new Vector();
            TurnPoints turnpoints = new TurnPoints();
            for (int j = 0; j < turnpoints.count(); ++j) {
                TurnPoint t = (TurnPoint)turnpoints.elementAt(j);
                p = new Coordinate(t.latlon).latlong2xy(1);
                this.coordinateList.addElement(p);
            }
        }
        for (int i = 0; i < this.coordinateList.size(); ++i) {
            p = (Point)this.coordinateList.elementAt(i);
            this.circle(g, p.x / this.reduction, p.y / this.reduction);
        }
    }

    private void drawCross(Graphics g) {
        if (Track.getInstance().getSelectedSampleIndex() < 0) {
            return;
        }
        g.setColor(Color.cyan);
        Sample s = Track.getInstance().getSelectedSample();
        Coordinate cs = new Coordinate(s.lat, s.lon);
        int x = cs.latlong2xy((int)this.reduction).x;
        int y = cs.latlong2xy((int)this.reduction).y;
        int r = 9;
        g.drawLine(x - 5, y - 5, x + 5, y + 5);
        g.drawLine(x - 5, y + 5, x + 5, y - 5);
        g.drawOval(x - r + 1, y - r + 1, 2 * r, 2 * r);
    }

    void drawGrid(Graphics g) {
        Point p2;
        Point p1;
        int delta;
        int lonMin = 800000;
        int lonMax = 1300000;
        int latMin = 5400000;
        int latMax = 5800000;
        g.setColor(Color.black);
        for (int lon = lonMin; lon <= lonMax; lon += 100000) {
            for (delta = 0; delta < 60000; delta += 20000) {
                p1 = new Coordinate(latMin, lon + delta).latlong2xy(this.reduction);
                p2 = new Coordinate(latMax, lon + delta).latlong2xy(this.reduction);
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
            }
            g.setColor(Color.white);
            for (int lat = latMin; lat <= latMax; lat += 100000) {
                p1 = new Coordinate(lat, lon).latlong2xy(this.reduction);
                g.drawString("" + lon / 100000, p1.x + 5, p1.y - 5);
            }
            g.setColor(Color.black);
        }
        for (int lat = latMin; lat <= latMax; lat += 100000) {
            for (delta = 0; delta < 60000; delta += 20000) {
                for (int lon = lonMin; lon < lonMax; lon += 20000) {
                    p1 = new Coordinate(lat + delta, lon).latlong2xy(this.reduction);
                    p2 = new Coordinate(lat + delta, lon + 20000).latlong2xy(this.reduction);
                    g.drawLine(p1.x, p1.y, p2.x, p2.y);
                }
            }
            g.setColor(Color.white);
            g.drawString("" + lat / 100000, 20, new Coordinate((int)lat, (int)lonMin).latlong2xy((int)this.reduction).y - 5);
            g.setColor(Color.black);
        }
    }

    private void drawMap(Graphics g) {
        if (this.reduction == 1) {
            for (int i = 0; i < 110; ++i) {
                if (!g.getClip().getBounds().intersects(this.rect8[i])) continue;
                g.drawImage(this.tile8[i], this.rect8[i].x, this.rect8[i].y, null);
            }
        } else if (this.reduction == 2) {
            for (int i = 0; i < 110; ++i) {
                if (!g.getClip().getBounds().intersects(this.rect4[i])) continue;
                g.drawImage(this.tile4[i], this.rect4[i].x, this.rect4[i].y, null);
            }
        } else {
            g.drawImage(this.map, 0, 0, mapWidth, mapHeight, null);
        }
    }

    public void drawRestrict(Graphics g) {
        PolyArray polyArray;
        int i;
        int p = 0;
        switch (this.reduction) {
            case 1: {
                p = 0;
                break;
            }
            case 2: {
                p = 1;
                break;
            }
            case 4: {
                p = 2;
                break;
            }
            case 8: {
                p = 3;
            }
        }
        for (i = 0; i < this.TMA.size(); ++i) {
            polyArray = (PolyArray)this.TMA.elementAt(i);
            String myName = (String)this.names.get(polyArray);
            g.setColor(Color.green);
            g.drawPolygon(polyArray.poly[p]);
            g.setColor(new Color(0, 255, 0, 50));
            g.fillPolygon(polyArray.poly[p]);
            if (myName == null) continue;
            Font f = g.getFont();
            Font newFont = new Font(f.getName(), f.getStyle(), 72 / this.reduction);
            g.setFont(newFont);
            FontMetrics fm = g.getFontMetrics();
            int width = fm.stringWidth(myName);
            int height = fm.getHeight();
            Rectangle r = polyArray.poly[p].getBounds();
            int x = r.x + (r.width - width) / 2;
            int y = r.y + r.height / 2 + height / 4;
            g.setColor(Color.green);
            g.drawString(myName, x, y);
            g.setFont(f);
        }
        for (i = 0; i < this.CTR.size(); ++i) {
            g.setColor(Color.yellow);
            polyArray = (PolyArray)this.CTR.elementAt(i);
            g.drawPolygon(polyArray.poly[p]);
            g.setColor(new Color(255, 255, 0, 100));
            g.fillPolygon(polyArray.poly[p]);
        }
        for (i = 0; i < this.DNG.size(); ++i) {
            g.setColor(Color.red);
            polyArray = (PolyArray)this.DNG.elementAt(i);
            g.drawPolygon(polyArray.poly[p]);
            g.setColor(new Color(255, 0, 0, 100));
            g.fillPolygon(polyArray.poly[p]);
        }
        for (i = 0; i < this.RST.size(); ++i) {
            g.setColor(Color.red);
            polyArray = (PolyArray)this.RST.elementAt(i);
            g.drawPolygon(polyArray.poly[p]);
            g.setColor(new Color(255, 0, 0, 100));
            g.fillPolygon(polyArray.poly[p]);
        }
    }

    void drawTrack(Graphics g) {
        int i;
        if (this.investigatedTp != null) {
            int x = this.investigatedTp.latlong2xy((int)this.reduction).x;
            int y = this.investigatedTp.latlong2xy((int)this.reduction).y;
            g.setColor(Color.yellow);
            int dx = 35 / this.reduction;
            int dy = 25 / this.reduction;
            g.drawLine(x - dx, y + dy, x + dx, y + dy);
            g.drawLine(x - dx, y - dy, x + dx, y - dy);
            g.drawLine(x + dx, y - dy, x + dx, y + dy);
            g.drawLine(x - dx, y - dy, x - dx, y + dy);
        }
        if (prePostSamples[0] != null) {
            g.setColor(Color.lightGray);
            for (i = 0; i < prePostSamples[0].size(); ++i) {
                Polygon p = (Polygon)prePostSamples[0].elementAt(i);
                g.drawPolyline(p.xpoints, p.ypoints, p.npoints);
            }
        }
        if (tripSamples[0] != null) {
            g.setColor(Color.yellow);
            for (i = 0; i < tripSamples[0].size(); ++i) {
                Polygon p = (Polygon)tripSamples[0].elementAt(i);
                g.drawPolyline(p.xpoints, p.ypoints, p.npoints);
            }
        }
        if (pilotEvents != null) {
            for (int j = 0; j < pilotEvents.size(); ++j) {
                Point p = (Point)pilotEvents.elementAt(j);
                this.circle(g, p.x / this.reduction, p.y / this.reduction, Color.black);
            }
        }
        if (Track.getInstance().getSamples().size() < 1) {
            return;
        }
        if (Track.getInstance().getSelectedSampleIndex() < 0) {
            return;
        }
        this.drawCross(g);
    }

    private void drawZoomed(Graphics g) {
        int dx = this.getOrigin().x;
        int dy = this.getOrigin().y;
        Graphics gm = g.create(this.magX - dx - 70, this.magY - dy - 70, 140, 140);
        gm.setColor(Color.lightGray);
        gm.setPaintMode();
        gm.fillOval(0, 0, 140, 140);
        gm.setColor(Color.black);
        gm.drawOval(0, 0, 140, 140);
        if (this.showRestrict) {
            this.drawZoomedRestrict(gm);
        }
        this.drawZoomedTrack(gm);
    }

    public void drawZoomedRestrict(Graphics g) {
        int n;
        Polygon poly;
        PolyArray polyArray;
        int i;
        int xOffset = 5 * (this.magX - this.getOrigin().x) - 70;
        int yOffset = 5 * (this.magY - this.getOrigin().y) - 70;
        int p = 0;
        switch (this.reduction) {
            case 1: {
                p = 0;
                break;
            }
            case 2: {
                p = 1;
                break;
            }
            case 4: {
                p = 2;
                break;
            }
            case 8: {
                p = 3;
            }
        }
        g.setColor(Color.green);
        for (i = 0; i < this.TMA.size(); ++i) {
            polyArray = (PolyArray)this.TMA.elementAt(i);
            poly = polyArray.poly[p];
            for (n = 0; n < poly.npoints - 1; ++n) {
                g.drawLine(poly.xpoints[n] * 5 - xOffset, poly.ypoints[n] * 5 - yOffset, poly.xpoints[n + 1] * 5 - xOffset, poly.ypoints[n + 1] * 5 - yOffset);
            }
        }
        g.setColor(Color.yellow);
        for (i = 0; i < this.CTR.size(); ++i) {
            polyArray = (PolyArray)this.CTR.elementAt(i);
            poly = polyArray.poly[p];
            for (n = 0; n < poly.npoints - 1; ++n) {
                g.drawLine(poly.xpoints[n] * 5 - xOffset, poly.ypoints[n] * 5 - yOffset, poly.xpoints[n + 1] * 5 - xOffset, poly.ypoints[n + 1] * 5 - yOffset);
            }
        }
        g.setColor(Color.red);
        for (i = 0; i < this.DNG.size(); ++i) {
            polyArray = (PolyArray)this.DNG.elementAt(i);
            poly = polyArray.poly[p];
            for (n = 0; n < poly.npoints - 1; ++n) {
                g.drawLine(poly.xpoints[n] * 5 - xOffset, poly.ypoints[n] * 5 - yOffset, poly.xpoints[n + 1] * 5 - xOffset, poly.ypoints[n + 1] * 5 - yOffset);
            }
        }
        for (i = 0; i < this.RST.size(); ++i) {
            polyArray = (PolyArray)this.RST.elementAt(i);
            poly = polyArray.poly[p];
            for (n = 0; n < poly.npoints - 1; ++n) {
                g.drawLine(poly.xpoints[n] * 5 - xOffset, poly.ypoints[n] * 5 - yOffset, poly.xpoints[n + 1] * 5 - xOffset, poly.ypoints[n + 1] * 5 - yOffset);
            }
        }
    }

    void drawZoomedTrack(Graphics g) {
        int n;
        Polygon p;
        int i;
        int xOffset = 5 * (this.magX - this.getOrigin().x) - 70;
        int yOffset = 5 * (this.magY - this.getOrigin().y) - 70;
        if (prePostSamples[1] != null) {
            g.setColor(Color.black);
            for (i = 0; i < prePostSamples[1].size(); ++i) {
                p = (Polygon)prePostSamples[1].elementAt(i);
                for (n = 0; n < p.npoints - 1; ++n) {
                    g.drawLine(p.xpoints[n] - xOffset, p.ypoints[n] - yOffset, p.xpoints[n + 1] - xOffset, p.ypoints[n + 1] - yOffset);
                }
            }
        }
        if (tripSamples[1] != null) {
            g.setColor(Color.cyan);
            for (i = 0; i < tripSamples[1].size(); ++i) {
                p = (Polygon)tripSamples[1].elementAt(i);
                for (n = 0; n < p.npoints - 1; ++n) {
                    g.drawLine(p.xpoints[n] - xOffset, p.ypoints[n] - yOffset, p.xpoints[n + 1] - xOffset, p.ypoints[n + 1] - yOffset);
                }
            }
        }
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if ((flags & 0x20) != 0) {
            this.reSize();
            return false;
        }
        if ((flags & 2) != 0) {
            mapHeight = h;
        }
        if ((flags & 1) != 0) {
            mapWidth = w;
        }
        if ((flags & 3) != 0 && mapWidth > 0 && mapHeight > 0) {
            this.reSize();
        }
        return true;
    }

    public void init(JFrame parent) {
        int w1 = 440;
        int h1 = 525;
        int w2 = 880;
        int h2 = 1050;
        MapDecoder md1 = new MapDecoder(440, 525, "map1.map");
        this.map1 = Toolkit.getDefaultToolkit().createImage(md1);
        MapDecoder md2 = new MapDecoder(880, 1050, "map2.map");
        this.map2 = Toolkit.getDefaultToolkit().createImage(md2);
        this.map = this.map1;
        this.setZoom(8 / COMMON.config.initialReduction);
        this.getHorizontalScrollBar().setValue(COMMON.config.initialX);
        this.getVerticalScrollBar().setValue(COMMON.config.initialY);
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int deltaX = this.getHorizontalScrollBar().getValue() + grabX - e.getX();
        int deltaY = this.getVerticalScrollBar().getValue() + grabY - e.getY();
        grabX = e.getX();
        grabY = e.getY();
        this.getHorizontalScrollBar().setValue(deltaX);
        this.getVerticalScrollBar().setValue(deltaY);
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.runner != null) {
            this.runner.stopMe();
            this.runner = null;
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.showCoords) {
            this.start(e);
        }
        if (this.magnify) {
            this.magX = e.getX();
            this.magY = e.getY();
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.scrolling = true;
        grabX = e.getX();
        grabY = e.getY();
        this.setCursor(grabCursor);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.scrolling = false;
        this.repaint();
    }

    @Override
    public void panelPaint(Graphics g) {
        this.origin = g.getClipBounds();
        if (this.map != null && this.showMap) {
            this.drawMap(g);
        }
        if (!this.scrolling && this.showGrid) {
            this.drawGrid(g);
        }
        if (!this.scrolling && this.showRestrict) {
            this.drawRestrict(g);
        }
        if (!this.scrolling && this.showCoords) {
            this.drawCoords(g);
        }
        if (this.showTask) {
            this.drawContest(g);
        }
        if (this.showGPS) {
            this.drawTrack(g);
        }
        if (this.magnify && !this.scrolling) {
            this.drawZoomed(g);
        }
        try {
            for (int i = 0; i < this.movingPlanes.size(); ++i) {
                PositionListener l = (PositionListener)this.movingPlanes.get(i);
                this.drawPlane(g, l.getName(), l.getColor(), l.getHeight(), l.getCourse(), l.getCoordinate());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void drawPlane(Graphics g, String name, Color color, int height, int course, Coordinate coord) {
        if (coord == null) {
            return;
        }
        g.setColor(Color.blue.darker());
        Point loc = coord.latlong2xy(this.reduction);
        g.drawLine(loc.x, loc.y, loc.x, loc.y - height);
        loc.y -= height;
        g.setColor(Color.black);
        g.drawString(name, loc.x + 5, loc.y - 5);
        g.drawLine(loc.x + plane[course][0][0], loc.y + plane[course][0][1], loc.x + plane[course][1][0], loc.y + plane[course][1][1]);
        g.drawLine(loc.x + plane[course][2][0], loc.y + plane[course][2][1], loc.x + plane[course][3][0], loc.y + plane[course][3][1]);
        g.drawLine(loc.x + plane[course][4][0], loc.y + plane[course][4][1], loc.x + plane[course][5][0], loc.y + plane[course][5][1]);
        g.setColor(color);
        --loc.x;
        ++loc.y;
        g.drawString(name, loc.x + 5, loc.y - 5);
        g.drawLine(loc.x + plane[course][0][0], loc.y + plane[course][0][1], loc.x + plane[course][1][0], loc.y + plane[course][1][1]);
        g.drawLine(loc.x + plane[course][2][0], loc.y + plane[course][2][1], loc.x + plane[course][3][0], loc.y + plane[course][3][1]);
        g.drawLine(loc.x + plane[course][4][0], loc.y + plane[course][4][1], loc.x + plane[course][5][0], loc.y + plane[course][5][1]);
    }

    private void readRestrict() {
        String line = null;
        PolyArray polyArray = null;
        boolean TMAt = false;
        boolean CTRt = true;
        int RSTt = 2;
        int DNGt = 3;
        int type = 0;
        this.DNG.removeAllElements();
        this.RST.removeAllElements();
        this.CTR.removeAllElements();
        this.TMA.removeAllElements();
        File file = new File(Home.getResources() + "luftrum.txt");
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                if (line.length() < 1 || line.startsWith(";") || line.startsWith("=") || line.startsWith(">")) {
                    this.addPolygon(polyArray, type);
                    polyArray = null;
                    this.name = null;
                    continue;
                }
                if (!line.endsWith("E")) {
                    if (line.endsWith("Danger")) {
                        type = 3;
                    } else if (line.endsWith("Restricted")) {
                        type = 2;
                    } else if (line.endsWith("CTR")) {
                        type = 1;
                    } else if (line.endsWith("TMA")) {
                        type = 0;
                    } else {
                        type = 0;
                        if (line.endsWith("SVFOM") || line.endsWith("Transit")) {
                            StringTokenizer st = new StringTokenizer(line);
                            this.name = st.nextToken();
                        }
                    }
                    this.addPolygon(polyArray, type);
                    polyArray = null;
                    continue;
                }
                int lat = 0;
                int lon = 0;
                Coordinate coord = null;
                try {
                    lat = new Integer(line.substring(0, line.indexOf(78)));
                    lon = new Integer(line.substring(line.indexOf(78) + 1, line.indexOf(69)));
                    coord = new Coordinate(lat * 10, lon * 10);
                    if (polyArray == null) {
                        polyArray = new PolyArray();
                        polyArray.poly[0] = new Polygon();
                        polyArray.poly[1] = new Polygon();
                        polyArray.poly[2] = new Polygon();
                        polyArray.poly[3] = new Polygon();
                    }
                    polyArray.poly[0].addPoint(coord.latlong2xy((int)1).x / 1, coord.latlong2xy((int)1).y / 1);
                    polyArray.poly[1].addPoint(coord.latlong2xy((int)1).x / 2, coord.latlong2xy((int)1).y / 2);
                    polyArray.poly[2].addPoint(coord.latlong2xy((int)1).x / 4, coord.latlong2xy((int)1).y / 4);
                    polyArray.poly[3].addPoint(coord.latlong2xy((int)1).x / 8, coord.latlong2xy((int)1).y / 8);
                }
                catch (Exception e) {
                    GDialog.error(this, "Fejl i " + file.getAbsolutePath() + ":\nLinie: " + line);
                }
            }
            this.addPolygon(polyArray, type);
            in.close();
        }
        catch (IOException ioe) {
            GDialog.error(this, "Fejl i " + file.getAbsolutePath() + ":\nLinie: " + line);
        }
    }

    public void removeAllCoords() {
        if (this.coordinateList != null) {
            this.coordinateList.removeAllElements();
            this.repaint();
        }
    }

    public void removeCoord(Coordinate coord) {
        if (coord == null) {
            return;
        }
        Point p = coord.latlong2xy(1);
        for (int i = 0; i < this.coordinateList.size(); ++i) {
            Point p2 = (Point)this.coordinateList.elementAt(i);
            if (!p.equals(p2)) continue;
            this.coordinateList.removeElementAt(i);
            this.repaint();
            return;
        }
    }

    public void reSize() {
        int i;
        if (this.reduction == 1) {
            mapWidth = 3520;
            mapHeight = 4200;
        } else if (this.reduction == 2) {
            mapWidth = 1760;
            mapHeight = 2100;
        } else if (this.map != null) {
            mapWidth = this.map.getWidth(this);
            mapHeight = this.map.getHeight(this);
        } else {
            mapWidth = 0;
            mapHeight = 0;
        }
        int midX = 0;
        int midY = 0;
        midX = this.getHorizontalScrollBar().getValue() + this.getViewport().getWidth() / 2;
        midY = this.getVerticalScrollBar().getValue() + this.getViewport().getHeight() / 2;
        int oldHeight = this.getPanelSize().height;
        this.setPanelSize(mapWidth, mapHeight);
        double change = (double)this.getPanelSize().height / (double)oldHeight;
        int val = (int)((double)midX * change - (double)(this.getViewport().getWidth() / 2));
        for (i = 0; i < 3; ++i) {
            this.getHorizontalScrollBar().setValue(val);
            if (this.getHorizontalScrollBar().getValue() == val) break;
        }
        val = (int)((double)midY * change - (double)(this.getViewport().getHeight() / 2));
        for (i = 0; i < 3; ++i) {
            this.getVerticalScrollBar().setValue(val);
            if (this.getVerticalScrollBar().getValue() == val) break;
        }
    }

    @Override
    public void selectedChanged() {
        this.repaint();
    }

    void start(MouseEvent e) {
        if (this.runner != null) {
            this.runner.stopMe();
            this.runner = null;
        }
        this.mouseXpos = e.getX();
        this.mouseYpos = e.getY();
        this.runner = new TpShower();
        this.runner.start();
    }

    public void store() {
        COMMON.config.store(this.reduction, this.getHorizontalScrollBar().getValue(), this.getVerticalScrollBar().getValue());
    }

    @Override
    public void trackChanged() {
        this.calcTrack();
    }

    public int getReduction() {
        return this.reduction;
    }

    @Override
    public void setPanelSize(int width, int height) {
        super.setPanelSize(width, height);
        if (!this.initialized) {
            this.initialized = true;
            this.getHorizontalScrollBar().setValue(COMMON.config.initialX);
            if (this.getHorizontalScrollBar().getValue() != COMMON.config.initialX) {
                this.initialized = false;
            }
            this.getVerticalScrollBar().setValue(COMMON.config.initialY);
            if (this.getVerticalScrollBar().getValue() != COMMON.config.initialY) {
                this.initialized = false;
            }
        }
    }

    static {
        for (int course = 0; course < 360; ++course) {
            double heading = (double)course * Math.PI / 180.0;
            double cos_track = Math.cos(heading);
            double sin_track = Math.sin(heading);
            MapViewer.plane[course][0][0] = (int)(cos_track * -10.0 - sin_track * -1.0);
            MapViewer.plane[course][0][1] = (int)(sin_track * -10.0 + cos_track * -1.0);
            MapViewer.plane[course][1][0] = (int)(cos_track * 10.0 - sin_track * -1.0);
            MapViewer.plane[course][1][1] = (int)(sin_track * 10.0 + cos_track * -1.0);
            MapViewer.plane[course][2][0] = (int)(cos_track * -2.0 - sin_track * 6.0);
            MapViewer.plane[course][2][1] = (int)(sin_track * -2.0 + cos_track * 6.0);
            MapViewer.plane[course][3][0] = (int)(cos_track * 2.0 - sin_track * 6.0);
            MapViewer.plane[course][3][1] = (int)(sin_track * 2.0 + cos_track * 6.0);
            MapViewer.plane[course][4][0] = (int)(cos_track * 0.0 - sin_track * -3.0);
            MapViewer.plane[course][4][1] = (int)(sin_track * 0.0 + cos_track * -3.0);
            MapViewer.plane[course][5][0] = (int)(cos_track * 0.0 - sin_track * 6.0);
            MapViewer.plane[course][5][1] = (int)(sin_track * 0.0 + cos_track * 6.0);
        }
    }

    private class TpShower
    extends Thread
    implements Runnable {
        private boolean stopped;

        public TpShower() {
            super(MapViewer.this.runner);
            this.stopped = false;
        }

        public void stopMe() {
            this.stopped = true;
            MapViewer.this.repaint();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(350L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.stopped) {
                return;
            }
            Coordinate coord = new Coordinate(MapViewer.this.mouseXpos, MapViewer.this.mouseYpos, MapViewer.this.getOrigin(), MapViewer.this.reduction);
            TurnPoints tps = COMMON.getTurnPoints();
            TurnPoint t = tps.getNearest(coord);
            Graphics g = MapViewer.this.getPanelGraphics();
            Color c = g.getColor();
            g.setColor(Color.yellow);
            int x = new Coordinate((CoordinateData)t.latlon).latlong2xy((int)MapViewer.this.reduction).x;
            int y = new Coordinate((CoordinateData)t.latlon).latlong2xy((int)MapViewer.this.reduction).y;
            int nameLen = g.getFontMetrics().charsWidth(t.description.toCharArray(), 0, t.description.length());
            int nameHgt = g.getFontMetrics().getHeight();
            g.fillRect(x, y - nameHgt + 2, nameLen, nameHgt);
            g.setColor(Color.black);
            g.drawString(t.description, x, y - 2);
            g.setColor(c);
            try {
                Thread.sleep(4000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.stopped) {
                MapViewer.this.repaint();
            }
        }
    }

    protected class PolyArray {
        Polygon[] poly = new Polygon[]{null, null, null, null};

        protected PolyArray() {
        }
    }
}

