/*
 * Decompiled with CFR 0.152.
 */
package glider;

import java.awt.Color;
import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.Document;

class LatLonTextField
extends JTextField {
    public LatLonTextField() {
    }

    public LatLonTextField(int columns) {
        super(columns);
    }

    public LatLonTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
    }

    public LatLonTextField(String text) {
        super(text);
    }

    public LatLonTextField(String text, int columns) {
        super(text, columns);
    }

    public boolean check(boolean seconds) {
        boolean ok = true;
        if (this.getText().length() < 1) {
            return false;
        }
        try {
            int i = new Integer(this.getText());
            if (i < 0) {
                i = -i;
            }
            this.setText("" + i);
            if (this.getText().length() > 7) {
                ok = false;
            }
        }
        catch (Exception e) {
            ok = false;
        }
        if (!ok) {
            this.getToolkit();
            Toolkit.getDefaultToolkit().beep();
            this.setText(this.getText().substring(0, this.getText().length() - 1));
        }
        if (ok = this.getName().endsWith("Lat") ? this.checkLatLon(54, 57, seconds) : this.checkLatLon(8, 12, seconds)) {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
        } else if (this.getText().length() == 7) {
            this.setBackground(Color.red);
            this.setForeground(Color.white);
        } else {
            this.setBackground(Color.yellow);
            this.setForeground(Color.black);
        }
        return ok;
    }

    private boolean checkLatLon(int min, int max, boolean seconds) {
        try {
            int lat = new Integer(this.getText());
            int deg = lat / 100000;
            if (deg < min || deg > max) {
                return false;
            }
            int minutes = lat / 1000 % 100;
            if (minutes > 59) {
                return false;
            }
            int sec = lat / 10 % 100;
            return !seconds || sec <= 59;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isOk(boolean seconds) {
        return this.check(seconds);
    }
}

