/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.GliderFrame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class Handicap
extends GliderFrame {
    private Vector list = new Vector();
    private static Handicap instance;

    private Handicap() {
        this.read();
        this.sort();
    }

    public static Handicap getInstance() {
        if (instance == null) {
            instance = new Handicap();
        }
        return instance;
    }

    public void fill(DefaultListModel defaultListModel, int rows) {
        defaultListModel.removeAllElements();
        for (int i = 0; i < this.list.size(); ++i) {
            defaultListModel.addElement(((Record)this.list.elementAt((int)i)).plane);
            if (i < rows - 1) continue;
            return;
        }
    }

    public void fill(DefaultListModel defaultListModel, String filter, int rows) {
        int j = 0;
        defaultListModel.removeAllElements();
        for (int i = 0; i < this.list.size(); ++i) {
            if (((Record)this.list.elementAt((int)i)).plane.toUpperCase().indexOf(filter.toUpperCase()) < 0) continue;
            defaultListModel.addElement(((Record)this.list.elementAt((int)i)).plane);
            if (j++ < rows - 1) continue;
            return;
        }
    }

    public String get(String plane) {
        if (plane != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                if (!((Record)this.list.elementAt((int)i)).plane.toUpperCase().equals(plane.toUpperCase())) continue;
                return Integer.toString(((Record)this.list.elementAt((int)i)).handicap);
            }
        }
        return "";
    }

    void read() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("glider/resourcer/daec.txt");
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if (line.length() < 1 || line.indexOf(35) >= 0) continue;
                int index = line.indexOf("\t");
                int handicap = Integer.parseInt(line.substring(0, index));
                String type = line.substring(index + 1);
                this.list.addElement(new Record(handicap, type));
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void sort() {
        boolean unsorted = true;
        while (unsorted) {
            unsorted = false;
            for (int i = 0; i < this.list.size() - 1; ++i) {
                if (((Record)this.list.elementAt((int)i)).plane.compareTo(((Record)this.list.elementAt((int)(i + 1))).plane) <= 0) continue;
                unsorted = true;
                this.list.insertElementAt(this.list.elementAt(i + 1), i);
                this.list.removeElementAt(i + 2);
            }
        }
    }

    private class Record {
        int handicap;
        String plane;

        Record(int handicap2, String plane) {
            this.handicap = handicap2;
            this.plane = plane;
        }
    }
}

