/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class Flights
extends JDialog {
    private Vector flights = null;
    private ButtonGroup ivjButtonGroup1 = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JButton jButtonOK = null;
    private JPanel ivjJFrameContentPane = null;
    private JRadioButton[] jRadioButtons = null;
    private int[] flightNos = null;

    public Flights(Vector flights) {
        this.flights = flights;
        this.initialize();
    }

    private ButtonGroup getButtonGroup1() {
        if (this.ivjButtonGroup1 == null) {
            try {
                this.ivjButtonGroup1 = new ButtonGroup();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonGroup1;
    }

    private JButton getJButtonOK() {
        if (this.jButtonOK == null) {
            try {
                this.jButtonOK = new JButton();
                this.jButtonOK.setName("JButton1");
                this.jButtonOK.setText("OK");
                this.jButtonOK.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.jButtonOK;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new GridBagLayout());
                int nflights = this.flights.size() / 2;
                this.flightNos = new int[nflights];
                GridBagConstraints[] constraintsJRadioButtons = new GridBagConstraints[nflights];
                this.jRadioButtons = new JRadioButton[nflights];
                for (int i = 0; i < nflights; ++i) {
                    this.flightNos[i] = (Integer)this.flights.elementAt(2 * i);
                    this.jRadioButtons[i] = new JRadioButton((String)this.flights.elementAt(2 * i + 1));
                    constraintsJRadioButtons[i] = new GridBagConstraints();
                    constraintsJRadioButtons[i].gridx = 0;
                    constraintsJRadioButtons[i].gridy = i;
                    constraintsJRadioButtons[i].gridwidth = 2;
                    constraintsJRadioButtons[i].anchor = 17;
                    constraintsJRadioButtons[i].insets = new Insets(4, 4, 4, 4);
                    this.ivjJFrameContentPane.add((Component)this.jRadioButtons[i], constraintsJRadioButtons[i]);
                    this.getButtonGroup1().add(this.jRadioButtons[i]);
                    this.jRadioButtons[i].addActionListener(this.ivjEventHandler);
                }
                GridBagConstraints constraintsJButton1 = new GridBagConstraints();
                constraintsJButton1.gridx = 1;
                constraintsJButton1.gridy = nflights;
                constraintsJButton1.insets = new Insets(4, 4, 4, 4);
                this.ivjJFrameContentPane.add((Component)this.getJButtonOK(), constraintsJButton1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFrameContentPane;
    }

    public int getSelection() {
        for (int i = 0; i < this.flights.size() / 2; ++i) {
            if (!this.jRadioButtons[i].isSelected()) continue;
            return this.flightNos[i];
        }
        return 0;
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.selection();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void handleException(Throwable exception) {
        COMMON.errorLog(this.getClass().getName(), exception);
    }

    private void initConnections() throws Exception {
        this.getJButtonOK().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setModal(true);
            this.setName("Flights");
            this.setDefaultCloseOperation(2);
            this.setSize(500, 100 + 30 * this.flights.size() / 2);
            int x = COMMON.topFrame.getLocation().x + (COMMON.topFrame.getSize().width - this.getSize().width) / 2;
            int y = COMMON.topFrame.getLocation().y + (COMMON.topFrame.getSize().height - this.getSize().height) / 2;
            this.setLocation(x, y);
            this.setTitle("V\u00e6lg flyvning");
            this.setContentPane(this.getJFrameContentPane());
            this.initConnections();
            this.getRootPane().setDefaultButton(this.getJButtonOK());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void selection() {
        this.setVisible(false);
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == Flights.this.getJButtonOK()) {
                Flights.this.connEtoC1(e);
            } else {
                Flights.this.getJButtonOK().setEnabled(true);
            }
        }
    }
}

