/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.Home;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;

public abstract class FileTree {
    public static final int GLIDER = 0;
    public static final int GPLIGC = 1;
    public static final int IGCREPLAY = 2;
    private static final String gliderZipFileName = "gliderFileTree.zip";
    private static final String gpligcZipFileName = "openGLIGC.zip";
    private static final String igcReplayZipFileName = "ramfs.zip";

    public static void build(int id) {
        switch (id) {
            case 0: {
                FileTree.checkFileTree(Home.getHome(), gliderZipFileName);
                break;
            }
            case 1: {
                FileTree.checkFileTree(Home.getOpenGLIGCDir(), gpligcZipFileName);
            }
        }
    }

    private static void createFile(File file, InputStream inputStream) {
        File parent = file.getParentFile();
        if (!parent.isDirectory()) {
            parent.mkdirs();
        }
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        BufferedOutputStream bos = null;
        try {
            int data;
            bos = new BufferedOutputStream(new FileOutputStream(file));
            while ((data = bis.read()) != -1) {
                bos.write(data);
            }
            bis.close();
            bos.flush();
            bos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                bis.close();
                bos.flush();
                bos.close();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
    }

    private static void checkFileTree(String topDirName, String zipFileName) {
        File topDir = new File(topDirName);
        if (!topDir.isDirectory()) {
            URL url;
            JOptionPane.showMessageDialog(null, "Opretter " + topDirName, "Initialisering", 1);
            if (topDir.isFile()) {
                topDir.delete();
            }
            if ((url = FileTree.class.getClassLoader().getResource("glider/resourcer/" + zipFileName)) == null && (url = FileTree.class.getClassLoader().getResource("igcreplay/resourcer/" + zipFileName)) == null) {
                throw new NullPointerException(zipFileName + " not found in glider/resourcer or igcreplay/resourcer");
            }
            File tmpFile = null;
            try {
                int data;
                InputStream is = url.openStream();
                if (is == null) {
                    throw new NullPointerException(zipFileName);
                }
                tmpFile = File.createTempFile("gliderTree", "tmp");
                BufferedInputStream bis = new BufferedInputStream(is);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile));
                while ((data = bis.read()) != -1) {
                    bos.write(data);
                }
                bis.close();
                bos.flush();
                bos.close();
                ZipFile zipFile = new ZipFile(tmpFile);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    String path = topDirName + entry.getName();
                    FileTree.createFile(new File(path), zipFile.getInputStream(entry));
                }
                tmpFile.delete();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                tmpFile.delete();
            }
        }
    }
}

