/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import glider.data.Contest;
import glider.data.ContestClass;
import glider.data.Plane;
import javax.swing.JCheckBox;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class DataModel
extends AbstractTableModel {
    private JCheckBox showAllClasses = null;

    public DataModel(JCheckBox showAllClasses) {
        this.showAllClasses = showAllClasses;
    }

    public Class getColumnClass(int column) {
        if (column == 4) {
            return Integer.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        int rowCount = 0;
        ContestClass c = null;
        Contest contest = COMMON.getContest();
        if (!this.showAllClasses.isSelected()) {
            c = contest.getCurrentClass();
            return c.planeCount();
        }
        for (int i = 0; i < contest.classCount(); ++i) {
            c = contest.getContestClass(i);
            rowCount += c.planeCount();
        }
        return rowCount;
    }

    @Override
    public Object getValueAt(int row, int column) {
        ContestClass c = null;
        Plane p = null;
        if (this.showAllClasses.isSelected()) {
            int rowNo = 0;
            int cNum = 0;
            while ((c = COMMON.getContest().getContestClass(cNum++)) != null) {
                if (row < rowNo + c.planeCount()) {
                    p = c.getPlane(row - rowNo);
                    break;
                }
                rowNo += c.planeCount();
            }
        } else {
            c = COMMON.getContest().getCurrentClass();
            p = c.getPlane(row);
        }
        switch (column) {
            case 0: {
                return c.getName();
            }
            case 1: {
                return p.getContestNumber();
            }
            case 2: {
                return p.getRegistration();
            }
            case 3: {
                return p.getType();
            }
            case 4: {
                return new Integer(p.getHandicap());
            }
            case 5: {
                return p.getPilot();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setShowAllClasses(JCheckBox showAllClasses) {
        this.showAllClasses = showAllClasses;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        String number = (String)this.getValueAt(row, 1);
        ContestClass c = COMMON.getContest().getContestClass(number);
        Plane p = c.getPlane(number);
        switch (column) {
            case 1: {
                p.setContestNumber((String)aValue);
                break;
            }
            case 2: {
                p.setRegistration((String)aValue);
                break;
            }
            case 3: {
                p.setType((String)aValue);
                break;
            }
            case 4: {
                p.setHandicap((Integer)aValue);
                break;
            }
            case 5: {
                p.setPilot((String)aValue);
            }
        }
        switch (column) {
            case 0: {
                COMMON.getContest().changeClass(p, (String)aValue);
                break;
            }
            case 2: {
                COMMON.getContest().changePlaneRegistration(c.getName(), p);
                break;
            }
            default: {
                COMMON.getContest().changePlane(c.getName(), p);
            }
        }
        this.fireTableChanged(new TableModelEvent(this));
    }
}

