/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.GDialog;
import glider.Home;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Config
implements Serializable {
    public int UTC2local;
    public boolean TpDM;
    public boolean TpJutland;
    public boolean TpFuen;
    public boolean TpZealand;
    public boolean TpForeign;
    public boolean fast;
    public boolean gplIgcDoc;
    public int initialReduction;
    public int initialX;
    public int initialY;
    public String explorerPath;

    public Config() {
        ObjectInputStream ois = null;
        Config old = new Config(false);
        File configFile = new File(Home.getHome() + "glider.cfg");
        try {
            ois = new ObjectInputStream(new FileInputStream(configFile));
            old = (Config)ois.readObject();
            ois.close();
            this.UTC2local = old.UTC2local;
            this.TpJutland = old.TpJutland;
            this.TpFuen = old.TpFuen;
            this.TpZealand = old.TpZealand;
            this.TpForeign = old.TpForeign;
            this.fast = old.fast;
            this.gplIgcDoc = old.gplIgcDoc;
            this.initialReduction = old.initialReduction;
            this.initialX = old.initialX;
            this.initialY = old.initialY;
            this.explorerPath = old.explorerPath;
        }
        catch (Exception e) {
            GDialog.info("Regenererer konfigurations fil " + configFile.getName());
            this.UTC2local = 2;
            this.TpJutland = false;
            this.TpFuen = false;
            this.TpZealand = true;
            this.TpForeign = false;
            this.fast = true;
            this.gplIgcDoc = true;
            this.initialReduction = 8;
            this.initialX = 0;
            this.initialY = 0;
            this.explorerPath = "\\Windows\\Notepad.exe";
            try {
                if (ois != null) {
                    ois.close();
                }
                this.store();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Config(boolean fake) {
    }

    public void store() {
        File configFile = new File(Home.getHome() + "glider.cfg");
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(configFile));
            os.writeObject(this);
            os.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            GDialog.error("Kunne ikke skrive " + configFile.getName());
        }
    }

    public void store(int reduction, int x, int y) {
        this.initialReduction = reduction;
        this.initialX = x;
        this.initialY = y;
        this.store();
    }
}

