/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import glider.Sample;
import glider.ScrollableMapIF;
import glider.Track;
import glider.data.Coordinate;
import glider.utils.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class CloseUpViewer
extends JPanel
implements ScrollableMapIF {
    private Polygon poly = new Polygon();
    private Coordinate coord = null;
    private double heading;
    private Point startFinishLineP1;
    private Point startFinishLineP2;
    private double lineSize;
    private int r1km = (int)(Utils.get1km() * 5.0);

    @Override
    public void setSize() {
        int w = COMMON.getMapViewer().getPanelSize().width * COMMON.getMapViewer().reduction * 5;
        int h = COMMON.getMapViewer().getPanelSize().height * COMMON.getMapViewer().reduction * 5;
        this.setSize(w, h);
        this.setPreferredSize(new Dimension(w, h));
    }

    public void changeTurnpoint(Coordinate c1, Coordinate c2, boolean first, boolean last, boolean outLanding) {
        Sample s;
        this.setSize();
        if (Track.getInstance().getSize() < 1) {
            this.poly = new Polygon();
            this.repaint();
            return;
        }
        this.heading = Utils.heading(c1, c2);
        this.heading = this.heading * Math.PI / 180.0;
        double p0x = Utils.latlong2x(c1) * 5.0;
        double p0y = Utils.latlong2y(c1) * 5.0;
        this.lineSize = first ? (double)(this.r1km * 5) : (last ? (double)this.r1km : 0.0);
        this.startFinishLineP1 = new Point((int)Math.round(p0x + Math.cos(this.heading) * this.lineSize), (int)Math.round(p0y + Math.sin(this.heading) * this.lineSize));
        this.startFinishLineP2 = new Point((int)Math.round(p0x - Math.cos(this.heading) * this.lineSize), (int)Math.round(p0y - Math.sin(this.heading) * this.lineSize));
        this.coord = c1;
        int nearest = 0;
        double minDist = 100000.0;
        if (outLanding) {
            nearest = Track.getInstance().getEnd() - 1;
        } else {
            int start = Track.getInstance().getStart();
            int end = Track.getInstance().getEnd();
            if (last) {
                start = (start + end) / 2;
            }
            if (first) {
                end = (start + end) / 2;
            }
            for (int i = start; i < end; ++i) {
                s = (Sample)Track.getInstance().getSamples().elementAt(i);
                Coordinate c = new Coordinate(s.lat, s.lon);
                if (!(minDist > Utils.distance(c, this.coord))) continue;
                minDist = Utils.distance(c, this.coord);
                nearest = i;
            }
        }
        s = (Sample)Track.getInstance().getSamples().elementAt(nearest);
        Coordinate cs = new Coordinate(s.lat, s.lon);
        Point p = cs.latlong2xy(1);
        JScrollPane sp = (JScrollPane)this.getParent().getParent();
        int hor = p.x * 5 - sp.getViewport().getWidth() / 2;
        int ver = p.y * 5 - sp.getViewport().getHeight() / 2;
        sp.getHorizontalScrollBar().setValue(hor);
        sp.getVerticalScrollBar().setValue(ver);
        int start = nearest - 25;
        int end = nearest + 25;
        if (start < Track.getInstance().getStart()) {
            start = Track.getInstance().getStart();
        }
        if (end > Track.getInstance().getEnd()) {
            end = Track.getInstance().getEnd();
        }
        this.poly = new Polygon();
        if (outLanding || last) {
            Track.getInstance().setSelectedSampleIndex(end);
        } else {
            Track.getInstance().setSelectedSampleIndex(start);
        }
        for (int i = start; i < end; ++i) {
            s = (Sample)Track.getInstance().getSamples().elementAt(i);
            cs = new Coordinate(s.lat, s.lon);
            p = cs.latlong2xy(1);
            this.poly.addPoint(p.x * 5, p.y * 5);
        }
        Track.getInstance().setDetailStart(start);
        Track.getInstance().setDetailEnd(end);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (COMMON.getMapViewer() == null) {
            return;
        }
        if (this.coord == null) {
            return;
        }
        int x0 = this.coord.latlong2xy((int)1).x * 5;
        int y0 = this.coord.latlong2xy((int)1).y * 5;
        g.setColor(Color.lightGray);
        int r = this.r1km / 2;
        g.drawOval(x0 - r, y0 - r, r * 2, r * 2);
        r = this.r1km;
        g.drawOval(x0 - r, y0 - r, r * 2, r * 2);
        r = this.r1km * 3;
        g.drawOval(x0 - r, y0 - r, r * 2, r * 2);
        g.drawLine(this.startFinishLineP1.x, this.startFinishLineP1.y, this.startFinishLineP2.x, this.startFinishLineP2.y);
        g.setColor(Color.blue);
        g.drawPolyline(this.poly.xpoints, this.poly.ypoints, this.poly.npoints);
        if (Track.getInstance().getSelectedSampleIndex() >= 0) {
            Sample s = Track.getInstance().getSelectedSample();
            g.setColor(Color.red);
            Coordinate cs = new Coordinate(s.lat, s.lon);
            int x = cs.latlong2xy((int)1).x * 5;
            int y = cs.latlong2xy((int)1).y * 5;
            g.drawLine(x - 5, y - 5, x + 5, y + 5);
            g.drawLine(x - 5, y + 5, x + 5, y - 5);
        }
    }
}

