/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import glider.CloseUpViewer;
import glider.GDialog;
import glider.OutLanding;
import glider.Sample;
import glider.Track;
import glider.TrackListener;
import glider.TripTime;
import glider.data.Coordinate;
import glider.data.Task;
import glider.utils.Utils;
import gui.JJDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class CloseUp
extends JJDialog
implements TrackListener,
ActionListener,
AdjustmentListener,
ComponentListener,
ItemListener,
WindowListener {
    private OutLanding outlanding = null;
    private TripTime triptime = null;
    private ButtonGroup ivjButtonGroup1 = null;
    private JPanel ivjJFrameContentPane = null;
    private JLabel ivjJLabel2 = null;
    private JRadioButton ivjJRadioButtonHjem = null;
    private JRadioButton ivjJRadioButtonVp1 = null;
    private JRadioButton ivjJRadioButtonVp2 = null;
    private JRadioButton ivjJRadioButtonVp3 = null;
    private JRadioButton ivjJRadioButtonVp4 = null;
    private JRadioButton ivjJRadioButtonVp5 = null;
    private JRadioButton ivjJRadioButtonVp6 = null;
    private JRadioButton ivjJRadioButtonVp7 = null;
    private JLabel ivjJLabel3 = null;
    private JLabel ivjJLabel4 = null;
    private JLabel ivjJLabel5 = null;
    private JScrollBar ivjJScrollBarEnd = null;
    private JScrollBar ivjJScrollBarHighlight = null;
    private JScrollBar ivjJScrollBarStart = null;
    private CloseUpViewer ivjCloseUpViewer1 = null;
    private JLabel ivjJLabel1 = null;
    private JTextField ivjJTextFieldHeight = null;
    private JTextField ivjJTextFieldTime = null;
    private JButton ivjJButtonRegisterOutlanding = null;
    private JButton ivjJButtonRegister = null;
    private JLabel ivjJLabel7 = null;
    private JTextField textFieldDistance = null;
    private JRadioButton ivjJRadioButtonOutlanding = null;
    private JRadioButton ivjJRadioButtonStart = null;
    private JButton ivjJButton1 = null;
    private JButton ivjJButton2 = null;
    private JLabel ivjJLabel8 = null;
    private JTextField ivjJTextFieldPunish = null;
    private JPanel ivjJPanel1 = null;
    private JPanel ivjJPanel2 = null;
    private JPanel ivjJPanel3 = null;
    private JScrollPane ivjJScrollPane1 = null;
    int tpNo = 0;

    public CloseUp() {
        this.initialize();
    }

    public CloseUp(Frame owner) {
        super(owner, "T\u00e6rskling / Vendepunkts Passage", false, false);
        this.initialize();
    }

    private ButtonGroup getButtonGroup1() {
        if (this.ivjButtonGroup1 == null) {
            try {
                this.ivjButtonGroup1 = new ButtonGroup();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonGroup1;
    }

    private CloseUpViewer getCloseUpViewer1() {
        if (this.ivjCloseUpViewer1 == null) {
            try {
                this.ivjCloseUpViewer1 = new CloseUpViewer();
                this.ivjCloseUpViewer1.setName("CloseUpViewer1");
                this.ivjCloseUpViewer1.setToolTipText("Cirklerne har radius 1/2, 1 og 3 km");
                this.ivjCloseUpViewer1.setBackground(new Color(222, 222, 222));
                this.ivjCloseUpViewer1.setBounds(0, 0, 420, 267);
                this.ivjCloseUpViewer1.setDoubleBuffered(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCloseUpViewer1;
    }

    private JButton getJButton1() {
        if (this.ivjJButton1 == null) {
            try {
                this.ivjJButton1 = new JButton();
                this.ivjJButton1.setName("JButton1");
                this.ivjJButton1.setToolTipText("Tilf\u00f8j 10 % straf points");
                this.ivjJButton1.setText("-10%");
                this.ivjJButton1.setBackground(Color.pink);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButton1;
    }

    private JButton getJButton2() {
        if (this.ivjJButton2 == null) {
            try {
                this.ivjJButton2 = new JButton();
                this.ivjJButton2.setName("JButton2");
                this.ivjJButton2.setToolTipText("Nulstil straf points");
                this.ivjJButton2.setText("Nulstil");
                this.ivjJButton2.setBackground(Color.pink);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButton2;
    }

    private JButton getJButtonRegister() {
        if (this.ivjJButtonRegister == null) {
            try {
                this.ivjJButtonRegister = new JButton();
                this.ivjJButtonRegister.setName("JButtonRegister");
                this.ivjJButtonRegister.setToolTipText("Registrer flyets ud- eller hjemt\u00e6rskling (i lokal tid)");
                this.ivjJButtonRegister.setText("Registrer tid...");
                this.ivjJButtonRegister.setMargin(new Insets(2, 4, 2, 4));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButtonRegister;
    }

    private JButton getJButtonRegisterOutlanding() {
        if (this.ivjJButtonRegisterOutlanding == null) {
            try {
                this.ivjJButtonRegisterOutlanding = new JButton();
                this.ivjJButtonRegisterOutlanding.setName("JButtonRegisterOutlanding");
                this.ivjJButtonRegisterOutlanding.setToolTipText("Registrer positionen for en udelanding");
                this.ivjJButtonRegisterOutlanding.setText("Registrer udelanding...");
                this.ivjJButtonRegisterOutlanding.setHorizontalTextPosition(0);
                this.ivjJButtonRegisterOutlanding.setEnabled(false);
                this.ivjJButtonRegisterOutlanding.setMargin(new Insets(2, 4, 2, 4));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJButtonRegisterOutlanding;
    }

    private JPanel getJFrameContentPane() {
        if (this.ivjJFrameContentPane == null) {
            try {
                this.ivjJFrameContentPane = new JPanel();
                this.ivjJFrameContentPane.setName("JFrameContentPane");
                this.ivjJFrameContentPane.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJRadioButtonStart = new GridBagConstraints();
                constraintsJRadioButtonStart.gridx = 0;
                constraintsJRadioButtonStart.gridy = 1;
                constraintsJRadioButtonStart.anchor = 17;
                constraintsJRadioButtonStart.insets = new Insets(0, 10, 0, 0);
                this.getJFrameContentPane().add((Component)this.getJRadioButtonStart(), constraintsJRadioButtonStart);
                GridBagConstraints constraintsJRadioButtonVp1 = new GridBagConstraints();
                constraintsJRadioButtonVp1.gridx = 0;
                constraintsJRadioButtonVp1.gridy = 2;
                constraintsJRadioButtonVp1.anchor = 17;
                constraintsJRadioButtonVp1.insets = new Insets(0, 10, 0, 0);
                this.getJFrameContentPane().add((Component)this.getJRadioButtonVp1(), constraintsJRadioButtonVp1);
                GridBagConstraints constraintsJRadioButtonVp2 = new GridBagConstraints();
                constraintsJRadioButtonVp2.gridx = 0;
                constraintsJRadioButtonVp2.gridy = 3;
                constraintsJRadioButtonVp2.anchor = 17;
                constraintsJRadioButtonVp2.insets = new Insets(0, 10, 0, 0);
                this.getJFrameContentPane().add((Component)this.getJRadioButtonVp2(), constraintsJRadioButtonVp2);
                GridBagConstraints constraintsJRadioButtonVp3 = new GridBagConstraints();
                constraintsJRadioButtonVp3.gridx = 0;
                constraintsJRadioButtonVp3.gridy = 4;
                constraintsJRadioButtonVp3.anchor = 17;
                constraintsJRadioButtonVp3.insets = new Insets(0, 10, 0, 0);
                this.getJFrameContentPane().add((Component)this.getJRadioButtonVp3(), constraintsJRadioButtonVp3);
                GridBagConstraints constraintsJRadioButtonVp4 = new GridBagConstraints();
                constraintsJRadioButtonVp4.gridx = 0;
                constraintsJRadioButtonVp4.gridy = 5;
                constraintsJRadioButtonVp4.anchor = 17;
                constraintsJRadioButtonVp4.insets = new Insets(0, 10, 0, 0);
                this.getJFrameContentPane().add((Component)this.getJRadioButtonVp4(), constraintsJRadioButtonVp4);
                GridBagConstraints constraintsJRadioButtonVp5 = new GridBagConstraints();
                constraintsJRadioButtonVp5.gridx = 0;
                constraintsJRadioButtonVp5.gridy = 6;
                constraintsJRadioButtonVp5.anchor = 17;
                constraintsJRadioButtonVp5.insets = new Insets(0, 10, 0, 0);
                this.getJFrameContentPane().add((Component)this.getJRadioButtonVp5(), constraintsJRadioButtonVp5);
                GridBagConstraints constraintsJRadioButtonVp6 = new GridBagConstraints();
                constraintsJRadioButtonVp6.gridx = 0;
                constraintsJRadioButtonVp6.gridy = 7;
                constraintsJRadioButtonVp6.anchor = 17;
                constraintsJRadioButtonVp6.insets = new Insets(0, 10, 0, 0);
                this.getJFrameContentPane().add((Component)this.getJRadioButtonVp6(), constraintsJRadioButtonVp6);
                GridBagConstraints constraintsJRadioButtonVp7 = new GridBagConstraints();
                constraintsJRadioButtonVp7.gridx = 0;
                constraintsJRadioButtonVp7.gridy = 8;
                constraintsJRadioButtonVp7.anchor = 17;
                constraintsJRadioButtonVp7.insets = new Insets(0, 10, 0, 0);
                this.getJFrameContentPane().add((Component)this.getJRadioButtonVp7(), constraintsJRadioButtonVp7);
                GridBagConstraints constraintsJRadioButtonHjem = new GridBagConstraints();
                constraintsJRadioButtonHjem.gridx = 0;
                constraintsJRadioButtonHjem.gridy = 9;
                constraintsJRadioButtonHjem.anchor = 17;
                constraintsJRadioButtonHjem.insets = new Insets(0, 10, 0, 0);
                this.getJFrameContentPane().add((Component)this.getJRadioButtonHjem(), constraintsJRadioButtonHjem);
                GridBagConstraints constraintsJScrollBarHighlight = new GridBagConstraints();
                constraintsJScrollBarHighlight.gridx = 0;
                constraintsJScrollBarHighlight.gridy = 13;
                constraintsJScrollBarHighlight.gridwidth = 4;
                constraintsJScrollBarHighlight.fill = 2;
                constraintsJScrollBarHighlight.weightx = 1.0;
                this.getJFrameContentPane().add((Component)this.getJScrollBarHighlight(), constraintsJScrollBarHighlight);
                GridBagConstraints constraintsJButtonRegister = new GridBagConstraints();
                constraintsJButtonRegister.gridx = 0;
                constraintsJButtonRegister.gridy = 11;
                constraintsJButtonRegister.gridwidth = 2;
                constraintsJButtonRegister.weightx = 1.0;
                this.getJFrameContentPane().add((Component)this.getJButtonRegister(), constraintsJButtonRegister);
                GridBagConstraints constraintsJLabel3 = new GridBagConstraints();
                constraintsJLabel3.gridx = 2;
                constraintsJLabel3.gridy = 12;
                constraintsJLabel3.gridwidth = 3;
                constraintsJLabel3.anchor = 16;
                constraintsJLabel3.insets = new Insets(10, 0, 0, 0);
                this.getJFrameContentPane().add((Component)this.getJLabel3(), constraintsJLabel3);
                GridBagConstraints constraintsJButtonRegisterOutlanding = new GridBagConstraints();
                constraintsJButtonRegisterOutlanding.gridx = 2;
                constraintsJButtonRegisterOutlanding.gridy = 11;
                constraintsJButtonRegisterOutlanding.weightx = 1.0;
                this.getJFrameContentPane().add((Component)this.getJButtonRegisterOutlanding(), constraintsJButtonRegisterOutlanding);
                GridBagConstraints constraintsJRadioButtonOutlanding = new GridBagConstraints();
                constraintsJRadioButtonOutlanding.gridx = 0;
                constraintsJRadioButtonOutlanding.gridy = 10;
                constraintsJRadioButtonOutlanding.insets = new Insets(0, 10, 0, 0);
                this.getJFrameContentPane().add((Component)this.getJRadioButtonOutlanding(), constraintsJRadioButtonOutlanding);
                GridBagConstraints constraintsJPanel1 = new GridBagConstraints();
                constraintsJPanel1.gridx = 0;
                constraintsJPanel1.gridy = 14;
                constraintsJPanel1.gridwidth = 4;
                constraintsJPanel1.fill = 1;
                constraintsJPanel1.weightx = 1.0;
                constraintsJPanel1.insets = new Insets(0, 0, 5, 0);
                this.getJFrameContentPane().add((Component)this.getJPanel1(), constraintsJPanel1);
                GridBagConstraints constraintsJPanel2 = new GridBagConstraints();
                constraintsJPanel2.gridx = 3;
                constraintsJPanel2.gridy = 11;
                constraintsJPanel2.gridheight = 2;
                constraintsJPanel2.fill = 1;
                constraintsJPanel2.weightx = 1.0;
                constraintsJPanel2.insets = new Insets(0, 4, 4, 4);
                this.getJFrameContentPane().add((Component)this.getJPanel2(), constraintsJPanel2);
                GridBagConstraints constraintsJPanel3 = new GridBagConstraints();
                constraintsJPanel3.gridx = 0;
                constraintsJPanel3.gridy = 0;
                constraintsJPanel3.gridwidth = 4;
                constraintsJPanel3.fill = 1;
                constraintsJPanel3.weightx = 1.0;
                constraintsJPanel3.insets = new Insets(0, 4, 0, 4);
                this.getJFrameContentPane().add((Component)this.getJPanel3(), constraintsJPanel3);
                GridBagConstraints constraintsJScrollPane1 = new GridBagConstraints();
                constraintsJScrollPane1.gridx = 1;
                constraintsJScrollPane1.gridy = 1;
                constraintsJScrollPane1.gridwidth = 3;
                constraintsJScrollPane1.gridheight = 10;
                constraintsJScrollPane1.fill = 1;
                constraintsJScrollPane1.weightx = 1.0;
                constraintsJScrollPane1.weighty = 1.0;
                constraintsJScrollPane1.insets = new Insets(4, 4, 4, 4);
                this.getJFrameContentPane().add((Component)this.getJScrollPane1(), constraintsJScrollPane1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJFrameContentPane;
    }

    private JLabel getJLabel1() {
        if (this.ivjJLabel1 == null) {
            try {
                this.ivjJLabel1 = new JLabel();
                this.ivjJLabel1.setName("JLabel1");
                this.ivjJLabel1.setText("H\u00f8jde:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel1;
    }

    private JLabel getJLabel2() {
        if (this.ivjJLabel2 == null) {
            try {
                this.ivjJLabel2 = new JLabel();
                this.ivjJLabel2.setName("JLabel2");
                this.ivjJLabel2.setText("UTC:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel2;
    }

    private JLabel getJLabel3() {
        if (this.ivjJLabel3 == null) {
            try {
                this.ivjJLabel3 = new JLabel();
                this.ivjJLabel3.setName("JLabel3");
                this.ivjJLabel3.setText("Logfil index:");
                this.ivjJLabel3.setHorizontalAlignment(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel3;
    }

    private JLabel getJLabel4() {
        if (this.ivjJLabel4 == null) {
            try {
                this.ivjJLabel4 = new JLabel();
                this.ivjJLabel4.setName("JLabel4");
                this.ivjJLabel4.setText("Afgr\u00e6ns start");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel4;
    }

    private JLabel getJLabel5() {
        if (this.ivjJLabel5 == null) {
            try {
                this.ivjJLabel5 = new JLabel();
                this.ivjJLabel5.setName("JLabel5");
                this.ivjJLabel5.setText("Afgr\u00e6ns slutning");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel5;
    }

    private JLabel getJLabel7() {
        if (this.ivjJLabel7 == null) {
            try {
                this.ivjJLabel7 = new JLabel();
                this.ivjJLabel7.setName("JLabel7");
                this.ivjJLabel7.setText("Afstand:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel7;
    }

    private JLabel getJLabel8() {
        if (this.ivjJLabel8 == null) {
            try {
                this.ivjJLabel8 = new JLabel();
                this.ivjJLabel8.setName("JLabel8");
                this.ivjJLabel8.setText("Straf (%):");
                this.ivjJLabel8.setForeground(Color.darkGray);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJLabel8;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJLabel4 = new GridBagConstraints();
                constraintsJLabel4.gridx = 0;
                constraintsJLabel4.gridy = 0;
                constraintsJLabel4.anchor = 15;
                constraintsJLabel4.insets = new Insets(4, 4, 0, 4);
                this.getJPanel1().add((Component)this.getJLabel4(), constraintsJLabel4);
                GridBagConstraints constraintsJScrollBarStart = new GridBagConstraints();
                constraintsJScrollBarStart.gridx = 0;
                constraintsJScrollBarStart.gridy = 1;
                constraintsJScrollBarStart.fill = 2;
                constraintsJScrollBarStart.weightx = 1.0;
                this.getJPanel1().add((Component)this.getJScrollBarStart(), constraintsJScrollBarStart);
                GridBagConstraints constraintsJLabel5 = new GridBagConstraints();
                constraintsJLabel5.gridx = 1;
                constraintsJLabel5.gridy = 0;
                constraintsJLabel5.anchor = 15;
                constraintsJLabel5.insets = new Insets(4, 4, 0, 4);
                this.getJPanel1().add((Component)this.getJLabel5(), constraintsJLabel5);
                GridBagConstraints constraintsJScrollBarEnd = new GridBagConstraints();
                constraintsJScrollBarEnd.gridx = 1;
                constraintsJScrollBarEnd.gridy = 1;
                constraintsJScrollBarEnd.fill = 2;
                constraintsJScrollBarEnd.weightx = 1.0;
                this.getJPanel1().add((Component)this.getJScrollBarEnd(), constraintsJScrollBarEnd);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setLayout(new GridBagLayout());
                this.ivjJPanel2.setBackground(Color.pink);
                GridBagConstraints constraintsJButton1 = new GridBagConstraints();
                constraintsJButton1.gridx = 0;
                constraintsJButton1.gridy = 0;
                constraintsJButton1.insets = new Insets(4, 4, 4, 4);
                this.getJPanel2().add((Component)this.getJButton1(), constraintsJButton1);
                GridBagConstraints constraintsJButton2 = new GridBagConstraints();
                constraintsJButton2.gridx = 1;
                constraintsJButton2.gridy = 0;
                constraintsJButton2.insets = new Insets(0, 4, 4, 4);
                this.getJPanel2().add((Component)this.getJButton2(), constraintsJButton2);
                GridBagConstraints constraintsJLabel8 = new GridBagConstraints();
                constraintsJLabel8.gridx = 0;
                constraintsJLabel8.gridy = 1;
                constraintsJLabel8.insets = new Insets(4, 4, 0, 4);
                this.getJPanel2().add((Component)this.getJLabel8(), constraintsJLabel8);
                GridBagConstraints constraintsJTextFieldPunish = new GridBagConstraints();
                constraintsJTextFieldPunish.gridx = 1;
                constraintsJTextFieldPunish.gridy = 1;
                constraintsJTextFieldPunish.insets = new Insets(4, 4, 0, 4);
                this.getJPanel2().add((Component)this.getJTextFieldPunish(), constraintsJTextFieldPunish);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private JPanel getJPanel3() {
        if (this.ivjJPanel3 == null) {
            try {
                this.ivjJPanel3 = new JPanel();
                this.ivjJPanel3.setName("JPanel3");
                this.ivjJPanel3.setLayout(new GridBagLayout());
                GridBagConstraints constraintsJLabel2 = new GridBagConstraints();
                constraintsJLabel2.gridx = 0;
                constraintsJLabel2.gridy = 0;
                constraintsJLabel2.anchor = 13;
                constraintsJLabel2.weightx = 1.0;
                constraintsJLabel2.insets = new Insets(0, 4, 0, 4);
                this.getJPanel3().add((Component)this.getJLabel2(), constraintsJLabel2);
                GridBagConstraints constraintsJTextFieldTime = new GridBagConstraints();
                constraintsJTextFieldTime.gridx = 1;
                constraintsJTextFieldTime.gridy = 0;
                constraintsJTextFieldTime.insets = new Insets(0, 4, 0, 4);
                this.getJPanel3().add((Component)this.getJTextFieldTime(), constraintsJTextFieldTime);
                GridBagConstraints constraintsJLabel1 = new GridBagConstraints();
                constraintsJLabel1.gridx = 2;
                constraintsJLabel1.gridy = 0;
                constraintsJLabel1.anchor = 13;
                constraintsJLabel1.weightx = 1.0;
                constraintsJLabel1.insets = new Insets(0, 4, 0, 4);
                this.getJPanel3().add((Component)this.getJLabel1(), constraintsJLabel1);
                GridBagConstraints constraintsJTextFieldHeight = new GridBagConstraints();
                constraintsJTextFieldHeight.gridx = 3;
                constraintsJTextFieldHeight.gridy = 0;
                constraintsJTextFieldHeight.insets = new Insets(0, 4, 0, 4);
                this.getJPanel3().add((Component)this.getJTextFieldHeight(), constraintsJTextFieldHeight);
                GridBagConstraints constraintsJLabel7 = new GridBagConstraints();
                constraintsJLabel7.gridx = 4;
                constraintsJLabel7.gridy = 0;
                constraintsJLabel7.anchor = 13;
                constraintsJLabel7.weightx = 1.0;
                constraintsJLabel7.insets = new Insets(0, 4, 0, 4);
                this.getJPanel3().add((Component)this.getJLabel7(), constraintsJLabel7);
                GridBagConstraints constraintsJTextFieldMotor = new GridBagConstraints();
                constraintsJTextFieldMotor.gridx = 5;
                constraintsJTextFieldMotor.gridy = 0;
                constraintsJTextFieldMotor.anchor = 17;
                constraintsJTextFieldMotor.weightx = 1.0;
                constraintsJTextFieldMotor.insets = new Insets(0, 4, 0, 4);
                this.getJPanel3().add((Component)this.getTextFieldDistance(), constraintsJTextFieldMotor);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel3;
    }

    private JRadioButton getJRadioButtonHjem() {
        if (this.ivjJRadioButtonHjem == null) {
            try {
                this.ivjJRadioButtonHjem = new JRadioButton();
                this.ivjJRadioButtonHjem.setName("JRadioButtonHjem");
                this.ivjJRadioButtonHjem.setToolTipText("Vis slutning af det afgr\u00e6nsede");
                this.ivjJRadioButtonHjem.setText("Hjem");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJRadioButtonHjem;
    }

    private JRadioButton getJRadioButtonOutlanding() {
        if (this.ivjJRadioButtonOutlanding == null) {
            try {
                this.ivjJRadioButtonOutlanding = new JRadioButton();
                this.ivjJRadioButtonOutlanding.setName("JRadioButtonOutlanding");
                this.ivjJRadioButtonOutlanding.setText("Ude-l.");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJRadioButtonOutlanding;
    }

    private JRadioButton getJRadioButtonStart() {
        if (this.ivjJRadioButtonStart == null) {
            try {
                this.ivjJRadioButtonStart = new JRadioButton();
                this.ivjJRadioButtonStart.setName("JRadioButtonStart");
                this.ivjJRadioButtonStart.setSelected(true);
                this.ivjJRadioButtonStart.setToolTipText("Vis start af det afgr\u00e6nsede");
                this.ivjJRadioButtonStart.setText("Start");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJRadioButtonStart;
    }

    private JRadioButton getJRadioButtonVp1() {
        if (this.ivjJRadioButtonVp1 == null) {
            try {
                this.ivjJRadioButtonVp1 = new JRadioButton();
                this.ivjJRadioButtonVp1.setName("JRadioButtonVp1");
                this.ivjJRadioButtonVp1.setText("Vp1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJRadioButtonVp1;
    }

    private JRadioButton getJRadioButtonVp2() {
        if (this.ivjJRadioButtonVp2 == null) {
            try {
                this.ivjJRadioButtonVp2 = new JRadioButton();
                this.ivjJRadioButtonVp2.setName("JRadioButtonVp2");
                this.ivjJRadioButtonVp2.setText("Vp2");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJRadioButtonVp2;
    }

    private JRadioButton getJRadioButtonVp3() {
        if (this.ivjJRadioButtonVp3 == null) {
            try {
                this.ivjJRadioButtonVp3 = new JRadioButton();
                this.ivjJRadioButtonVp3.setName("JRadioButtonVp3");
                this.ivjJRadioButtonVp3.setText("Vp3");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJRadioButtonVp3;
    }

    private JRadioButton getJRadioButtonVp4() {
        if (this.ivjJRadioButtonVp4 == null) {
            try {
                this.ivjJRadioButtonVp4 = new JRadioButton();
                this.ivjJRadioButtonVp4.setName("JRadioButtonVp4");
                this.ivjJRadioButtonVp4.setText("Vp4");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJRadioButtonVp4;
    }

    private JRadioButton getJRadioButtonVp5() {
        if (this.ivjJRadioButtonVp5 == null) {
            try {
                this.ivjJRadioButtonVp5 = new JRadioButton();
                this.ivjJRadioButtonVp5.setName("JRadioButtonVp5");
                this.ivjJRadioButtonVp5.setText("Vp5");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJRadioButtonVp5;
    }

    private JRadioButton getJRadioButtonVp6() {
        if (this.ivjJRadioButtonVp6 == null) {
            try {
                this.ivjJRadioButtonVp6 = new JRadioButton();
                this.ivjJRadioButtonVp6.setName("JRadioButtonVp6");
                this.ivjJRadioButtonVp6.setText("Vp6");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJRadioButtonVp6;
    }

    private JRadioButton getJRadioButtonVp7() {
        if (this.ivjJRadioButtonVp7 == null) {
            try {
                this.ivjJRadioButtonVp7 = new JRadioButton();
                this.ivjJRadioButtonVp7.setName("JRadioButtonVp7");
                this.ivjJRadioButtonVp7.setText("Vp7");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJRadioButtonVp7;
    }

    private JScrollBar getJScrollBarEnd() {
        if (this.ivjJScrollBarEnd == null) {
            try {
                this.ivjJScrollBarEnd = new JScrollBar();
                this.ivjJScrollBarEnd.setName("JScrollBarEnd");
                this.ivjJScrollBarEnd.setToolTipText("Skr\u00e6l flyvning efter hjemt\u00e6rskling / motorstart af");
                this.ivjJScrollBarEnd.setOrientation(0);
                this.ivjJScrollBarEnd = new JScrollBar(0);
                this.ivjJScrollBarEnd.setName("JScrollBarEnd");
                this.ivjJScrollBarEnd.setToolTipText("Skr\u00e6l flyvning efter hjemt\u00e6rskling / motorstart af");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollBarEnd;
    }

    private JScrollBar getJScrollBarHighlight() {
        if (this.ivjJScrollBarHighlight == null) {
            try {
                this.ivjJScrollBarHighlight = new JScrollBar();
                this.ivjJScrollBarHighlight.setName("JScrollBarHighlight");
                this.ivjJScrollBarHighlight.setToolTipText("Juster til den \u00f8nskede logning fremh\u00e6ves");
                this.ivjJScrollBarHighlight.setOrientation(0);
                this.ivjJScrollBarHighlight = new JScrollBar(0);
                this.ivjJScrollBarHighlight.setName("JScrollBarHighlight");
                this.ivjJScrollBarHighlight.setToolTipText("Juster til den \u00f8nskede logning fremh\u00e6ves");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollBarHighlight;
    }

    private JScrollBar getJScrollBarStart() {
        if (this.ivjJScrollBarStart == null) {
            try {
                this.ivjJScrollBarStart = new JScrollBar();
                this.ivjJScrollBarStart.setName("JScrollBarStart");
                this.ivjJScrollBarStart.setToolTipText("Skr\u00e6l flyvning f\u00f8r udt\u00e6rskling af");
                this.ivjJScrollBarStart.setOrientation(0);
                this.ivjJScrollBarStart = new JScrollBar(0);
                this.ivjJScrollBarStart.setName("JScrollBarStart");
                this.ivjJScrollBarStart.setToolTipText("Skr\u00e6l flyvning f\u00f8r udt\u00e6rskling af");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollBarStart;
    }

    private JScrollPane getJScrollPane1() {
        if (this.ivjJScrollPane1 == null) {
            try {
                this.ivjJScrollPane1 = new JScrollPane();
                this.ivjJScrollPane1.setName("JScrollPane1");
                this.ivjJScrollPane1.setVerticalScrollBarPolicy(21);
                this.ivjJScrollPane1.setHorizontalScrollBarPolicy(31);
                this.getJScrollPane1().setViewportView(this.getCloseUpViewer1());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJScrollPane1;
    }

    private JTextField getJTextFieldHeight() {
        if (this.ivjJTextFieldHeight == null) {
            try {
                this.ivjJTextFieldHeight = new JTextField();
                this.ivjJTextFieldHeight.setName("JTextFieldHeight");
                this.ivjJTextFieldHeight.setPreferredSize(new Dimension(40, 19));
                this.ivjJTextFieldHeight.setBackground(Color.gray);
                this.ivjJTextFieldHeight.setForeground(Color.green);
                this.ivjJTextFieldHeight.setHorizontalAlignment(4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldHeight;
    }

    private JTextField getTextFieldDistance() {
        if (this.textFieldDistance == null) {
            try {
                this.textFieldDistance = new JTextField();
                this.textFieldDistance.setName("JTextFieldMotor");
                this.textFieldDistance.setPreferredSize(new Dimension(40, 19));
                this.textFieldDistance.setBackground(Color.gray);
                this.textFieldDistance.setForeground(Color.green);
                this.textFieldDistance.setHorizontalAlignment(4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.textFieldDistance;
    }

    private JTextField getJTextFieldPunish() {
        if (this.ivjJTextFieldPunish == null) {
            try {
                this.ivjJTextFieldPunish = new JTextField();
                this.ivjJTextFieldPunish.setName("JTextFieldPunish");
                this.ivjJTextFieldPunish.setToolTipText("Sum af straf points");
                this.ivjJTextFieldPunish.setBackground(Color.gray);
                this.ivjJTextFieldPunish.setMaximumSize(new Dimension(50, 19));
                this.ivjJTextFieldPunish.setForeground(Color.green);
                this.ivjJTextFieldPunish.setPreferredSize(new Dimension(50, 19));
                this.ivjJTextFieldPunish.setHorizontalAlignment(4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldPunish;
    }

    private JTextField getJTextFieldTime() {
        if (this.ivjJTextFieldTime == null) {
            try {
                this.ivjJTextFieldTime = new JTextField();
                this.ivjJTextFieldTime.setName("JTextFieldTime");
                this.ivjJTextFieldTime.setPreferredSize(new Dimension(50, 19));
                this.ivjJTextFieldTime.setBackground(Color.gray);
                this.ivjJTextFieldTime.setForeground(Color.green);
                this.ivjJTextFieldTime.setHorizontalAlignment(4);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJTextFieldTime;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getJButtonRegister()) {
            this.connEtoC1(e);
        }
        if (e.getSource() == this.getJButtonRegisterOutlanding()) {
            this.connEtoC6(e);
        }
        if (e.getSource() == this.getJRadioButtonStart()) {
            this.connEtoM10(e);
        }
        if (e.getSource() == this.getJRadioButtonVp1()) {
            this.connEtoM11(e);
        }
        if (e.getSource() == this.getJRadioButtonVp2()) {
            this.connEtoM12(e);
        }
        if (e.getSource() == this.getJRadioButtonVp3()) {
            this.connEtoM13(e);
        }
        if (e.getSource() == this.getJRadioButtonVp4()) {
            this.connEtoM14(e);
        }
        if (e.getSource() == this.getJRadioButtonVp5()) {
            this.connEtoM15(e);
        }
        if (e.getSource() == this.getJRadioButtonVp6()) {
            this.connEtoM16(e);
        }
        if (e.getSource() == this.getJRadioButtonVp7()) {
            this.connEtoM17(e);
        }
        if (e.getSource() == this.getJRadioButtonHjem()) {
            this.connEtoM18(e);
        }
        if (e.getSource() == this.getJRadioButtonOutlanding()) {
            this.connEtoM20(e);
        }
        if (e.getSource() == this.getJButton1()) {
            this.connEtoC7(e);
        }
        if (e.getSource() == this.getJButton2()) {
            this.connEtoC8(e);
        }
        if (e.getSource() == this.getJRadioButtonVp1() || e.getSource() == this.getJRadioButtonVp2() || e.getSource() == this.getJRadioButtonVp3() || e.getSource() == this.getJRadioButtonVp4() || e.getSource() == this.getJRadioButtonVp5() || e.getSource() == this.getJRadioButtonVp6() || e.getSource() == this.getJRadioButtonVp7() || e.getSource() == this.getJRadioButtonStart() || e.getSource() == this.getJRadioButtonHjem() || e.getSource() == this.getJRadioButtonOutlanding()) {
            this.changeTurnpoint();
        }
    }

    public void adjustInterval() {
        int size = Track.getInstance().getSize();
        if (size < 1) {
            return;
        }
        JScrollBar st = this.getJScrollBarStart();
        JScrollBar e = this.getJScrollBarEnd();
        Track.getInstance().setSampleStart((int)((double)st.getValue() / 90.0 * (double)size));
        Track.getInstance().setSampleEnd((int)((double)e.getValue() / 90.0 * (double)size));
        this.getJScrollBarHighlight().setValue(0);
        this.getJLabel3().setText("Logfil index:        ");
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.getJScrollBarHighlight()) {
            this.connEtoC4(e);
        }
        if (e.getSource() == this.getJScrollBarStart()) {
            this.connEtoC2(e);
        }
        if (e.getSource() == this.getJScrollBarEnd()) {
            this.connEtoC3(e);
        }
    }

    public void changeSelected() {
        Vector samples = Track.getInstance().getSamples();
        if (samples.size() < 1) {
            return;
        }
        JScrollBar js = this.getJScrollBarHighlight();
        double ratio = (double)js.getValue() / 90.0;
        int selected = this.getJRadioButtonHjem().isSelected() ? Track.getInstance().getDetailEnd() - (int)(50.0 * (1.0 - ratio)) - 1 : (int)(50.0 * ratio) + Track.getInstance().getDetailStart();
        if (selected >= samples.size()) {
            selected = samples.size() - 1;
        }
        this.getJLabel3().setText("Logfil index: " + selected);
        Sample s = (Sample)samples.elementAt(selected);
        this.getJTextFieldTime().setText(s.time);
        this.getJTextFieldHeight().setText("" + s.pressAltitude);
        Coordinate c1 = new Coordinate(s.lat, s.lon);
        Coordinate c2 = new Coordinate(COMMON.getCurrentTask().getTurnpoint(this.tpNo).getCoordinate());
        double dist = Utils.distance(c1, c2);
        int distance = (int)(dist * (double)Math.round(1000.0f));
        if (distance > 500) {
            this.getTextFieldDistance().setBackground(Color.red);
            this.getTextFieldDistance().setForeground(Color.white);
        } else {
            this.getTextFieldDistance().setBackground(Color.gray);
            this.getTextFieldDistance().setForeground(Color.green);
        }
        this.getTextFieldDistance().setText("" + distance);
        Track.getInstance().setSelectedSampleIndex(selected);
    }

    void changeTurnpoint() {
        Task t = COMMON.getCurrentTask();
        if (this.getJRadioButtonStart().isSelected()) {
            this.tpNo = 0;
        } else if (this.getJRadioButtonVp1().isSelected()) {
            this.tpNo = 1;
        } else if (this.getJRadioButtonVp2().isSelected()) {
            this.tpNo = 2;
        } else if (this.getJRadioButtonVp3().isSelected()) {
            this.tpNo = 3;
        } else if (this.getJRadioButtonVp4().isSelected()) {
            this.tpNo = 4;
        } else if (this.getJRadioButtonVp5().isSelected()) {
            this.tpNo = 5;
        } else if (this.getJRadioButtonVp6().isSelected()) {
            this.tpNo = 6;
        } else if (this.getJRadioButtonVp7().isSelected()) {
            this.tpNo = 7;
        } else if (this.getJRadioButtonHjem().isSelected()) {
            this.tpNo = t.size() - 1;
        }
        this.getJScrollBarHighlight().setValue(0);
        this.getJLabel3().setText("Logfil index:        ");
        if (t != null && t.size() >= 2) {
            this.setTitle("T\u00e6rskling / Vendepunkts Passage: " + t.getTurnpoint((int)this.tpNo).description);
            boolean first = this.tpNo == 0;
            boolean last = this.tpNo == t.size() - 1;
            Coordinate c1 = null;
            Coordinate c2 = null;
            if (last) {
                c1 = t.coordinate(t.size() - 1);
                c2 = t.coordinate(t.size() - 2);
            } else {
                c1 = t.coordinate(this.tpNo);
                c2 = t.coordinate(this.tpNo + 1);
            }
            this.getCloseUpViewer1().changeTurnpoint(c1, c2, first, last, this.getJRadioButtonOutlanding().isSelected());
            if (this.isShowing()) {
                COMMON.getMapViewer().setInvestigatedTp(c1);
            }
        }
        if (this.getJRadioButtonOutlanding().isSelected()) {
            this.getJScrollBarHighlight().setValue(100);
        }
    }

    public void clearPunish() {
        COMMON.getContest().getPlaneResult().setPenaltyPoint(0);
        this.showPunish();
    }

    public void closeUp_WindowClosed() {
        COMMON.getMapViewer().setInvestigatedTp(null);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getSource() == this) {
            this.connEtoM23(e);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.registerTime();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(AdjustmentEvent arg1) {
        try {
            this.adjustInterval();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(AdjustmentEvent arg1) {
        try {
            this.adjustInterval();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(AdjustmentEvent arg1) {
        try {
            this.changeSelected();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(WindowEvent arg1) {
        try {
            this.closeUp_WindowClosed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(ActionEvent arg1) {
        try {
            this.registerOutlanding();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7(ActionEvent arg1) {
        try {
            this.punish10();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC8(ActionEvent arg1) {
        try {
            this.clearPunish();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1() {
        try {
            this.getButtonGroup1().add(this.getJRadioButtonStart());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM10(ActionEvent arg1) {
        try {
            this.getJButtonRegister().setEnabled(true);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM11(ActionEvent arg1) {
        try {
            this.getJButtonRegister().setEnabled(false);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM12(ActionEvent arg1) {
        try {
            this.getJButtonRegister().setEnabled(false);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM13(ActionEvent arg1) {
        try {
            this.getJButtonRegister().setEnabled(false);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM14(ActionEvent arg1) {
        try {
            this.getJButtonRegister().setEnabled(false);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM15(ActionEvent arg1) {
        try {
            this.getJButtonRegister().setEnabled(false);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM16(ActionEvent arg1) {
        try {
            this.getJButtonRegister().setEnabled(false);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM17(ActionEvent arg1) {
        try {
            this.getJButtonRegister().setEnabled(false);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM18(ActionEvent arg1) {
        try {
            this.getJButtonRegister().setEnabled(true);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM19() {
        try {
            this.getButtonGroup1().add(this.getJRadioButtonOutlanding());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2() {
        try {
            this.getButtonGroup1().add(this.getJRadioButtonVp1());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM20(ActionEvent arg1) {
        try {
            this.getJButtonRegister().setEnabled(false);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM21(ItemEvent arg1) {
        try {
            this.getJButtonRegisterOutlanding().setEnabled(this.getJRadioButtonOutlanding().isSelected());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM23(ComponentEvent arg1) {
        try {
            this.getCloseUpViewer1().setSize();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM3() {
        try {
            this.getButtonGroup1().add(this.getJRadioButtonVp2());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM4() {
        try {
            this.getButtonGroup1().add(this.getJRadioButtonVp3());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM5() {
        try {
            this.getButtonGroup1().add(this.getJRadioButtonVp4());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM6() {
        try {
            this.getButtonGroup1().add(this.getJRadioButtonVp5());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM7() {
        try {
            this.getButtonGroup1().add(this.getJRadioButtonVp6());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM8() {
        try {
            this.getButtonGroup1().add(this.getJRadioButtonVp7());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM9() {
        try {
            this.getButtonGroup1().add(this.getJRadioButtonHjem());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    @Override
    public void detailChanged() {
        this.changeTurnpoint();
    }

    private void handleException(Throwable exception) {
        COMMON.errorLog(this.getClass().getName(), exception);
    }

    private void initConnections() throws Exception {
        this.getJButtonRegister().addActionListener(this);
        this.getJScrollBarHighlight().addAdjustmentListener(this);
        this.getJScrollBarStart().addAdjustmentListener(this);
        this.getJScrollBarEnd().addAdjustmentListener(this);
        this.getJButtonRegisterOutlanding().addActionListener(this);
        this.getJRadioButtonStart().addActionListener(this);
        this.getJRadioButtonVp1().addActionListener(this);
        this.getJRadioButtonVp2().addActionListener(this);
        this.getJRadioButtonVp3().addActionListener(this);
        this.getJRadioButtonVp4().addActionListener(this);
        this.getJRadioButtonVp5().addActionListener(this);
        this.getJRadioButtonVp6().addActionListener(this);
        this.getJRadioButtonVp7().addActionListener(this);
        this.getJRadioButtonHjem().addActionListener(this);
        this.addWindowListener(this);
        this.getJRadioButtonOutlanding().addActionListener(this);
        this.getJRadioButtonOutlanding().addItemListener(this);
        this.getJButton1().addActionListener(this);
        this.getJButton2().addActionListener(this);
        this.addComponentListener(this);
    }

    private void initialize() {
        try {
            Track.getInstance().addListener(this);
            this.setName("CloseUp");
            this.setDefaultCloseOperation(2);
            this.setResizable(true);
            this.setSize(491, 452);
            this.setTitle("T\u00e6rskling / Vendepunkts Passage");
            this.setContentPane(this.getJFrameContentPane());
            this.initConnections();
            this.connEtoM1();
            this.connEtoM2();
            this.connEtoM3();
            this.connEtoM4();
            this.connEtoM5();
            this.connEtoM6();
            this.connEtoM7();
            this.connEtoM8();
            this.connEtoM9();
            this.connEtoM19();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getJScrollBarEnd().setValue(90);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getJRadioButtonOutlanding()) {
            this.connEtoM21(e);
        }
    }

    public void newTrack() {
        this.getJScrollBarEnd().setValue(90);
        this.getJScrollBarStart().setValue(0);
        this.getJScrollBarHighlight().setValue(0);
        this.getJLabel3().setText("Logfil index:        ");
        this.getJRadioButtonStart().setSelected(true);
        this.changeTurnpoint();
        if (this.isShowing()) {
            this.showPunish();
        }
    }

    public void punish10() {
        COMMON.getContest().getPlaneResult().setPenaltyPoint(COMMON.getContest().getPlaneResult().getPenaltyPoint() + 10);
        this.showPunish();
    }

    public void registerOutlanding() {
        Sample s = Track.getInstance().getSelectedSample();
        COMMON.getMapViewer().setMaxPoints(1);
        this.outlanding.setOutLanding(s.lat, s.lon);
        this.outlanding.setVisible(true);
    }

    public void registerTime() {
        int time = 0;
        try {
            time = new Integer(this.getJTextFieldTime().getText());
        }
        catch (Exception e) {
            GDialog.error(this, "Fejl i tids angivelsen");
            return;
        }
        int sec = time % 100;
        int min = (time /= 100) % 100;
        int hour = time / 100 + COMMON.config.UTC2local;
        time = hour * 3600 + min * 60 + sec;
        if (this.getJRadioButtonStart().isSelected()) {
            this.triptime.show(time, COMMON.getContest().getPlaneResult().getEndTime());
        } else if (this.getJRadioButtonHjem().isSelected()) {
            this.triptime.show(COMMON.getContest().getPlaneResult().getStartTime(), time);
        }
    }

    @Override
    public void selectedChanged() {
        this.getCloseUpViewer1().repaint();
    }

    public void show(OutLanding outlanding, TripTime triptime) {
        this.outlanding = outlanding;
        this.triptime = triptime;
        super.setVisible(true);
        this.getJRadioButtonStart().setSelected(true);
        try {
            int num = COMMON.getCurrentTask().size();
            this.getJRadioButtonVp1().setEnabled(num > 2);
            this.getJRadioButtonVp2().setEnabled(num > 3);
            this.getJRadioButtonVp3().setEnabled(num > 4);
            this.getJRadioButtonVp4().setEnabled(num > 5);
            this.getJRadioButtonVp5().setEnabled(num > 6);
            this.getJRadioButtonVp6().setEnabled(num > 7);
            this.getJRadioButtonVp7().setEnabled(num > 8);
            this.changeTurnpoint();
            this.showPunish();
        }
        catch (Exception e) {
            GDialog.info(this, "Opret en opgave f\u00f8r du bruger denne funktion");
        }
    }

    void showPunish() {
        try {
            int punish = COMMON.getContest().getPlaneResult().getPenaltyPoint();
            if (punish > 0) {
                this.getJTextFieldPunish().setText("" + new Integer(punish));
            } else {
                this.getJTextFieldPunish().setText("");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void trackChanged() {
        this.changeTurnpoint();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.getJRadioButtonStart().setSelected(true);
        if (e.getSource() == this) {
            this.connEtoC5(e);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        try {
            CloseUp aCloseUp = new CloseUp();
            try {
                Class<?> aCloserClass = Class.forName("com.ibm.uvm.abt.edit.WindowCloser");
                Class[] parmTypes = new Class[]{Window.class};
                Object[] parms = new Object[]{aCloseUp};
                Constructor<?> aCtor = aCloserClass.getConstructor(parmTypes);
                aCtor.newInstance(parms);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            aCloseUp.setVisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

