/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.COMMON;
import glider.GDialog;
import glider.Sample;
import glider.Track;
import glider.TrackListener;
import glider.data.PlaneResult;
import glider.utils.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;

class BarographPanel
extends JPanel
implements TrackListener,
AdjustmentListener {
    private JScrollPane scrollPane;
    private int WIDTH;
    private int HEIGHT;
    private double xMag;
    private double yMag;
    private int maxAlt;
    private final int MAXZOOM = 10;
    private final int OFFSET = 50;
    int offset = 50;
    private boolean show1500 = false;
    private boolean show2500 = false;
    private boolean show1000m = true;
    private boolean showVariable = false;
    private boolean showNoise = true;
    private int variable = 150;
    private int zoom;
    private int reduction = 10;
    private int mark = -1;
    private int oldMark = -1;
    private JTextField jTextFieldAlt;
    private JTextField jTextFieldUtc;
    private JTextField jTextFieldMs;
    private int xOrigin = 0;
    private Polygon polyAlt = new Polygon();
    private Polygon polyGnssAlt = new Polygon();
    private Polygon polyNoise = new Polygon();
    private int start = -1;
    private int end = -1;
    private Runner runner = null;
    private JScrollBar horBar;
    private JScrollBar verBar;
    private JSlider jSliderMark;
    private DecimalFormat df1 = new DecimalFormat("#0.0");
    private boolean showBaro = true;
    private boolean showGps = true;

    public BarographPanel() {
        this.setBackground(new Color(220, 220, 220));
        Track.getInstance().addListener(this);
    }

    public void setUp(JTextField newUTC, JTextField newAlt, JTextField newMs) {
        this.jTextFieldAlt = newAlt;
        this.jTextFieldUtc = newUTC;
        this.jTextFieldMs = newMs;
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
        this.componentResized();
    }

    public void componentResized() {
        this.HEIGHT = this.scrollPane.getViewport().getExtentSize().height;
        this.WIDTH = this.scrollPane.getViewport().getExtentSize().width;
        this.calcTrack();
    }

    public void setMark(int newMark, int scrollPaneWidth) {
        if (newMark == 100 || newMark == 0) {
            this.mark = -1;
            Track.getInstance().setSelectedSampleIndex(-1);
        } else {
            this.mark = newMark * scrollPaneWidth / this.jSliderMark.getMaximum();
            this.getRunner().setSelectedSample(this.jSliderMark.getValue() * this.reduction);
        }
        this.drawMark();
    }

    public void setOffset(int newValue) {
        this.offset = newValue;
        this.reCalculateGnssGraph();
        this.repaint();
        int selectedSample = Track.getInstance().getSelectedSampleIndex();
        if (selectedSample >= 0) {
            Sample s = (Sample)Track.getInstance().getSamples().elementAt(selectedSample);
            this.jTextFieldAlt.setText("" + (s.pressAltitude - this.offset));
        } else {
            this.jTextFieldAlt.setText("");
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.repaint();
    }

    public void setScroller(JScrollPane scrollPane, JSlider slider) {
        this.scrollPane = scrollPane;
        this.horBar = scrollPane.getVerticalScrollBar();
        this.verBar = scrollPane.getHorizontalScrollBar();
        this.jSliderMark = slider;
        this.horBar.addAdjustmentListener(this);
    }

    public void setShowBaro(boolean value) {
        this.showBaro = value;
        this.repaint();
    }

    public void setShowGps(boolean value) {
        this.showGps = value;
        this.repaint();
    }

    public void setShow1000m(boolean newShow) {
        this.show1000m = newShow;
        this.repaint();
    }

    public void setShow1500(boolean newShow1500) {
        this.show1500 = newShow1500;
        this.repaint();
    }

    public void setShow2500(boolean newShow) {
        this.show2500 = newShow;
        this.repaint();
    }

    public void setShowNoise(boolean newShow) {
        this.showNoise = newShow;
        this.repaint();
    }

    public void setShowVariable(boolean newShow, String newVariable) {
        this.showVariable = newShow;
        try {
            this.variable = Integer.parseInt(newVariable);
        }
        catch (Exception e) {
            this.showVariable = false;
        }
        this.repaint();
    }

    public void setZoom(int zoom) {
        int size;
        this.zoom = zoom;
        Dimension dim = new Dimension(this.WIDTH * zoom, this.HEIGHT * zoom);
        this.setSize(dim);
        this.setPreferredSize(dim);
        Vector samples = Track.getInstance().getSamples();
        if (samples.size() < 1) {
            this.polyAlt = new Polygon();
            this.polyGnssAlt = new Polygon();
            this.polyNoise = new Polygon();
            return;
        }
        int oldReduction = this.reduction;
        int oldXorigin = this.horBar.getValue();
        this.reduction = zoom != 0 ? 10 / zoom : 10;
        this.xOrigin = oldXorigin * oldReduction / this.reduction + this.mark * oldReduction / this.reduction - this.mark;
        if (this.xOrigin < 0) {
            this.mark += this.xOrigin;
            this.jSliderMark.setValue(this.mark);
        }
        if (this.xOrigin + this.horBar.getModel().getExtent() > this.WIDTH / this.reduction) {
            this.mark += this.xOrigin + this.horBar.getModel().getExtent() - this.WIDTH / this.reduction;
            this.jSliderMark.setValue(this.mark);
        }
        if (this.polyAlt.npoints != (size = samples.size())) {
            this.polyAlt = new Polygon(new int[size], new int[size], size);
        }
        if (this.polyGnssAlt.npoints != size) {
            this.polyGnssAlt = new Polygon(new int[size], new int[size], size);
        }
        if (this.polyNoise.npoints != samples.size()) {
            this.polyNoise = new Polygon(new int[size], new int[size], size);
        }
        for (int i = 0; i < size; ++i) {
            Sample s = (Sample)samples.elementAt(i);
            int x = this.x2screen(i);
            int y = this.y2screen(s.pressAltitude);
            this.polyAlt.xpoints[i] = x;
            this.polyAlt.ypoints[i] = y;
            y = this.y2screen(s.motor + 100);
            this.polyNoise.xpoints[i] = x;
            this.polyNoise.ypoints[i] = y;
        }
        this.reCalculateGnssGraph();
        int extent = this.verBar.getModel().getExtent();
        int selected = Track.getInstance().getSelectedSampleIndex();
        if (selected >= 0) {
            Sample s = (Sample)samples.elementAt(selected);
            int alt = s.pressAltitude - this.offset;
            this.verBar.setValue(this.y2screen(alt) - extent / 2);
        }
        this.repaint();
    }

    void reCalculateGnssGraph() {
        int y0 = this.offset / this.reduction;
        Vector samples = Track.getInstance().getSamples();
        int size = samples.size();
        if (size != this.polyGnssAlt.ypoints.length) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            Sample s = (Sample)samples.elementAt(i);
            int x = this.x2screen(i);
            int y = this.y2screen(y0 + s.gnssAltitude);
            this.polyGnssAlt.xpoints[i] = x;
            this.polyGnssAlt.ypoints[i] = y;
        }
    }

    public void calcTrack() {
        Sample s;
        int alt;
        Vector samples = Track.getInstance().getSamples();
        int size = samples.size();
        if (size < 2) {
            this.polyAlt = new Polygon();
            this.polyGnssAlt = new Polygon();
            this.polyNoise = new Polygon();
            return;
        }
        int delta = 15;
        int sum = alt = ((Sample)samples.elementAt((int)0)).pressAltitude;
        int i = 0;
        for (i = 1; i < samples.size(); ++i) {
            Sample s2 = (Sample)samples.elementAt(i);
            if (s2.pressAltitude - alt > 15) break;
            sum += s2.pressAltitude;
        }
        int mean = sum / i;
        if (i > 5 && Math.abs(alt - mean) < 15) {
            this.setOffset(mean);
        } else {
            sum = alt = ((Sample)samples.elementAt((int)(samples.size() - 1))).pressAltitude;
            for (i = 1; i < samples.size(); ++i) {
                s = (Sample)samples.elementAt(samples.size() - i - 1);
                if (s.pressAltitude - alt > 15) break;
                sum += s.pressAltitude;
            }
            mean = sum / i;
            if (i > 5 && Math.abs(alt - mean) < 15) {
                this.setOffset(mean);
                if (this.isShowing()) {
                    GDialog.info(this, "NB: nulpunkt (QFE) er justeret udfra landingen,\nstart fra jorden kunne ikke lokaliseres.");
                }
            } else {
                this.setOffset(0);
                if (this.isShowing()) {
                    GDialog.info(this, "Kunne ikke justere h\u00f8jde nulpunkt (QFE) automatisk,\nhverken start eller landing kunne lokaliseres.\nH\u00d8JDE ANGIVELSER P\u00c5 BAROGRAM VIL V\u00c6RE UN\u00d8JAGTIGE");
                }
            }
        }
        this.verBar.setValue(this.verBar.getMaximum());
        this.horBar.setValue(0);
        if (size > 0) {
            Track.getInstance().setSelectedSampleIndex(1);
        } else {
            Track.getInstance().setSelectedSampleIndex(-1);
        }
        this.maxAlt = 0;
        for (i = 0; i < size; ++i) {
            s = (Sample)samples.elementAt(i);
            if (s.pressAltitude > this.maxAlt) {
                this.maxAlt = s.pressAltitude;
            }
            if (s.gnssAltitude <= this.maxAlt) continue;
            this.maxAlt = s.gnssAltitude;
        }
        this.xMag = (double)this.WIDTH / (double)Track.getInstance().getSamples().size();
        this.yMag = (double)this.HEIGHT / (double)(this.maxAlt + 100);
        this.setZoom(this.zoom);
        if (!COMMON.getContest().isDefined()) {
            return;
        }
        PlaneResult pr = COMMON.getContest().getPlaneResult();
        if (pr == null) {
            return;
        }
        int startTime = pr.getStartTime() / 3600 * 10000 + pr.getStartTime() % 3600 / 60 * 100 + pr.getStartTime() % 60;
        int endTime = pr.getEndTime() / 3600 * 10000 + pr.getEndTime() % 3600 / 60 * 100 + pr.getEndTime() % 60;
        startTime -= 20000;
        endTime -= 20000;
        this.start = -1;
        this.end = -1;
        for (i = 0; i < size; ++i) {
            Sample s3 = (Sample)samples.elementAt(i);
            if (Integer.parseInt(s3.time) <= startTime) {
                this.start = i;
            }
            if (Integer.parseInt(s3.time) > endTime) continue;
            this.end = i;
        }
        this.repaint();
    }

    @Override
    public void detailChanged() {
    }

    private void drawMark() {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        Rectangle vis = this.getVisibleRect();
        g.setClip(vis.x, vis.y, vis.width, vis.height);
        g.setXORMode(this.getBackground());
        g.setColor(Color.green);
        if (this.oldMark != -1) {
            g.drawLine(this.xOrigin + this.oldMark - 1, 0, this.xOrigin + this.oldMark - 1, this.getSize().height);
        }
        if (this.mark != -1) {
            g.drawLine(this.xOrigin + this.mark - 1, 0, this.xOrigin + this.mark - 1, this.getSize().height);
        }
        this.oldMark = this.mark;
        g.dispose();
    }

    Runner getRunner() {
        if (this.runner == null) {
            this.runner = new Runner();
            this.runner.start();
        }
        return this.runner;
    }

    @Override
    public void paint(Graphics g) {
        int x;
        super.paint(g);
        if (this.polyAlt.npoints < 2) {
            g.setColor(Color.black);
            g.drawString("Logger data ikke indl\u00e6st", 20, 20);
            return;
        }
        this.xOrigin = g.getClipBounds().x;
        g.setColor(Color.lightGray);
        int y0 = this.offset / this.reduction;
        int y = this.y2screen(y0);
        g.drawLine(0, y, this.getSize().width, y);
        g.drawString("Nul linie", this.xOrigin + g.getClipBounds().width / 2, y);
        g.setColor(Color.red);
        if (this.show1500) {
            y = this.y2screen(y0 + 457);
            g.drawLine(0, y, this.getSize().width, y);
            g.drawString("1500 ft", this.xOrigin + 10, y);
        }
        if (this.show2500) {
            y = this.y2screen(y0 + 762);
            g.drawLine(0, y, this.getSize().width, y);
            g.drawString("2500 ft", this.xOrigin + 10, y);
        }
        if (this.show1000m) {
            y = this.y2screen(y0 + 1000);
            g.drawLine(0, y, this.getSize().width, y);
            g.drawString("1000 m", this.xOrigin + 10, y);
        }
        g.setColor(Color.magenta);
        if (this.showVariable) {
            y = this.y2screen(y0 + this.variable);
            g.drawLine(0, y, this.getSize().width, y);
            g.drawString(this.variable + " m", this.xOrigin + 10, y);
        }
        if (this.mark > 0) {
            g.setColor(Color.green);
            g.drawLine(this.xOrigin + this.mark - 1, 0, this.xOrigin + this.mark - 1, this.getSize().height);
        }
        g.setColor(Color.yellow);
        if (this.start >= 0) {
            x = this.x2screen(this.start);
            g.drawLine(x, 0, x, this.getSize().height);
        }
        if (this.end >= 0) {
            x = this.x2screen(this.end);
            g.drawLine(x, 0, x, this.getSize().height);
        }
        g.setColor(Color.black);
        this.paintSamples(g);
    }

    private void paintSamples(Graphics g) {
        if (this.showGps) {
            g.setColor(Color.blue);
            g.drawPolyline(this.polyGnssAlt.xpoints, this.polyGnssAlt.ypoints, this.polyGnssAlt.npoints);
        }
        if (this.showBaro) {
            g.setColor(Color.black);
            g.drawPolyline(this.polyAlt.xpoints, this.polyAlt.ypoints, this.polyAlt.npoints);
        }
        if (this.showNoise) {
            g.setColor(Color.red);
            g.drawPolyline(this.polyNoise.xpoints, this.polyNoise.ypoints, this.polyNoise.npoints);
            g.drawString("St\u00f8j nivau", this.xOrigin + g.getClipBounds().width / 2, this.y2screen(150));
        }
    }

    @Override
    public void selectedChanged() {
        Sample s = Track.getInstance().getSelectedSample();
        if (s != null) {
            if (Double.isNaN(s.thermal)) {
                this.jTextFieldMs.setText("");
            } else {
                this.jTextFieldMs.setText(this.df1.format(s.thermal));
            }
            this.jTextFieldAlt.setText("" + (s.pressAltitude - this.offset));
            this.jTextFieldUtc.setText(s.time);
        }
    }

    @Override
    public void trackChanged() {
        BarographPanel.analyze();
        this.calcTrack();
        if (this.isShowing()) {
            this.repaint();
        }
    }

    private int x2screen(int x) {
        return (int)(this.xMag * (double)x * (double)this.zoom);
    }

    private int y2screen(int y) {
        return (int)(this.yMag * (double)(this.maxAlt - y)) * this.zoom;
    }

    private static void analyze() {
        Vector samples = Track.getInstance().getSamples();
        int selectedSampleIndex = 0;
        int alt = 0;
        Sample s = null;
        while (selectedSampleIndex < samples.size() - 1) {
            s = (Sample)samples.elementAt(selectedSampleIndex);
            alt = s.pressAltitude;
            if (alt < 100) {
                while (selectedSampleIndex < samples.size() && alt < 100) {
                    s = (Sample)samples.elementAt(selectedSampleIndex++);
                    alt = s.pressAltitude;
                }
                while (selectedSampleIndex < samples.size() - 2) {
                    Sample s2 = (Sample)samples.elementAt(selectedSampleIndex + 1);
                    int newAlt = s2.pressAltitude;
                    if (newAlt < alt) break;
                    alt = newAlt;
                    ++selectedSampleIndex;
                    s = s2;
                }
            }
            while (selectedSampleIndex < samples.size() - 2) {
                s = (Sample)samples.elementAt(selectedSampleIndex);
                int newAlt = s.pressAltitude;
                if (newAlt > alt) break;
                alt = newAlt;
                ++selectedSampleIndex;
            }
            if (selectedSampleIndex >= samples.size()) break;
            if (alt < 200) {
                while (selectedSampleIndex < samples.size() - 1) {
                    s = (Sample)samples.elementAt(selectedSampleIndex);
                    if (s.pressAltitude > 300) break;
                    ++selectedSampleIndex;
                }
                if (selectedSampleIndex >= samples.size()) break;
            }
            int leftIndex = selectedSampleIndex;
            int leftAlt = ((Sample)samples.elementAt((int)leftIndex)).pressAltitude;
            int rightIndex = selectedSampleIndex;
            int rightAlt = ((Sample)samples.elementAt((int)rightIndex)).pressAltitude;
            while (selectedSampleIndex < samples.size() - 2) {
                Sample s2 = (Sample)samples.elementAt(selectedSampleIndex + 1);
                int newAlt = s2.pressAltitude;
                if (newAlt > rightAlt) {
                    rightAlt = newAlt;
                    rightIndex = selectedSampleIndex + 1;
                }
                if (newAlt < rightAlt - 20) break;
                ++selectedSampleIndex;
                s = s2;
            }
            Sample prev = (Sample)samples.elementAt(leftIndex);
            Sample next = (Sample)samples.elementAt(rightIndex);
            double altIncr = next.pressAltitude - prev.pressAltitude;
            if (altIncr > 75.0) {
                try {
                    Date nextS = Utils.sdf.parse(next.time);
                    Date prevS = Utils.sdf.parse(prev.time);
                    long secIncr = (nextS.getTime() - prevS.getTime()) / 1000L;
                    double mpers = 0.0;
                    if (secIncr != 0L) {
                        mpers = altIncr / (double)secIncr;
                        for (int i = leftIndex; i <= rightIndex; ++i) {
                            Sample sample = (Sample)samples.elementAt(i);
                            sample.thermal = mpers;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            selectedSampleIndex = rightIndex + 1;
        }
    }

    class Runner
    extends Thread {
        int selectedSample = -1;

        Runner() {
        }

        public void setSelectedSample(int selectedSample) {
            this.selectedSample = selectedSample;
            this.interrupt();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    continue;
                }
                if (this.selectedSample < 0) continue;
                Track.getInstance().setSelectedSampleIndex(this.selectedSample);
                this.selectedSample = -1;
                BarographPanel.this.repaint();
            }
        }
    }
}

