/*
 * Decompiled with CFR 0.152.
 */
package glider;

import glider.Barogram_jCheckBox1000m_actionAdapter;
import glider.Barogram_jCheckBox1500ft_actionAdapter;
import glider.Barogram_jCheckBox2500ft_actionAdapter;
import glider.Barogram_jCheckBoxBaro_actionAdapter;
import glider.Barogram_jCheckBoxGps_actionAdapter;
import glider.Barogram_jCheckBoxHeight_actionAdapter;
import glider.Barogram_jCheckBoxNoise_actionAdapter;
import glider.Barogram_jComboBoxZoom_actionAdapter;
import glider.Barogram_jSliderHorizontal_changeAdapter;
import glider.Barogram_jSliderVertical_changeAdapter;
import glider.Barogram_jTextFieldVarHeight_actionAdapter;
import glider.Barogram_this_componentAdapter;
import glider.BarographPanel;
import glider.Sample;
import glider.Track;
import glider.TrackListener;
import gui.JJDialog;
import gui.JJDisplayField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;

public class Barogram
extends JJDialog
implements TrackListener,
AdjustmentListener {
    private final int MAXZOOM = 10;
    private int reduction;
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelTop = new JPanel();
    JPanel jPanelEast = new JPanel();
    JPanel jPanelCenter = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel jLabel1 = new JLabel();
    JComboBox jComboBoxZoom = new JComboBox();
    JLabel jLabel2 = new JLabel();
    JJDisplayField jJDisplayFieldHeight = new JJDisplayField();
    JLabel jLabel3 = new JLabel();
    JJDisplayField jJDisplayFieldUtc = new JJDisplayField();
    JLabel jLabel4 = new JLabel();
    JJDisplayField jJDisplayFieldMs = new JJDisplayField();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JCheckBox jCheckBox1500ft = new JCheckBox();
    JCheckBox jCheckBox2500ft = new JCheckBox();
    JCheckBox jCheckBox1000m = new JCheckBox();
    JCheckBox jCheckBoxHeight = new JCheckBox();
    JCheckBox jCheckBoxGps = new JCheckBox();
    JCheckBox jCheckBoxBaro = new JCheckBox();
    JCheckBox jCheckBoxNoise = new JCheckBox();
    JTextField jTextFieldVarHeight = new JTextField();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JSlider jSliderMark = new JSlider();
    JSlider jSliderOffset = new JSlider();
    BarographPanel barographPanel = new BarographPanel();
    JScrollPane jScrollPane = new JScrollPane();

    public Barogram(Frame frame) {
        super(frame, "Barogram", false, false);
        try {
            this.jbInit();
            this.init();
            this.pack();
            int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
            this.setSize(screenWidth, this.getSize().height);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Barogram() {
        this((Frame)null);
    }

    private void init() throws Exception {
        this.jComboBoxZoom.addItem("1");
        this.jComboBoxZoom.addItem("2");
        this.jComboBoxZoom.addItem("5");
        this.jComboBoxZoom.addItem("10");
        this.jComboBoxZoom.setSelectedIndex(0);
        this.jScrollPane.setViewportView(this.barographPanel);
        this.barographPanel.setScroller(this.jScrollPane, this.jSliderMark);
        this.barographPanel.setUp(this.jJDisplayFieldUtc, this.jJDisplayFieldHeight, this.jJDisplayFieldMs);
        Track.getInstance().addListener(this);
    }

    private void jbInit() throws Exception {
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanelTop.setLayout(this.gridBagLayout1);
        this.jLabel1.setText("Zoom:");
        this.jLabel2.setText("H\u00f8jde:");
        this.jJDisplayFieldHeight.setPreferredSize(new Dimension(40, 20));
        this.jJDisplayFieldHeight.setText("");
        this.jLabel3.setText("UTC:");
        this.jJDisplayFieldUtc.setPreferredSize(new Dimension(50, 20));
        this.jJDisplayFieldUtc.setText("");
        this.jLabel4.setText("m/s:");
        this.jJDisplayFieldMs.setPreferredSize(new Dimension(30, 20));
        this.jPanelEast.setLayout(this.gridBagLayout2);
        this.jCheckBox1500ft.setText("1500 ft");
        this.jCheckBox1500ft.addActionListener(new Barogram_jCheckBox1500ft_actionAdapter(this));
        this.jCheckBoxGps.setSelected(true);
        this.jCheckBoxGps.setText("GPS");
        this.jCheckBoxGps.addActionListener(new Barogram_jCheckBoxGps_actionAdapter(this));
        this.jCheckBoxBaro.setSelected(true);
        this.jCheckBoxBaro.setText("Baro");
        this.jCheckBoxBaro.addActionListener(new Barogram_jCheckBoxBaro_actionAdapter(this));
        this.jCheckBoxNoise.setSelected(true);
        this.jCheckBoxNoise.setText("St\u00f8j");
        this.jCheckBoxNoise.addActionListener(new Barogram_jCheckBoxNoise_actionAdapter(this));
        this.jCheckBoxHeight.setText("");
        this.jCheckBoxHeight.addActionListener(new Barogram_jCheckBoxHeight_actionAdapter(this));
        this.jCheckBox2500ft.setText("2500 ft");
        this.jCheckBox2500ft.addActionListener(new Barogram_jCheckBox2500ft_actionAdapter(this));
        this.jCheckBox1000m.setSelected(true);
        this.jCheckBox1000m.setText("1000 m");
        this.jCheckBox1000m.addActionListener(new Barogram_jCheckBox1000m_actionAdapter(this));
        this.jTextFieldVarHeight.setText("150");
        this.jTextFieldVarHeight.addActionListener(new Barogram_jTextFieldVarHeight_actionAdapter(this));
        this.jPanelCenter.setLayout(this.gridBagLayout3);
        this.jSliderOffset.setOrientation(1);
        this.jSliderOffset.setPreferredSize(new Dimension(16, 20));
        this.jSliderOffset.addChangeListener(new Barogram_jSliderVertical_changeAdapter(this));
        this.jSliderMark.addChangeListener(new Barogram_jSliderHorizontal_changeAdapter(this));
        this.addComponentListener(new Barogram_this_componentAdapter(this));
        this.jComboBoxZoom.addActionListener(new Barogram_jComboBoxZoom_actionAdapter(this));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanelTop, "North");
        this.jPanel1.add((Component)this.jPanelEast, "East");
        this.jPanelEast.add((Component)this.jCheckBox1500ft, new GridBagConstraints(0, 6, 2, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelEast.add((Component)this.jCheckBox2500ft, new GridBagConstraints(0, 5, 2, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelEast.add((Component)this.jCheckBox1000m, new GridBagConstraints(0, 4, 2, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelEast.add((Component)this.jCheckBoxHeight, new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelEast.add((Component)this.jCheckBoxGps, new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelEast.add((Component)this.jCheckBoxBaro, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelEast.add((Component)this.jCheckBoxNoise, new GridBagConstraints(0, 0, 2, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelEast.add((Component)this.jTextFieldVarHeight, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanelCenter, "Center");
        this.jPanelCenter.add((Component)this.jSliderMark, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelCenter.add((Component)this.jSliderOffset, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelCenter.add((Component)this.jScrollPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelTop.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 10, 0, 2), 0, 0));
        this.jPanelTop.add((Component)this.jComboBoxZoom, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelTop.add((Component)this.jLabel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 10, 0, 2), 0, 0));
        this.jPanelTop.add((Component)this.jJDisplayFieldHeight, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelTop.add((Component)this.jLabel3, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 10, 0, 2), 0, 0));
        this.jPanelTop.add((Component)this.jJDisplayFieldUtc, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelTop.add((Component)this.jLabel4, new GridBagConstraints(6, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 10, 0, 2), 0, 0));
        this.jPanelTop.add((Component)this.jJDisplayFieldMs, new GridBagConstraints(7, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
    }

    void jCheckBoxNoise_actionPerformed(ActionEvent e) {
        this.barographPanel.setShowNoise(this.jCheckBoxNoise.isSelected());
    }

    void jCheckBoxBaro_actionPerformed(ActionEvent e) {
        this.barographPanel.setShowBaro(this.jCheckBoxBaro.isSelected());
    }

    void jCheckBoxGps_actionPerformed(ActionEvent e) {
        this.barographPanel.setShowGps(this.jCheckBoxGps.isSelected());
    }

    void variableHeghtChanged(ActionEvent e) {
        this.barographPanel.setShowVariable(this.jCheckBoxHeight.isSelected(), this.jTextFieldVarHeight.getText());
    }

    void jCheckBox1000m_actionPerformed(ActionEvent e) {
        this.barographPanel.setShow1000m(this.jCheckBox1000m.isSelected());
    }

    void jCheckBox2500ft_actionPerformed(ActionEvent e) {
        this.barographPanel.setShow2500(this.jCheckBox2500ft.isSelected());
    }

    void jCheckBox1500ft_actionPerformed(ActionEvent e) {
        this.barographPanel.setShow1500(this.jCheckBox1500ft.isSelected());
    }

    void jSliderVertical_stateChanged(ChangeEvent e) {
        int offset = 10 * (this.jSliderOffset.getValue() - 50);
        this.barographPanel.setOffset(offset);
    }

    void jSliderHorizontal_stateChanged(ChangeEvent e) {
        Dimension dim = this.jScrollPane.getViewport().getExtentSize();
        if (this.jScrollPane.getVerticalScrollBar().isShowing()) {
            dim.width += this.jScrollPane.getVerticalScrollBar().getSize().width;
        }
        this.barographPanel.setMark(this.jSliderMark.getValue(), dim.width);
    }

    void this_componentResized(ComponentEvent e) {
        this.barographPanel.componentResized();
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
        this.barographPanel.setVisible(value);
    }

    public void calcTrack() {
        this.barographPanel.calcTrack();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.jJDisplayFieldHeight.setText("");
        this.jJDisplayFieldUtc.setText("");
    }

    @Override
    public void detailChanged() {
    }

    @Override
    public void selectedChanged() {
    }

    @Override
    public void trackChanged() {
        Vector samples = Track.getInstance().getSamples();
        if (samples.size() < 1) {
            this.setTitle("Barogram");
            return;
        }
        this.jSliderMark.setMaximum(samples.size() / this.reduction);
        int delta = 10;
        int alt = ((Sample)samples.elementAt((int)0)).pressAltitude;
        int i = 0;
        for (i = 1; i < samples.size() - 1; ++i) {
            Sample s = (Sample)samples.elementAt(i);
            if (s.pressAltitude - alt > 10) break;
        }
        String startTime = ((Sample)samples.elementAt((int)i)).time;
        alt = ((Sample)samples.elementAt((int)(samples.size() - 1))).pressAltitude;
        for (i = 1; i < samples.size() - 1; ++i) {
            Sample s = (Sample)samples.elementAt(samples.size() - i - 1);
            if (s.pressAltitude - alt > 10) break;
        }
        String endTime = ((Sample)samples.elementAt((int)(samples.size() - i))).time;
        try {
            int hours = Integer.parseInt(endTime.substring(0, 2)) - Integer.parseInt(startTime.substring(0, 2));
            int mins = Integer.parseInt(endTime.substring(2, 4)) - Integer.parseInt(startTime.substring(2, 4));
            if (mins < 0) {
                mins += 60;
                --hours;
            }
            if (hours >= 0) {
                this.setTitle("Barogram - Flyvetid: " + hours + " timer " + mins + " minutter");
            } else {
                this.setTitle("Barogram");
            }
        }
        catch (Exception e) {
            this.setTitle("Barogram");
        }
    }

    void jComboBoxZoom_actionPerformed(ActionEvent e) {
        String newZoom = (String)this.jComboBoxZoom.getSelectedItem();
        int zoom = Integer.parseInt(newZoom);
        this.barographPanel.setZoom(zoom);
        this.reduction = zoom != 0 ? 10 / zoom : 10;
        int size = Track.getInstance().getSamples().size() / this.reduction;
        this.jSliderMark.setMaximum(size);
    }
}

