/*
 * Decompiled with CFR 0.152.
 */
package dk.johny.udplog;

import dk.johny.udplog.Constants;
import dk.johny.udplog.UdpAppender;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;

public class UdpLog
implements Constants {
    private static String serverIp;
    private static UdpAppender udpAppender;
    private static RollingFileAppender rollingFileAppender;
    private static Map<String, Logger> loggers;
    private static File file;
    private static boolean startLineWritten;

    private static Caller getCaller() {
        String name = new Throwable().getStackTrace()[2].getClassName();
        int index = name.lastIndexOf(46) + 1;
        return new Caller(name.substring(index));
    }

    public static synchronized Logger getLogger(String ip, File logFile) {
        if (!startLineWritten) {
            serverIp = ip;
            file = logFile;
        }
        return UdpLog.getALogger(UdpLog.getCaller());
    }

    public static synchronized Logger getLogger(String ip) {
        if (!startLineWritten) {
            serverIp = ip;
        }
        return UdpLog.getALogger(UdpLog.getCaller());
    }

    public static synchronized Logger getLogger(File logFile) {
        if (!startLineWritten) {
            file = logFile;
        }
        return UdpLog.getALogger(UdpLog.getCaller());
    }

    public static synchronized Logger getLogger(String ip, Caller caller) {
        Caller c = caller != null ? caller : UdpLog.getCaller();
        return UdpLog.getALogger(c);
    }

    public static synchronized Logger get() {
        return UdpLog.getLogger("192.168.43.172", UdpLog.getCaller());
    }

    private static synchronized Logger getALogger(Caller caller) {
        Logger logger = loggers.get(caller.toString());
        if (logger == null) {
            logger = Logger.getLogger(caller.toString());
            if (serverIp != null) {
                if (udpAppender == null) {
                    try {
                        udpAppender = new UdpAppender(serverIp);
                    }
                    catch (UnsupportedOperationException uoe) {
                        throw new UnsupportedOperationException(uoe.getMessage() + " Call setIP()");
                    }
                }
                logger.addAppender(udpAppender);
            }
            if (file != null) {
                if (rollingFileAppender == null) {
                    try {
                        rollingFileAppender = new RollingFileAppender(PATTERN_LAYOUT, file.getPath(), true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                logger.addAppender(rollingFileAppender);
            }
            loggers.put(caller.toString(), logger);
        }
        if (!startLineWritten) {
            startLineWritten = true;
            logger.error("--------------------- Restart ---------------------");
        }
        return logger;
    }

    static {
        loggers = new HashMap<String, Logger>(10);
        startLineWritten = false;
    }

    private static class Caller {
        private String name;

        private Caller(String className) {
            this.name = className;
        }

        public String toString() {
            return this.name;
        }
    }
}

