/*
 * Decompiled with CFR 0.152.
 */
package dk.johny.udplog;

import dk.johny.udplog.Constants;
import dk.johny.udplog.LogPackage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.Semaphore;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;

public class UdpAppender
extends WriterAppender
implements Constants {
    private String ip;
    private String application;
    private InetAddress address;
    private DatagramSocket outSocket;
    private boolean inError = false;
    private static byte sequence = 0;
    private static final Semaphore appendLock = new Semaphore(1);

    public UdpAppender(String ip) {
        this.ip = ip;
        if (ip == null) {
            throw new UnsupportedOperationException("Server IP is null.");
        }
        this.address = null;
        try {
            this.address = InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            System.err.println("Unknown host: " + ip);
        }
        this.setLayout(PATTERN_LAYOUT);
        this.activateOptions();
        this.setEncoding("8859-1");
    }

    @Override
    public void activateOptions() {
        if (this.application == null) {
            this.application = "JJsoar";
        }
        if (this.address == null) {
            if (this.ip == null) {
                String err = "The server property is required for SocketAppender named " + this.name;
                System.err.println(err);
                throw new IllegalStateException(err);
            }
            try {
                this.address = InetAddress.getByName(this.ip);
            }
            catch (UnknownHostException ex) {
                System.err.println("Unknown host: " + this.ip);
                ex.printStackTrace();
                throw new IllegalStateException(ex);
            }
        }
        if (this.address == null) {
            String err = "The address property is required for SocketAppender named " + this.name;
            System.err.println(err);
            throw new IllegalStateException(err);
        }
        System.out.println("UDP server address: " + this.address + ":" + 9991);
        this.connect(this.address, 9991);
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.outSocket != null) {
            try {
                this.outSocket.close();
            }
            catch (Exception e) {
                System.err.println("Could not close outSocket.");
                e.printStackTrace();
            }
            this.outSocket = null;
        }
    }

    private void connect(final InetAddress address, final int port) {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.outSocket = new DatagramSocket();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        UdpAppender.this.outSocket.connect(address, port);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        catch (IOException e) {
            System.err.println("Could not open UDP Socket for sending.");
            e.printStackTrace();
            this.inError = true;
        }
    }

    @Override
    public void append(LoggingEvent event) {
        if (this.inError || event == null || this.address == null) {
            return;
        }
        if (this.outSocket != null) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(16384);
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                try {
                    appendLock.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                byte by = sequence;
                sequence = (byte)(by + 1);
                LogPackage logPackage = new LogPackage(by, event);
                oos.writeObject(logPackage);
                byte[] payload = bos.toByteArray();
                final DatagramPacket dp = new DatagramPacket(payload, payload.length, this.address, 9991);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            UdpAppender.this.outSocket.send(dp);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        appendLock.release();
                    }
                }).start();
            }
            catch (SocketException se) {
                this.outSocket = null;
                System.err.println("UdpAppender: " + se);
            }
            catch (IOException e) {
                this.outSocket = null;
                System.err.println("Detected problem with UDP connection: ");
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }
}

