/*
 * Decompiled with CFR 0.152.
 */
package dk.johny.udplog;

import dk.johny.udplog.Constants;
import dk.johny.udplog.LogPackage;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggingEvent;

public class UDPLogServer
implements Constants {
    private static final Logger cat = Logger.getLogger(UDPLogServer.class);
    private static final String version = "1.0";
    private static final int PACKET_LENGTH = 16384;

    public static void main(String[] args) {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    cat.debug("UDP log server exiting");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            new UDPLogServer().doIt();
        }
        catch (Exception ex) {
            cat.error("Exception in main", ex);
        }
    }

    private void doIt() throws Exception {
        byte lastSequence = -1;
        DatagramSocket ds = new DatagramSocket(9991);
        byte[] buf = new byte[16384];
        cat.setLevel(Level.DEBUG);
        ConsoleAppender ca = new ConsoleAppender(PATTERN_LAYOUT);
        ca.setEncoding("8859-1");
        cat.addAppender(ca);
        RollingFileAppender rfa = new RollingFileAppender((Layout)PATTERN_LAYOUT, "trace.log");
        rfa.setMaxBackupIndex(3);
        rfa.setMaxFileSize("2MB");
        rfa.setEncoding("8859-1");
        cat.addAppender(rfa);
        cat.debug("UDP log server 1.0 listening on " + InetAddress.getLocalHost().getHostAddress() + ":" + 9991);
        while (true) {
            try {
                while (true) {
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    ds.receive(packet);
                    ByteArrayInputStream bis = new ByteArrayInputStream(buf);
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    ois.read(packet.getData(), 0, packet.getLength());
                    Object o = ois.readObject();
                    LogPackage logPackage = (LogPackage)o;
                    lastSequence = (byte)(lastSequence + 1);
                    if (lastSequence != logPackage.sequence) {
                        cat.error("---------- Expected sequence: " + lastSequence + ", got: " + logPackage.sequence + " ----------");
                        lastSequence = logPackage.sequence;
                    }
                    LoggingEvent loggingEvent = logPackage.loggingEvent;
                    cat.callAppenders(loggingEvent);
                }
            }
            catch (EOFException eof) {
                cat.debug("Ignoring EOFException, the log producer/source is probably restarting");
                continue;
            }
            catch (Throwable th) {
                cat.fatal("UDP2log server error: " + th.getMessage(), th);
                ds.close();
                ds = new DatagramSocket(9991);
                continue;
            }
            break;
        }
    }
}

